/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryKind;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibrarySettingsProvider {
    public static final ExtensionPointName<LibrarySettingsProvider> EP_NAME = ExtensionPointName.create("com.intellij.librarySettingsProvider");

    @NotNull
    @Contract(pure=true)
    public abstract LibraryKind getLibraryKind();

    @Contract(pure=true)
    public abstract Configurable getAdditionalSettingsConfigurable(Project var1);

    @Nullable
    @Contract(pure=true)
    public static Configurable getAdditionalSettingsConfigurable(Project project2, LibraryKind libKind) {
        LibrarySettingsProvider provider2 = LibrarySettingsProvider.forLibraryType(libKind);
        if (provider2 == null) {
            return null;
        }
        return provider2.getAdditionalSettingsConfigurable(project2);
    }

    @Nullable
    @Contract(pure=true)
    public static LibrarySettingsProvider forLibraryType(LibraryKind libType) {
        for (LibrarySettingsProvider provider2 : EP_NAME.getExtensionList()) {
            if (!provider2.getLibraryKind().equals(libType)) continue;
            return provider2;
        }
        return null;
    }
}

