/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;

public class ToggleSourcesStateAction<P extends JpsElement>
extends ContentEntryEditingAction {
    private final ContentEntryTreeEditor myEntryTreeEditor;
    private final ModuleSourceRootEditHandler<P> myEditHandler;

    public ToggleSourcesStateAction(JTree tree, ContentEntryTreeEditor entryEditor, ModuleSourceRootEditHandler<P> editHandler) {
        super(tree);
        this.myEntryTreeEditor = entryEditor;
        this.myEditHandler = editHandler;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(editHandler.getMarkRootButtonText());
        templatePresentation.setDescription(ProjectBundle.messagePointer((String)"module.toggle.sources.action.description", (Object[])new Object[]{editHandler.getFullRootTypeName().toLowerCase(Locale.getDefault())}));
        templatePresentation.setIcon(editHandler.getRootIcon());
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        VirtualFile[] selectedFiles;
        if (e == null) {
            ToggleSourcesStateAction.$$$reportNull$$$0(0);
        }
        if ((selectedFiles = this.getSelectedFiles()).length == 0) {
            return false;
        }
        ContentEntryEditor editor2 = this.myEntryTreeEditor.getContentEntryEditor();
        return this.myEditHandler.getRootType().equals(editor2.getRootType(selectedFiles[0]));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean isSelected) {
        if (e == null) {
            ToggleSourcesStateAction.$$$reportNull$$$0(1);
        }
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        assert (selectedFiles.length != 0);
        ContentEntryEditor contentEntryEditor = this.myEntryTreeEditor.getContentEntryEditor();
        for (VirtualFile selectedFile : selectedFiles) {
            SourceFolder sourceFolder = contentEntryEditor.getSourceFolder(selectedFile);
            if (isSelected) {
                JpsElement properties;
                if (sourceFolder == null) {
                    properties = (JpsElement)this.myEditHandler.getRootType().createDefaultProperties();
                    contentEntryEditor.addSourceFolder(selectedFile, this.myEditHandler.getRootType(), properties);
                    continue;
                }
                if (this.myEditHandler.getRootType().equals(sourceFolder.getRootType())) continue;
                properties = this.myEditHandler.getRootType().getClass().equals(sourceFolder.getRootType().getClass()) ? sourceFolder.getJpsElement().getProperties().getBulkModificationSupport().createCopy() : (JpsElement)this.myEditHandler.getRootType().createDefaultProperties();
                contentEntryEditor.removeSourceFolder(sourceFolder);
                contentEntryEditor.addSourceFolder(selectedFile, this.myEditHandler.getRootType(), properties);
                continue;
            }
            if (sourceFolder == null) continue;
            contentEntryEditor.removeSourceFolder(sourceFolder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/actions/ToggleSourcesStateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

