/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class NullableLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private final NullableFunction<? super H, ? extends T> myFunction;

    private NullableLazyKey(@NonNls String name2, NullableFunction<? super H, ? extends T> function) {
        super(name2);
        this.myFunction = function;
    }

    @Nullable
    public T getValue(H h) {
        Object data2 = h.getUserData(this);
        if (data2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            data2 = this.myFunction.fun(h);
            if (stamp.mayCacheNow()) {
                h.putUserData(this, (Object)(data2 == null ? ObjectUtils.NULL : data2));
            }
        }
        return data2 == ObjectUtils.NULL ? null : (T)data2;
    }

    public static <T, H extends UserDataHolder> NullableLazyKey<T, H> create(@NonNls String name2, NullableFunction<? super H, ? extends T> function) {
        return new NullableLazyKey<T, H>(name2, function);
    }
}

