/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectNode {
    private ObjectNode myParent;
    private final Disposable myObject;
    private List<ObjectNode> myChildren;
    private Throwable myTrace;
    private static final Disposable ROOT_DISPOSABLE = Disposer.newDisposable();

    ObjectNode(@NotNull Disposable object, @NotNull ObjectNode parentNode) {
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            ObjectNode.$$$reportNull$$$0(1);
        }
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = parentNode.isRoot() && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    private ObjectNode() {
        this.myObject = ROOT_DISPOSABLE;
        this.myParent = this;
    }

    void assertNoChildren(boolean throwError) {
        if (this.myChildren != null) {
            for (ObjectNode childNode : this.myChildren) {
                if (childNode == null) continue;
                Disposable object = childNode.getObject();
                Throwable trace = childNode.getTrace();
                String message2 = "Memory leak detected: '" + object + "' of " + object.getClass() + " is registered in Disposer but wasn't disposed.\nRegister it with a proper parentDisposable or ensure that it's always disposed by direct Disposer.dispose call.\nSee https://jetbrains.org/intellij/sdk/docs/basics/disposers.html for more details.\nThe corresponding Disposer.register() stacktrace is shown as the cause:\n";
                RuntimeException exception = new RuntimeException(message2, trace);
                if (throwError) {
                    throw exception;
                }
                ObjectTree.getLogger().error(exception);
            }
        }
    }

    private boolean isRoot() {
        return this.myObject == ROOT_DISPOSABLE;
    }

    @NotNull
    static ObjectNode createRoot() {
        return new ObjectNode();
    }

    void addChild(@NotNull ObjectNode child) {
        List<ObjectNode> children2;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(2);
        }
        if ((children2 = this.myChildren) == null) {
            this.myChildren = new SmartList<ObjectNode>(child);
        } else {
            children2.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode child) {
        List<ObjectNode> children2;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(3);
        }
        if ((children2 = this.myChildren) != null) {
            for (int i = children2.size() - 1; i >= 0; --i) {
                ObjectNode node2 = children2.get(i);
                if (!node2.equals(child)) continue;
                children2.remove(i);
                break;
            }
        }
    }

    @NotNull
    ObjectNode getParent() {
        ObjectNode objectNode = this.myParent;
        if (objectNode == null) {
            ObjectNode.$$$reportNull$$$0(4);
        }
        return objectNode;
    }

    void getAndRemoveRecursively(@NotNull ObjectTree myTree, @NotNull List<? super Disposable> result2) {
        if (myTree == null) {
            ObjectNode.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            ObjectNode.$$$reportNull$$$0(6);
        }
        this.getAndRemoveChildrenRecursively(myTree, result2, null);
        myTree.removeObjectFromTree(this);
        if (myTree.rememberDisposedTrace(this.myObject) == null) {
            result2.add(this.myObject);
        }
        this.myChildren = null;
        this.myParent = null;
    }

    void getAndRemoveChildrenRecursively(@NotNull ObjectTree myTree, @NotNull List<? super Disposable> result2, @Nullable Predicate<? super Disposable> predicate) {
        if (myTree == null) {
            ObjectNode.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            ObjectNode.$$$reportNull$$$0(8);
        }
        if (this.myChildren != null) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                ObjectNode childNode = this.myChildren.get(i);
                if (predicate != null && !predicate.test(childNode.getObject())) continue;
                childNode.getAndRemoveRecursively(myTree, result2);
            }
        }
    }

    @NotNull
    Disposable getObject() {
        Disposable disposable = this.myObject;
        if (disposable == null) {
            ObjectNode.$$$reportNull$$$0(9);
        }
        return disposable;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void clearTrace() {
        this.myTrace = null;
    }

    @TestOnly
    void assertNoReferencesKept(@NotNull Disposable aDisposable) {
        if (aDisposable == null) {
            ObjectNode.$$$reportNull$$$0(10);
        }
        assert (this.getObject() != aDisposable);
        if (this.myChildren != null) {
            for (ObjectNode node2 : this.myChildren) {
                node2.assertNoReferencesKept(aDisposable);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myTree";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndRemoveRecursively";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAndRemoveChildrenRecursively";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferencesKept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

