/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectNode;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectTree {
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final Map<Disposable, ObjectNode> myObject2NodeMap = new Reference2ObjectOpenHashMap<Disposable, ObjectNode>();
    private final Map<Disposable, Object> myDisposedObjects = CollectionFactory.createWeakIdentityMap(100, 0.5f);
    private final Object treeLock = new Object();
    private final ObjectNode ROOT_NODE = ObjectNode.createRoot();

    ObjectTree() {
    }

    private ObjectNode getNode(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(0);
        }
        return this.myObject2NodeMap.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RuntimeException register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            ObjectTree.$$$reportNull$$$0(1);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(2);
        }
        if (parent == child) {
            return new IllegalArgumentException("Cannot register to itself: " + parent);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode childNode;
            ObjectNode parentNode;
            RuntimeException e;
            Object wasDisposed = this.getDisposalInfo(parent);
            if (wasDisposed != null) {
                return new IncorrectOperationException("Sorry but parent: " + parent + " (" + parent.getClass() + ") has already been disposed (see the cause for stacktrace) so the child: " + child + " (" + child.getClass() + ") will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            this.myDisposedObjects.remove(child);
            if (child instanceof Disposer.CheckedDisposableImpl) {
                ((Disposer.CheckedDisposableImpl)child).isDisposed = false;
            }
            if ((e = this.checkWasNotAddedAlreadyAsChild(parentNode = this.getOrCreateParentNode(parent), childNode = this.getOrCreateChildNode(parentNode, child))) != null) {
                return e;
            }
            parentNode.addChild(childNode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDisposalInfo(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(3);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private RuntimeException checkWasNotAddedAlreadyAsChild(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) {
        if (childNode == null) {
            ObjectTree.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(5);
        }
        for (ObjectNode node2 = childNode; node2 != this.ROOT_NODE; node2 = node2.getParent()) {
            if (node2 != parentNode) continue;
            return new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
        return null;
    }

    @NotNull
    private ObjectNode getOrCreateParentNode(@NotNull Disposable parent) {
        if (parent == null) {
            ObjectTree.$$$reportNull$$$0(6);
        }
        ObjectNode objectNode = this.myObject2NodeMap.computeIfAbsent(parent, p -> new ObjectNode((Disposable)p, this.ROOT_NODE));
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(7);
        }
        return objectNode;
    }

    @NotNull
    private ObjectNode getOrCreateChildNode(@NotNull ObjectNode parentNode, @NotNull Disposable child) {
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(8);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(9);
        }
        ObjectNode objectNode = this.myObject2NodeMap.compute(child, (c, oldNode) -> {
            if (oldNode == null) {
                oldNode = new ObjectNode((Disposable)c, parentNode);
            } else {
                ObjectNode oldParent = oldNode.getParent();
                oldParent.removeChild((ObjectNode)oldNode);
            }
            return oldNode;
        });
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(10);
        }
        return objectNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithTrace(@NotNull @NotNull Supplier<? extends @NotNull List<Disposable>> removeFromTreeAction) {
        List<Disposable> disposables;
        boolean needTrace;
        if (removeFromTreeAction == null) {
            ObjectTree.$$$reportNull$$$0(11);
        }
        boolean bl = needTrace = Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
        if (needTrace) {
            ourTopmostDisposeTrace.set(ThrowableInterner.intern(new Throwable()));
        }
        Object object = this.treeLock;
        synchronized (object) {
            disposables = removeFromTreeAction.get();
        }
        SmartList<Throwable> exceptions = null;
        for (int i = disposables.size() - 1; i >= 0; --i) {
            Disposable disposable = disposables.get(i);
            if (!(disposable instanceof Disposable.Parent)) continue;
            try {
                ((Disposable.Parent)disposable).beforeTreeDispose();
                continue;
            }
            catch (Throwable t) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(t);
            }
        }
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList();
                }
                exceptions.add(e);
            }
        }
        if (needTrace) {
            ourTopmostDisposeTrace.remove();
        }
        if (exceptions != null) {
            ObjectTree.handleExceptions(exceptions);
        }
    }

    void executeAllChildren(@NotNull Disposable object, @Nullable Predicate<? super Disposable> predicate) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(12);
        }
        this.runWithTrace(() -> {
            ObjectNode node2 = this.getNode(object);
            if (node2 == null) {
                return Collections.emptyList();
            }
            ArrayList disposables = new ArrayList();
            node2.getAndRemoveChildrenRecursively(this, disposables, predicate);
            return disposables;
        });
    }

    void executeAll(@NotNull Disposable object, boolean processUnregistered) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(13);
        }
        this.runWithTrace(() -> {
            ObjectNode node2 = this.getNode(object);
            if (node2 == null && !processUnregistered) {
                return Collections.emptyList();
            }
            ArrayList<Disposable> disposables = new ArrayList<Disposable>();
            if (node2 == null) {
                if (this.rememberDisposedTrace(object) == null) {
                    disposables.add(object);
                }
            } else {
                node2.getAndRemoveRecursively(this, disposables);
            }
            return disposables;
        });
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            ObjectTree.$$$reportNull$$$0(14);
        }
        if (exceptions.isEmpty()) {
            return;
        }
        ProcessCanceledException processCanceledException = null;
        for (Throwable throwable : exceptions) {
            if (!(throwable instanceof ProcessCanceledException)) {
                ObjectTree.getLogger().error(throwable);
                continue;
            }
            if (processCanceledException != null) continue;
            processCanceledException = (ProcessCanceledException)throwable;
        }
        if (processCanceledException != null) {
            throw processCanceledException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    void assertNoReferenceKeptInTree(@NotNull Disposable disposable) {
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(15);
        }
        Object object = this.treeLock;
        synchronized (object) {
            for (ObjectNode node2 : this.myObject2NodeMap.values()) {
                node2.assertNoReferencesKept(disposable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            this.ROOT_NODE.assertNoChildren(throwError);
        }
    }

    Throwable getRegistrationTrace(@NotNull Disposable object) {
        ObjectNode objectNode;
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(16);
        }
        return (objectNode = this.getNode(object)) == null ? null : objectNode.getTrace();
    }

    @NotNull
    static Logger getLogger() {
        Logger logger = Logger.getInstance(ObjectTree.class);
        if (logger == null) {
            ObjectTree.$$$reportNull$$$0(17);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object rememberDisposedTrace(@NotNull Disposable object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(18);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            return this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDisposedObjectTraces() {
        Object object = this.treeLock;
        synchronized (object) {
            this.myDisposedObjects.clear();
            for (ObjectNode value : this.myObject2NodeMap.values()) {
                value.clearTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObjectFromTree(@NotNull ObjectNode node2) {
        if (node2 == null) {
            ObjectTree.$$$reportNull$$$0(19);
        }
        Object object = this.treeLock;
        synchronized (object) {
            Disposable myObject = node2.getObject();
            this.myObject2NodeMap.remove(myObject);
            ObjectNode parent = node2.getParent();
            parent.removeChild(node2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeFromTreeAction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ObjectTree";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateParentNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateChildNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkWasNotAddedAlreadyAsChild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateParentNode";
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateChildNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runWithTrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeAllChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeAll";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleExceptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferenceKeptInTree";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrationTrace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rememberDisposedTrace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeObjectFromTree";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

