/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithMnemonic {
    public static final TextWithMnemonic EMPTY = new TextWithMnemonic("", -1, "");
    public static final Pattern MNEMONIC = Pattern.compile(" ?\\(_?[A-Z]\\)");
    @NotNull
    @Nls
    private final String myText;
    private final int myMnemonicIndex;
    @NotNull
    @Nls
    private final String myMnemonicSuffix;

    private TextWithMnemonic(@NotNull @Nls String text2, int mnemonicIndex, @NotNull @Nls String mnemonicSuffix) {
        if (text2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(0);
        }
        if (mnemonicSuffix == null) {
            TextWithMnemonic.$$$reportNull$$$0(1);
        }
        assert (mnemonicIndex >= 0 || mnemonicSuffix.isEmpty());
        assert (mnemonicIndex >= -1 && mnemonicIndex < text2.length() + mnemonicSuffix.length());
        this.myText = StringUtil.internEmptyString(text2);
        this.myMnemonicIndex = mnemonicIndex;
        this.myMnemonicSuffix = mnemonicSuffix;
    }

    @NotNull
    @Nls
    public String getText() {
        String string2 = this.getText(false);
        if (string2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    @Nls
    public String getText(boolean withMnemonicSuffix) {
        if (this.myMnemonicSuffix.isEmpty()) {
            String string2 = this.myText;
            if (string2 == null) {
                TextWithMnemonic.$$$reportNull$$$0(3);
            }
            return string2;
        }
        if (withMnemonicSuffix) {
            String string3 = this.myText + this.myMnemonicSuffix;
            if (string3 == null) {
                TextWithMnemonic.$$$reportNull$$$0(4);
            }
            return string3;
        }
        int ellipsisLength = TextWithMnemonic.getEllipsisLength(this.myMnemonicSuffix);
        if (ellipsisLength == 0) {
            String string4 = this.myText;
            if (string4 == null) {
                TextWithMnemonic.$$$reportNull$$$0(5);
            }
            return string4;
        }
        String string5 = this.myText + this.myMnemonicSuffix.substring(this.myMnemonicSuffix.length() - ellipsisLength);
        if (string5 == null) {
            TextWithMnemonic.$$$reportNull$$$0(6);
        }
        return string5;
    }

    @Deprecated
    public int getMnemonic() {
        char ch = this.getMnemonicChar();
        return ch == '\uffff' ? (char)'\u0000' : Character.toUpperCase(ch);
    }

    public int getMnemonicCode() {
        char ch = this.getMnemonicChar();
        return ch == '\uffff' ? 0 : KeyEvent.getExtendedKeyCodeForChar(ch);
    }

    public char getMnemonicChar() {
        if (this.myMnemonicIndex < 0) {
            return '\uffff';
        }
        int index = this.myMnemonicIndex - this.myText.length();
        return index < 0 ? this.myText.charAt(this.myMnemonicIndex) : this.myMnemonicSuffix.charAt(index);
    }

    public int getMnemonicIndex() {
        return this.myMnemonicIndex;
    }

    public boolean hasMnemonic() {
        return this.myMnemonicIndex >= 0;
    }

    public TextWithMnemonic dropMnemonic(boolean forceRemove) {
        if (!this.hasMnemonic()) {
            return this;
        }
        if (!forceRemove) {
            return TextWithMnemonic.fromPlainText(this.myText);
        }
        Matcher matcher = MNEMONIC.matcher(this.myText);
        if (matcher.find()) {
            return TextWithMnemonic.fromPlainText(matcher.replaceAll(""));
        }
        return this;
    }

    @Deprecated
    public TextWithMnemonic setMnemonicAt(int index) {
        if (index < 0 || index >= this.myText.length() + this.myMnemonicSuffix.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return index == this.myMnemonicIndex ? this : new TextWithMnemonic(this.myText, index, this.myMnemonicSuffix);
    }

    @NotNull
    public TextWithMnemonic withMnemonicIndex(int index) {
        if (index == this.myMnemonicIndex) {
            TextWithMnemonic textWithMnemonic = this;
            if (textWithMnemonic == null) {
                TextWithMnemonic.$$$reportNull$$$0(7);
            }
            return textWithMnemonic;
        }
        if (index >= -1) {
            String text2 = this.getText();
            if (index == -1) {
                return TextWithMnemonic.fromPlainText(text2);
            }
            if (index < text2.length() - TextWithMnemonic.getEllipsisLength(text2)) {
                return TextWithMnemonic.fromPlainTextWithIndex(text2, index);
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public TextWithMnemonic append(@NotNull @Nls String textToAppend) {
        if (textToAppend == null) {
            TextWithMnemonic.$$$reportNull$$$0(8);
        }
        return new TextWithMnemonic(this.myText + textToAppend, this.myMnemonicIndex < this.myText.length() ? this.myMnemonicIndex : this.myMnemonicIndex + textToAppend.length(), this.myMnemonicSuffix);
    }

    public TextWithMnemonic replaceFirst(@NotNull String target2, @Nls @NotNull String replacement) {
        int index;
        if (target2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(9);
        }
        if (replacement == null) {
            TextWithMnemonic.$$$reportNull$$$0(10);
        }
        if ((index = this.myText.indexOf(target2)) == -1) {
            return this;
        }
        String resultText = this.myText.substring(0, index) + replacement + this.myText.substring(index + target2.length());
        int resultIndex = this.myMnemonicIndex < index ? this.myMnemonicIndex : (this.myMnemonicIndex >= index + target2.length() ? this.myMnemonicIndex - target2.length() + replacement.length() : -1);
        return new TextWithMnemonic(resultText, resultIndex, this.myMnemonicSuffix);
    }

    @ApiStatus.Internal
    @Nullable
    public static TextWithMnemonic fromMnemonicText(@NotNull @Nls String text2) {
        int pos;
        if (text2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(11);
        }
        if ((pos = text2.indexOf(27)) < 0) {
            return null;
        }
        String str = text2.substring(pos + 1);
        if (str.isEmpty()) {
            throw new IllegalArgumentException("unexpected mnemonic marker in " + text2);
        }
        if (str.indexOf(27) >= 0) {
            throw new IllegalArgumentException("several mnemonic markers in " + text2);
        }
        return TextWithMnemonic.fromPlainTextWithIndex((String)(pos > 0 ? text2.substring(0, pos) + str : str), pos);
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic fromPlainText(@NotNull @Nls String text2) {
        if (text2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(12);
        }
        return text2.isEmpty() ? EMPTY : new TextWithMnemonic(text2, -1, "");
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic fromPlainText(@NotNull @Nls String text2, char mnemonicChar) {
        if (text2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(13);
        }
        if (mnemonicChar == '\u0000') {
            return TextWithMnemonic.fromPlainText(text2);
        }
        mnemonicChar = Character.toUpperCase(mnemonicChar);
        for (int i = 0; i < text2.length(); ++i) {
            if (Character.toUpperCase(text2.charAt(i)) != mnemonicChar) continue;
            return new TextWithMnemonic(text2, i, "");
        }
        int ellipsisLength = TextWithMnemonic.getEllipsisLength(text2);
        String suffix = "(" + mnemonicChar + ")" + text2.substring(text2.length() - ellipsisLength);
        text2 = text2.substring(0, text2.length() - ellipsisLength);
        return new TextWithMnemonic(text2, text2.length() + 1, suffix);
    }

    @NotNull
    public static TextWithMnemonic fromPlainTextWithIndex(@NotNull @Nls String text2, int index) {
        int pos;
        if (text2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(14);
        }
        if (index < 0) {
            return TextWithMnemonic.fromPlainText(text2);
        }
        if (index < text2.length() && (pos = text2.length() - TextWithMnemonic.getEllipsisLength(text2) - 3) >= 0 && index == pos + 1 && text2.charAt(pos) == '(' && text2.charAt(pos + 2) == ')') {
            while (pos > 0 && text2.charAt(pos - 1) == ' ') {
                --pos;
            }
            return new TextWithMnemonic(text2.substring(0, pos), index, text2.substring(pos));
        }
        return new TextWithMnemonic(text2, index, "");
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic parse(@NotNull @Nls String text2) {
        TextWithMnemonic mnemonic;
        if (text2 == null) {
            TextWithMnemonic.$$$reportNull$$$0(15);
        }
        TextWithMnemonic textWithMnemonic = mnemonic = text2.isEmpty() ? EMPTY : TextWithMnemonic.fromMnemonicText(text2);
        if (mnemonic != null) {
            TextWithMnemonic textWithMnemonic2 = mnemonic;
            if (textWithMnemonic2 == null) {
                TextWithMnemonic.$$$reportNull$$$0(16);
            }
            return textWithMnemonic2;
        }
        if (text2.contains("_") || text2.contains("&")) {
            @Nls StringBuilder plainText = new StringBuilder();
            int mnemonicIndex = -1;
            int backShift = 0;
            for (int i = 0; i < text2.length(); ++i) {
                char ch = text2.charAt(i);
                if (mnemonicIndex == -1 && (ch == '_' || ch == '&')) {
                    if (++i >= text2.length()) break;
                    ch = text2.charAt(i);
                    if (ch != '_' && ch != '&') {
                        mnemonicIndex = i - 1 - backShift;
                    } else {
                        ++backShift;
                    }
                }
                plainText.append(ch);
            }
            return TextWithMnemonic.fromPlainTextWithIndex(plainText.toString(), mnemonicIndex);
        }
        return TextWithMnemonic.fromPlainText(text2);
    }

    private static int getEllipsisLength(String text2) {
        if (text2.endsWith("...")) {
            return 3;
        }
        if (text2.endsWith("\u2026")) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextWithMnemonic mnemonic = (TextWithMnemonic)o;
        return this.myMnemonicIndex == mnemonic.myMnemonicIndex && this.myText.equals(mnemonic.myText) && this.myMnemonicSuffix.equals(mnemonic.myMnemonicSuffix);
    }

    public int hashCode() {
        return (this.myText.hashCode() * 31 + this.myMnemonicIndex) * 31 + this.myMnemonicSuffix.hashCode();
    }

    @Nls
    public String toString() {
        if (this.myMnemonicIndex > -1) {
            String completeText = this.myText + this.myMnemonicSuffix;
            String prefix = StringUtil.escapeMnemonics(completeText.substring(0, this.myMnemonicIndex));
            String suffix = completeText.substring(this.myMnemonicIndex);
            return prefix + "_" + suffix;
        }
        return StringUtil.escapeMnemonics(this.myText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mnemonicSuffix";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToAppend";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withMnemonicIndex";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceFirst";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromMnemonicText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fromPlainText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fromPlainTextWithIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

