/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    public static final String PROTOCOL = "file";
    public static final String PROTOCOL_PREFIX = "file://";

    public static LocalFileSystem getInstance() {
        return LocalFileSystemHolder.ourInstance;
    }

    @Nullable
    public VirtualFile findFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            LocalFileSystem.$$$reportNull$$$0(0);
        }
        return this.findFileByPath(file2.getAbsolutePath());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            LocalFileSystem.$$$reportNull$$$0(1);
        }
        return this.refreshAndFindFileByPath(file2.getAbsolutePath());
    }

    @Nullable
    public VirtualFile findFileByNioFile(@NotNull Path file2) {
        if (file2 == null) {
            LocalFileSystem.$$$reportNull$$$0(2);
        }
        return this.findFileByPath(file2.toAbsolutePath().toString());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByNioFile(@NotNull Path file2) {
        if (file2 == null) {
            LocalFileSystem.$$$reportNull$$$0(3);
        }
        return this.refreshAndFindFileByPath(file2.toAbsolutePath().toString());
    }

    public void refreshIoFiles(@NotNull Iterable<? extends File> files2) {
        if (files2 == null) {
            LocalFileSystem.$$$reportNull$$$0(4);
        }
        this.refreshIoFiles(files2, false, false, null);
    }

    public final void refreshNioFiles(@NotNull Iterable<? extends Path> files2) {
        if (files2 == null) {
            LocalFileSystem.$$$reportNull$$$0(5);
        }
        this.refreshNioFiles(files2, false, false, null);
    }

    public abstract void refreshIoFiles(@NotNull Iterable<? extends File> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public abstract void refreshNioFiles(@NotNull Iterable<? extends Path> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files2) {
        if (files2 == null) {
            LocalFileSystem.$$$reportNull$$$0(6);
        }
        this.refreshFiles(files2, false, false, null);
    }

    public abstract void refreshFiles(@NotNull Iterable<? extends VirtualFile> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    @Nullable
    public WatchRequest addRootToWatch(@NotNull String rootPath, boolean watchRecursively) {
        Set<WatchRequest> result2;
        if (rootPath == null) {
            LocalFileSystem.$$$reportNull$$$0(7);
        }
        return (result2 = this.addRootsToWatch(Collections.singleton(rootPath), watchRecursively)).size() == 1 ? result2.iterator().next() : null;
    }

    @NotNull
    public Set<WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths == null) {
            LocalFileSystem.$$$reportNull$$$0(8);
        }
        if (rootPaths.isEmpty()) {
            Set<WatchRequest> set2 = Collections.emptySet();
            if (set2 == null) {
                LocalFileSystem.$$$reportNull$$$0(9);
            }
            return set2;
        }
        if (watchRecursively) {
            Set<WatchRequest> set3 = this.replaceWatchedRoots(Collections.emptySet(), rootPaths, null);
            if (set3 == null) {
                LocalFileSystem.$$$reportNull$$$0(10);
            }
            return set3;
        }
        Set<WatchRequest> set4 = this.replaceWatchedRoots(Collections.emptySet(), null, rootPaths);
        if (set4 == null) {
            LocalFileSystem.$$$reportNull$$$0(11);
        }
        return set4;
    }

    public void removeWatchedRoot(@NotNull WatchRequest watchRequest) {
        if (watchRequest == null) {
            LocalFileSystem.$$$reportNull$$$0(12);
        }
        this.removeWatchedRoots(Collections.singleton(watchRequest));
    }

    public void removeWatchedRoots(@NotNull Collection<WatchRequest> watchRequests) {
        if (watchRequests == null) {
            LocalFileSystem.$$$reportNull$$$0(13);
        }
        if (!watchRequests.isEmpty()) {
            this.replaceWatchedRoots(watchRequests, null, null);
        }
    }

    @Nullable
    public WatchRequest replaceWatchedRoot(@Nullable WatchRequest watchRequest, @NotNull String rootPath, boolean watchRecursively) {
        if (rootPath == null) {
            LocalFileSystem.$$$reportNull$$$0(14);
        }
        Set<WatchRequest> requests = watchRequest != null ? Collections.singleton(watchRequest) : Collections.emptySet();
        Set<String> roots2 = Collections.singleton(rootPath);
        Set<WatchRequest> result2 = watchRecursively ? this.replaceWatchedRoots(requests, roots2, null) : this.replaceWatchedRoots(requests, null, roots2);
        return result2.size() == 1 ? result2.iterator().next() : null;
    }

    @NotNull
    public abstract Set<WatchRequest> replaceWatchedRoots(@NotNull Collection<WatchRequest> var1, @Nullable Collection<String> var2, @Nullable Collection<String> var3);

    public abstract void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROTOCOL;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPaths";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/LocalFileSystem";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequest";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/LocalFileSystem";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addRootsToWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNioFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByNioFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshIoFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshNioFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRootToWatch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToWatch";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchedRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchedRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoot";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface WatchRequest {
        @NotNull
        public @SystemIndependent String getRootPath();

        public boolean isToWatchRecursively();
    }

    private static class LocalFileSystemHolder {
        private static final LocalFileSystem ourInstance = (LocalFileSystem)VirtualFileManager.getInstance().getFileSystem("file");

        private LocalFileSystemHolder() {
        }
    }
}

