/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAttribute {
    private static final Set<String> ourRegisteredIds = ContainerUtil.newConcurrentSet();
    private static final int UNDEFINED_VERSION = -1;
    private final String myId;
    private final int myVersion;
    private final boolean myFixedSize;
    private final boolean myShouldEnumerate;

    public FileAttribute(@NonNls @NotNull String id2) {
        if (id2 == null) {
            FileAttribute.$$$reportNull$$$0(0);
        }
        this(id2, -1, false, false);
    }

    public FileAttribute(@NonNls @NotNull String id2, int version, boolean fixedSize) {
        if (id2 == null) {
            FileAttribute.$$$reportNull$$$0(1);
        }
        this(id2, version, fixedSize, false);
    }

    public FileAttribute(@NonNls @NotNull String id2, int version, boolean fixedSize, boolean shouldEnumerate) {
        if (id2 == null) {
            FileAttribute.$$$reportNull$$$0(2);
        }
        this(version, fixedSize, id2, shouldEnumerate);
        boolean added = ourRegisteredIds.add(id2);
        assert (added) : "Attribute id='" + id2 + "' is not unique";
    }

    private FileAttribute(int version, boolean fixedSize, @NotNull String id2, boolean shouldEnumerate) {
        if (id2 == null) {
            FileAttribute.$$$reportNull$$$0(3);
        }
        this.myId = id2;
        this.myVersion = version;
        this.myFixedSize = fixedSize;
        this.myShouldEnumerate = shouldEnumerate;
    }

    @Deprecated
    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAttribute.$$$reportNull$$$0(4);
        }
        return ManagingFS.getInstance().readAttribute(file2, this);
    }

    @Deprecated
    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAttribute.$$$reportNull$$$0(5);
        }
        AttributeOutputStream attributeOutputStream = ManagingFS.getInstance().writeAttribute(file2, this);
        if (attributeOutputStream == null) {
            FileAttribute.$$$reportNull$$$0(6);
        }
        return attributeOutputStream;
    }

    @Nullable
    public AttributeInputStream readFileAttribute(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAttribute.$$$reportNull$$$0(7);
        }
        return ManagingFS.getInstance().readAttribute(file2, this);
    }

    @NotNull
    public AttributeOutputStream writeFileAttribute(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileAttribute.$$$reportNull$$$0(8);
        }
        AttributeOutputStream attributeOutputStream = ManagingFS.getInstance().writeAttribute(file2, this);
        if (attributeOutputStream == null) {
            FileAttribute.$$$reportNull$$$0(9);
        }
        return attributeOutputStream;
    }

    public byte @Nullable [] readAttributeBytes(VirtualFile file2) throws IOException {
        try (DataInputStream stream = this.readAttribute(file2);){
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            int len = stream.readInt();
            byte[] byArray = FileUtil.loadBytes(stream, len);
            return byArray;
        }
    }

    public void writeAttributeBytes(VirtualFile file2, byte @NotNull [] bytes) throws IOException {
        if (bytes == null) {
            FileAttribute.$$$reportNull$$$0(10);
        }
        this.writeAttributeBytes(file2, bytes, 0, bytes.length);
    }

    public void writeAttributeBytes(VirtualFile file2, byte[] bytes, int offset, int len) throws IOException {
        try (DataOutputStream stream = this.writeAttribute(file2);){
            stream.writeInt(len);
            stream.write(bytes, offset, len);
        }
    }

    @NotNull
    public String getId() {
        String string2 = this.myId;
        if (string2 == null) {
            FileAttribute.$$$reportNull$$$0(11);
        }
        return string2;
    }

    public boolean isFixedSize() {
        return this.myFixedSize;
    }

    @NotNull
    public FileAttribute newVersion(int newVersion) {
        return new FileAttribute(newVersion, this.myFixedSize, this.myId, this.myShouldEnumerate);
    }

    public int getVersion() {
        return this.myVersion;
    }

    public boolean isVersioned() {
        return this.myVersion != -1;
    }

    public static void resetRegisteredIds() {
        ourRegisteredIds.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "writeFileAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFileAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeFileAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributeBytes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

