/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusWatcher
implements ContainerListener,
FocusListener {
    private WeakReference<Component> myTopComponent;
    private WeakReference<Component> myFocusedComponent;
    private WeakReference<Component> myNearestFocusableComponent;

    public Component getTopComponent() {
        return SoftReference.dereference(this.myTopComponent);
    }

    @Override
    public final void componentAdded(ContainerEvent e) {
        this.installImpl(e.getChild());
    }

    @Override
    public final void componentRemoved(ContainerEvent e) {
        Component removedChild = e.getChild();
        if (this.getNearestFocusableComponent() != null && SwingUtilities.isDescendingFrom(this.getNearestFocusableComponent(), removedChild)) {
            this.setNearestFocusableComponent(null);
        }
        if (this.getFocusedComponent() != null && SwingUtilities.isDescendingFrom(this.getFocusedComponent(), removedChild)) {
            this.setNearestFocusableComponent(e.getContainer());
        }
        this.deinstall(removedChild, e);
    }

    public final void deinstall(Component component2) {
        this.deinstall(component2, null);
    }

    public final void deinstall(Component component2, @Nullable AWTEvent cause) {
        if (component2 == null) {
            return;
        }
        if (component2 instanceof Container) {
            Container container = (Container)component2;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.deinstall(container.getComponent(i));
            }
            container.removeContainerListener(this);
        }
        component2.removeFocusListener(this);
        if (this.getFocusedComponent() == component2) {
            this.setFocusedComponentImpl(null, cause);
        }
    }

    @Override
    public final void focusGained(FocusEvent e) {
        Component component2 = e.getComponent();
        if (e.isTemporary() || !component2.isShowing()) {
            return;
        }
        if (component2 instanceof JTextComponent) {
            UIUtil.addUndoRedoActions((JTextComponent)component2);
        }
        this.setFocusedComponentImpl(component2, e);
        this.setNearestFocusableComponent(component2.getParent());
    }

    @Override
    public final void focusLost(FocusEvent e) {
        Component component2 = e.getOppositeComponent();
        if (component2 != null && !SwingUtilities.isDescendingFrom(component2, SoftReference.dereference(this.myTopComponent))) {
            this.focusLostImpl(e);
        }
    }

    public final Component getFocusedComponent() {
        return SoftReference.dereference(this.myFocusedComponent);
    }

    private Component getNearestFocusableComponent() {
        return SoftReference.dereference(this.myNearestFocusableComponent);
    }

    public final void install(@NotNull Component component2) {
        if (component2 == null) {
            FocusWatcher.$$$reportNull$$$0(0);
        }
        this.myTopComponent = new WeakReference<Component>(component2);
        this.installImpl(component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installImpl(Component component2) {
        if (component2 instanceof Container) {
            Container container = (Container)component2;
            Object object = container.getTreeLock();
            synchronized (object) {
                int componentCount = container.getComponentCount();
                for (int i = 0; i < componentCount; ++i) {
                    this.installImpl(container.getComponent(i));
                }
                container.addContainerListener(this);
            }
        }
        if (component2 instanceof JMenuItem || component2 instanceof JMenuBar) {
            return;
        }
        component2.addFocusListener(this);
    }

    public void setFocusedComponentImpl(Component component2) {
        this.setFocusedComponentImpl(component2, null);
    }

    private void setFocusedComponentImpl(Component component2, @Nullable AWTEvent cause) {
        if (!this.isFocusedComponentChangeValid(component2, cause)) {
            return;
        }
        if (UIUtil.isFocusProxy(component2)) {
            this._setFocused(this.getFocusedComponent(), cause);
            return;
        }
        this._setFocused(component2, cause);
    }

    private void _setFocused(Component component2, AWTEvent cause) {
        this.setFocusedComponent(component2);
        this.focusedComponentChanged(component2, cause);
    }

    protected boolean isFocusedComponentChangeValid(@Nullable Component component2, @Nullable AWTEvent cause) {
        return component2 != null || cause != null;
    }

    protected void focusedComponentChanged(@Nullable Component component2, @Nullable AWTEvent cause) {
    }

    protected void focusLostImpl(FocusEvent e) {
    }

    private void setFocusedComponent(Component focusedComponent) {
        this.myFocusedComponent = new WeakReference<Component>(focusedComponent);
    }

    private void setNearestFocusableComponent(Component nearestFocusableComponent) {
        this.myNearestFocusableComponent = new WeakReference<Component>(nearestFocusableComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/FocusWatcher", "install"));
    }
}

