/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class FindDependencyUtil {
    private FindDependencyUtil() {
    }

    public static UsageInfo[] findDependencies(@Nullable List<? extends DependenciesBuilder> builders, Set<? extends PsiFile> searchIn, Set<? extends PsiFile> searchFor) {
        ArrayList usages = new ArrayList();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        int totalCount = searchIn.size();
        int count2 = 0;
        for (PsiFile psiFile : searchIn) {
            Set<? extends PsiFile> precomputedDeps;
            count2 = FindDependencyUtil.updateIndicator(indicator, totalCount, count2, psiFile);
            if (!psiFile.isValid()) continue;
            if (builders != null) {
                HashSet<PsiFile> depsByFile = new HashSet<PsiFile>();
                for (DependenciesBuilder dependenciesBuilder : builders) {
                    Set<PsiFile> deps = dependenciesBuilder.getDependencies().get(psiFile);
                    if (deps == null) continue;
                    depsByFile.addAll(deps);
                }
                precomputedDeps = new HashSet<PsiFile>(depsByFile);
                precomputedDeps.retainAll(searchFor);
                if (precomputedDeps.isEmpty()) {
                    continue;
                }
            } else {
                precomputedDeps = Collections.unmodifiableSet(searchFor);
            }
            FindDependencyUtil.analyzeFileDependencies(psiFile, precomputedDeps, usages);
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    public static UsageInfo[] findBackwardDependencies(List<? extends DependenciesBuilder> builders, Set<? extends PsiFile> searchIn, Set<? extends PsiFile> searchFor) {
        ArrayList usages = new ArrayList();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        HashSet<PsiFile> deps = new HashSet<PsiFile>();
        for (PsiFile psiFile : searchFor) {
            for (DependenciesBuilder dependenciesBuilder : builders) {
                Set<PsiFile> depsByBuilder = dependenciesBuilder.getDependencies().get(psiFile);
                if (depsByBuilder == null) continue;
                deps.addAll(depsByBuilder);
            }
        }
        deps.retainAll(searchIn);
        if (deps.isEmpty()) {
            return UsageInfo.EMPTY_ARRAY;
        }
        int totalCount = deps.size();
        boolean bl = false;
        for (PsiFile psiFile : deps) {
            int n;
            n = FindDependencyUtil.updateIndicator(indicator, totalCount, n, psiFile);
            FindDependencyUtil.analyzeFileDependencies(psiFile, searchFor, usages);
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static void analyzeFileDependencies(PsiFile psiFile, Set<? extends PsiFile> searchFor, List<? super UsageInfo> result2) {
        DependenciesBuilder.analyzeFileDependencies(psiFile, (place, dependency) -> {
            PsiElement navigationElement;
            PsiFile dependencyFile = dependency.getContainingFile();
            if (dependencyFile != null && (navigationElement = dependencyFile.getNavigationElement()) instanceof PsiFile) {
                dependencyFile = (PsiFile)navigationElement;
            }
            if (searchFor.contains(dependencyFile)) {
                result2.add(new UsageInfo(place));
            }
        });
    }

    private static int updateIndicator(ProgressIndicator indicator, int totalCount, int count2, PsiFile psiFile) {
        if (indicator != null) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled((ProgressIndicator)indicator);
            indicator.setFraction((double)(++count2) / (double)totalCount);
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 != null) {
                indicator.setText(CodeInsightBundle.message("find.dependencies.progress.text", virtualFile2.getPresentableUrl()));
            }
        }
        return count2;
    }

    public static UsageInfo[] findDependencies(DependenciesBuilder builder2, Set<? extends PsiFile> searchIn, Set<? extends PsiFile> searchFor) {
        return FindDependencyUtil.findDependencies(Collections.singletonList(builder2), searchIn, searchFor);
    }

    public static UsageInfo[] findBackwardDependencies(DependenciesBuilder builder2, Set<? extends PsiFile> searchIn, Set<? extends PsiFile> searchFor) {
        return FindDependencyUtil.findBackwardDependencies(Collections.singletonList(builder2), searchIn, searchFor);
    }
}

