/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class DependenciesHandlerBase {
    @NotNull
    protected final Project myProject;
    private final List<? extends AnalysisScope> myScopes;
    private final Set<PsiFile> myExcluded;

    public DependenciesHandlerBase(@NotNull Project project2, List<? extends AnalysisScope> scopes, Set<PsiFile> excluded) {
        if (project2 == null) {
            DependenciesHandlerBase.$$$reportNull$$$0(0);
        }
        this.myScopes = scopes;
        this.myExcluded = excluded;
        this.myProject = project2;
    }

    public void analyze() {
        final ArrayList builders = new ArrayList();
        Task task2 = this.canStartInBackground() ? new Task.Backgroundable(this.myProject, this.getProgressTitle(), true, new PerformAnalysisInBackgroundOption(this.myProject)){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                DependenciesHandlerBase.this.perform(builders, indicator);
            }

            @Override
            public void onSuccess() {
                DependenciesHandlerBase.this.onSuccess(builders);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packageDependencies/actions/DependenciesHandlerBase$1", "run"));
            }
        } : new Task.Modal(this.myProject, this.getProgressTitle(), true){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                DependenciesHandlerBase.this.perform(builders, indicator);
            }

            @Override
            public void onSuccess() {
                DependenciesHandlerBase.this.onSuccess(builders);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packageDependencies/actions/DependenciesHandlerBase$2", "run"));
            }
        };
        ProgressManager.getInstance().run(task2);
    }

    protected boolean canStartInBackground() {
        return true;
    }

    protected boolean shouldShowDependenciesPanel(List<? extends DependenciesBuilder> builders) {
        return true;
    }

    @NlsContexts.ProgressTitle
    protected abstract String getProgressTitle();

    @NlsContexts.TabTitle
    protected abstract String getPanelDisplayName(AnalysisScope var1);

    protected abstract DependenciesBuilder createDependenciesBuilder(AnalysisScope var1);

    private void perform(List<DependenciesBuilder> builders, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DependenciesHandlerBase.$$$reportNull$$$0(1);
        }
        try {
            PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
            for (AnalysisScope analysisScope : this.myScopes) {
                builders.add(this.createDependenciesBuilder(analysisScope));
            }
            for (DependenciesBuilder dependenciesBuilder : builders) {
                dependenciesBuilder.analyze();
            }
            snapshot.logResponsivenessSinceCreation("Dependency analysis");
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance(this.myProject).showDumbModeNotification(CodeInsightBundle.message("analyze.dependencies.not.available.notification.indexing", new Object[0]));
            throw new ProcessCanceledException();
        }
    }

    private void onSuccess(List<DependenciesBuilder> builders) {
        SwingUtilities.invokeLater(() -> {
            if (this.shouldShowDependenciesPanel(builders)) {
                String displayName = this.getPanelDisplayName(builders);
                DependenciesPanel panel2 = new DependenciesPanel(this.myProject, builders, this.myExcluded);
                Content content2 = ContentFactory.getInstance().createContent((JComponent)panel2, displayName, false);
                content2.setDisposer((Disposable)panel2);
                panel2.setContent(content2);
                DependenciesToolWindow.getInstance(this.myProject).addContent(content2);
            }
        });
    }

    @NlsContexts.TabTitle
    protected String getPanelDisplayName(List<? extends DependenciesBuilder> builders) {
        return this.getPanelDisplayName(builders.get(0).getScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packageDependencies/actions/DependenciesHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

