/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiFile;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleNode
extends PackageDependenciesNode
implements NavigatableWithText {
    @NotNull
    private final Module myModule;
    private final ModuleGrouper myModuleGrouper;

    public ModuleNode(@NotNull Module module, @Nullable ModuleGrouper moduleGrouper) {
        if (module == null) {
            ModuleNode.$$$reportNull$$$0(0);
        }
        super(module.getProject());
        this.myModule = module;
        this.myModuleGrouper = moduleGrouper;
    }

    @Override
    public void fillFiles(Set<? super PsiFile> set2, boolean recursively) {
        super.fillFiles(set2, recursively);
        int count2 = this.getChildCount();
        for (int i = 0; i < count2; ++i) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i);
            child.fillFiles(set2, true);
        }
    }

    @Override
    public boolean canNavigate() {
        return !this.myModule.isDisposed();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean focus) {
        ProjectSettingsService.getInstance(this.myModule.getProject()).openModuleSettings(this.myModule);
    }

    @Override
    public Icon getIcon() {
        return this.myModule.isDisposed() ? super.getIcon() : ModuleType.get((Module)this.myModule).getIcon();
    }

    @Override
    public String toString() {
        return this.myModuleGrouper != null ? this.myModuleGrouper.getShortenedName(this.myModule) : this.myModule.getName();
    }

    public String getModuleName() {
        return this.myModule.getName();
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ModuleNode.$$$reportNull$$$0(1);
        }
        return module;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleNode)) {
            return false;
        }
        ModuleNode moduleNode = (ModuleNode)o;
        return Comparing.equal(this.myModule, moduleNode.myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @Override
    public boolean isValid() {
        return !this.myModule.isDisposed();
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/ui/ModuleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/ui/ModuleNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

