/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.AppInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProjectInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.VisibleTreeState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.lang.LangBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPane;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPaneKt;
import com.intellij.profile.codeInspection.ui.EmptyInspectionTreeActionProvider;
import com.intellij.profile.codeInspection.ui.HighlightingChooser;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.InspectionUiUtilKt;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.ScopesOrderDialog;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.filter.InspectionFilterAction;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.DefaultTreeTableExpander;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleInspectionProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(SingleInspectionProfilePanel.class);
    @NonNls
    private static final String INSPECTION_FILTER_HISTORY = "INSPECTION_FILTER_HISTORY";
    private static final float DIVIDER_PROPORTION_DEFAULT = 0.5f;
    private static final int SECTION_GAP = 20;
    private final Map<String, ToolDescriptors> myInitialToolDescriptors;
    private final InspectionConfigTreeNode myRoot;
    private final Alarm myAlarm;
    private final ProjectInspectionProfileManager myProjectProfileManager;
    @NotNull
    private final InspectionProfileModifiableModel myProfile;
    private DescriptionEditorPane myDescription;
    private JBLabel myOptionsLabel;
    private JPanel myOptionsPanel;
    private JPanel myInspectionProfilePanel;
    private FilterComponent myProfileFilter;
    private final InspectionsFilter myInspectionsFilter;
    private boolean myModified;
    private InspectionsConfigTreeTable myTreeTable;
    private TreeExpander myTreeExpander;
    private boolean myIsInRestore;
    private DefaultActionGroup myCreateInspectionActions;
    private List<String> myInitialScopesOrder;
    private Disposable myDisposable;

    public SingleInspectionProfilePanel(@NotNull ProjectInspectionProfileManager projectProfileManager, @NotNull InspectionProfileModifiableModel profile) {
        if (projectProfileManager == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myInitialToolDescriptors = new HashMap<String, ToolDescriptors>();
        this.myRoot = new InspectionConfigTreeNode.Group(InspectionsBundle.message("inspection.root.node.title", new Object[0]));
        this.myAlarm = new Alarm();
        this.myInspectionsFilter = new InspectionsFilter(){

            @Override
            protected void filterChanged() {
                SingleInspectionProfilePanel.this.filterTree();
                SingleInspectionProfilePanel.this.updateEmptyText();
            }
        };
        this.myDisposable = Disposer.newDisposable();
        this.myProjectProfileManager = projectProfileManager;
        this.myProfile = profile;
    }

    public boolean differsFromDefault() {
        return this.myRoot.isProperSetting();
    }

    public void performProfileReset() {
        TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).traverse().processEach(n -> {
            InspectionConfigTreeNode node2 = (InspectionConfigTreeNode)n;
            if (node2 instanceof InspectionConfigTreeNode.Tool && node2.isProperSetting()) {
                ((InspectionConfigTreeNode.Tool)node2).getDefaultDescriptor().loadConfig();
            }
            return true;
        });
        this.getProfile().resetToBase(this.getProject());
        this.loadDescriptorsConfigs(true);
        this.postProcessModification();
        this.updateModificationMarker();
        this.myRoot.dropCache();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProjectProfileManager.getProject();
        if (project2 == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(2);
        }
        return project2;
    }

    private static VisibleTreeState getExpandedNodes(InspectionProfileImpl profile) {
        if (profile.isProjectLevel()) {
            return ProjectInspectionProfilesVisibleTreeState.getInstance(((ProjectInspectionProfileManager)profile.getProfileManager()).getProject()).getVisibleTreeState(profile);
        }
        return AppInspectionProfilesVisibleTreeState.getInstance().getVisibleTreeState(profile);
    }

    private static InspectionConfigTreeNode findGroupNodeByPath(String @NotNull [] path2, int idx, @NotNull InspectionConfigTreeNode node2) {
        if (node2 == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(4);
        }
        if (path2.length == idx) {
            return node2;
        }
        String currentKey = path2[idx];
        for (int i = 0; i < node2.getChildCount(); ++i) {
            InspectionConfigTreeNode currentNode = (InspectionConfigTreeNode)node2.getChildAt(i);
            if (!(currentNode instanceof InspectionConfigTreeNode.Group) || !((InspectionConfigTreeNode.Group)currentNode).getGroupName().equals(currentKey)) continue;
            return SingleInspectionProfilePanel.findGroupNodeByPath(path2, ++idx, currentNode);
        }
        return null;
    }

    @Nullable
    private static InspectionConfigTreeNode findNodeByKey(String name2, InspectionConfigTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)root.getChildAt(i);
            if (child instanceof InspectionConfigTreeNode.Tool) {
                if (!((InspectionConfigTreeNode.Tool)child).getKey().toString().equals(name2)) continue;
                return child;
            }
            InspectionConfigTreeNode node2 = SingleInspectionProfilePanel.findNodeByKey(name2, child);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    @Nls
    public static String renderSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(5);
        }
        if (HighlightSeverity.INFORMATION.equals(severity)) {
            return LangBundle.message("single.inspection.profile.panel.no.highlighting.only.fix", new Object[0]);
        }
        return severity.getDisplayCapitalizedName();
    }

    private static boolean isDescriptorAccepted(Descriptor descriptor, @NonNls String filter2, boolean forceInclude, List<Set<String>> keySetList, Set<String> quoted) {
        filter2 = StringUtil.toLowerCase(filter2);
        if (StringUtil.containsIgnoreCase(descriptor.getText(), filter2)) {
            return true;
        }
        String[] groupPath = descriptor.getGroup();
        for (String group : groupPath) {
            if (!StringUtil.containsIgnoreCase(group, filter2)) continue;
            return true;
        }
        for (String string2 : quoted) {
            if (StringUtil.containsIgnoreCase(descriptor.getText(), string2)) {
                return true;
            }
            for (String group : groupPath) {
                if (!StringUtil.containsIgnoreCase(group, string2)) continue;
                return true;
            }
            String description = descriptor.getToolWrapper().loadDescription();
            if (description != null && StringUtil.containsIgnoreCase(StringUtil.toLowerCase(description), string2)) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        for (Set set2 : keySetList) {
            if (set2.contains(descriptor.getKey().toString())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    private void setConfigPanel(JPanel configPanelAnchor, ScopeToolState state) {
        configPanelAnchor.removeAll();
        JComponent additionalConfigPanel = state.getAdditionalConfigPanel();
        if (additionalConfigPanel != null) {
            additionalConfigPanel.setBorder(InspectionUiUtilKt.getBordersForOptions(additionalConfigPanel));
            configPanelAnchor.add(InspectionUiUtilKt.addScrollPaneIfNecessary(additionalConfigPanel));
        }
        if (this.myOptionsLabel != null) {
            this.myOptionsLabel.setText(AnalysisBundle.message("inspections.settings.options.title.specific.scope", state.getScopeName() == CustomScopesProviderEx.getAllScope().getScopeId() ? LangBundle.message("scopes.table.everywhere.else", new Object[0]) : state.getScopeName()));
        }
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String[] groupPath) {
        InspectionConfigTreeNode currentRoot = root;
        for (String group : groupPath) {
            currentRoot = SingleInspectionProfilePanel.getGroupNode(currentRoot, group);
        }
        return currentRoot;
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String group) {
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)root.getChildAt(i);
            if (!group.equals(child.getUserObject())) continue;
            return child;
        }
        InspectionConfigTreeNode.Group child = new InspectionConfigTreeNode.Group(group);
        root.add(child);
        return child;
    }

    private static void copyUsedSeveritiesIfUndefined(InspectionProfileImpl selectedProfile, BaseInspectionProfileManager profileManager) {
        SeverityRegistrar registrar = profileManager.getSeverityRegistrar();
        Set<HighlightSeverity> severities = selectedProfile.getUsedSeverities();
        severities.removeIf(severity -> registrar.isSeverityValid(severity.getName()));
        if (!severities.isEmpty()) {
            SeverityRegistrar oppositeRegister = selectedProfile.getProfileManager().getSeverityRegistrar();
            for (HighlightSeverity severity2 : severities) {
                TextAttributesKey attributesKey = TextAttributesKey.find(severity2.getName());
                TextAttributes textAttributes = oppositeRegister.getTextAttributesBySeverity(severity2);
                if (textAttributes == null) continue;
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(severity2, attributesKey);
                registrar.registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
            }
        }
    }

    private void initUI() {
        this.myInspectionProfilePanel = this.createInspectionProfileSettingsPanel();
        this.add((Component)this.myInspectionProfilePanel, "Center");
        UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
        userActivityWatcher.addUserActivityListener(() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.updateProperSettingsForSelection();
            this.updateModificationMarker();
        }));
        userActivityWatcher.register((Component)this.myOptionsPanel);
        this.updateSelectedProfileState();
        this.reset();
        this.getProject().getMessageBus().connect(this.myDisposable).subscribe(ProfileChangeAdapter.TOPIC, new ProfileChangeAdapter(){

            @Override
            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (SingleInspectionProfilePanel.this.myProfile == profile) {
                    SingleInspectionProfilePanel.this.initToolStates();
                    SingleInspectionProfilePanel.this.filterTree();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$2", "profileChanged"));
            }
        });
    }

    private void updateSelectedProfileState() {
        if (this.isDisposed()) {
            return;
        }
        this.restoreTreeState();
        this.repaintTableData();
        this.updateSelection();
    }

    public void updateSelection() {
        TreePath selectionPath;
        if (this.myTreeTable != null && (selectionPath = this.myTreeTable.getTree().getSelectionPath()) != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)((TreeNode)selectionPath.getLastPathComponent()));
            int rowForPath = this.myTreeTable.getTree().getRowForPath(selectionPath);
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void loadDescriptorsConfigs(boolean onlyModified) {
        this.myInitialToolDescriptors.values().stream().flatMap(ToolDescriptors::getDescriptors).forEach(d -> {
            if (!onlyModified || this.myProfile.isProperSetting(d.getKey().toString())) {
                d.loadConfig();
            }
        });
    }

    private void updateModificationMarker() {
        this.myModified = this.myInitialToolDescriptors.values().stream().flatMap(ToolDescriptors::getDescriptors).anyMatch(descriptor -> {
            Element oldConfig = descriptor.getConfig();
            if (oldConfig == null) {
                return false;
            }
            ScopeToolState state = descriptor.getState();
            Element newConfig = Descriptor.createConfigElement(state.getTool());
            if (!JDOMUtil.areElementsEqual(oldConfig, newConfig)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
                return true;
            }
            return false;
        });
    }

    private void updateProperSettingsForSelection() {
        InspectionConfigTreeNode node2;
        TreePath selectionPath = this.myTreeTable.getTree().getSelectionPath();
        if (selectionPath != null && (node2 = (InspectionConfigTreeNode)selectionPath.getLastPathComponent()) instanceof InspectionConfigTreeNode.Tool) {
            boolean properSetting = this.myProfile.isProperSetting(((InspectionConfigTreeNode.Tool)node2).getKey().toString());
            if (node2.isProperSetting() != properSetting) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
                InspectionConfigTreeNode.updateUpHierarchy(node2);
            }
        }
    }

    private void initToolStates() {
        if (this.isDisposed()) {
            return;
        }
        this.myInitialToolDescriptors.clear();
        Project project2 = this.getProject();
        for (ScopeToolState state : this.myProfile.getDefaultStates(this.getProject())) {
            if (!this.accept(state.getTool())) continue;
            ToolDescriptors descriptors = ToolDescriptors.fromScopeToolState(state, this.myProfile, project2);
            this.myInitialToolDescriptors.put(descriptors.getDefaultDescriptor().getShortName(), descriptors);
        }
        this.myInitialScopesOrder = this.myProfile.getScopesOrder();
    }

    private boolean isDisposed() {
        return this.myDisposable == null;
    }

    protected boolean accept(InspectionToolWrapper entry) {
        return !entry.getDefaultLevel().isNonSwitchable();
    }

    private void postProcessModification() {
        this.updateModificationMarker();
        for (ScopeToolState state : this.myProfile.getAllTools()) {
            state.resetConfigPanel();
        }
        this.fillTreeData(this.myProfileFilter.getFilter(), true);
        this.repaintTableData();
        this.updateOptionsAndDescriptionPanel();
    }

    public void setFilter(String filter2) {
        this.myProfileFilter.setFilter(filter2);
    }

    private void filterTree() {
        String filter2;
        String string2 = filter2 = this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null;
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.fillTreeData(filter2, true);
            this.reloadModel();
            this.restoreTreeState();
            if (this.myTreeTable.getTree().getSelectionPath() == null) {
                TreeUtil.promiseSelectFirst((JTree)this.myTreeTable.getTree());
            }
        }
    }

    private void reloadModel() {
        try {
            this.myIsInRestore = true;
            ((DefaultTreeModel)this.myTreeTable.getTree().getModel()).reload();
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private void restoreTreeState() {
        try {
            this.myIsInRestore = true;
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).restoreVisibleState((Tree)this.myTreeTable.getTree());
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actions2 = new DefaultActionGroup();
        actions2.add((AnAction)new InspectionFilterAction(this.myProfile, this.myInspectionsFilter, this.getProject(), this.myProfileFilter));
        actions2.addSeparator();
        actions2.add(actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions2.add(actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions2.add((AnAction)new DumbAwareAction(InspectionsBundle.messagePointer("action.DumbAware.SingleInspectionProfilePanel.text.reset.to.empty", new Object[0]), InspectionsBundle.messagePointer("action.DumbAware.SingleInspectionProfilePanel.description.reset.to.empty", new Object[0]), AllIcons.Actions.Unselectall){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!SingleInspectionProfilePanel.this.isDisposed() && SingleInspectionProfilePanel.this.myProfile.isExecutable(SingleInspectionProfilePanel.this.getProject()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                SingleInspectionProfilePanel.this.myProfile.resetToEmpty(SingleInspectionProfilePanel.this.getProject());
                SingleInspectionProfilePanel.this.loadDescriptorsConfigs(false);
                SingleInspectionProfilePanel.this.postProcessModification();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (InspectionProfileActionProvider provider2 : InspectionProfileActionProvider.EP_NAME.getExtensionList()) {
            for (AnAction action2 : provider2.getActions(this)) {
                actions2.add(action2);
            }
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SingleInspectionProfile", (ActionGroup)actions2, true);
        actionToolbar.setTargetComponent((JComponent)this);
        return actionToolbar;
    }

    private void repaintTableData() {
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.reloadModel();
            this.restoreTreeState();
        }
    }

    public void selectInspectionTool(String name2) {
        this.selectNode(SingleInspectionProfilePanel.findNodeByKey(name2, this.myRoot));
    }

    public void selectInspectionGroup(String[] path2) {
        InspectionConfigTreeNode node2 = SingleInspectionProfilePanel.findGroupNodeByPath(path2, 0, this.myRoot);
        this.selectNode(node2);
        if (node2 != null) {
            this.myTreeTable.getTree().expandPath(new TreePath(node2.getPath()));
        }
    }

    private void selectNode(InspectionConfigTreeNode node2) {
        if (node2 != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)node2);
            int rowForPath = this.myTreeTable.getTree().getRowForPath(new TreePath(node2.getPath()));
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void scrollToCenter() {
        ListSelectionModel selectionModel = this.myTreeTable.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, this.myTreeTable.getColumnModel().getSelectionModel().getMinSelectionIndex());
        Rectangle maxCellRect = this.myTreeTable.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = maxCellRect.getLocation();
        int allHeight = this.myTreeTable.getVisibleRect().height;
        this.myTreeTable.scrollRectToVisible(new Rectangle(new Point(0, Math.max(0, selectPoint.y - allHeight / 2)), new Dimension(0, allHeight)));
    }

    private JScrollPane initTreeScrollPane() {
        this.fillTreeData(null, true);
        InspectionsConfigTreeRenderer renderer = new InspectionsConfigTreeRenderer(){

            @Override
            protected String getFilter() {
                return SingleInspectionProfilePanel.this.myProfileFilter != null ? SingleInspectionProfilePanel.this.myProfileFilter.getFilter() : null;
            }
        };
        this.myTreeTable = InspectionsConfigTreeTable.create(new InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings(this.myRoot, this.getProject()){

            @Override
            protected void onChanged(@NotNull InspectionConfigTreeNode node2) {
                if (node2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                InspectionConfigTreeNode.updateUpHierarchy(node2);
            }

            @Override
            public void updateRightPanel() {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
            }

            @Override
            @NotNull
            public InspectionProfileImpl getInspectionProfile() {
                InspectionProfileModifiableModel inspectionProfileModifiableModel = SingleInspectionProfilePanel.this.myProfile;
                if (inspectionProfileModifiableModel == null) {
                    5.$$$reportNull$$$0(1);
                }
                return inspectionProfileModifiableModel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInspectionProfile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onChanged";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, this.myDisposable);
        this.myTreeTable.setTreeCellRenderer((TreeCellRenderer)((Object)renderer));
        this.myTreeTable.setRootVisible(false);
        this.myCreateInspectionActions = new DefaultActionGroup();
        for (EmptyInspectionTreeActionProvider provider2 : EmptyInspectionTreeActionProvider.EP_NAME.getExtensionList()) {
            this.myCreateInspectionActions.addAll(provider2.getActions(this));
        }
        this.updateEmptyText();
        TreeTableTree tree = this.myTreeTable.getTree();
        tree.putClientProperty((Object)DefaultTreeUI.LARGE_MODEL_ALLOWED, (Object)true);
        tree.setRowHeight(renderer.getTreeCellRendererComponent((JTree)tree, (Object)"xxx", (boolean)true, (boolean)true, (boolean)false, (int)0, (boolean)true).getPreferredSize().height);
        tree.setLargeModel(true);
        tree.addTreeSelectionListener(__ -> {
            if (this.myTreeTable.getTree().getSelectionPaths() != null) {
                this.updateOptionsAndDescriptionPanel();
            } else {
                this.initOptionsAndDescriptionPanel();
            }
            if (!this.myIsInRestore && !this.isDisposed()) {
                InspectionProfileImpl baseProfile = this.myProfile.getSource();
                SingleInspectionProfilePanel.getExpandedNodes(baseProfile).setSelectionPaths(this.myTreeTable.getTree().getSelectionPaths());
                SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).setSelectionPaths(this.myTreeTable.getTree().getSelectionPaths());
            }
        });
        this.myTreeTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                TreeTableTree tree = SingleInspectionProfilePanel.this.myTreeTable.getTree();
                int[] selectionRows = tree.getSelectionRows();
                if (selectionRows != null && tree.getPathForLocation(x, y) != null && Arrays.binarySearch(selectionRows, tree.getRowForLocation(x, y)) > -1) {
                    SingleInspectionProfilePanel.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        new TreeSpeedSearch((Tree)tree, o -> {
            InspectionConfigTreeNode node2 = (InspectionConfigTreeNode)o.getLastPathComponent();
            return InspectionsConfigTreeComparator.getDisplayTextToSort(node2.getText());
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeTable));
        tree.setShowsRootHandles(true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        TreeUtil.collapseAll((JTree)tree, (int)1);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                InspectionProfileModifiableModel selected = SingleInspectionProfilePanel.this.myProfile;
                SingleInspectionProfilePanel.getExpandedNodes(selected.getSource()).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
                SingleInspectionProfilePanel.getExpandedNodes(selected).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (!SingleInspectionProfilePanel.this.isDisposed()) {
                    InspectionConfigTreeNode node2 = (InspectionConfigTreeNode)event.getPath().getLastPathComponent();
                    SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile.getSource()).expandNode(node2);
                    SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile).expandNode(node2);
                }
            }
        });
        this.myTreeExpander = new DefaultTreeTableExpander((TreeTable)this.myTreeTable);
        this.myProfileFilter = new MyFilterComponent();
        return scrollPane;
    }

    private JPopupMenu compoundPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        SeverityRegistrar severityRegistrar = this.myProfile.getProfileManager().getSeverityRegistrar();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(severityRegistrar, this.includeDoNotShow())) {
            final HighlightDisplayLevel level = HighlightDisplayLevel.find(severity);
            group.add(new AnAction(SingleInspectionProfilePanel.renderSeverity(severity), SingleInspectionProfilePanel.renderSeverity(severity), level.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    SingleInspectionProfilePanel.this.setNewHighlightingLevel(level);
                }

                public boolean isDumbAware() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$8", "actionPerformed"));
                }
            });
        }
        group.add((AnAction)Separator.getInstance());
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
        return menu.getComponent();
    }

    private boolean includeDoNotShow() {
        TreePath[] paths2 = this.myTreeTable.getTree().getSelectionPaths();
        if (paths2 == null) {
            return true;
        }
        return this.includeDoNotShow(this.myTreeTable.getSelectedToolNodes());
    }

    private boolean includeDoNotShow(Collection<InspectionConfigTreeNode.Tool> nodes) {
        Project project2 = this.getProject();
        return !ContainerUtil.exists(nodes, node2 -> {
            InspectionToolWrapper<?, ?> tool = this.myProfile.getToolDefaultState(node2.getKey().toString(), project2).getTool();
            return tool instanceof GlobalInspectionToolWrapper && ((GlobalInspectionToolWrapper)tool).getSharedLocalInspectionToolWrapper() == null;
        });
    }

    private void fillTreeData(@Nullable String filter2, boolean forceInclude) {
        Set filters;
        if (this.isDisposed()) {
            return;
        }
        this.myRoot.removeAllChildren();
        this.myRoot.dropCache();
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        HashSet<String> quoted = new HashSet<String>();
        if (filter2 != null && !filter2.isEmpty()) {
            keySetList.addAll(SearchUtil.findKeys((String)filter2, quoted));
        }
        Project project2 = this.getProject();
        boolean emptyFilter = this.myInspectionsFilter.isEmptyFilter();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors.values()) {
            Descriptor descriptor = toolDescriptors.getDefaultDescriptor();
            if (filter2 != null && !filter2.isEmpty() && !SingleInspectionProfilePanel.isDescriptorAccepted(descriptor, filter2, forceInclude, keySetList, quoted)) continue;
            String shortName = toolDescriptors.getDefaultDescriptor().getShortName();
            InspectionConfigTreeNode.Tool node2 = new InspectionConfigTreeNode.Tool(() -> this.myInitialToolDescriptors.get(shortName));
            if (!emptyFilter && !this.myInspectionsFilter.matches(this.myProfile.getTools(shortName, project2), node2)) continue;
            SingleInspectionProfilePanel.getGroupNode(this.myRoot, toolDescriptors.getDefaultDescriptor().getGroup()).add(node2);
        }
        if (filter2 != null && forceInclude && this.myRoot.getChildCount() == 0 && ((filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter2)).size() > 1 || !quoted.isEmpty())) {
            this.fillTreeData(filter2, false);
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, InspectionsConfigTreeComparator.INSTANCE);
    }

    @Deprecated(forRemoval=true)
    public static void readHTML(JEditorPane browser, String text2) {
        DescriptionEditorPaneKt.readHTML(browser, text2);
    }

    @Deprecated(forRemoval=true)
    public static String toHTML(JEditorPane browser, @Nls String text2, boolean miniFontSize) {
        return DescriptionEditorPaneKt.toHTML(browser, text2, miniFontSize);
    }

    private void updateOptionsAndDescriptionPanel() {
        if (this.isDisposed()) {
            return;
        }
        final Collection<InspectionConfigTreeNode.Tool> nodes = this.myTreeTable.getSelectedToolNodes();
        if (!nodes.isEmpty()) {
            double severityPanelWeightY;
            boolean showOptionPanel;
            ScopesAndSeveritiesTable scopesAndScopesAndSeveritiesTable;
            boolean showDefaultConfigurationOptions;
            final Project project2 = this.getProject();
            InspectionConfigTreeNode.Tool singleNode = this.myTreeTable.getStrictlySelectedToolNode();
            ScopeToolState toolState = singleNode != null ? this.myProfile.getToolDefaultState(singleNode.getDefaultDescriptor().getKey().toString(), project2) : null;
            boolean bl = showDefaultConfigurationOptions = toolState == null || ((InspectionProfileEntry)toolState.getTool().getTool()).showDefaultConfigurationOptions();
            if (singleNode != null) {
                Descriptor descriptor = singleNode.getDefaultDescriptor();
                if (descriptor.loadDescription() != null) {
                    Descriptor defaultDescriptor = singleNode.getDefaultDescriptor();
                    String description = defaultDescriptor.loadDescription();
                    try {
                        if (description == null) {
                            throw new NullPointerException();
                        }
                        DescriptionEditorPaneKt.readHTML(this.myDescription, SearchUtil.markup((String)description, (String)this.myProfileFilter.getFilter()));
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to load description for: " + defaultDescriptor.getToolWrapper().getTool().getClass() + "; description: " + description, t);
                    }
                } else {
                    DescriptionEditorPaneKt.readHTML(this.myDescription, AnalysisBundle.message("inspections.settings.no.description.warning", new Object[0]));
                }
            } else {
                DescriptionEditorPaneKt.readHTML(this.myDescription, AnalysisBundle.message("inspections.settings.multiple.inspections.warning", new Object[0]));
            }
            this.myOptionsPanel.removeAll();
            JPanel severityPanel = new JPanel(new GridBagLayout());
            final JPanel configPanelAnchor = new JPanel(new GridLayout());
            HashSet<String> scopesNames = new HashSet<String>();
            for (InspectionConfigTreeNode.Tool node3 : nodes) {
                List<ScopeToolState> nonDefaultTools = this.myProfile.getNonDefaultTools(node3.getDefaultDescriptor().getKey().toString(), project2);
                for (ScopeToolState tool : nonDefaultTools) {
                    scopesNames.add(tool.getScopeName());
                }
            }
            this.myOptionsLabel = new JBLabel(AnalysisBundle.message("inspections.settings.options.title", new Object[0]));
            if (scopesNames.isEmpty()) {
                HighlightSeverity severity = ScopesAndSeveritiesTable.getSeverity(ContainerUtil.map(nodes, node2 -> node2.getDefaultDescriptor().getState()));
                ScopesChooser scopesChooser = new ScopesChooser(ContainerUtil.map(nodes, node2 -> node2.getDefaultDescriptor()), this.myProfile, project2, null){

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeAdded(@NotNull String scopeName) {
                        if (scopeName == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$9", "onScopeAdded"));
                    }
                };
                JComponent scopesChooserComponent = scopesChooser.createCustomComponent(scopesChooser.getTemplatePresentation(), "unknown");
                final HighlightingChooser highlightingChooser = new HighlightingChooser(this.myProfile.getProfileManager().getSeverityRegistrar()){

                    @Override
                    void onKeyChosen(@NotNull TextAttributesKey key) {
                        if (key == null) {
                            10.$$$reportNull$$$0(0);
                        }
                        SmartList<InspectionConfigTreeNode.Tool> toUpdate = new SmartList<InspectionConfigTreeNode.Tool>();
                        for (InspectionConfigTreeNode.Tool node2 : nodes) {
                            NamedScope scope = node2.getDefaultDescriptor().getScope();
                            boolean doUpdate2 = SingleInspectionProfilePanel.this.myProfile.getEditorAttributesKey(node2.getKey(), scope, project2) != key;
                            if (!doUpdate2) continue;
                            SingleInspectionProfilePanel.this.myProfile.setEditorAttributesKey(node2.getKey().toString(), key.getExternalName(), null, project2);
                            toUpdate.add(node2);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively(toUpdate, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$10", "onKeyChosen"));
                    }
                };
                JComponent highlightsChooserComponent = highlightingChooser.createCustomComponent(highlightingChooser.getTemplatePresentation(), "unknown");
                SingleInspectionProfilePanel.updateHighlightingChooser(nodes, project2, highlightingChooser);
                LevelChooserAction severityLevelChooser = new LevelChooserAction(this.myProfile.getProfileManager().getSeverityRegistrar(), this.includeDoNotShow(nodes)){

                    @Override
                    protected void onChosen(@NotNull HighlightSeverity severity) {
                        if (severity == null) {
                            11.$$$reportNull$$$0(0);
                        }
                        HighlightDisplayLevel level = HighlightDisplayLevel.find(severity);
                        SmartList<InspectionConfigTreeNode.Tool> toUpdate = new SmartList<InspectionConfigTreeNode.Tool>();
                        for (InspectionConfigTreeNode.Tool node2 : nodes) {
                            NamedScope scope;
                            HighlightDisplayKey key = node2.getDefaultDescriptor().getKey();
                            boolean doUpdate2 = SingleInspectionProfilePanel.this.myProfile.getErrorLevel(key, scope = node2.getDefaultDescriptor().getScope(), project2) != level || SingleInspectionProfilePanel.this.myProfile.getEditorAttributesKey(key, scope, project2) != null;
                            if (!doUpdate2) continue;
                            SingleInspectionProfilePanel.this.myProfile.setErrorLevel(key, level, null, project2);
                            SingleInspectionProfilePanel.this.myProfile.setEditorAttributesKey(node2.getKey().toString(), null, null, project2);
                            SingleInspectionProfilePanel.updateHighlightingChooser(nodes, project2, highlightingChooser);
                            toUpdate.add(node2);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively(toUpdate, false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$11", "onChosen"));
                    }
                };
                severityLevelChooser.setChosen(severity);
                final JComponent severityLevelChooserComponent = severityLevelChooser.createCustomComponent(severityLevelChooser.getTemplatePresentation(), "unknown");
                severityLevelChooserComponent.getInputMap(2).put(KeyStroke.getKeyStroke(86, MnemonicHelper.getFocusAcceleratorKeyMask()), "changeSeverity");
                severityLevelChooserComponent.getActionMap().put("changeSeverity", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ComboBoxAction.ComboBoxButton button2 = (ComboBoxAction.ComboBoxButton)severityLevelChooserComponent;
                        button2.showPopup();
                    }
                });
                GridBag constraint = new GridBag().setDefaultInsets(0, 0, 0, 10).setDefaultWeightX(1.0).setDefaultFill(2);
                JPanel scopesChooserPanel = UI.PanelFactory.panel((JComponent)scopesChooserComponent).withLabel(InspectionsBundle.message("inspection.scope", new Object[0])).moveLabelOnTop().createPanel();
                severityPanel.add((Component)scopesChooserPanel, constraint.next().weightx(0.0));
                JPanel severityLevelChooserPanel = UI.PanelFactory.panel((JComponent)severityLevelChooserComponent).withLabel(InspectionsBundle.message("inspection.severity", new Object[0])).moveLabelOnTop().createPanel();
                severityPanel.add((Component)severityLevelChooserPanel, constraint.next());
                JPanel highlightChooserPanel = UI.PanelFactory.panel((JComponent)highlightsChooserComponent).withLabel(InspectionsBundle.message("inspection.highlighting", new Object[0])).moveLabelOnTop().createPanel();
                severityPanel.add((Component)highlightChooserPanel, constraint.next());
                if (toolState != null) {
                    if (!showDefaultConfigurationOptions) {
                        severityLevelChooserPanel.setVisible(false);
                        scopesChooserPanel.setVisible(false);
                    }
                    this.setConfigPanel(configPanelAnchor, toolState);
                    this.myOptionsLabel.setText(AnalysisBundle.message("inspections.settings.options.title", new Object[0]));
                }
                scopesAndScopesAndSeveritiesTable = null;
                showOptionPanel = configPanelAnchor.getComponentCount() != 0;
                severityPanelWeightY = 0.0;
            } else {
                if (singleNode != null) {
                    for (Descriptor descriptor : singleNode.getDescriptors().getNonDefaultDescriptors()) {
                        descriptor.loadConfig();
                    }
                }
                ScopesAndSeveritiesTable.TableSettings tableSettings = new ScopesAndSeveritiesTable.TableSettings(nodes, this.myProfile, project2){

                    @Override
                    protected void onScopeChosen(@NotNull ScopeToolState state) {
                        if (state == null) {
                            13.$$$reportNull$$$0(0);
                        }
                        SingleInspectionProfilePanel.this.setConfigPanel(configPanelAnchor, state);
                        configPanelAnchor.revalidate();
                        configPanelAnchor.repaint();
                    }

                    @Override
                    protected void onSettingsChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, false);
                    }

                    @Override
                    protected void onScopeAdded() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, false);
                    }

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeRemoved(int scopesCount) {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, scopesCount == 1);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$13", "onScopeChosen"));
                    }
                };
                scopesAndScopesAndSeveritiesTable = new ScopesAndSeveritiesTable(tableSettings);
                ToolbarDecorator wrappedTable = ToolbarDecorator.createDecorator((JTable)((Object)scopesAndScopesAndSeveritiesTable)).setToolbarPosition(ActionToolbarPosition.LEFT).disableUpDownActions().setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setRemoveActionUpdater(__ -> {
                    int selectedRow = scopesAndScopesAndSeveritiesTable.getSelectedRow();
                    int rowCount = scopesAndScopesAndSeveritiesTable.getRowCount();
                    return rowCount - 1 != selectedRow;
                }).addExtraAction(new AnActionButton(IdeBundle.messagePointer((String)"action.Anonymous.text.edit.scopes.order", (Object[])new Object[0]), AllIcons.General.GearPlain, tableSettings){
                    final /* synthetic */ 13 val$tableSettings;
                    {
                        this.val$tableSettings = var6_6;
                        super(arg0, arg1);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        ScopesOrderDialog dlg;
                        if (e == null) {
                            14.$$$reportNull$$$0(0);
                        }
                        if ((dlg = new ScopesOrderDialog((Component)((Object)scopesAndScopesAndSeveritiesTable), SingleInspectionProfilePanel.this.myProfile, project2)).showAndGet()) {
                            this.val$tableSettings.onScopesOrderChanged();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$14", "actionPerformed"));
                    }
                });
                severityPanel = wrappedTable.createPanel();
                Dimension panelSize = new Dimension(this.getMinimumSize().width, 81);
                severityPanel.setMinimumSize(panelSize);
                severityPanel.setPreferredSize(panelSize);
                severityPanel.setMaximumSize(panelSize);
                showOptionPanel = configPanelAnchor.getComponentCount() != 0;
                severityPanelWeightY = showOptionPanel ? 0.0 : 1.0;
            }
            GridBag constraint = new GridBag().setDefaultWeightX(1.0).setDefaultWeightY(1.0);
            this.myOptionsPanel.add((Component)severityPanel, constraint.nextLine().weighty(severityPanelWeightY).fillCell().insetTop(20));
            GuiUtils.enableChildren((Component)this.myOptionsPanel, (boolean)this.isThoughOneNodeEnabled(nodes), (JComponent[])new JComponent[0]);
            if (showOptionPanel) {
                if (showDefaultConfigurationOptions) {
                    this.myOptionsPanel.add((Component)new ToolOptionsSeparator(configPanelAnchor, scopesAndScopesAndSeveritiesTable), constraint.nextLine().weighty(0.0).fillCellHorizontally());
                }
                this.myOptionsPanel.add((Component)configPanelAnchor, constraint.nextLine().fillCell());
            } else if (scopesNames.isEmpty()) {
                this.myOptionsPanel.add((Component)configPanelAnchor, constraint.nextLine().fillCell());
            }
            this.myOptionsPanel.revalidate();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.myOptionsPanel.repaint();
    }

    private static void updateHighlightingChooser(Collection<InspectionConfigTreeNode.Tool> nodes, Project project2, HighlightingChooser highlightingChooser) {
        TextAttributesKey key = ScopesAndSeveritiesTable.getEditorAttributesKey(ContainerUtil.map(nodes, node2 -> node2.getDefaultDescriptor().getState()), project2);
        highlightingChooser.setChosen(key);
    }

    private void updateRecursively(Collection<? extends InspectionConfigTreeNode> nodes, boolean updateOptionsAndDescriptionPanel) {
        InspectionConfigTreeNode.updateUpHierarchy(nodes);
        this.myTreeTable.repaint();
        if (updateOptionsAndDescriptionPanel) {
            this.updateOptionsAndDescriptionPanel();
        }
    }

    private boolean isThoughOneNodeEnabled(Collection<InspectionConfigTreeNode.Tool> nodes) {
        Project project2 = this.getProject();
        for (InspectionConfigTreeNode.Tool node2 : nodes) {
            String toolId = node2.getKey().toString();
            if (!this.myProfile.getTools(toolId, project2).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void initOptionsAndDescriptionPanel() {
        this.myOptionsPanel.removeAll();
        DescriptionEditorPaneKt.readHTML(this.myDescription, "<html><body></body></html>");
        this.myOptionsPanel.validate();
        this.myOptionsPanel.repaint();
    }

    @NotNull
    public InspectionProfileModifiableModel getProfile() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = this.myProfile;
        if (inspectionProfileModifiableModel == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(6);
        }
        return inspectionProfileModifiableModel;
    }

    public InspectionToolWrapper<?, ?> getSelectedTool() {
        InspectionConfigTreeNode.Tool node2 = this.myTreeTable.getStrictlySelectedToolNode();
        if (node2 == null) {
            return null;
        }
        return node2.getDefaultDescriptor().getToolWrapper();
    }

    public void removeSelectedRow() {
        InspectionConfigTreeNode.Tool node2 = this.myTreeTable.getStrictlySelectedToolNode();
        if (node2 != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            TreePath path2 = this.myTreeTable.getTree().getSelectionPath();
            assert (path2 != null);
            TreePath newPath = path2.getParentPath().pathByAddingChild(node2.getPreviousNode());
            this.myTreeTable.removeSelectedPath(path2);
            this.myTreeTable.addSelectedPath(newPath);
            this.restoreTreeState();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    public void disposeUI() {
        this.myAlarm.cancelAllRequests();
        if (this.myProfileFilter != null) {
            this.myProfileFilter.dispose();
        }
        if (this.myInspectionProfilePanel != null) {
            for (ScopeToolState state : this.myProfile.getAllTools()) {
                state.resetConfigPanel();
            }
        }
        this.myProfile.cleanup(this.myProjectProfileManager.getProject());
        Disposer.dispose(this.myDisposable);
        this.myDisposable = null;
    }

    public static HyperlinkAdapter createSettingsHyperlinkListener(final Project project2) {
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(0);
                }
                try {
                    URI url = new URI(e.getDescription());
                    if (url.getScheme().equals("settings")) {
                        DataContext context2 = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
                        if (context2 != null) {
                            Settings settings = (Settings)Settings.KEY.getData(context2);
                            SearchTextField searchTextField = (SearchTextField)SearchTextField.KEY.getData(context2);
                            String configId = url.getHost();
                            String search2 = url.getQuery();
                            if (settings != null) {
                                Configurable configurable2 = settings.find(configId);
                                settings.select(configurable2).doWhenDone(() -> {
                                    if (searchTextField != null && search2 != null) {
                                        searchTextField.setText(search2);
                                    }
                                });
                            } else {
                                ShowSettingsUtilImpl.showSettingsDialog((Project)project2, (String)configId, (String)search2);
                            }
                        }
                    } else {
                        BrowserUtil.browse((URI)url);
                    }
                }
                catch (URISyntaxException ex) {
                    LOG.error(ex);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$15", "hyperlinkActivated"));
            }
        };
    }

    private JPanel createInspectionProfileSettingsPanel() {
        this.myDescription = new DescriptionEditorPane();
        this.myDescription.addHyperlinkListener(SingleInspectionProfilePanel.createSettingsHyperlinkListener(this.getProject()));
        this.initToolStates();
        this.fillTreeData(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null, true);
        OnePixelSplitter rightSplitter = new OnePixelSplitter(true, "SingleInspectionProfilePanel.HORIZONTAL_DIVIDER_PROPORTION", 0.5f);
        JBScrollPane descriptionPanel = new JBScrollPane((Component)this.myDescription);
        descriptionPanel.setBorder((Border)JBUI.Borders.empty());
        rightSplitter.setFirstComponent((JComponent)descriptionPanel);
        this.myOptionsPanel = new JPanel(new GridBagLayout());
        this.initOptionsAndDescriptionPanel();
        rightSplitter.setSecondComponent((JComponent)this.myOptionsPanel);
        JScrollPane tree = this.initTreeScrollPane();
        JPanel northPanel = new JPanel(new GridBagLayout());
        northPanel.setBorder(JBUI.Borders.empty(4, 0));
        this.myProfileFilter.setPreferredSize(new Dimension(20, this.myProfileFilter.getPreferredSize().height));
        GridBag constraint = new GridBag().setDefaultWeightY(1.0);
        northPanel.add((Component)this.myProfileFilter, constraint.next().weightx(0.5).fillCellHorizontally().anchor(768));
        northPanel.add((Component)this.createTreeToolbarPanel().getComponent(), constraint.next().weightx(1.0).anchor(17));
        JBSplitter mainSplitter = new JBSplitter(false, 0.5f, 0.35f, 0.65f);
        mainSplitter.setSplitterProportionKey("SingleInspectionProfilePanel.VERTICAL_DIVIDER_PROPORTION");
        mainSplitter.setFirstComponent((JComponent)tree);
        mainSplitter.setSecondComponent((JComponent)rightSplitter);
        mainSplitter.setHonorComponentsMinimumSize(false);
        mainSplitter.setDividerWidth(20);
        JPanel inspectionTreePanel = new JPanel(new BorderLayout());
        inspectionTreePanel.add((Component)northPanel, "North");
        inspectionTreePanel.add((Component)mainSplitter, "Center");
        JBCheckBox disableNewInspectionsCheckBox = new JBCheckBox(AnalysisBundle.message("inspections.settings.disable.new.inspections.by.default.checkbox", new Object[0]), this.getProfile().isProfileLocked());
        JPanel panel2 = new JPanel(new BorderLayout(10, 12));
        panel2.add((Component)inspectionTreePanel, "Center");
        panel2.add((Component)disableNewInspectionsCheckBox, "South");
        disableNewInspectionsCheckBox.addItemListener(__ -> {
            boolean enabled = disableNewInspectionsCheckBox.isSelected();
            if (!this.isDisposed()) {
                InspectionProfileModifiableModel profile = this.getProfile();
                profile.lockProfile(enabled);
            }
        });
        return panel2;
    }

    public boolean isModified() {
        if (this.myTreeTable == null) {
            return false;
        }
        if (this.myModified) {
            return true;
        }
        if (this.myProfile.isChanged()) {
            return true;
        }
        if (this.myProfile.getSource().isProjectLevel() != this.myProfile.isProjectLevel()) {
            return true;
        }
        if (!Comparing.strEqual(this.myProfile.getSource().getName(), this.myProfile.getName())) {
            return true;
        }
        if (!this.myInitialScopesOrder.equals(this.myProfile.getScopesOrder())) {
            return true;
        }
        return this.descriptorsAreChanged();
    }

    public void reset() {
        this.myModified = false;
        this.filterTree();
        String filter2 = this.myProfileFilter.getFilter();
        this.myProfileFilter.reset();
        this.myProfileFilter.setSelectedItem(filter2);
        this.myProfile.setName(this.myProfile.getSource().getName());
        this.myProfile.setProjectLevel(this.myProfile.getSource().isProjectLevel());
    }

    public void apply() {
        boolean modified = this.isModified();
        if (!modified) {
            return;
        }
        InspectionProfileModifiableModel selectedProfile = this.myProfile;
        BaseInspectionProfileManager profileManager = selectedProfile.isProjectLevel() ? this.myProjectProfileManager : (BaseInspectionProfileManager)InspectionProfileManager.getInstance();
        InspectionProfileImpl source = selectedProfile.getSource();
        if (source.getProfileManager() != profileManager) {
            source.getProfileManager().deleteProfile(source);
        }
        if (selectedProfile.getProfileManager() != profileManager) {
            SingleInspectionProfilePanel.copyUsedSeveritiesIfUndefined(selectedProfile, profileManager);
            selectedProfile.setProfileManager(profileManager);
        }
        selectedProfile.commit();
        profileManager.addProfile(source);
        profileManager.fireProfileChanged(source);
        this.myModified = false;
        this.myRoot.dropCache();
        this.initToolStates();
        this.updateOptionsAndDescriptionPanel();
    }

    private boolean descriptorsAreChanged() {
        return ContainerUtil.exists(this.myInitialToolDescriptors.values(), toolDescriptors -> SingleInspectionProfilePanel.areToolDescriptorsChanged(this.getProject(), this.myProfile, toolDescriptors));
    }

    public static boolean areToolDescriptorsChanged(@NotNull Project project2, @NotNull InspectionProfileModifiableModel profile, @NotNull ToolDescriptors toolDescriptors) {
        Descriptor desc;
        if (project2 == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(7);
        }
        if (profile == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(8);
        }
        if (toolDescriptors == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(9);
        }
        if (profile.isToolEnabled((desc = toolDescriptors.getDefaultDescriptor()).getKey(), null, project2) != desc.isEnabled()) {
            return true;
        }
        if (profile.getErrorLevel(desc.getKey(), desc.getScope(), project2) != desc.getLevel()) {
            return true;
        }
        if (!Objects.equals(profile.getEditorAttributesKey(desc.getKey(), desc.getScope(), project2), desc.getEditorAttributesKey())) {
            return true;
        }
        List<Descriptor> descriptors = toolDescriptors.getNonDefaultDescriptors();
        for (Descriptor descriptor : descriptors) {
            if (profile.isToolEnabled(descriptor.getKey(), descriptor.getScope(), project2) != descriptor.isEnabled()) {
                return true;
            }
            if (profile.getErrorLevel(descriptor.getKey(), descriptor.getScope(), project2) != descriptor.getLevel()) {
                return true;
            }
            if (Objects.equals(profile.getEditorAttributesKey(descriptor.getKey(), descriptor.getScope(), project2), descriptor.getEditorAttributesKey())) continue;
            return true;
        }
        List<ScopeToolState> tools = profile.getNonDefaultTools(desc.getKey().toString(), project2);
        if (tools.size() != descriptors.size()) {
            return true;
        }
        for (int i = 0; i < tools.size(); ++i) {
            ScopeToolState pair = tools.get(i);
            if (Comparing.equal(pair.getScope(project2), descriptors.get(i).getScope())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.myInspectionProfilePanel == null) {
            this.myProfile.initInspectionTools(this.myProjectProfileManager.getProject());
            this.initUI();
        }
        super.setVisible(aFlag);
    }

    private void setNewHighlightingLevel(@NotNull HighlightDisplayLevel level) {
        Collection<InspectionConfigTreeNode.Tool> tools;
        if (level == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(10);
        }
        if (!(tools = this.myTreeTable.getSelectedToolNodes()).isEmpty()) {
            for (InspectionConfigTreeNode.Tool tool : tools) {
                this.updateErrorLevel(tool, level);
            }
            this.updateOptionsAndDescriptionPanel();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.repaintTableData();
    }

    private void updateErrorLevel(InspectionConfigTreeNode.Tool child, @NotNull HighlightDisplayLevel level) {
        if (level == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(11);
        }
        HighlightDisplayKey key = child.getKey();
        this.myProfile.setErrorLevel(key, level, null, this.getProject());
        child.dropCache();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeTable;
    }

    private void updateEmptyText() {
        StatusText emptyText = this.myTreeTable.getEmptyText();
        emptyText.setText(AnalysisBundle.message("inspections.settings.empty.text", new Object[0]));
        if (!this.myInspectionsFilter.isEmptyFilter()) {
            emptyText.appendLine(AnalysisBundle.message("inspections.settings.empty.text.filters.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.myInspectionsFilter.reset());
        } else if (this.myCreateInspectionActions.getChildrenCount() > 0) {
            emptyText.appendSecondaryText(AnalysisBundle.message("inspections.settings.empty.text.inspection.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> JBPopupFactory.getInstance().createActionGroupPopup(AnalysisBundle.message("inspections.settings.popup.title.create.inspection", new Object[0]), (ActionGroup)this.myCreateInspectionActions, DataManager.getInstance().getDataContext((Component)this.myInspectionProfilePanel), null, true).show(new RelativePoint((Component)((Object)this.myTreeTable), this.myTreeTable.getEmptyText().getPointBelow())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolDescriptors";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNodeByPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderSeverity";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "areToolDescriptorsChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setNewHighlightingLevel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorLevel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToolOptionsSeparator
    extends JPanel {
        private final ActionLink myResetLink;
        @Nullable
        private final ScopesAndSeveritiesTable myScopesAndSeveritiesTable;

        ToolOptionsSeparator(@Nullable JComponent options, ScopesAndSeveritiesTable scopesAndSeveritiesTable) {
            this.myScopesAndSeveritiesTable = scopesAndSeveritiesTable;
            this.setLayout(new GridBagLayout());
            this.setBorder(JBUI.Borders.emptyTop(20));
            GridBag constraint = new GridBag().setDefaultWeightY(1.0);
            this.add((Component)SingleInspectionProfilePanel.this.myOptionsLabel, constraint.next().anchor(21));
            this.add((Component)new JSeparator(0), constraint.next().weightx(1.0).anchor(10).fillCellHorizontally().insets(2, 6, 0, 0));
            UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
            userActivityWatcher.addUserActivityListener(() -> this.setupResetLinkVisibility());
            userActivityWatcher.register((Component)options);
            this.myResetLink = new ActionLink(IdeBundle.message((String)"reset.action.text", (Object[])new Object[0]), e -> {
                ScopeToolState state = this.getSelectedState();
                if (state != null) {
                    state.resetConfigPanel();
                    Project project2 = SingleInspectionProfilePanel.this.getProject();
                    SingleInspectionProfilePanel.this.myProfile.resetToBase(((InspectionProfileEntry)state.getTool().getTool()).getShortName(), state.getScope(project2), project2);
                    SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
                }
            });
            this.add((Component)this.myResetLink, constraint.next().anchor(22).insetLeft(6));
            this.setupResetLinkVisibility();
        }

        private void setupResetLinkVisibility() {
            if (SingleInspectionProfilePanel.this.myTreeTable == null || SingleInspectionProfilePanel.this.isDisposed()) {
                return;
            }
            InspectionConfigTreeNode.Tool node2 = SingleInspectionProfilePanel.this.myTreeTable.getStrictlySelectedToolNode();
            if (node2 != null) {
                ScopeToolState state = this.getSelectedState();
                if (state == null) {
                    return;
                }
                Project project2 = SingleInspectionProfilePanel.this.getProject();
                NamedScope scope = state.getScope(project2);
                if (scope == null) {
                    return;
                }
                boolean canReset = !SingleInspectionProfilePanel.this.myProfile.isProperSetting(((InspectionProfileEntry)state.getTool().getTool()).getShortName(), scope, project2);
                this.myResetLink.setVisible(canReset);
                this.revalidate();
                this.repaint();
            }
        }

        private ScopeToolState getSelectedState() {
            InspectionConfigTreeNode.Tool node2 = SingleInspectionProfilePanel.this.myTreeTable.getStrictlySelectedToolNode();
            if (node2 == null) {
                return null;
            }
            if (this.myScopesAndSeveritiesTable != null) {
                List<ScopeToolState> selectedStates = this.myScopesAndSeveritiesTable.getSelectedStates();
                LOG.assertTrue(selectedStates.size() == 1);
                return selectedStates.get(0);
            }
            return node2.getDescriptors().getDefaultDescriptor().getState();
        }
    }

    private final class MyFilterComponent
    extends FilterComponent {
        private MyFilterComponent() {
            super(SingleInspectionProfilePanel.INSPECTION_FILTER_HISTORY, 10);
        }

        public void filter() {
            SingleInspectionProfilePanel.this.filterTree();
        }

        protected void onlineFilter() {
            if (SingleInspectionProfilePanel.this.isDisposed()) {
                return;
            }
            String filter2 = this.getFilter();
            SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            SingleInspectionProfilePanel.this.fillTreeData(filter2, true);
            SingleInspectionProfilePanel.this.reloadModel();
            if (filter2 == null || filter2.isEmpty()) {
                SingleInspectionProfilePanel.this.restoreTreeState();
            } else {
                TreeUtil.expandAll((JTree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }
        }
    }
}

