/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.table.HighlightingRenderer;
import com.intellij.profile.codeInspection.ui.table.SeverityRenderer;
import com.intellij.profile.codeInspection.ui.table.ThreeStateCheckBoxRenderer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopesAndSeveritiesTable
extends JBTable {
    private static final Logger LOG = Logger.getInstance(ScopesAndSeveritiesTable.class);
    public static final HighlightSeverity MIXED_FAKE_SEVERITY = new HighlightSeverity("Mixed", -1);
    public static final HighlightDisplayLevel MIXED_FAKE_LEVEL = new HighlightDisplayLevel(MIXED_FAKE_SEVERITY, AllIcons.General.InspectionsMixed);
    public static final TextAttributesKey MIXED_FAKE_KEY = TextAttributesKey.createTextAttributesKey("Mixed");
    public static final TextAttributesKey INFORMATION_FAKE_KEY = TextAttributesKey.createTextAttributesKey("");
    private static final int SCOPE_ENABLED_COLUMN = 0;
    private static final int SCOPE_NAME_COLUMN = 1;
    private static final int SEVERITY_COLUMN = 2;
    private static final int HIGHLIGHTING_COLUMN = 3;

    public ScopesAndSeveritiesTable(final TableSettings tableSettings) {
        super((TableModel)new MyTableModel(tableSettings));
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn scopeEnabledColumn = columnModel.getColumn(0);
        scopeEnabledColumn.setMaxWidth(30);
        scopeEnabledColumn.setCellRenderer(new ThreeStateCheckBoxRenderer());
        scopeEnabledColumn.setCellEditor(new ThreeStateCheckBoxRenderer());
        columnModel.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component2.setForeground(RenderingUtil.getForeground(table, isSelected));
                component2.setBackground(RenderingUtil.getBackground(table, isSelected));
                if (value instanceof String) {
                    NamedScope namedScope = NamedScopesHolder.getScope(tableSettings.myProject, (String)value);
                    if (namedScope != null) {
                        this.setText(namedScope.getPresentableName());
                    } else if (LangBundle.message("scopes.table.everywhere.else", new Object[0]).equals(value)) {
                        this.setText((String)value);
                    } else {
                        this.setText(LangBundle.message("scopes.table.missing.scope", value));
                        component2.setForeground(UIUtil.getErrorForeground());
                    }
                }
                return component2;
            }
        });
        TableColumn severityColumn = columnModel.getColumn(2);
        SeverityRenderer renderer = new SeverityRenderer(tableSettings.getInspectionProfile(), tableSettings.getProject(), () -> tableSettings.onSettingsChanged(), this);
        severityColumn.setCellRenderer((TableCellRenderer)((Object)renderer));
        severityColumn.setCellEditor((TableCellEditor)((Object)renderer));
        TableColumn highlightingColumn = columnModel.getColumn(3);
        HighlightingRenderer highlightingRenderer = new HighlightingRenderer(ScopesAndSeveritiesTable.getEditorAttributesKeysAndNames(tableSettings.getInspectionProfile())){

            @Override
            void openColorSettings() {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
                ApplicationManager.getApplication().invokeLater(() -> ColorAndFontOptions.selectOrEditColor((DataContext)dataContext, (String)OptionsBundle.message((String)"options.java.attribute.descriptor.error", (Object[])new Object[0]).split("//")[0], (String)OptionsBundle.message((String)"options.general.display.name", (Object[])new Object[0])));
            }
        };
        highlightingColumn.setCellRenderer((TableCellRenderer)((Object)highlightingRenderer));
        highlightingColumn.setCellEditor((TableCellEditor)((Object)highlightingRenderer));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExistedScopesStatesAndNonExistNames scopeToolState;
                List<ScopeToolState> existedStates;
                int idx = ScopesAndSeveritiesTable.this.getSelectionModel().getMinSelectionIndex();
                if (idx >= 0 && (existedStates = (scopeToolState = ((MyTableModel)ScopesAndSeveritiesTable.this.getModel()).getScopeToolState(idx)).getExistedStates()).size() == 1 && scopeToolState.getNonExistNames().isEmpty()) {
                    tableSettings.onScopeChosen(existedStates.get(0));
                }
            }
        });
        this.setRowSelectionInterval(0, 0);
        this.setShowGrid(false);
        ((MyTableModel)this.getModel()).setTable(this);
    }

    boolean isRowEnabled(int row) {
        return Boolean.TRUE.equals(((MyTableModel)this.getModel()).isEnabled(row));
    }

    void setSelectedSeverity(HighlightSeverity severity) {
        this.getModel().setValueAt(severity, this.getSelectedRow(), 2);
    }

    public List<ScopeToolState> getSelectedStates() {
        return ((MyTableModel)this.getModel()).getScopeToolState(this.getSelectedRow()).getExistedStates();
    }

    @NotNull
    public static HighlightSeverity getSeverity(@NotNull List<? extends ScopeToolState> scopeToolStates) {
        if (scopeToolStates == null) {
            ScopesAndSeveritiesTable.$$$reportNull$$$0(0);
        }
        HighlightSeverity previousValue = null;
        for (ScopeToolState scopeToolState : scopeToolStates) {
            HighlightSeverity currentValue = scopeToolState.getLevel().getSeverity();
            if (previousValue == null) {
                previousValue = currentValue;
                continue;
            }
            if (previousValue.equals(currentValue)) continue;
            HighlightSeverity highlightSeverity = MIXED_FAKE_SEVERITY;
            if (highlightSeverity == null) {
                ScopesAndSeveritiesTable.$$$reportNull$$$0(1);
            }
            return highlightSeverity;
        }
        HighlightSeverity highlightSeverity = previousValue;
        if (highlightSeverity == null) {
            ScopesAndSeveritiesTable.$$$reportNull$$$0(2);
        }
        return highlightSeverity;
    }

    @NotNull
    public static TextAttributesKey getEditorAttributesKey(@NotNull List<? extends ScopeToolState> scopeToolStates, @NotNull Project project2) {
        if (scopeToolStates == null) {
            ScopesAndSeveritiesTable.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            ScopesAndSeveritiesTable.$$$reportNull$$$0(4);
        }
        TextAttributesKey previousValue = null;
        SeverityRegistrar registrar = SeverityRegistrar.getSeverityRegistrar(project2);
        for (ScopeToolState scopeToolState : scopeToolStates) {
            TextAttributesKey key = scopeToolState.getEditorAttributesKey();
            if (key == null) {
                HighlightSeverity severity = scopeToolState.getLevel().getSeverity();
                TextAttributesKey textAttributesKey = key = severity.equals(HighlightSeverity.INFORMATION) ? INFORMATION_FAKE_KEY : registrar.getHighlightInfoTypeBySeverity(severity).getAttributesKey();
            }
            if (previousValue == null) {
                previousValue = key;
                continue;
            }
            if (previousValue.equals(key)) continue;
            TextAttributesKey textAttributesKey = MIXED_FAKE_KEY;
            if (textAttributesKey == null) {
                ScopesAndSeveritiesTable.$$$reportNull$$$0(5);
            }
            return textAttributesKey;
        }
        TextAttributesKey textAttributesKey = previousValue != null ? previousValue : MIXED_FAKE_KEY;
        if (textAttributesKey == null) {
            ScopesAndSeveritiesTable.$$$reportNull$$$0(6);
        }
        return textAttributesKey;
    }

    private static ArrayList<Pair<TextAttributesKey, @Nls String>> getEditorAttributesKeysAndNames(InspectionProfileImpl profile) {
        ArrayList textAttributes = ColorSettingsUtil.getErrorTextAttributes();
        Collection<HighlightInfoType> standardSeverities = SeverityRegistrar.standardSeverities();
        SeverityRegistrar registrar = profile.getProfileManager().getSeverityRegistrar();
        for (HighlightSeverity severity : registrar.getAllSeverities()) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoType = registrar.getHighlightInfoTypeBySeverity(severity);
            if (standardSeverities.contains(highlightInfoType)) continue;
            TextAttributesKey attributes = registrar.getHighlightInfoTypeBySeverity(severity).getAttributesKey();
            textAttributes.add(new Pair<TextAttributesKey, String>(attributes, severity.getDisplayName()));
        }
        textAttributes.add(new Pair<TextAttributesKey, String>(HighlightingRenderer.EDIT_HIGHLIGHTING, InspectionsBundle.message("inspection.edit.highlighting.action", new Object[0])));
        return textAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeToolStates";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorAttributesKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEditorAttributesKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExistedScopesStatesAndNonExistNames {
        private final List<ScopeToolState> myExistedStates;
        private final List<String> myNonExistNames;

        ExistedScopesStatesAndNonExistNames(List<ScopeToolState> existedStates, List<String> nonExistNames) {
            this.myExistedStates = existedStates;
            this.myNonExistNames = nonExistNames;
        }

        public List<ScopeToolState> getExistedStates() {
            return this.myExistedStates;
        }

        public List<String> getNonExistNames() {
            return this.myNonExistNames;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        @NotNull
        private final InspectionProfileImpl myInspectionProfile;
        private final List<String> myKeyNames;
        @NotNull
        private final Project myProject;
        private final TableSettings myTableSettings;
        private final List<HighlightDisplayKey> myKeys;
        private final Comparator<String> myScopeComparator;
        private ScopesAndSeveritiesTable myTable;
        private String[] myScopeNames;

        MyTableModel(@NotNull TableSettings tableSettings) {
            if (tableSettings == null) {
                MyTableModel.$$$reportNull$$$0(0);
            }
            this.myTableSettings = tableSettings;
            this.myProject = tableSettings.getProject();
            this.myInspectionProfile = tableSettings.getInspectionProfile();
            this.myKeys = tableSettings.getKeys();
            this.myKeyNames = tableSettings.getKeyNames();
            this.myScopeComparator = new ScopeOrderComparator(this.myInspectionProfile);
            this.refreshAggregatedScopes();
        }

        public void setTable(ScopesAndSeveritiesTable table) {
            this.myTable = table;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return false;
            }
            if (columnIndex == 0) {
                return true;
            }
            assert (columnIndex == 2 || columnIndex == 3);
            if (Boolean.FALSE.equals(this.isEnabled(rowIndex))) {
                return false;
            }
            ExistedScopesStatesAndNonExistNames scopeToolState = this.getScopeToolState(rowIndex);
            return scopeToolState.getNonExistNames().isEmpty();
        }

        @Override
        public int getRowCount() {
            return this.lastRowIndex() + 1;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            switch (column) {
                case 1: {
                    return LangBundle.message("scopes.chooser.scope.column", new Object[0]);
                }
                case 2: {
                    return LangBundle.message("scopes.chooser.scope.severity", new Object[0]);
                }
                case 3: {
                    return LangBundle.message("scopes.chooser.scope.highlighting", new Object[0]);
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (0 == columnIndex) {
                return Boolean.class;
            }
            if (1 == columnIndex) {
                return String.class;
            }
            if (2 == columnIndex) {
                return HighlightSeverity.class;
            }
            if (3 == columnIndex) {
                return TextAttributesKey.class;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return this.isEnabled(rowIndex);
                }
                case 1: {
                    return rowIndex == this.lastRowIndex() ? LangBundle.message("scopes.table.everywhere.else", new Object[0]) : this.getScopeName(rowIndex);
                }
                case 2: {
                    return this.getSeverityState(rowIndex);
                }
                case 3: {
                    return this.getAttributesKey(rowIndex);
                }
            }
            throw new IllegalArgumentException("Invalid column index " + columnIndex);
        }

        private NamedScope getScope(int rowIndex) {
            return this.getScopeToolState(rowIndex).getExistedStates().get(0).getScope(this.myProject);
        }

        private String getScopeName(int rowIndex) {
            return this.getScopeToolState(rowIndex).getExistedStates().get(0).getScopeName();
        }

        @NotNull
        private HighlightSeverity getSeverityState(int rowIndex) {
            ExistedScopesStatesAndNonExistNames existedScopesStatesAndNonExistNames = this.getScopeToolState(rowIndex);
            if (!existedScopesStatesAndNonExistNames.getNonExistNames().isEmpty()) {
                HighlightSeverity highlightSeverity = MIXED_FAKE_SEVERITY;
                if (highlightSeverity == null) {
                    MyTableModel.$$$reportNull$$$0(1);
                }
                return highlightSeverity;
            }
            HighlightSeverity highlightSeverity = ScopesAndSeveritiesTable.getSeverity(existedScopesStatesAndNonExistNames.getExistedStates());
            if (highlightSeverity == null) {
                MyTableModel.$$$reportNull$$$0(2);
            }
            return highlightSeverity;
        }

        private TextAttributesKey getAttributesKey(int rowIndex) {
            ExistedScopesStatesAndNonExistNames existedScopesStatesAndNonExistNames = this.getScopeToolState(rowIndex);
            if (!existedScopesStatesAndNonExistNames.getNonExistNames().isEmpty()) {
                return MIXED_FAKE_KEY;
            }
            return ScopesAndSeveritiesTable.getEditorAttributesKey(existedScopesStatesAndNonExistNames.myExistedStates, this.myProject);
        }

        @Nullable
        private Boolean isEnabled(int rowIndex) {
            Boolean previousValue = null;
            ExistedScopesStatesAndNonExistNames existedScopesStatesAndNonExistNames = this.getScopeToolState(rowIndex);
            for (ScopeToolState scopeToolState : existedScopesStatesAndNonExistNames.getExistedStates()) {
                boolean currentValue = scopeToolState.isEnabled();
                if (previousValue == null) {
                    previousValue = currentValue;
                    continue;
                }
                if (previousValue.equals(currentValue)) continue;
                return null;
            }
            if (!existedScopesStatesAndNonExistNames.getNonExistNames().isEmpty() && !Boolean.FALSE.equals(previousValue)) {
                return null;
            }
            return previousValue;
        }

        private ExistedScopesStatesAndNonExistNames getScopeToolState(int rowIndex) {
            SmartList<String> nonExistNames = new SmartList<String>();
            SmartList<ScopeToolState> existedStates = new SmartList<ScopeToolState>();
            for (String keyName : this.myKeyNames) {
                ScopeToolState scopeToolState = this.getScopeToolState(keyName, rowIndex);
                if (scopeToolState != null) {
                    existedStates.add(scopeToolState);
                    continue;
                }
                nonExistNames.add(keyName);
            }
            return new ExistedScopesStatesAndNonExistNames(existedStates, nonExistNames);
        }

        @Nullable
        private ScopeToolState getScopeToolState(String keyName, int rowIndex) {
            if (rowIndex == this.lastRowIndex()) {
                return this.myInspectionProfile.getToolDefaultState(keyName, this.myProject);
            }
            String scopeName = this.myScopeNames[rowIndex];
            List<ScopeToolState> nonDefaultTools = this.myInspectionProfile.getNonDefaultTools(keyName, this.myProject);
            for (ScopeToolState nonDefaultTool : nonDefaultTools) {
                if (!Objects.equals(scopeName, nonDefaultTool.getScopeName())) continue;
                return nonDefaultTool;
            }
            return null;
        }

        private void refreshAggregatedScopes() {
            this.myScopeNames = (String[])this.myKeyNames.stream().map(keyName -> this.myInspectionProfile.getNonDefaultTools((String)keyName, this.myProject)).flatMap(Collection::stream).map(state -> state.getScopeName()).distinct().sorted(this.myScopeComparator).toArray(String[]::new);
        }

        private int lastRowIndex() {
            return this.myScopeNames.length;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                return;
            }
            if (columnIndex == 2) {
                if (value == SeverityRenderer.EDIT_SEVERITIES) {
                    return;
                }
                HighlightSeverity severity = (HighlightSeverity)value;
                HighlightDisplayLevel level = HighlightDisplayLevel.find(severity.getName());
                if (level == null) {
                    LOG.error("no display level found for name " + severity.getName());
                    return;
                }
                String scopeName = rowIndex == this.lastRowIndex() ? null : this.getScopeName(rowIndex);
                this.myInspectionProfile.setErrorLevel(this.myKeys, level, scopeName, this.myProject);
                this.myInspectionProfile.setEditorAttributesKey(this.myKeys, null, scopeName, this.myProject);
            } else if (columnIndex == 3) {
                if (value == HighlightingRenderer.EDIT_HIGHLIGHTING) {
                    return;
                }
                TextAttributesKey key = (TextAttributesKey)value;
                String scopeName = rowIndex == this.lastRowIndex() ? null : this.getScopeName(rowIndex);
                this.myInspectionProfile.setEditorAttributesKey(this.myKeys, key, scopeName, this.myProject);
            } else if (columnIndex == 0) {
                NamedScope scope = this.getScope(rowIndex);
                if (scope == null) {
                    return;
                }
                if (((Boolean)value).booleanValue()) {
                    if (rowIndex == this.lastRowIndex()) {
                        this.myInspectionProfile.enableToolsByDefault(this.myKeyNames, this.myProject);
                    } else {
                        this.myInspectionProfile.enableTools(this.myKeyNames, scope, this.myProject);
                    }
                    for (String keyName : this.myKeyNames) {
                        this.myInspectionProfile.enableTool(keyName, this.myProject);
                    }
                } else if (rowIndex == this.lastRowIndex()) {
                    this.myInspectionProfile.disableToolByDefault(this.myKeyNames, this.myProject);
                } else {
                    this.myInspectionProfile.disableTools(this.myKeyNames, scope, this.myProject);
                }
                if (this.myKeyNames.size() == 1) {
                    String keyName = ContainerUtil.getFirstItem(this.myKeyNames);
                    ScopeToolState state = this.getScopeToolState(keyName, rowIndex);
                    this.myTableSettings.onScopeChosen(state);
                }
            }
            this.myTableSettings.onSettingsChanged();
        }

        @Override
        public void removeRow(int idx) {
            if (idx != this.lastRowIndex()) {
                this.myInspectionProfile.removeScopes(this.myKeyNames, this.getScopeName(idx), this.myProject);
                this.refreshAggregatedScopes();
                this.myTableSettings.onScopeRemoved(this.getRowCount());
            }
        }

        @Override
        public void addRow() {
            List<Descriptor> descriptors = ContainerUtil.map(this.myTableSettings.getNodes(), inspectionConfigTreeNode -> inspectionConfigTreeNode.getDefaultDescriptor());
            ScopesChooser scopesChooser = new ScopesChooser(descriptors, this.myInspectionProfile, this.myProject, this.myScopeNames){

                @Override
                protected void onScopeAdded(@NotNull String scopeName) {
                    if (scopeName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    myTableSettings.onScopeAdded();
                    this.refreshAggregatedScopes();
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        if (!this.getScopeName(i).equals(scopeName)) continue;
                        this.fireTableRowsInserted(i, i);
                        myTable.clearSelection();
                        myTable.setRowSelectionInterval(i, i);
                    }
                }

                @Override
                protected void onScopesOrderChanged() {
                    myTableSettings.onScopesOrderChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable$MyTableModel$1", "onScopeAdded"));
                }
            };
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this.myTable));
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(LangBundle.message("scopes.chooser.popup.title.select.scope.to.change.its.settings", new Object[0]), (ActionGroup)scopesChooser.createPopupActionGroup((JComponent)((Object)this.myTable)), dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            RelativePoint point = new RelativePoint((Component)((Object)this.myTable), new Point(0, 0));
            popup2.show(point);
        }

        @Override
        public void exchangeRows(int oldIndex, int newIndex) {
        }

        @Override
        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableSettings";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable$MyTableModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable$MyTableModel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverityState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class TableSettings {
        private final Collection<InspectionConfigTreeNode.Tool> myNodes;
        private final List<String> myKeyNames;
        private final List<HighlightDisplayKey> myKeys;
        private final InspectionProfileImpl myInspectionProfile;
        private final Project myProject;

        protected TableSettings(@NotNull Collection<InspectionConfigTreeNode.Tool> nodes, @NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project2) {
            if (nodes == null) {
                TableSettings.$$$reportNull$$$0(0);
            }
            if (inspectionProfile == null) {
                TableSettings.$$$reportNull$$$0(1);
            }
            if (project2 == null) {
                TableSettings.$$$reportNull$$$0(2);
            }
            this.myNodes = nodes;
            this.myKeys = new ArrayList<HighlightDisplayKey>(this.myNodes.size());
            this.myKeyNames = new ArrayList<String>(this.myNodes.size());
            for (InspectionConfigTreeNode.Tool node2 : nodes) {
                HighlightDisplayKey key = node2.getKey();
                this.myKeys.add(key);
                this.myKeyNames.add(key.toString());
            }
            this.myInspectionProfile = inspectionProfile;
            this.myProject = project2;
        }

        @NotNull
        public List<HighlightDisplayKey> getKeys() {
            List<HighlightDisplayKey> list2 = this.myKeys;
            if (list2 == null) {
                TableSettings.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public List<String> getKeyNames() {
            List<String> list2 = this.myKeyNames;
            if (list2 == null) {
                TableSettings.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public Collection<InspectionConfigTreeNode.Tool> getNodes() {
            Collection<InspectionConfigTreeNode.Tool> collection = this.myNodes;
            if (collection == null) {
                TableSettings.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @NotNull
        public InspectionProfileImpl getInspectionProfile() {
            InspectionProfileImpl inspectionProfileImpl = this.myInspectionProfile;
            if (inspectionProfileImpl == null) {
                TableSettings.$$$reportNull$$$0(6);
            }
            return inspectionProfileImpl;
        }

        @NotNull
        public Project getProject() {
            Project project2 = this.myProject;
            if (project2 == null) {
                TableSettings.$$$reportNull$$$0(7);
            }
            return project2;
        }

        protected abstract void onScopeAdded();

        protected abstract void onScopesOrderChanged();

        protected abstract void onScopeRemoved(int var1);

        protected abstract void onScopeChosen(@NotNull ScopeToolState var1);

        protected abstract void onSettingsChanged();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspectionProfile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable$TableSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profile/codeInspection/ui/table/ScopesAndSeveritiesTable$TableSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeys";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyNames";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInspectionProfile";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

