/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.table;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class SeverityRenderer
extends ComboBoxTableRenderer<HighlightSeverity> {
    private static final Icon DEFAULT_DISABLED_ICON = HighlightDisplayLevel.createIconByMask(UIUtil.getLabelDisabledForeground());
    static final HighlightSeverity EDIT_SEVERITIES = new HighlightSeverity("-", -1);
    @NotNull
    private final Runnable myOnClose;
    private final ScopesAndSeveritiesTable myTable;
    @NotNull
    private final Project myProject;

    public SeverityRenderer(@NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project2, @NotNull Runnable onClose, @NotNull ScopesAndSeveritiesTable table) {
        if (inspectionProfile == null) {
            SeverityRenderer.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            SeverityRenderer.$$$reportNull$$$0(1);
        }
        if (onClose == null) {
            SeverityRenderer.$$$reportNull$$$0(2);
        }
        if (table == null) {
            SeverityRenderer.$$$reportNull$$$0(3);
        }
        super((Object[])SeverityRenderer.getSeverities(inspectionProfile));
        this.myOnClose = onClose;
        this.myTable = table;
        this.myProject = project2;
    }

    private static HighlightSeverity[] getSeverities(InspectionProfileImpl profile) {
        ArrayList<HighlightSeverity> list2 = new ArrayList<HighlightSeverity>(LevelChooserAction.getSeverities(profile.getProfileManager().getSeverityRegistrar()));
        list2.add(EDIT_SEVERITIES);
        return list2.toArray(new HighlightSeverity[0]);
    }

    public static Icon getIcon(@NotNull HighlightDisplayLevel level) {
        Icon icon2;
        if (level == null) {
            SeverityRenderer.$$$reportNull$$$0(4);
        }
        return (icon2 = level.getIcon()) instanceof HighlightDisplayLevel.ColoredIcon ? new ColorIcon(icon2.getIconWidth(), ((HighlightDisplayLevel.ColoredIcon)((Object)icon2)).getColor()) : icon2;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        component2.setForeground(RenderingUtil.getForeground(table, isSelected));
        component2.setBackground(RenderingUtil.getBackground(table, isSelected));
        component2.setEnabled(((ScopesAndSeveritiesTable)((Object)table)).isRowEnabled(row));
        return component2;
    }

    protected void customizeComponent(HighlightSeverity value, JTable table, boolean isSelected) {
        super.customizeComponent((Object)value, table, isSelected);
        HighlightDisplayLevel hdl = HighlightDisplayLevel.find(value == null ? HighlightSeverity.INFORMATION : value);
        this.setDisabledIcon(hdl != null ? IconLoader.getDisabledIcon(hdl.getIcon()) : DEFAULT_DISABLED_ICON);
    }

    protected String getTextFor(@NotNull HighlightSeverity value) {
        if (value == null) {
            SeverityRenderer.$$$reportNull$$$0(5);
        }
        return value == EDIT_SEVERITIES ? InspectionsBundle.message("inspection.edit.severities.item", new Object[0]) : SingleInspectionProfilePanel.renderSeverity(value);
    }

    protected Icon getIconFor(@NotNull HighlightSeverity value) {
        if (value == null) {
            SeverityRenderer.$$$reportNull$$$0(6);
        }
        return value == EDIT_SEVERITIES ? EmptyIcon.create(HighlightDisplayLevel.getEmptyIconDim()) : HighlightDisplayLevel.find(value).getIcon();
    }

    public boolean isCellEditable(EventObject event) {
        return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
    }

    protected ListSeparator getSeparatorAbove(HighlightSeverity value) {
        return value == EDIT_SEVERITIES ? new ListSeparator() : null;
    }

    public void onClosed(@NotNull LightweightWindowEvent event) {
        if (event == null) {
            SeverityRenderer.$$$reportNull$$$0(7);
        }
        super.onClosed(event);
        this.myOnClose.run();
        if (this.getCellEditorValue() == EDIT_SEVERITIES) {
            ApplicationManager.getApplication().invokeLater(() -> SeverityEditorDialog.show(this.myProject, null, SeverityRegistrar.getSeverityRegistrar(this.myProject), true, severity -> this.myTable.setSelectedSeverity((HighlightSeverity)severity)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClose";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/profile/codeInspection/ui/table/SeverityRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextFor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconFor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

