/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.content.JpsExcludeFolder;
import com.intellij.project.model.impl.module.content.JpsSourceFolder;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsContentEntry
implements ContentEntry,
Disposable {
    private final VirtualFilePointer myRoot;
    private final JpsModule myModule;
    private final JpsRootModel myRootModel;
    private final List<JpsSourceFolder> mySourceFolders;
    private final List<JpsExcludeFolder> myExcludeFolders;
    private final List<String> myExcludePatterns;

    public JpsContentEntry(JpsModule module, JpsRootModel rootModel, String rootUrl) {
        this.myModule = module;
        this.myRootModel = rootModel;
        this.myRoot = VirtualFilePointerManager.getInstance().create(rootUrl, (Disposable)this, null);
        this.mySourceFolders = new ArrayList<JpsSourceFolder>();
        String rootPath = VfsUtilCore.urlToPath(this.getUrl());
        for (JpsModuleSourceRoot root : this.myModule.getSourceRoots()) {
            if (!FileUtil.isAncestor(rootPath, VfsUtilCore.urlToPath(root.getUrl()), false)) continue;
            this.mySourceFolders.add(new JpsSourceFolder(root, this));
        }
        this.myExcludeFolders = new ArrayList<JpsExcludeFolder>();
        for (String excludedUrl : this.myModule.getExcludeRootsList().getUrls()) {
            if (!FileUtil.isAncestor(rootPath, VfsUtilCore.urlToPath(excludedUrl), false)) continue;
            this.myExcludeFolders.add(new JpsExcludeFolder(excludedUrl, this));
        }
        this.myExcludePatterns = new SmartList<String>();
        for (JpsExcludePattern pattern : this.myModule.getExcludePatterns()) {
            if (!pattern.getBaseDirUrl().equals(rootUrl)) continue;
            this.myExcludePatterns.add(pattern.getPattern());
        }
    }

    @Override
    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @Override
    @NotNull
    public String getUrl() {
        String string2 = this.myRoot.getUrl();
        if (string2 == null) {
            JpsContentEntry.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public SourceFolder @NotNull [] getSourceFolders() {
        SourceFolder[] sourceFolderArray = this.mySourceFolders.toArray(new SourceFolder[0]);
        if (sourceFolderArray == null) {
            JpsContentEntry.$$$reportNull$$$0(1);
        }
        return sourceFolderArray;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            JpsContentEntry.$$$reportNull$$$0(2);
        }
        List<SourceFolder> list2 = this.getSourceFolders(Collections.singleton(rootType));
        if (list2 == null) {
            JpsContentEntry.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            JpsContentEntry.$$$reportNull$$$0(4);
        }
        SmartList<SourceFolder> folders = new SmartList<SourceFolder>();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add(folder);
        }
        SmartList<SourceFolder> smartList = folders;
        if (smartList == null) {
            JpsContentEntry.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @Override
    public VirtualFile @NotNull [] getSourceFolderFiles() {
        VirtualFile[] virtualFileArray = JpsContentEntry.getFiles(this.getSourceFolders());
        if (virtualFileArray == null) {
            JpsContentEntry.$$$reportNull$$$0(6);
        }
        return virtualFileArray;
    }

    private static VirtualFile[] getFiles(ContentFolder[] sourceFolders2) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(sourceFolders2.length);
        for (ContentFolder sourceFolder : sourceFolders2) {
            VirtualFile file2 = sourceFolder.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @Override
    public ExcludeFolder @NotNull [] getExcludeFolders() {
        ExcludeFolder[] excludeFolderArray = this.myExcludeFolders.toArray(new ExcludeFolder[0]);
        if (excludeFolderArray == null) {
            JpsContentEntry.$$$reportNull$$$0(7);
        }
        return excludeFolderArray;
    }

    @Override
    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                excluded.add(pointer.getUrl());
            }
        }
        ArrayList<String> arrayList = excluded;
        if (arrayList == null) {
            JpsContentEntry.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    public VirtualFile @NotNull [] getExcludeFolderFiles() {
        ArrayList excluded = new ArrayList();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            ContainerUtil.addIfNotNull(excluded, folder.getFile());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions(this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                ContainerUtil.addIfNotNull(excluded, pointer.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(excluded);
        if (virtualFileArray == null) {
            JpsContentEntry.$$$reportNull$$$0(9);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource) {
        if (file2 == null) {
            JpsContentEntry.$$$reportNull$$$0(10);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file2, isTestSource, "");
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(11);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource, @NotNull String packagePrefix) {
        if (file2 == null) {
            JpsContentEntry.$$$reportNull$$$0(12);
        }
        if (packagePrefix == null) {
            JpsContentEntry.$$$reportNull$$$0(13);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file2.getUrl(), isTestSource, packagePrefix);
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(14);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (file2 == null) {
            JpsContentEntry.$$$reportNull$$$0(15);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(16);
        }
        if (properties == null) {
            JpsContentEntry.$$$reportNull$$$0(17);
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(file2.getUrl(), type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(18);
        }
        return jpsSourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRootType<P> type) {
        if (file2 == null) {
            JpsContentEntry.$$$reportNull$$$0(19);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(20);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file2, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(21);
        }
        return sourceFolder;
    }

    private SourceFolder addSourceFolder(String url, boolean isTestSource, String packagePrefix) {
        JavaSourceRootType rootType = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties(packagePrefix);
        return this.addSourceFolder(url, (JpsModuleSourceRootType)rootType, (JpsElement)properties);
    }

    @Override
    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(22);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, isTestSource, "");
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(23);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(24);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(25);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(26);
        }
        return sourceFolder;
    }

    @Override
    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(27);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(28);
        }
        if (properties == null) {
            JpsContentEntry.$$$reportNull$$$0(29);
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(url, type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(30);
        }
        return jpsSourceFolder;
    }

    @Override
    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(31);
        }
        JpsSourceFolder folder = (JpsSourceFolder)sourceFolder;
        this.mySourceFolders.remove(folder);
        this.myModule.removeSourceRoot(folder.getSourceRoot().getUrl(), folder.getSourceRoot().getRootType());
        Disposer.dispose(folder);
    }

    @Override
    public void clearSourceFolders() {
        ArrayList<JpsModuleSourceRoot> toRemove2 = new ArrayList<JpsModuleSourceRoot>();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            toRemove2.add(folder.getSourceRoot());
            Disposer.dispose(folder);
        }
        this.mySourceFolders.clear();
        for (JpsModuleSourceRoot root : toRemove2) {
            this.myModule.removeSourceRoot(root.getUrl(), root.getRootType());
        }
    }

    @Override
    @NotNull
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JpsContentEntry.$$$reportNull$$$0(32);
        }
        ExcludeFolder excludeFolder = this.addExcludeFolder(file2.getUrl());
        if (excludeFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(33);
        }
        return excludeFolder;
    }

    @Override
    @NotNull
    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(34);
        }
        JpsExcludeFolder folder = new JpsExcludeFolder(url, this);
        this.myModule.getExcludeRootsList().addUrl(url);
        this.myExcludeFolders.add(folder);
        JpsExcludeFolder jpsExcludeFolder = folder;
        if (jpsExcludeFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(35);
        }
        return jpsExcludeFolder;
    }

    @Override
    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(36);
        }
        JpsExcludeFolder folder = (JpsExcludeFolder)excludeFolder;
        this.myExcludeFolders.remove(folder);
        this.myModule.getExcludeRootsList().removeUrl(folder.getUrl());
        Disposer.dispose(folder);
    }

    @Override
    public boolean removeExcludeFolder(@NotNull String url) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(37);
        }
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            this.myModule.getExcludeRootsList().removeUrl(url);
            Disposer.dispose(folder);
            return true;
        }
        return false;
    }

    @Override
    public void clearExcludeFolders() {
        ArrayList<String> toRemove2 = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            toRemove2.add(folder.getUrl());
            Disposer.dispose(folder);
        }
        this.myExcludeFolders.clear();
        for (String url : toRemove2) {
            this.myModule.getExcludeRootsList().removeUrl(url);
        }
    }

    @Override
    @NotNull
    public List<String> getExcludePatterns() {
        List<String> list2 = this.myExcludePatterns;
        if (list2 == null) {
            JpsContentEntry.$$$reportNull$$$0(38);
        }
        return list2;
    }

    @Override
    public void addExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            JpsContentEntry.$$$reportNull$$$0(39);
        }
        this.myExcludePatterns.add(pattern);
        this.myModule.addExcludePattern(this.getUrl(), pattern);
    }

    @Override
    public void removeExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            JpsContentEntry.$$$reportNull$$$0(40);
        }
        this.myExcludePatterns.remove(pattern);
        this.myModule.removeExcludePattern(this.getUrl(), pattern);
    }

    @Override
    public void setExcludePatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            JpsContentEntry.$$$reportNull$$$0(41);
        }
        for (String pattern : this.myExcludePatterns) {
            this.myModule.removeExcludePattern(this.getUrl(), pattern);
        }
        this.myExcludePatterns.clear();
        for (String pattern : patterns) {
            this.addExcludePattern(pattern);
        }
    }

    @Override
    @NotNull
    public ModuleRootModel getRootModel() {
        JpsRootModel jpsRootModel = this.myRootModel;
        if (jpsRootModel == null) {
            JpsContentEntry.$$$reportNull$$$0(42);
        }
        return jpsRootModel;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void dispose() {
        for (JpsSourceFolder jpsSourceFolder : this.mySourceFolders) {
            Disposer.dispose(jpsSourceFolder);
        }
        for (JpsExcludeFolder jpsExcludeFolder : this.myExcludeFolders) {
            Disposer.dispose(jpsExcludeFolder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/project/model/impl/module/content/JpsContentEntry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 16: 
            case 20: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeFolder";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/project/model/impl/module/content/JpsContentEntry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolders";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderUrls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderFiles";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceFolder";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "addExcludeFolder";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludePatterns";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolders";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFolder";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeFolder";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludeFolder";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addExcludePattern";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludePattern";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setExcludePatterns";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

