/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.CodeStyleDeriveProcessor;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResultImpl;
import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class BruteForceProcessor
extends CodeStyleDeriveProcessor {
    public BruteForceProcessor(LangCodeStyleExtractor langExtractor) {
        super(langExtractor);
    }

    @Override
    public ValuesExtractionResult runWithProgress(Project project2, CodeStyleSettings settings, PsiFile file2, ProgressIndicator indicator) {
        List<Value> values2 = this.getFormattingValues(settings, file2.getLanguage());
        Differ differ = this.myLangExtractor.getDiffer(project2, file2, settings);
        ValuesExtractionResultImpl container = new ValuesExtractionResultImpl(values2);
        Utils.adjustValuesMin(container, differ, indicator);
        return container;
    }

    @Override
    @NotNull
    public String getHTMLReport() {
        return "";
    }

    public void randomizeSettings(CodeStyleSettings settings, Language language) {
        List<Value> values2 = this.getFormattingValues(settings, language);
        Random rand = new Random();
        for (Value value : values2) {
            Object[] possible = value.getPossibleValues();
            int index = rand.nextInt(possible.length);
            value.value = possible[index];
            value.write(false);
        }
    }
}

