/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.values;

import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import com.intellij.util.IntPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Generation {
    private static final int GENERATION_POOL_SIZE = 45;
    private static final int MUTATION_PER_GEN = 10;
    public static int GEN_COUNT = 40;
    private List<Gens> myGensPool;
    private int myAge;
    private final int myParentKind;

    private Generation(@NotNull Gens bestGens) {
        if (bestGens == null) {
            Generation.$$$reportNull$$$0(0);
        }
        this.myParentKind = -1;
        this.myGensPool = new ArrayList<Gens>(45);
        for (int i = 0; i < 45; ++i) {
            this.myGensPool.add(new Gens(bestGens).mutate(i == 0 ? 0 : 10));
        }
        this.myAge = 0;
    }

    private Generation(@NotNull Generation previous, int parentKind) {
        if (previous == null) {
            Generation.$$$reportNull$$$0(1);
        }
        this.myAge = previous.myAge + 1;
        this.myParentKind = parentKind;
        this.myGensPool = new ArrayList<Gens>(45);
        int mutationsCount = 10;
        int prevPullSize = previous.myGensPool.size();
        for (int i = 0; i < 45; ++i) {
            int parent1 = 0;
            int parent2 = 0;
            int iterations = 0;
            while (parent1 == parent2) {
                parent1 = Utils.getRandomLess(prevPullSize);
                parent2 = Utils.getRandomLess(prevPullSize);
                if (++iterations <= 25) continue;
            }
            this.myGensPool.add(Gens.breed(previous.myGensPool.get(parent1), previous.myGensPool.get(parent2), mutationsCount));
        }
    }

    @NotNull
    public static Generation createZeroGeneration(@NotNull Gens gens) {
        if (gens == null) {
            Generation.$$$reportNull$$$0(2);
        }
        return new Generation(gens);
    }

    public static Generation createNextGeneration(@NotNull Differ differ, @NotNull Generation previous) {
        if (differ == null) {
            Generation.$$$reportNull$$$0(3);
        }
        if (previous == null) {
            Generation.$$$reportNull$$$0(4);
        }
        int parentKind = previous.reduceToSize(differ, (int)(0.2 * (double)previous.myGensPool.size()));
        return previous.tryAgain() ? new Generation(previous, parentKind) : previous;
    }

    private int reduceToSize(@NotNull Differ differ, int newPoolSize) {
        if (differ == null) {
            Generation.$$$reportNull$$$0(5);
        }
        ArrayList<IntPair> ranges2 = new ArrayList<IntPair>(this.myGensPool.size());
        int i = 0;
        for (Gens gens : this.myGensPool) {
            int range = differ.getDifference(gens);
            ranges2.add(new IntPair(range, i++));
            if (range != 0) continue;
            this.myAge = GEN_COUNT;
            newPoolSize = 1;
            break;
        }
        ranges2.sort(Comparator.comparingInt(o -> o.first));
        ArrayList<Gens> gensPool = new ArrayList<Gens>(newPoolSize);
        int count2 = 0;
        int worseForward = 0;
        for (IntPair pair : ranges2) {
            if (count2 >= newPoolSize) break;
            Gens gens = this.myGensPool.get(pair.second);
            gensPool.add(gens);
            ++count2;
            worseForward = pair.first;
        }
        this.myGensPool = gensPool;
        return worseForward;
    }

    public boolean tryAgain() {
        return this.myAge < GEN_COUNT;
    }

    public Gens getBestGens(Differ differ) {
        this.reduceToSize(differ, 1);
        return this.myGensPool.get(0);
    }

    public int getAge() {
        return this.myAge;
    }

    public int getParentKind() {
        return this.myParentKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bestGens";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previous";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gens";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "differ";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/extractor/values/Generation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createZeroGeneration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createNextGeneration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reduceToSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

