/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.presentation.CodeStyleBoundedIntegerSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleCommaSeparatedIdentifiersPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSoftMarginsPresentation;
import com.intellij.util.LocaleSensitiveApplicationCacheService;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class CodeStyleSettingsPresentations {
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> myBlankLinesStandardSettings;
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> mySpacingStandardSettings;
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> myWrappingAndBracesStandardSettings;
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> myIndentStandardSettings;

    private CodeStyleSettingsPresentations() {
        LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> result2 = new LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>();
        CodeStyleSettingsCustomizableOptions customizableOptions = CodeStyleSettingsCustomizableOptions.getInstance();
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.BLANK_LINES_KEEP), ContainerUtil.immutableList(new CodeStyleSettingPresentation("KEEP_BLANK_LINES_IN_DECLARATIONS", ApplicationBundle.message((String)"editbox.keep.blanklines.in.declarations", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_IN_CODE", ApplicationBundle.message((String)"editbox.keep.blanklines.in.code", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_BEFORE_RBRACE", ApplicationBundle.message((String)"editbox.keep.blanklines.before.rbrace", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_BETWEEN_PACKAGE_DECLARATION_AND_HEADER", ApplicationBundle.message((String)"editbox.keep.blanklines.between.header.and.package", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.BLANK_LINES), ContainerUtil.immutableList(new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_PACKAGE", ApplicationBundle.message((String)"editbox.blanklines.before.package.statement", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_PACKAGE", ApplicationBundle.message((String)"editbox.blanklines.after.package.statement", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_IMPORTS", ApplicationBundle.message((String)"editbox.blanklines.before.imports", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_IMPORTS", ApplicationBundle.message((String)"editbox.blanklines.after.imports", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_CLASS", ApplicationBundle.message((String)"editbox.blanklines.around.class", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_CLASS_HEADER", ApplicationBundle.message((String)"editbox.blanklines.after.class.header", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_CLASS_END", ApplicationBundle.message((String)"editbox.blanklines.before.class.end", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER", ApplicationBundle.message((String)"editbox.blanklines.after.anonymous.class.header", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_FIELD_IN_INTERFACE", ApplicationBundle.message((String)"editbox.blanklines.around.field.in.interface", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_FIELD", ApplicationBundle.message((String)"editbox.blanklines.around.field", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_METHOD_IN_INTERFACE", ApplicationBundle.message((String)"editbox.blanklines.around.method.in.interface", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_METHOD", ApplicationBundle.message((String)"editbox.blanklines.around.method", (Object[])new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_METHOD_BODY", ApplicationBundle.message((String)"editbox.blanklines.before.method.body", (Object[])new Object[0]))));
        this.myBlankLinesStandardSettings = Collections.unmodifiableMap(result2);
        result2 = new LinkedHashMap();
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_BEFORE_PARENTHESES), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.method.declaration.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_CALL_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.method.call.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_IF_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.if.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FOR_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.for.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.while.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SWITCH_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.switch.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_TRY_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.try.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.catch.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SYNCHRONIZED_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.synchronized.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ANOTATION_PARAMETER_LIST", ApplicationBundle.message((String)"checkbox.spaces.annotation.parameters", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_AROUND_OPERATORS), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_AROUND_ASSIGNMENT_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.assignment.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_LOGICAL_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.logical.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_EQUALITY_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.equality.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_RELATIONAL_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.relational.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_BITWISE_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.bitwise.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_ADDITIVE_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.additive.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_MULTIPLICATIVE_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.multiplicative.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_SHIFT_OPERATORS", ApplicationBundle.message((String)"checkbox.spaces.shift.operators", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_UNARY_OPERATOR", ApplicationBundle.message((String)"checkbox.spaces.around.unary.operator", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_LAMBDA_ARROW", ApplicationBundle.message((String)"checkbox.spaces.around.lambda.arrow", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_METHOD_REF_DBL_COLON", ApplicationBundle.message((String)"checkbox.spaces.around.method.ref.dbl.colon.arrow", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_BEFORE_LEFT_BRACE), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_BEFORE_CLASS_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.class.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.method.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_IF_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.if.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ELSE_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.else.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FOR_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.for.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.while.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_DO_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.do.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SWITCH_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.switch.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_TRY_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.try.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.catch.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FINALLY_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.finally.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SYNCHRONIZED_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.synchronized.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.array.initializer.left.brace", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE", ApplicationBundle.message((String)"checkbox.spaces.annotation.array.initializer.left.brace", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_BEFORE_KEYWORD), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_BEFORE_ELSE_KEYWORD", ApplicationBundle.message((String)"checkbox.spaces.else.keyword", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_KEYWORD", ApplicationBundle.message((String)"checkbox.spaces.while.keyword", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_KEYWORD", ApplicationBundle.message((String)"checkbox.spaces.catch.keyword", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FINALLY_KEYWORD", ApplicationBundle.message((String)"checkbox.spaces.finally.keyword", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_WITHIN), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_WITHIN_BRACES", ApplicationBundle.message((String)"checkbox.spaces.within.braces", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_BRACKETS", ApplicationBundle.message((String)"checkbox.spaces.within.brackets", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", ApplicationBundle.message((String)"checkbox.spaces.within.array.initializer.braces", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES", ApplicationBundle.message((String)"checkbox.spaces.within.empty.array.initializer.braces", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.within.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_METHOD_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.checkbox.spaces.method.declaration.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_METHOD_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.checkbox.spaces.empty.method.declaration.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_METHOD_CALL_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.checkbox.spaces.method.call.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.checkbox.spaces.empty.method.call.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_IF_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.if.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_FOR_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.for.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_WHILE_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.while.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_SWITCH_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.switch.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_TRY_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.try.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_CATCH_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.catch.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_SYNCHRONIZED_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.synchronized.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_CAST_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.type.cast.parentheses", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_ANNOTATION_PARENTHESES", ApplicationBundle.message((String)"checkbox.spaces.annotation.parentheses", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_IN_TERNARY_OPERATOR), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_BEFORE_QUEST", ApplicationBundle.message((String)"checkbox.spaces.before.question", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_QUEST", ApplicationBundle.message((String)"checkbox.spaces.after.question", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_COLON", ApplicationBundle.message((String)"checkbox.spaces.before.colon", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_COLON", ApplicationBundle.message((String)"checkbox.spaces.after.colon", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_WITHIN_TYPE_ARGUMENTS), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS", ApplicationBundle.message((String)"checkbox.spaces.after.comma", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_IN_TYPE_ARGUMENTS), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_BEFORE_TYPE_PARAMETER_LIST", ApplicationBundle.message((String)"checkbox.spaces.before.opening.angle.bracket", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_IN_TYPE_PARAMETERS), ContainerUtil.immutableList(new CodeStyleSettingPresentation[0]));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_OTHER), ContainerUtil.immutableList(new CodeStyleSettingPresentation("SPACE_BEFORE_COMMA", ApplicationBundle.message((String)"checkbox.spaces.before.comma", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_COMMA", ApplicationBundle.message((String)"checkbox.spaces.after.comma", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SEMICOLON", ApplicationBundle.message((String)"checkbox.spaces.before.semicolon", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_SEMICOLON", ApplicationBundle.message((String)"checkbox.spaces.after.semicolon", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_TYPE_CAST", ApplicationBundle.message((String)"checkbox.spaces.after.type.cast", (Object[])new Object[0]))));
        this.mySpacingStandardSettings = Collections.unmodifiableMap(result2);
        result2 = new LinkedHashMap();
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(null), ContainerUtil.immutableList(new CodeStyleBoundedIntegerSettingPresentation("RIGHT_MARGIN", ApplicationBundle.message((String)"editbox.right.margin.columns", (Object[])new Object[0]), 0, 999, -1, ApplicationBundle.message((String)"settings.code.style.default.general", (Object[])new Object[0])), new CodeStyleSelectSettingPresentation("WRAP_ON_TYPING", ApplicationBundle.message((String)"wrapping.wrap.on.typing", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES, customizableOptions.WRAP_ON_TYPING_OPTIONS), new CodeStyleSoftMarginsPresentation()));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_KEEP), ContainerUtil.immutableList(new CodeStyleSettingPresentation("KEEP_LINE_BREAKS", ApplicationBundle.message((String)"wrapping.keep.line.breaks", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message((String)"wrapping.keep.comment.at.first.column", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_CONTROL_STATEMENT_IN_ONE_LINE", ApplicationBundle.message((String)"checkbox.keep.when.reformatting.control.statement.in.one.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE", ApplicationBundle.message((String)"wrapping.keep.multiple.expressions.in.one.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", ApplicationBundle.message((String)"wrapping.keep.simple.blocks.in.one.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_METHODS_IN_ONE_LINE", ApplicationBundle.message((String)"wrapping.keep.simple.methods.in.one.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE", ApplicationBundle.message((String)"wrapping.keep.simple.lambdas.in.one.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_CLASSES_IN_ONE_LINE", ApplicationBundle.message((String)"wrapping.keep.simple.classes.in.one.line", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(null), ContainerUtil.immutableList(new CodeStyleSettingPresentation("WRAP_LONG_LINES", ApplicationBundle.message((String)"wrapping.long.lines", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_COMMENTS), ContainerUtil.immutableList(new CodeStyleSettingPresentation("WRAP_COMMENTS", ApplicationBundle.message((String)"wrapping.comments.wrap.at.right.margin", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_BRACES), ContainerUtil.immutableList(new CodeStyleSelectSettingPresentation("CLASS_BRACE_STYLE", ApplicationBundle.message((String)"wrapping.brace.placement.class.declaration", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("METHOD_BRACE_STYLE", ApplicationBundle.message((String)"wrapping.brace.placement.method.declaration", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("LAMBDA_BRACE_STYLE", ApplicationBundle.message((String)"wrapping.brace.placement.lambda", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("BRACE_STYLE", ApplicationBundle.message((String)"wrapping.brace.placement.other", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS)));
        CodeStyleSettingsPresentations.putGroupTop(result2, "EXTENDS_LIST_WRAP", customizableOptions.WRAPPING_EXTENDS_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_EXTENDS_LIST), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_EXTENDS_LIST", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "EXTENDS_KEYWORD_WRAP", customizableOptions.WRAPPING_EXTENDS_KEYWORD, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON, customizableOptions.WRAP_OPTIONS_FOR_SINGLETON);
        CodeStyleSettingsPresentations.putGroupTop(result2, "THROWS_LIST_WRAP", customizableOptions.WRAPPING_THROWS_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_THROWS_LIST), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_THROWS_LIST", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("ALIGN_THROWS_KEYWORD", ApplicationBundle.message((String)"wrapping.align.throws.keyword", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "THROWS_KEYWORD_WRAP", customizableOptions.WRAPPING_THROWS_KEYWORD, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON, customizableOptions.WRAP_OPTIONS_FOR_SINGLETON);
        CodeStyleSettingsPresentations.putGroupTop(result2, "METHOD_PARAMETERS_WRAP", customizableOptions.WRAPPING_METHOD_PARAMETERS, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_METHOD_PARAMETERS), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARAMETERS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0])), new CodeStyleSettingPresentation("METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "CALL_PARAMETERS_WRAP", customizableOptions.WRAPPING_METHOD_ARGUMENTS_WRAPPING, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_METHOD_ARGUMENTS_WRAPPING), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARAMETERS_IN_CALLS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("PREFER_PARAMETERS_WRAP", ApplicationBundle.message((String)"wrapping.take.priority.over.call.chain.wrapping", (Object[])new Object[0])), new CodeStyleSettingPresentation("CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0])), new CodeStyleSettingPresentation("CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_METHOD_PARENTHESES), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_METHOD_BRACKETS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "METHOD_CALL_CHAIN_WRAP", customizableOptions.WRAPPING_CALL_CHAIN, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_CALL_CHAIN), ContainerUtil.immutableList(new CodeStyleSettingPresentation("WRAP_FIRST_METHOD_IN_CALL_CHAIN", ApplicationBundle.message((String)"wrapping.chained.method.call.first.on.new.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("ALIGN_MULTILINE_CHAINED_METHODS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleCommaSeparatedIdentifiersPresentation("BUILDER_METHODS", ApplicationBundle.message((String)"wrapping.builder.methods", (Object[])new Object[0])), new CodeStyleSettingPresentation("KEEP_BUILDER_METHODS_INDENTS", ApplicationBundle.message((String)"wrapping.builder.methods.keep.indents", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_IF_STATEMENT), ContainerUtil.immutableList(new CodeStyleSelectSettingPresentation("IF_BRACE_FORCE", ApplicationBundle.message((String)"wrapping.force.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS), new CodeStyleSettingPresentation("ELSE_ON_NEW_LINE", ApplicationBundle.message((String)"wrapping.else.on.new.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("SPECIAL_ELSE_IF_TREATMENT", ApplicationBundle.message((String)"wrapping.special.else.if.braces.treatment", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "FOR_STATEMENT_WRAP", customizableOptions.WRAPPING_FOR_STATEMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_FOR_STATEMENT), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_FOR", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("FOR_STATEMENT_LPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0])), new CodeStyleSettingPresentation("FOR_STATEMENT_RPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0])), new CodeStyleSelectSettingPresentation("FOR_BRACE_FORCE", ApplicationBundle.message((String)"wrapping.force.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS)));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_WHILE_STATEMENT), ContainerUtil.immutableList(new CodeStyleSelectSettingPresentation("WHILE_BRACE_FORCE", ApplicationBundle.message((String)"wrapping.force.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS)));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_DOWHILE_STATEMENT), ContainerUtil.immutableList(new CodeStyleSelectSettingPresentation("DOWHILE_BRACE_FORCE", ApplicationBundle.message((String)"wrapping.force.braces", (Object[])new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS), new CodeStyleSettingPresentation("WHILE_ON_NEW_LINE", ApplicationBundle.message((String)"wrapping.while.on.new.line", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_SWITCH_STATEMENT), ContainerUtil.immutableList(new CodeStyleSettingPresentation("INDENT_CASE_FROM_SWITCH", ApplicationBundle.message((String)"wrapping.indent.case.from.switch", (Object[])new Object[0])), new CodeStyleSettingPresentation("INDENT_BREAK_FROM_CASE", ApplicationBundle.message((String)"wrapping.indent.break.from.case", (Object[])new Object[0])), new CodeStyleSettingPresentation("CASE_STATEMENT_ON_NEW_LINE", ApplicationBundle.message((String)"wrapping.case.statements.on.one.line", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "RESOURCE_LIST_WRAP", customizableOptions.WRAPPING_TRY_RESOURCE_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_TRY_RESOURCE_LIST), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_RESOURCES", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("RESOURCE_LIST_LPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0])), new CodeStyleSettingPresentation("RESOURCE_LIST_RPAREN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_TRY_STATEMENT), ContainerUtil.immutableList(new CodeStyleSettingPresentation("CATCH_ON_NEW_LINE", ApplicationBundle.message((String)"wrapping.catch.on.new.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("FINALLY_ON_NEW_LINE", ApplicationBundle.message((String)"wrapping.finally.on.new.line", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "BINARY_OPERATION_WRAP", customizableOptions.WRAPPING_BINARY_OPERATION, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_BINARY_OPERATION), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_BINARY_OPERATION", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("BINARY_OPERATION_SIGN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.operation.sign.on.next.line", (Object[])new Object[0])), new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION", ApplicationBundle.message((String)"wrapping.align.parenthesised.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("PARENTHESES_EXPRESSION_LPAREN_WRAP", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0])), new CodeStyleSettingPresentation("PARENTHESES_EXPRESSION_RPAREN_WRAP", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "ASSIGNMENT_WRAP", customizableOptions.WRAPPING_ASSIGNMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_ASSIGNMENT), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_ASSIGNMENT", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.assignment.sign.on.next.line", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_FIELDS_VARIABLES_GROUPS), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_GROUP_FIELD_DECLARATIONS", ApplicationBundle.message((String)"wrapping.align.fields.in.columns", (Object[])new Object[0])), new CodeStyleSettingPresentation("ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS", ApplicationBundle.message((String)"wrapping.align.variables.in.columns", (Object[])new Object[0])), new CodeStyleSettingPresentation("ALIGN_CONSECUTIVE_ASSIGNMENTS", ApplicationBundle.message((String)"wrapping.align.assignments.in.columns", (Object[])new Object[0])), new CodeStyleSettingPresentation("ALIGN_SUBSEQUENT_SIMPLE_METHODS", ApplicationBundle.message((String)"wrapping.align.simple.methods.in.columns", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "TERNARY_OPERATION_WRAP", customizableOptions.WRAPPING_TERNARY_OPERATION, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_TERNARY_OPERATION), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_TERNARY_OPERATION", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.quest.and.colon.signs.on.next.line", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "ARRAY_INITIALIZER_WRAP", customizableOptions.WRAPPING_ARRAY_INITIALIZER, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_ARRAY_INITIALIZER), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0])), new CodeStyleSettingPresentation("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.new.line.after.lbrace", (Object[])new Object[0])), new CodeStyleSettingPresentation("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.rbrace.on.new.line", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_MODIFIER_LIST), ContainerUtil.immutableList(new CodeStyleSettingPresentation("MODIFIER_LIST_WRAP", ApplicationBundle.message((String)"wrapping.after.modifier.list", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "ASSERT_STATEMENT_WRAP", customizableOptions.WRAPPING_ASSERT_STATEMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_ASSERT_STATEMENT), ContainerUtil.immutableList(new CodeStyleSettingPresentation("ASSERT_STATEMENT_COLON_ON_NEXT_LINE", ApplicationBundle.message((String)"wrapping.colon.signs.on.next.line", (Object[])new Object[0]))));
        CodeStyleSettingsPresentations.putGroupTop(result2, "ENUM_CONSTANTS_WRAP", ApplicationBundle.message((String)"wrapping.enum.constants", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result2, "CLASS_ANNOTATION_WRAP", ApplicationBundle.message((String)"wrapping.classes.annotation", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result2, "METHOD_ANNOTATION_WRAP", ApplicationBundle.message((String)"wrapping.methods.annotation", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result2, "FIELD_ANNOTATION_WRAP", ApplicationBundle.message((String)"wrapping.fields.annotation", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result2, "PARAMETER_ANNOTATION_WRAP", ApplicationBundle.message((String)"wrapping.parameters.annotation", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result2, "VARIABLE_ANNOTATION_WRAP", ApplicationBundle.message((String)"wrapping.local.variables.annotation", (Object[])new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        this.myWrappingAndBracesStandardSettings = Collections.unmodifiableMap(result2);
        result2 = new LinkedHashMap();
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(null), ContainerUtil.immutableList(new CodeStyleSettingPresentation("INDENT_SIZE", ApplicationBundle.message((String)"editbox.indent.indent", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(null), ContainerUtil.immutableList(new CodeStyleSettingPresentation("CONTINUATION_INDENT_SIZE", ApplicationBundle.message((String)"editbox.indent.continuation.indent", (Object[])new Object[0]))));
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(null), ContainerUtil.immutableList(new CodeStyleSettingPresentation("TAB_SIZE", ApplicationBundle.message((String)"editbox.indent.tab.size", (Object[])new Object[0]))));
        this.myIndentStandardSettings = Collections.unmodifiableMap(result2);
    }

    private static void putGroupTop(@NotNull Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> result2, @NotNull String fieldName, @NlsContexts.Label @NotNull String uiName, int[] values2, String[] valueUiNames) {
        if (result2 == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(1);
        }
        if (uiName == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(2);
        }
        result2.put(new CodeStyleSettingPresentation.SettingsGroup(null), ContainerUtil.immutableList(new CodeStyleSelectSettingPresentation(fieldName, uiName, values2, valueUiNames)));
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getBlankLinesStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map2 = this.myBlankLinesStandardSettings;
        if (map2 == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getSpacingStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map2 = this.mySpacingStandardSettings;
        if (map2 == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getWrappingAndBracesStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map2 = this.myWrappingAndBracesStandardSettings;
        if (map2 == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getIndentStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map2 = this.myIndentStandardSettings;
        if (map2 == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @NotNull
    static CodeStyleSettingsPresentations getInstance() {
        CodeStyleSettingsPresentations codeStyleSettingsPresentations = LocaleSensitiveApplicationCacheService.getInstance().getData(CodeStyleSettingsPresentations.class, CodeStyleSettingsPresentations::new);
        if (codeStyleSettingsPresentations == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(7);
        }
        return codeStyleSettingsPresentations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/presentation/CodeStyleSettingsPresentations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/presentation/CodeStyleSettingsPresentations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlankLinesStandardSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpacingStandardSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappingAndBracesStandardSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentStandardSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putGroupTop";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

