/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexScanUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexingStamp;
import java.util.HashSet;
import java.util.Map;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexTodoCacheManagerImpl
implements TodoCacheManager {
    private static final Logger LOG = Logger.getInstance(IndexTodoCacheManagerImpl.class);
    private final Project myProject;

    public IndexTodoCacheManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    public PsiFile @NotNull [] getFilesWithTodoItems() {
        HashSet files2 = new HashSet();
        this.processFilesWithTodoItems(new CommonProcessors.CollectProcessor(files2));
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(files2);
        if (psiFileArray == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(1);
        }
        return psiFileArray;
    }

    public boolean processFilesWithTodoItems(@NotNull Processor<? super PsiFile> processor) {
        if (processor == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            return true;
        }
        GlobalSearchScope scope = new GlobalSearchScope(this.myProject){

            @Override
            public boolean isSearchInModuleContent(@NotNull Module module) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public boolean isSearchInLibraries() {
                return false;
            }

            @Override
            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return TodoIndexers.belongsToProject((Project)IndexTodoCacheManagerImpl.this.myProject, (VirtualFile)file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ConcurrentBitSet idSet = ConcurrentBitSet.create();
        ManagingFS fs = ManagingFS.getInstance();
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        IntPredicate consumer = fileId -> {
            VirtualFile file2 = fs.findFileById(fileId);
            if (file2 == null || !file2.isValid() || !scope.contains(file2)) {
                return true;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            return psiFile == null || processor.process(psiFile);
        };
        DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> FileBasedIndex.getInstance().processAllKeys(TodoIndex.NAME, fileId -> {
            idSet.set(fileId.intValue());
            return true;
        }, scope, null));
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        fileDocumentManager.processUnsavedDocuments(document -> {
            VirtualFile file2 = fileDocumentManager.getFile((Document)document);
            if (file2 instanceof VirtualFileWithId) {
                idSet.clear(((VirtualFileWithId)((Object)file2)).getId());
            }
            return true;
        });
        int fileId2 = idSet.nextSetBit(0);
        while (fileId2 > 0) {
            if (IndexingStamp.isFileIndexedStateCurrent(fileId2, TodoIndex.NAME) != FileIndexingState.UP_TO_DATE) {
                idSet.clear(fileId2);
            } else if (!consumer.test(fileId2)) {
                return false;
            }
            fileId2 = idSet.nextSetBit(fileId2 + 1);
        }
        IdFilter filter2 = ((FileBasedIndexEx)FileBasedIndex.getInstance()).extractIdFilter(scope, this.myProject);
        return FileBasedIndexScanUtil.doProcessAllKeys(TodoIndex.NAME, fileId -> idSet.set(fileId.intValue()) || consumer.test((int)fileId), scope, filter2);
    }

    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPatternProvider patternProvider) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(3);
        }
        if (patternProvider == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(4);
        }
        return this.getTodoCountImpl(file2, patternProvider.getIndexPatterns());
    }

    public int getTodoCount(@NotNull VirtualFile file2, @NotNull IndexPattern pattern) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(6);
        }
        return this.getTodoCountImpl(file2, pattern);
    }

    private int getTodoCountImpl(@NotNull VirtualFile file2, IndexPattern ... indexPatterns) {
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(7);
        }
        if (indexPatterns == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(8);
        }
        if (file2 instanceof VirtualFileWindow) {
            return -1;
        }
        Map<TodoIndexEntry, Integer> data2 = IndexTodoCacheManagerImpl.getTodoMap(this.myProject, file2);
        if (data2 == null || data2.isEmpty()) {
            return 0;
        }
        int result2 = 0;
        for (IndexPattern pattern : indexPatterns) {
            result2 += data2.getOrDefault(new TodoIndexEntry(pattern.getPatternString(), pattern.isCaseSensitive()), 0).intValue();
        }
        return result2;
    }

    @Nullable
    public static Map<TodoIndexEntry, Integer> getTodoMap(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if (project2.isDefault()) {
            return null;
        }
        if (file2 instanceof VirtualFileWindow) {
            return null;
        }
        return file2 instanceof LightVirtualFile ? IndexTodoCacheManagerImpl.calcTodoMap(project2, (LightVirtualFile)file2) : (TodoIndexers.belongsToProject((Project)project2, (VirtualFile)file2) ? IndexTodoCacheManagerImpl.getTodoMapFromIndex(project2, file2) : null);
    }

    @Nullable
    private static Map<TodoIndexEntry, Integer> calcTodoMap(@NotNull Project project2, @NotNull LightVirtualFile file2) {
        CharSequence content2;
        if (project2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty(content2 = file2.getContent())) {
            return null;
        }
        TodoIndex extension2 = FileBasedIndexExtension.EXTENSION_POINT_NAME.findExtension(TodoIndex.class);
        if (extension2 == null) {
            return null;
        }
        FileContent fc = FileContentImpl.createByText(file2, content2, project2);
        Map data2 = extension2.getIndexer().map(fc);
        return (Map)ContainerUtil.getFirstItem(data2.values());
    }

    @Nullable
    private static Map<TodoIndexEntry, Integer> getTodoMapFromIndex(@NotNull Project project2, @NotNull VirtualFile file2) {
        Map<Integer, Map<TodoIndexEntry, Integer>> map2;
        if (project2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            IndexTodoCacheManagerImpl.$$$reportNull$$$0(14);
        }
        return (map2 = FileBasedIndexScanUtil.getIndexData(TodoIndex.NAME, project2, file2)) == null ? null : ContainerUtil.getFirstItem(map2.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexTodoCacheManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithTodoItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithTodoItems";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTodoCount";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTodoCountImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTodoMap";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcTodoMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTodoMapFromIndex";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

