/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentCalculator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BaseLineOffsetCalculator myBaseLineOffsetCalculator;
    @NotNull
    private final Indent myIndent;
    public static final BaseLineOffsetCalculator LINE_BEFORE = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            if (currPosition == null) {
                1.$$$reportNull$$$0(0);
            }
            return CharArrayUtil.shiftBackward(currPosition.getChars(), currPosition.getStartOffset(), " \t\n\r");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator$1", "getOffsetInBaseIndentLine"));
        }
    };
    public static final BaseLineOffsetCalculator LINE_AFTER = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            if (currPosition == null) {
                2.$$$reportNull$$$0(0);
            }
            return CharArrayUtil.shiftForward(currPosition.getChars(), currPosition.getStartOffset(), " \t\n\r");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator$2", "getOffsetInBaseIndentLine"));
        }
    };

    public IndentCalculator(@NotNull Project project2, @NotNull Editor editor2, @NotNull BaseLineOffsetCalculator baseLineOffsetCalculator, @NotNull Indent indent) {
        if (project2 == null) {
            IndentCalculator.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            IndentCalculator.$$$reportNull$$$0(1);
        }
        if (baseLineOffsetCalculator == null) {
            IndentCalculator.$$$reportNull$$$0(2);
        }
        if (indent == null) {
            IndentCalculator.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myEditor = editor2;
        this.myBaseLineOffsetCalculator = baseLineOffsetCalculator;
        this.myIndent = indent;
    }

    @Nullable
    String getIndentString(@Nullable Language language, @NotNull SemanticEditorPosition currPosition) {
        if (currPosition == null) {
            IndentCalculator.$$$reportNull$$$0(4);
        }
        String baseIndent = this.getBaseIndent(currPosition);
        Document document = this.myEditor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
        if (file2 != null) {
            CommonCodeStyleSettings.IndentOptions options;
            CommonCodeStyleSettings.IndentOptions fileOptions = CodeStyle.getIndentOptions((PsiFile)file2);
            CommonCodeStyleSettings.IndentOptions indentOptions = options = !fileOptions.isOverrideLanguageOptions() && language != null && !language.is(file2.getLanguage()) && !language.is(Language.ANY) ? CodeStyle.getLanguageSettings((PsiFile)file2, (Language)language).getIndentOptions() : fileOptions;
            if (options != null) {
                int indentLength = baseIndent.replaceAll("\t", StringUtil.repeatSymbol(' ', options.TAB_SIZE)).length() + IndentCalculator.indentToSize(this.myIndent, options);
                return new IndentInfo(0, indentLength, 0, false).generateNewWhiteSpace(options);
            }
        }
        return null;
    }

    @NotNull
    protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
        int indentEnd;
        int indentStart;
        int indentLineOffset;
        if (currPosition == null) {
            IndentCalculator.$$$reportNull$$$0(5);
        }
        CharSequence docChars = this.myEditor.getDocument().getCharsSequence();
        int offset = currPosition.getStartOffset();
        if (offset > 0 && (indentLineOffset = this.myBaseLineOffsetCalculator.getOffsetInBaseIndentLine(currPosition)) > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil(docChars, indentLineOffset, "\n") + 1) >= 0 && (indentEnd = CharArrayUtil.shiftForward(docChars, indentStart, " \t")) > indentStart) {
            String string2 = docChars.subSequence(indentStart, indentEnd).toString();
            if (string2 == null) {
                IndentCalculator.$$$reportNull$$$0(6);
            }
            return string2;
        }
        return "";
    }

    private static int indentToSize(@NotNull Indent indent, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (indent == null) {
            IndentCalculator.$$$reportNull$$$0(7);
        }
        if (options == null) {
            IndentCalculator.$$$reportNull$$$0(8);
        }
        if (indent.getType() == Indent.Type.NORMAL) {
            return options.INDENT_SIZE;
        }
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return options.CONTINUATION_INDENT_SIZE;
        }
        if (indent.getType() == Indent.Type.SPACES && indent instanceof IndentImpl) {
            return ((IndentImpl)indent).getSpaces();
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLineOffsetCalculator";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currPosition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIndentString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBaseIndent";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indentToSize";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BaseLineOffsetCalculator {
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition var1);
    }
}

