/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaLikeLangLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project2, @NotNull Editor editor2, @Nullable Language language, int offset) {
        if (project2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(1);
        }
        if (offset > 0) {
            IndentCalculator indentCalculator = this.getIndent(project2, editor2, language, offset - 1);
            if (indentCalculator != null) {
                return indentCalculator.getIndentString(language, this.getPosition(editor2, offset - 1));
            }
        } else {
            return "";
        }
        return null;
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project2, @NotNull Editor editor2, @Nullable Language language, int offset) {
        if (project2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(3);
        }
        IndentCalculatorFactory myFactory = new IndentCalculatorFactory(project2, editor2);
        if (this.getPosition(editor2, offset).matchesRule(position -> position.isAt(JavaLikeElement.Whitespace) && position.isAtMultiline())) {
            if (this.getPosition(editor2, offset).before().isAt(JavaLikeElement.Comma)) {
                SemanticEditorPosition position2 = this.getPosition(editor2, offset);
                if (position2.hasEmptyLineAfter(offset) && !position2.after().matchesRule(p -> p.isAtAnyOf(JavaLikeElement.ArrayClosingBracket, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace, JavaLikeElement.RightParenthesis) || p.isAtEnd()) && position2.findLeftParenthesisBackwardsSkippingNestedWithPredicate(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis, self -> self.isAtAnyOf(JavaLikeElement.BlockClosingBrace, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.Semicolon)).isAt(JavaLikeElement.LeftParenthesis)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_AFTER);
                }
            } else {
                if (this.afterOptionalWhitespaceOnSameLine(editor2, offset).matchesRule(position -> position.isAt(JavaLikeElement.BlockClosingBrace) && !position.after().afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.Comma))) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, position -> {
                        position.moveToLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                        if (!position.isAtEnd()) {
                            return this.getBlockStatementStartOffset(position);
                        }
                        return -1;
                    });
                }
                if (this.getPosition(editor2, offset).beforeOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockClosingBrace)) {
                    SemanticEditorPosition position3 = this.getPosition(editor2, offset).beforeOptional(JavaLikeElement.Whitespace).before();
                    boolean isOnNewLine = position3.isAtMultiline(JavaLikeElement.Whitespace);
                    position3.moveToLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                    position3.moveBefore();
                    int statementStart = this.getStatementStartOffset(position3, true);
                    position3 = this.getPosition(editor2, statementStart);
                    if (!this.isStartOfStatementWithOptionalBlock(position3)) {
                        if (!isOnNewLine) {
                            return null;
                        }
                        return myFactory.createIndentCalculator(JavaLikeLangLineIndentProvider.getBlockIndentType(editor2, language), IndentCalculator.LINE_BEFORE);
                    }
                    return myFactory.createIndentCalculator(JavaLikeLangLineIndentProvider.getBlockIndentType(editor2, language), this::getFirstUppermostControlStructureKeywordOffset);
                }
                if (this.getPosition(editor2, offset).before().isAt(JavaLikeElement.Semicolon)) {
                    int statementStart;
                    SemanticEditorPosition atStatementStart;
                    SemanticEditorPosition beforeSemicolon = this.getPosition(editor2, offset).before().beforeOptional(JavaLikeElement.Semicolon);
                    if (beforeSemicolon.isAt(JavaLikeElement.BlockClosingBrace)) {
                        beforeSemicolon.moveBeforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                    }
                    if (JavaLikeLangLineIndentProvider.isAtBlockOpeningOnSameLine(atStatementStart = this.getPosition(editor2, statementStart = this.getStatementStartOffset(beforeSemicolon, this.dropIndentAfterReturnLike(beforeSemicolon), true)))) {
                        return myFactory.createIndentCalculator(this.getIndentInBlock(project2, language, atStatementStart), this::getDeepBlockStatementStartOffset);
                    }
                    if (!this.isInsideForLikeConstruction(atStatementStart)) {
                        return myFactory.createIndentCalculator(Indent.Type.NONE, position -> statementStart);
                    }
                } else {
                    if (this.isInArray(editor2, offset)) {
                        return myFactory.createIndentCalculator(this.getIndentInBrackets(), IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(editor2, offset).before().isAt(JavaLikeElement.LeftParenthesis)) {
                        return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(editor2, offset).matchesRule(position -> {
                        JavaLikeLangLineIndentProvider.moveBeforeEndLineComments(position);
                        if (position.isAt(JavaLikeElement.BlockOpeningBrace)) {
                            return !position.before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace).isAt(JavaLikeElement.LeftParenthesis);
                        }
                        return false;
                    })) {
                        SemanticEditorPosition position4 = this.getPosition(editor2, offset).before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace);
                        return myFactory.createIndentCalculator(this.getIndentInBlock(project2, language, position4), this::getBlockStatementStartOffset);
                    }
                    if (this.getPosition(editor2, offset).before().matchesRule(position -> this.isColonAfterLabelOrCase(position) || position.isAtAnyOf(JavaLikeElement.ElseKeyword, JavaLikeElement.DoKeyword))) {
                        Indent.Type indentType = this.getPosition(editor2, offset).afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockOpeningBrace) ? Indent.Type.NONE : Indent.Type.NORMAL;
                        return myFactory.createIndentCalculator(indentType, IndentCalculator.LINE_BEFORE);
                    }
                    if (this.getPosition(editor2, offset).matchesRule(position -> {
                        position.moveBefore();
                        if (position.isAt(JavaLikeElement.BlockComment)) {
                            return position.before().isAt(JavaLikeElement.Whitespace) && position.isAtMultiline();
                        }
                        return false;
                    })) {
                        int offsetBeforeComment = this.getPosition(editor2, offset).findStartOf(JavaLikeElement.BlockComment);
                        return this.getIndent(project2, editor2, language, offsetBeforeComment);
                    }
                    if (this.getPosition(editor2, offset).before().isAt(JavaLikeElement.DocBlockEnd)) {
                        return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf(JavaLikeElement.DocBlockStart));
                    }
                    SemanticEditorPosition position5 = this.getPosition(editor2, offset);
                    if ((position5 = position5.before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace)).isAt(JavaLikeElement.RightParenthesis)) {
                        int offsetAfterParen = position5.getStartOffset() + 1;
                        position5.moveBeforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                        if (!position5.isAtEnd()) {
                            position5.moveBeforeOptional(JavaLikeElement.Whitespace);
                            if (position5.isAt(JavaLikeElement.IfKeyword) || position5.isAt(JavaLikeElement.ForKeyword)) {
                                SemanticEditorPosition.SyntaxElement element2 = position5.getCurrElement();
                                assert (element2 != null);
                                int controlKeywordOffset = position5.getStartOffset();
                                Indent.Type indentType = this.getPosition(editor2, offsetAfterParen).afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockOpeningBrace) ? Indent.Type.NONE : Indent.Type.NORMAL;
                                return myFactory.createIndentCalculator(indentType, baseLineOffset -> controlKeywordOffset);
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isAtBlockOpeningOnSameLine(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(4);
        }
        SemanticEditorPosition pos = position.copy();
        while (!pos.isAt(JavaLikeElement.BlockOpeningBrace)) {
            pos.moveBefore();
            if (!pos.isAtEnd() && !pos.isAtMultiline()) continue;
            return false;
        }
        return true;
    }

    private SemanticEditorPosition afterOptionalWhitespaceOnSameLine(@NotNull Editor editor2, int offset) {
        SemanticEditorPosition position;
        if (editor2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(5);
        }
        if ((position = this.getPosition(editor2, offset)).isAt(JavaLikeElement.Whitespace)) {
            if (position.hasLineBreaksAfter(offset)) {
                return position;
            }
            position.moveAfter();
        }
        return position;
    }

    protected boolean isInArray(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(6);
        }
        return this.getPosition(editor2, offset).before().isAt(JavaLikeElement.ArrayOpeningBracket);
    }

    protected boolean dropIndentAfterReturnLike(@NotNull SemanticEditorPosition statementBeforeSemicolon) {
        if (statementBeforeSemicolon == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(7);
        }
        return false;
    }

    protected boolean isColonAfterLabelOrCase(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(8);
        }
        return position.isAt(JavaLikeElement.Colon) && this.getPosition(position.getEditor(), position.getStartOffset()).isAfterOnSameLine(JavaLikeElement.SwitchCase, JavaLikeElement.SwitchDefault);
    }

    protected boolean isInsideForLikeConstruction(SemanticEditorPosition position) {
        return position.isAfterOnSameLine(JavaLikeElement.ForKeyword);
    }

    protected int getBlockStatementStartOffset(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(9);
        }
        JavaLikeLangLineIndentProvider.moveBeforeEndLineComments(position);
        position.moveBeforeOptional(JavaLikeElement.BlockOpeningBrace);
        if (position.isAt(JavaLikeElement.Whitespace)) {
            if (position.isAtMultiline()) {
                return position.after().getStartOffset();
            }
            position.moveBefore();
        }
        return this.getStatementStartOffset(position, false);
    }

    private static void moveBeforeEndLineComments(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(10);
        }
        position.moveBefore();
        while (!position.isAtMultiline() && position.isAtAnyOf(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace)) {
            position.moveBefore();
        }
    }

    protected int getDeepBlockStatementStartOffset(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(11);
        }
        position.moveToLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
        return this.getBlockStatementStartOffset(position);
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(12);
        }
        return this.getStatementStartOffset(position, ignoreLabels, false);
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position, boolean ignoreLabels, boolean useParentControlStructures) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(13);
        }
        Language currLanguage = position.getLanguage();
        while (!position.isAtEnd()) {
            if (currLanguage == Language.ANY || currLanguage == null) {
                currLanguage = position.getLanguage();
            }
            if (!ignoreLabels && this.isColonAfterLabelOrCase(position)) {
                SemanticEditorPosition afterColon = this.getPosition(position.getEditor(), position.getStartOffset()).afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.BlockComment).after().afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment);
                return afterColon.getStartOffset();
            }
            if (position.isAt(JavaLikeElement.RightParenthesis)) {
                position.moveBeforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                continue;
            }
            if (position.isAt(JavaLikeElement.BlockClosingBrace)) {
                position.moveBeforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                continue;
            }
            if (position.isAt(JavaLikeElement.ArrayClosingBracket)) {
                position.moveBeforeParentheses(JavaLikeElement.ArrayOpeningBracket, JavaLikeElement.ArrayClosingBracket);
                continue;
            }
            if (this.isStartOfStatementWithOptionalBlock(position)) {
                return useParentControlStructures ? this.getFirstUppermostControlStructureKeywordOffset(position) : position.getStartOffset();
            }
            if (position.isAtAnyOf(JavaLikeElement.Semicolon, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockComment, JavaLikeElement.DocBlockEnd, JavaLikeElement.LeftParenthesis, JavaLikeElement.LanguageStartDelimiter) || position.getLanguage() != Language.ANY && !position.isAtLanguage(currLanguage)) {
                SemanticEditorPosition statementStart = position.copy();
                if (!this.isIndentProvider(statementStart = statementStart.after().afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment), ignoreLabels)) {
                    SemanticEditorPosition afterColonStatement;
                    SemanticEditorPosition maybeColon = statementStart.afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.BlockComment).after();
                    if (JavaLikeLangLineIndentProvider.atColonWithNewLineAfterColonStatement(maybeColon, afterColonStatement = maybeColon.after().after())) {
                        return afterColonStatement.getStartOffset();
                    }
                    if (JavaLikeLangLineIndentProvider.atBlockStartAndNeedBlockIndent(position)) {
                        return position.getStartOffset();
                    }
                } else if (!statementStart.isAtEnd()) {
                    return statementStart.getStartOffset();
                }
            }
            position.moveBefore();
        }
        return 0;
    }

    protected boolean isStartOfStatementWithOptionalBlock(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(14);
        }
        return position.matchesRule(self -> {
            SemanticEditorPosition before2 = self.before();
            return before2.isAt(JavaLikeElement.Whitespace) && before2.isAtMultiline() && self.isAtAnyOf(JavaLikeElement.ElseKeyword, JavaLikeElement.IfKeyword, JavaLikeElement.ForKeyword, JavaLikeElement.TryKeyword, JavaLikeElement.DoKeyword);
        });
    }

    private static boolean atBlockStartAndNeedBlockIndent(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(15);
        }
        return position.isAt(JavaLikeElement.BlockOpeningBrace);
    }

    private static boolean atColonWithNewLineAfterColonStatement(@NotNull SemanticEditorPosition maybeColon, @NotNull SemanticEditorPosition afterColonStatement) {
        if (maybeColon == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(16);
        }
        if (afterColonStatement == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(17);
        }
        return maybeColon.isAt(JavaLikeElement.Colon) && maybeColon.after().isAtMultiline(JavaLikeElement.Whitespace) && !afterColonStatement.isAtEnd();
    }

    private int getFirstUppermostControlStructureKeywordOffset(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(18);
        }
        SemanticEditorPosition curr = position.copy();
        while (!curr.isAtEnd()) {
            if (this.isStartOfStatementWithOptionalBlock(curr)) {
                SemanticEditorPosition candidate = curr.copy();
                curr.moveBefore();
                curr.moveBeforeOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment, JavaLikeElement.BlockComment);
                if (curr.isAt(JavaLikeElement.RightParenthesis)) {
                    curr.moveBeforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                    SemanticEditorPosition controlStructureCheck = curr.copy();
                    controlStructureCheck.moveBeforeOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment, JavaLikeElement.BlockComment);
                    if (this.isStartOfStatementWithOptionalBlock(controlStructureCheck)) continue;
                }
                return candidate.getStartOffset();
            }
            if (curr.isAt(JavaLikeElement.BlockClosingBrace)) {
                curr.moveBeforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                continue;
            }
            curr.moveBefore();
        }
        return position.before().getStartOffset();
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition statementStartPosition, boolean ignoreLabels) {
        if (statementStartPosition == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(19);
        }
        return true;
    }

    public SemanticEditorPosition getPosition(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(20);
        }
        return SemanticEditorPosition.createEditorPosition(editor2, offset, (_editor, _offset) -> this.getIteratorAtPosition((Editor)_editor, (int)_offset), tokenType -> this.mapType((IElementType)tokenType));
    }

    @NotNull
    protected HighlighterIterator getIteratorAtPosition(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(21);
        }
        HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(offset);
        if (highlighterIterator == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(22);
        }
        return highlighterIterator;
    }

    @Nullable
    protected abstract SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType var1);

    @Nullable
    protected Indent getIndentInBlock(@NotNull Project project2, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        if (project2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(23);
        }
        if (blockStartPosition == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(24);
        }
        if (language != null) {
            CommonCodeStyleSettings settings = CodeStyle.getSettings((Editor)blockStartPosition.getEditor()).getCommonSettings(language);
            if (settings.BRACE_STYLE == 3) {
                return JavaLikeLangLineIndentProvider.getDefaultIndentFromType((Indent.Type)(settings.METHOD_BRACE_STYLE == 3 ? Indent.Type.NONE : null));
            }
        }
        return JavaLikeLangLineIndentProvider.getDefaultIndentFromType(Indent.Type.NORMAL);
    }

    @Contract(value="_, null -> null")
    private static Indent.Type getBlockIndentType(@NotNull Editor editor2, @Nullable Language language) {
        if (editor2 == null) {
            JavaLikeLangLineIndentProvider.$$$reportNull$$$0(25);
        }
        if (language != null) {
            CommonCodeStyleSettings settings = CodeStyle.getSettings((Editor)editor2).getCommonSettings(language);
            if (settings.BRACE_STYLE == 2 || settings.BRACE_STYLE == 1) {
                return Indent.Type.NONE;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    protected static Indent getDefaultIndentFromType(@Nullable Indent.Type type) {
        return type == null ? null : Indent.getIndent((Indent.Type)type, (int)0, (boolean)false, (boolean)false);
    }

    @Contract(value="null -> false")
    public final boolean isSuitableFor(@Nullable Language language) {
        return language != null && this.isSuitableForLanguage(language);
    }

    public abstract boolean isSuitableForLanguage(@NotNull Language var1);

    protected Indent.Type getIndentTypeInBrackets() {
        return Indent.Type.CONTINUATION;
    }

    protected Indent getIndentInBrackets() {
        return JavaLikeLangLineIndentProvider.getDefaultIndentFromType(this.getIndentTypeInBrackets());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementBeforeSemicolon";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeColon";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterColonStatement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementStartPosition";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStartPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorAtPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAtBlockOpeningOnSameLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "afterOptionalWhitespaceOnSameLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInArray";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dropIndentAfterReturnLike";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isColonAfterLabelOrCase";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBlockStatementStartOffset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveBeforeEndLineComments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDeepBlockStatementStartOffset";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStatementStartOffset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isStartOfStatementWithOptionalBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "atBlockStartAndNeedBlockIndent";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "atColonWithNewLineAfterColonStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFirstUppermostControlStructureKeywordOffset";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isIndentProvider";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPosition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorAtPosition";
                break;
            }
            case 22: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInBlock";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBlockIndentType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IndentCalculatorFactory {
        private final Project myProject;
        private final Editor myEditor;

        public IndentCalculatorFactory(Project project2, Editor editor2) {
            this.myProject = project2;
            this.myEditor = editor2;
        }

        @Nullable
        public IndentCalculator createIndentCalculator(@Nullable Indent.Type indentType, @Nullable IndentCalculator.BaseLineOffsetCalculator baseLineOffsetCalculator) {
            return this.createIndentCalculator(JavaLikeLangLineIndentProvider.getDefaultIndentFromType(indentType), baseLineOffsetCalculator);
        }

        @Nullable
        public IndentCalculator createIndentCalculator(@Nullable Indent indent, @Nullable IndentCalculator.BaseLineOffsetCalculator baseLineOffsetCalculator) {
            return indent != null ? new IndentCalculator(this.myProject, this.myEditor, baseLineOffsetCalculator != null ? baseLineOffsetCalculator : IndentCalculator.LINE_BEFORE, indent) : null;
        }
    }

    public static enum JavaLikeElement implements SemanticEditorPosition.SyntaxElement
    {
        Whitespace,
        Semicolon,
        BlockOpeningBrace,
        BlockClosingBrace,
        ArrayOpeningBracket,
        ArrayClosingBracket,
        RightParenthesis,
        LeftParenthesis,
        Colon,
        SwitchCase,
        SwitchDefault,
        ElseKeyword,
        IfKeyword,
        ForKeyword,
        TryKeyword,
        DoKeyword,
        BlockComment,
        DocBlockStart,
        DocBlockEnd,
        LineComment,
        Comma,
        LanguageStartDelimiter;

    }
}

