/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class JpsFileTargetContextUtils {
    private JpsFileTargetContextUtils() {
    }

    @NotNull
    public static Collection<FileTargetContext> prepareTargetContexts(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull Collection<FileTargetContext> targetContexts) {
        if (project2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(1);
        }
        if (targetContexts == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(2);
        }
        if (targetContexts.size() <= 1) {
            Collection<FileTargetContext> collection = targetContexts;
            if (collection == null) {
                JpsFileTargetContextUtils.$$$reportNull$$$0(3);
            }
            return collection;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
        boolean isInSources = projectFileIndex.isInSourceContent(file2) && !projectFileIndex.isInTestSourceContent(file2);
        List<FileTargetContextWrapper> targetContextWrappers = ContainerUtil.filter(JpsFileTargetContextUtils.findSourceRootTypes(targetContexts), tc -> {
            if (isInSources && tc.getSourceRootType() != null && tc.getSourceRootType().isForTests()) {
                return false;
            }
            if (tc.getJpsModuleSourceRoot() == null) {
                return true;
            }
            JavaSourceRootProperties srcProperties = (JavaSourceRootProperties)tc.getJpsModuleSourceRoot().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (srcProperties == null) {
                return true;
            }
            return !srcProperties.isForGeneratedSources();
        });
        if (JpsFileTargetContextUtils.hasEqualSourceRootTypes(targetContextWrappers)) {
            Collection<FileTargetContext> collection = targetContexts;
            if (collection == null) {
                JpsFileTargetContextUtils.$$$reportNull$$$0(4);
            }
            return collection;
        }
        if (projectFileIndex.isInTestSourceContent(file2)) {
            targetContextWrappers.sort(JpsFileTargetContextUtils::compareTargetsForTests);
        } else {
            targetContextWrappers.sort(JpsFileTargetContextUtils::compareTargetsForProduction);
        }
        List<FileTargetContext> list2 = ContainerUtil.map(targetContextWrappers, FileTargetContextWrapper::getTargetContext);
        if (list2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static boolean hasEqualSourceRootTypes(@NotNull List<FileTargetContextWrapper> wrappers) {
        if (wrappers == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(6);
        }
        if (wrappers.size() <= 1) {
            return true;
        }
        JpsModuleSourceRootType<?> sourceRootType = null;
        for (FileTargetContextWrapper item : wrappers) {
            JpsModuleSourceRootType<?> itemSourceRootType = item.getSourceRootType();
            if (sourceRootType == null) {
                if (itemSourceRootType == null) continue;
                sourceRootType = itemSourceRootType;
                continue;
            }
            if (sourceRootType == itemSourceRootType) continue;
            return false;
        }
        return true;
    }

    private static List<FileTargetContextWrapper> findSourceRootTypes(Collection<FileTargetContext> targetContexts) {
        return ContainerUtil.map(targetContexts, c -> {
            Project project2 = c.getFileSystemItem().getProject();
            SourceFolder sourceFolder = null;
            VirtualFile file2 = c.getFileSystemItem().getVirtualFile();
            if (file2 != null) {
                sourceFolder = JpsFileTargetContextUtils.getSourceFolder(project2, file2);
            }
            return new FileTargetContextWrapper((FileTargetContext)c, sourceFolder);
        });
    }

    @Nullable
    private static SourceFolder getSourceFolder(@NotNull Project project2, @NotNull VirtualFile directory) {
        if (project2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(7);
        }
        if (directory == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(8);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project2);
        return projectFileIndex.getSourceFolder(directory);
    }

    private static int compareTargetsForTests(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        if (d1 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(9);
        }
        if (d2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(10);
        }
        int o1 = JpsFileTargetContextUtils.getTestsTargetOrdinal(d1);
        int o2 = JpsFileTargetContextUtils.getTestsTargetOrdinal(d2);
        if (o1 > 0 || o2 > 0) {
            return Integer.compare(o1, o2);
        }
        return JpsFileTargetContextUtils.compareDirectoryPaths(d1, d2);
    }

    private static int compareTargetsForProduction(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        if (d1 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(11);
        }
        if (d2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(12);
        }
        int o1 = JpsFileTargetContextUtils.getSourcesTargetOrdinal(d1);
        int o2 = JpsFileTargetContextUtils.getSourcesTargetOrdinal(d2);
        if (o1 > 0 || o2 > 0) {
            return Integer.compare(o1, o2);
        }
        return JpsFileTargetContextUtils.compareDirectoryPaths(d1, d2);
    }

    private static int getTestsTargetOrdinal(@NotNull FileTargetContextWrapper item) {
        JpsModuleSourceRootType<?> type;
        if (item == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(13);
        }
        if (JpsFileTargetContextUtils.isSourceItem(type = item.getSourceRootType())) {
            return 4;
        }
        if (JpsFileTargetContextUtils.isTestSourceItem(type)) {
            return 3;
        }
        if (JpsFileTargetContextUtils.isResourceItem(type)) {
            return 2;
        }
        if (JpsFileTargetContextUtils.isTestResourceItem(type)) {
            return 1;
        }
        return 0;
    }

    private static int getSourcesTargetOrdinal(@NotNull FileTargetContextWrapper item) {
        JpsModuleSourceRootType<?> type;
        if (item == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(14);
        }
        if (JpsFileTargetContextUtils.isTestSourceItem(type = item.getSourceRootType())) {
            return 4;
        }
        if (JpsFileTargetContextUtils.isSourceItem(type)) {
            return 3;
        }
        if (JpsFileTargetContextUtils.isTestResourceItem(type)) {
            return 2;
        }
        if (JpsFileTargetContextUtils.isResourceItem(type)) {
            return 1;
        }
        return 0;
    }

    private static int compareDirectoryPaths(@NotNull FileTargetContextWrapper d1, @NotNull FileTargetContextWrapper d2) {
        if (d1 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(15);
        }
        if (d2 == null) {
            JpsFileTargetContextUtils.$$$reportNull$$$0(16);
        }
        PsiFileSystemItem directory1 = d1.getTargetContext().getFileSystemItem();
        PsiFileSystemItem directory2 = d2.getTargetContext().getFileSystemItem();
        assert (directory1 != null) : "Invalid PsiFileSystemItem instances found";
        assert (directory2 != null) : "Invalid PsiFileSystemItem instances found";
        VirtualFile f1 = directory1.getVirtualFile();
        VirtualFile f2 = directory2.getVirtualFile();
        return f1.getPath().compareTo(f2.getPath());
    }

    private static boolean isTestResourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaResourceRootType.TEST_RESOURCE;
    }

    private static boolean isResourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaResourceRootType.RESOURCE;
    }

    private static boolean isTestSourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaSourceRootType.TEST_SOURCE;
    }

    private static boolean isSourceItem(@Nullable JpsModuleSourceRootType<?> type) {
        return type == JavaSourceRootType.SOURCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContexts";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JpsFileTargetContextUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d1";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d2";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JpsFileTargetContextUtils";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTargetContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetContexts";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasEqualSourceRootTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareTargetsForTests";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareTargetsForProduction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTestsTargetOrdinal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesTargetOrdinal";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compareDirectoryPaths";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FileTargetContextWrapper {
        private final FileTargetContext myTargetContext;
        private final SourceFolder mySourceFolder;

        private FileTargetContextWrapper(FileTargetContext context2, @Nullable SourceFolder sourceFolder) {
            this.myTargetContext = context2;
            this.mySourceFolder = sourceFolder;
        }

        public FileTargetContext getTargetContext() {
            return this.myTargetContext;
        }

        @Nullable
        public JpsModuleSourceRootType<?> getSourceRootType() {
            return this.mySourceFolder != null ? this.mySourceFolder.getRootType() : null;
        }

        public JpsModuleSourceRoot getJpsModuleSourceRoot() {
            return this.mySourceFolder != null ? this.mySourceFolder.getJpsElement() : null;
        }
    }
}

