/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePatternPackageSet
extends PatternBasedPackageSet {
    private static final Logger LOG = Logger.getInstance(FilePatternPackageSet.class);
    @NonNls
    public static final String SCOPE_FILE = "file";
    @NonNls
    public static final String SCOPE_EXT = "ext";
    private final String myPathPattern;
    private final Pattern myFilePattern;
    private final boolean myProjectFiles;

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern) {
        this(modulePattern, filePattern, true);
    }

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern, boolean projectFiles) {
        super(modulePattern);
        this.myPathPattern = filePattern;
        this.myFilePattern = filePattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(filePattern, '/')) : null;
        this.myProjectFiles = projectFiles;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2, @NotNull Project project2, @Nullable NamedScopesHolder holder) {
        ProjectFileIndex fileIndex;
        if (file2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(1);
        }
        return this.fileMatcher(file2, fileIndex = ProjectRootManager.getInstance(project2).getFileIndex(), holder != null ? holder.getProjectBaseDir() : project2.getBaseDir()) && (this.myProjectFiles ? this.matchesModule(file2, fileIndex) : FilePatternPackageSet.matchesLibrary(this.myModulePattern, file2, fileIndex));
    }

    private boolean fileMatcher(@NotNull VirtualFile virtualFile2, ProjectFileIndex fileIndex, VirtualFile projectBaseDir) {
        if (virtualFile2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(2);
        }
        if (virtualFile2 instanceof VirtualFileWindow) {
            virtualFile2 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
        }
        if (fileIndex.isInContent(virtualFile2) != this.myProjectFiles) {
            return false;
        }
        Object relativePath = FilePatternPackageSet.getRelativePath(virtualFile2, fileIndex, true, projectBaseDir);
        if (relativePath == null) {
            LOG.error("vFile: " + virtualFile2 + "; projectBaseDir: " + projectBaseDir + "; content File: " + fileIndex.getContentRootForFile(virtualFile2));
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath) && !virtualFile2.equals(projectBaseDir)) {
            return false;
        }
        if (virtualFile2.isDirectory()) {
            relativePath = (String)relativePath + "/";
        }
        return this.myFilePattern.matcher((CharSequence)relativePath).matches();
    }

    static String convertToRegexp(String aspectsntx, char separator) {
        StringBuilder buf = new StringBuilder(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\").append(separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\").append(separator).append("]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\").append(separator).append("(.*\\").append(separator).append(")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            if (curChar == '.') {
                buf.append("\\");
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\").append(separator).append("]*");
        }
        return buf.toString();
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        return new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern);
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getText() {
        @NonNls StringBuilder buf = new StringBuilder(this.myProjectFiles ? SCOPE_FILE : SCOPE_EXT);
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myPathPattern);
        String string2 = buf.toString();
        if (string2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public String getPattern() {
        return this.myPathPattern;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual(this.myPathPattern, oldQName) || Comparing.strEqual(oldQName + "//*", this.myPathPattern) || Comparing.strEqual(oldQName + "/*", this.myPathPattern);
    }

    @Override
    @NotNull
    public PatternBasedPackageSet updatePattern(@NotNull String oldName, @NotNull String newName2) {
        if (oldName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(4);
        }
        if (newName2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(5);
        }
        return new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern.replace(oldName, newName2), this.myProjectFiles);
    }

    @Override
    @NotNull
    public PatternBasedPackageSet updateModulePattern(@NotNull String oldName, @NotNull String newName2) {
        if (oldName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(6);
        }
        if (newName2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(7);
        }
        return new FilePatternPackageSet(this.myModulePatternText.replace(oldName, newName2), this.myPathPattern, this.myProjectFiles);
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile virtualFile2, @NotNull ProjectFileIndex index, boolean useFQName, VirtualFile projectBaseDir) {
        VirtualFile contentRootForFile;
        if (virtualFile2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(8);
        }
        if (index == null) {
            FilePatternPackageSet.$$$reportNull$$$0(9);
        }
        if ((contentRootForFile = index.getContentRootForFile(virtualFile2)) != null) {
            String relativePath = VfsUtilCore.getRelativePath(virtualFile2, contentRootForFile, '/');
            if (relativePath != null) {
                return relativePath;
            }
            if (!virtualFile2.getFileSystem().equals(contentRootForFile.getFileSystem())) {
                String relativeToParent;
                VirtualFile parent = virtualFile2.getParent();
                String string2 = relativeToParent = parent != null ? VfsUtilCore.getRelativePath(parent, contentRootForFile, '/') : null;
                if (relativeToParent != null) {
                    return relativeToParent + "/" + virtualFile2.getName();
                }
            }
            return null;
        }
        Module module = index.getModuleForFile(virtualFile2);
        if (module != null) {
            if (projectBaseDir != null && VfsUtilCore.isAncestor(projectBaseDir, virtualFile2, false)) {
                String projectRelativePath = VfsUtilCore.getRelativePath(virtualFile2, projectBaseDir, '/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile2.getPath();
        }
        return FilePatternPackageSet.getLibRelativePath(virtualFile2, index);
    }

    public static String getLibRelativePath(VirtualFile virtualFile2, ProjectFileIndex index) {
        ArrayList<String> path2 = new ArrayList<String>();
        for (VirtualFile directory = virtualFile2; directory != null && index.isInLibrary(directory); directory = directory.getParent()) {
            path2.add(directory.getName());
        }
        if (path2.isEmpty()) {
            return "";
        }
        Collections.reverse(path2);
        return StringUtil.join(ArrayUtilRt.toStringArray(path2), 1, path2.size(), "/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCOPE_FILE;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fileMatcher";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updatePattern";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateModulePattern";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

