/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.stubs.CompositeBinaryBuilderMap;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubCumulativeInputDiffBuilder;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTreeLoaderImpl;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.StaleIndexesChecker;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StubUpdatingIndexStorage
extends TransientFileContentIndex<Integer, SerializedStubTree, Data> {
    private static final Logger LOG = Logger.getInstance(StubUpdatingIndexStorage.class);
    private StubIndexImpl myStubIndex;
    @Nullable
    private final CompositeBinaryBuilderMap myCompositeBinaryBuilderMap;
    @NotNull
    private final SerializationManagerEx mySerializationManager;

    StubUpdatingIndexStorage(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension2, @NotNull VfsAwareIndexStorageLayout<Integer, SerializedStubTree> layout, @NotNull SerializationManagerEx serializationManager) throws IOException {
        if (extension2 == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(1);
        }
        if (serializationManager == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(2);
        }
        super(extension2, layout, null);
        this.myCompositeBinaryBuilderMap = FileBasedIndex.USE_IN_MEMORY_INDEX ? null : new CompositeBinaryBuilderMap();
        this.mySerializationManager = serializationManager;
    }

    @Override
    protected void doFlush() throws IOException, StorageException {
        StubIndexImpl stubIndex = this.getStubIndex();
        try {
            stubIndex.flush();
            this.mySerializationManager.flushNameStorage();
        }
        finally {
            super.doFlush();
        }
    }

    @NotNull
    private StubIndexImpl getStubIndex() {
        StubIndexImpl index = this.myStubIndex;
        if (index == null) {
            this.myStubIndex = index = (StubIndexImpl)StubIndex.getInstance();
        }
        StubIndexImpl stubIndexImpl = index;
        if (stubIndexImpl == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(3);
        }
        return stubIndexImpl;
    }

    @NotNull
    public Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable FileContent content2) throws MapReduceIndexMappingException, ProcessCanceledException {
        Computable indexUpdateComputable = super.mapInputAndPrepareUpdate(inputId, (Object)content2);
        IndexingStampInfo indexingStampInfo = content2 == null ? null : StubUpdatingIndex.calculateIndexingStamp((FileContent)content2);
        Computable<Boolean> computable = () -> {
            try {
                Boolean result2 = (Boolean)indexUpdateComputable.compute();
                if (Boolean.TRUE.equals(result2) && !StaleIndexesChecker.isStaleIdDeletion()) {
                    StubTreeLoaderImpl.saveIndexingStampInfo(indexingStampInfo, inputId);
                }
                return result2;
            }
            catch (ProcessCanceledException e) {
                LOG.error("ProcessCanceledException is not expected here", e);
                throw e;
            }
        };
        if (computable == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(4);
        }
        return computable;
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Integer, SerializedStubTree> diffBuilder) {
        if (diffBuilder == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(5);
        }
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> maps = StubUpdatingIndexStorage.getStubIndexMaps((StubCumulativeInputDiffBuilder)diffBuilder);
        if (FileBasedIndexEx.DO_TRACE_STUB_INDEX_UPDATE) {
            LOG.info("removing transient data for inputId = " + inputId + ", keys = " + ((StubCumulativeInputDiffBuilder)diffBuilder).getKeys() + ", data = " + maps);
        }
        super.removeTransientDataForKeys(inputId, diffBuilder);
        StubUpdatingIndexStorage.removeTransientStubIndexKeys(inputId, maps);
    }

    private static void removeTransientStubIndexKeys(int inputId, @NotNull Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs) {
        if (indexedStubs == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(6);
        }
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey<?, ?> key : indexedStubs.keySet()) {
            stubIndex.removeTransientDataForFile(key, inputId, indexedStubs.get(key));
        }
    }

    @NotNull
    private static Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> getStubIndexMaps(@NotNull StubCumulativeInputDiffBuilder diffBuilder) {
        SerializedStubTree tree;
        if (diffBuilder == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(7);
        }
        Map map2 = (tree = diffBuilder.getSerializedStubTree()) == null ? Collections.emptyMap() : tree.getStubIndicesValueMap();
        if (map2 == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @Override
    protected void doClear() throws StorageException, IOException {
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        if (stubIndex != null) {
            stubIndex.clearAllIndices();
        }
        super.doClear();
    }

    @Override
    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        finally {
            try {
                this.getStubIndex().dispose();
            }
            finally {
                this.mySerializationManager.performShutdown();
            }
        }
    }

    @Override
    public Data getFileIndexMetaData(@NotNull IndexedFile file2) {
        if (file2 == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(9);
        }
        Object data2 = super.getFileIndexMetaData(file2);
        FileType fileType = ProgressManager.getInstance().computeInNonCancelableSection(() -> file2.getFileType());
        return new Data(data2 == null ? -1 : ((VfsAwareMapReduceIndex.IndexerIdHolder)data2).indexerId, fileType);
    }

    @Override
    public void setIndexedStateForFileOnFileIndexMetaData(int fileId, @Nullable Data fileData) {
        super.setIndexedStateForFileOnFileIndexMetaData(fileId, fileData);
        LOG.assertTrue(fileData != null, "getFileIndexMetaData doesn't return null");
        this.setBinaryBuilderConfiguration(fileId, fileData);
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(10);
        }
        super.setIndexedStateForFile(fileId, file2);
        this.setBinaryBuilderConfiguration(fileId, file2);
    }

    @Override
    public void setUnindexedStateForFile(int fileId) {
        super.setUnindexedStateForFile(fileId);
        this.resetBinaryBuilderConfiguration(fileId);
    }

    @Override
    protected FileIndexingState isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(11);
        }
        if (this.myCompositeBinaryBuilderMap == null) {
            return FileIndexingState.UP_TO_DATE;
        }
        try {
            return this.myCompositeBinaryBuilderMap.isUpToDateState(fileId, file2.getFile());
        }
        catch (IOException e) {
            LOG.error(e);
            return FileIndexingState.OUT_DATED;
        }
    }

    @Override
    protected void setIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(12);
        }
        this.setBinaryBuilderConfiguration(fileId, file2);
    }

    private void setBinaryBuilderConfiguration(int fileId, @NotNull IndexedFile file2) {
        if (file2 == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(13);
        }
        if (this.myCompositeBinaryBuilderMap != null) {
            try {
                this.myCompositeBinaryBuilderMap.persistState(fileId, file2.getFile());
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private void setBinaryBuilderConfiguration(int fileId, @NotNull Data fileData) {
        if (fileData == null) {
            StubUpdatingIndexStorage.$$$reportNull$$$0(14);
        }
        if (this.myCompositeBinaryBuilderMap != null) {
            try {
                this.myCompositeBinaryBuilderMap.persistState(fileId, fileData.myFileType);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private void resetBinaryBuilderConfiguration(int fileId) {
        if (this.myCompositeBinaryBuilderMap != null) {
            try {
                this.myCompositeBinaryBuilderMap.resetPersistedState(fileId);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndexStorage";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedStubs";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndexStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndexMaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientStubIndexKeys";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStubIndexMaps";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileIndexMetaData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIndexConfigurationUpToDate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setIndexConfigurationUpToDate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryBuilderConfiguration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class Data
    extends VfsAwareMapReduceIndex.IndexerIdHolder {
        private final FileType myFileType;

        Data(int indexerId, FileType type) {
            super(indexerId);
            this.myFileType = type;
        }
    }
}

