/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TemplateDataLanguagePatterns", storages={@Storage(value="templateLanguages.xml")}, category=SettingsCategory.CODE)
public final class TemplateDataLanguagePatterns
implements PersistentStateComponent<Element> {
    private FileTypeAssocTable<Language> myAssocTable = new FileTypeAssocTable();
    @NonNls
    private static final String SEPARATOR = ";";

    public static TemplateDataLanguagePatterns getInstance() {
        return ApplicationManager.getApplication().getService(TemplateDataLanguagePatterns.class);
    }

    public FileTypeAssocTable<Language> getAssocTable() {
        return this.myAssocTable.copy();
    }

    @Nullable
    public Language getTemplateDataLanguageByFileName(VirtualFile file2) {
        return (Language)this.myAssocTable.findAssociatedFileType((CharSequence)file2.getName());
    }

    public void setAssocTable(FileTypeAssocTable<Language> assocTable) {
        this.myAssocTable = assocTable.copy();
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            TemplateDataLanguagePatterns.$$$reportNull$$$0(0);
        }
        this.myAssocTable = new FileTypeAssocTable();
        HashMap<String, Language> dialectMap = new HashMap<String, Language>();
        for (Language dialect : TemplateDataLanguageMappings.getTemplateableLanguages()) {
            dialectMap.put(dialect.getID(), dialect);
        }
        List<Element> files2 = state.getChildren("pattern");
        for (Element fileElement : files2) {
            String patterns = fileElement.getAttributeValue("value");
            String langId = fileElement.getAttributeValue("lang");
            Language dialect = (Language)dialectMap.get(langId);
            if (dialect == null || StringUtil.isEmpty(patterns)) continue;
            for (String pattern : patterns.split(SEPARATOR)) {
                this.myAssocTable.addAssociation(FileTypeManager.parseFromString((String)pattern), (Object)dialect);
            }
        }
    }

    @Override
    public Element getState() {
        Element state = new Element("x");
        for (Language language : TemplateDataLanguageMappings.getTemplateableLanguages()) {
            List matchers = this.myAssocTable.getAssociations((Object)language);
            if (matchers.isEmpty()) continue;
            Element child = new Element("pattern");
            state.addContent(child);
            child.setAttribute("value", StringUtil.join(matchers, fileNameMatcher -> fileNameMatcher.getPresentableString(), SEPARATOR));
            child.setAttribute("lang", language.getID());
        }
        return state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/templateLanguages/TemplateDataLanguagePatterns", "loadState"));
    }
}

