/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class SameSourceRootWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<VirtualFile, ProximityLocation> SOURCE_ROOT_KEY = NullableLazyKey.create("sourceRoot", proximityLocation -> SameSourceRootWeigher.findSourceRoot(proximityLocation.getPosition()));

    @Override
    public Comparable weigh(@NotNull PsiElement element2, @NotNull ProximityLocation location) {
        if (element2 == null) {
            SameSourceRootWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            SameSourceRootWeigher.$$$reportNull$$$0(1);
        }
        if (location.getPosition() == null) {
            return null;
        }
        VirtualFile sourceRoot = SOURCE_ROOT_KEY.getValue(location);
        if (sourceRoot == null) {
            return Boolean.valueOf(false);
        }
        return Boolean.valueOf(sourceRoot.equals(SameSourceRootWeigher.findSourceRoot(element2)));
    }

    private static VirtualFile findSourceRoot(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file2 = psiFile.getOriginalFile().getVirtualFile();
        if (file2 == null) {
            return null;
        }
        return ProjectFileIndex.getInstance(element2.getProject()).getSourceRootForFile(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/SameSourceRootWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

