/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.CommonBundle;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyFilesOrDirectoriesDialog
extends RefactoringDialog
implements DumbAware {
    public static final int MAX_PATH_LENGTH = 70;
    @NonNls
    private static final String COPY = "Copy";
    @NonNls
    private static final String COPY_OPEN_IN_EDITOR = "Copy.OpenInEditor";
    @NonNls
    private static final String RECENT_KEYS = "CopyFile.RECENT_KEYS";
    private JLabel myInformationLabel;
    private TextFieldWithHistoryWithBrowseButton myTargetDirectoryField;
    private boolean myUnknownFileType = false;
    private EditorTextField myNewNameField;
    private final PsiElement[] myElements;
    private final boolean myShowDirectoryField;
    private final boolean myShowNewNameField;
    private PsiDirectory myTargetDirectory;
    private final boolean myFileCopy;

    public static String shortenPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CopyFilesOrDirectoriesDialog.$$$reportNull$$$0(0);
        }
        return StringUtil.shortenPathWithEllipsis(file2.getPresentableUrl(), 70);
    }

    @Deprecated(forRemoval=true)
    public static JCheckBox createOpenInEditorCB() {
        JCheckBox checkBox = new JCheckBox(RefactoringBundle.message((String)"open.copy.in.editor"), PropertiesComponent.getInstance().getBoolean(COPY_OPEN_IN_EDITOR, true));
        return checkBox;
    }

    @Deprecated(forRemoval=true)
    public static void saveOpenInEditorState(boolean selected) {
        PropertiesComponent.getInstance().setValue(COPY_OPEN_IN_EDITOR, String.valueOf(selected));
    }

    public CopyFilesOrDirectoriesDialog(PsiElement[] elements, @Nullable PsiDirectory defaultTargetDirectory, Project project2, boolean doClone) {
        super(project2, true, CopyFilesOrDirectoriesDialog.canBeOpenedInEditor(elements));
        this.myElements = elements;
        this.myShowDirectoryField = !doClone;
        this.myShowNewNameField = elements.length == 1;
        boolean bl = this.myFileCopy = elements.length == 1 && elements[0] instanceof PsiFile;
        if (doClone && elements.length != 1) {
            throw new IllegalArgumentException("wrong number of elements to clone: " + elements.length);
        }
        this.setTitle(RefactoringBundle.message((String)(doClone ? "copy.files.clone.title" : "copy.files.copy.title")));
        this.init();
        for (int i = 0; i < elements.length; ++i) {
            if (!(elements[i] instanceof PsiFile)) continue;
            elements[i] = ((PsiFile)elements[i]).getOriginalFile();
        }
        if (elements.length == 1) {
            String text2;
            if (elements[0] instanceof PsiFile) {
                String fileName;
                PsiFile file2 = (PsiFile)elements[0];
                VirtualFile vFile = file2.getVirtualFile();
                text2 = RefactoringBundle.message((String)(doClone ? "copy.files.clone.file.0" : "copy.files.copy.file.0"), (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(vFile)});
                String string2 = fileName = vFile.isInLocalFileSystem() ? vFile.getName() : PathUtil.suggestFileName(file2.getName(), true, true);
                if (StringUtil.isEmpty(vFile.getExtension()) && ScratchUtil.isScratch(vFile)) {
                    FileType type = ObjectUtils.notNull(file2.getLanguage().getAssociatedFileType(), file2.getFileType());
                    fileName = PathUtil.makeFileName(fileName, type.getDefaultExtension());
                }
                this.myNewNameField.setText(fileName);
                int dotIdx = fileName.lastIndexOf(46);
                if (dotIdx > 0) {
                    this.selectNameWithoutExtension(dotIdx);
                }
                this.myTargetDirectory = file2.getContainingDirectory();
            } else {
                VirtualFile vFile = ((PsiDirectory)elements[0]).getVirtualFile();
                text2 = RefactoringBundle.message((String)(doClone ? "copy.files.clone.directory.0" : "copy.files.copy.directory.0"), (Object[])new Object[]{CopyFilesOrDirectoriesDialog.shortenPath(vFile)});
                this.myNewNameField.setText(vFile.getName());
            }
            this.myInformationLabel.setText(text2);
        } else {
            this.setMultipleElementCopyLabel(elements);
        }
        if (this.myShowDirectoryField) {
            String targetPath = defaultTargetDirectory == null ? "" : defaultTargetDirectory.getVirtualFile().getPresentableUrl();
            this.getTargetDirectoryComponent().setText(targetPath);
        }
        this.validateButtons();
        this.setRefactorButtonText(CommonBundle.getOkButtonText());
    }

    private static boolean canBeOpenedInEditor(PsiElement[] elements) {
        for (PsiElement element2 : elements) {
            if (element2.getContainingFile() instanceof PsiBinaryFile) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isOpenInEditorEnabledByDefault() {
        return this.myFileCopy;
    }

    private void selectNameWithoutExtension(int dotIdx) {
        Runnable selectRunnable = () -> {
            Editor editor2 = this.myNewNameField.getEditor();
            if (editor2 != null) {
                editor2.getSelectionModel().setSelection(0, dotIdx);
                editor2.getCaretModel().moveToOffset(dotIdx);
            } else {
                this.myNewNameField.selectAll();
            }
        };
        SwingUtilities.invokeLater(selectRunnable);
    }

    private void setMultipleElementCopyLabel(PsiElement[] elements) {
        boolean allFiles = true;
        boolean allDirectories = true;
        for (PsiElement element2 : elements) {
            if (element2 instanceof PsiDirectory) {
                allFiles = false;
                continue;
            }
            allDirectories = false;
        }
        if (allFiles) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.files.label"));
        } else if (allDirectories) {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.directories.label"));
        } else {
            this.myInformationLabel.setText(RefactoringBundle.message((String)"copy.files.copy.specified.mixed.label"));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myShowNewNameField ? this.myNewNameField : this.getTargetDirectoryComponent();
    }

    protected TextFieldWithHistory getTargetDirectoryComponent() {
        return (TextFieldWithHistory)this.myTargetDirectoryField.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        this.myInformationLabel = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.myInformationLabel).addVerticalGap(8);
        if (this.myShowNewNameField) {
            this.myNewNameField = new EditorTextField();
            this.myNewNameField.addDocumentListener(new DocumentListener(){

                @Override
                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CopyFilesOrDirectoriesDialog.this.validateButtons();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesDialog$1", "documentChanged"));
                }
            });
            formBuilder.addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)this.myNewNameField);
        }
        if (this.myShowDirectoryField) {
            this.myTargetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
            this.myTargetDirectoryField.setTextFieldPreferredWidth(70);
            List recentEntries = RecentsManager.getInstance((Project)this.myProject).getRecentEntries(RECENT_KEYS);
            if (recentEntries != null) {
                this.getTargetDirectoryComponent().setHistory(recentEntries);
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"the.file.will.be.copied.to.this.directory"), this.myProject, descriptor, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
            this.getTargetDirectoryComponent().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                @Override
                protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CopyFilesOrDirectoriesDialog.this.validateButtons();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesDialog$2", "textChanged"));
                }
            });
            formBuilder.addLabeledComponent(RefactoringBundle.message((String)"copy.files.to.directory.label"), (JComponent)this.myTargetDirectoryField);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            formBuilder.addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText}));
        }
        return formBuilder.getPanel();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getNewName() {
        return this.myNewNameField != null ? this.myNewNameField.getText().trim() : null;
    }

    @Deprecated
    public boolean openInEditor() {
        return this.isOpenInEditor();
    }

    @Override
    public boolean isOpenInEditor() {
        return !this.myUnknownFileType && super.isOpenInEditor();
    }

    @Override
    protected void doAction() {
        if (this.myShowNewNameField) {
            String newName2 = this.getNewName();
            if (newName2.length() == 0) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.new.name.specified"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            if (this.myFileCopy && !PathUtilRt.isValidFileName(newName2, false)) {
                Messages.showErrorDialog((Component)this.myNewNameField, (String)RefactoringBundle.message((String)"name.is.not.a.valid.file.name"));
                return;
            }
            if (this.myFileCopy && this.myTargetDirectory != null && this.isOpenInEditor() && FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)this.myTargetDirectory.getVirtualFile(), (String)newName2, (Project)this.myProject) == null) {
                this.myUnknownFileType = true;
            }
        }
        if (this.myShowDirectoryField) {
            String targetDirectoryName = this.getTargetDirectoryComponent().getText();
            if (targetDirectoryName.length() == 0) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"no.target.directory.specified"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_KEYS, targetDirectoryName);
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    String path2 = FileUtil.toSystemIndependentName(targetDirectoryName);
                    this.myTargetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance(this.myProject), path2);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }), RefactoringBundle.message((String)"create.directory"), null);
            if (this.myTargetDirectory == null) {
                Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
            FileChooserUtil.setLastOpenedFile((Project)this.myProject, (Path)this.myTargetDirectory.getVirtualFile().toNioPath());
            try {
                for (PsiElement element2 : this.myElements) {
                    MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf(element2, this.myTargetDirectory);
                }
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)RefactoringBundle.message((String)"error.title"));
                return;
            }
        }
        this.closeOKAction();
    }

    @Override
    protected boolean hasPreviewButton() {
        return false;
    }

    @Override
    protected boolean areButtonsValid() {
        String newName2;
        if (this.myShowDirectoryField && this.getTargetDirectoryComponent().getText().length() == 0) {
            return false;
        }
        return !this.myShowNewNameField || (newName2 = this.getNewName()).length() != 0 && (!this.myFileCopy || PathUtilRt.isValidFileName(newName2, false));
    }

    @Override
    @NotNull
    protected String getRefactoringId() {
        return COPY;
    }

    protected String getHelpId() {
        return "refactoring.copyClass";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/copy/CopyFilesOrDirectoriesDialog", "shortenPath"));
    }
}

