/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.inline.InlineOptions;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Query;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InlineOptionsDialog
extends RefactoringDialog
implements InlineOptions {
    protected JRadioButton myRbInlineAll;
    @Nullable
    protected JRadioButton myKeepTheDeclaration;
    protected JRadioButton myRbInlineThisOnly;
    protected boolean myInvokedOnReference;
    protected final PsiElement myElement;
    private final JLabel myNameLabel = new JLabel();

    protected InlineOptionsDialog(Project project2, boolean canBeParent, PsiElement element2) {
        super(project2, canBeParent);
        this.myElement = element2;
    }

    protected JComponent createNorthPanel() {
        this.myNameLabel.setText(this.getNameLabelText());
        return this.myNameLabel;
    }

    @Override
    public boolean isInlineThisOnly() {
        return this.myRbInlineThisOnly.isSelected();
    }

    @Override
    public boolean isKeepTheDeclaration() {
        if (this.myKeepTheDeclaration != null) {
            return this.myKeepTheDeclaration.isSelected();
        }
        return false;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JRadioButton[] buttons;
        JRadioButton[] jRadioButtonArray;
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(new EmptyBorder(JBUIScale.scale(10), 0, 0, 0));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        this.myRbInlineAll = new JRadioButton();
        this.myRbInlineAll.setText(this.getInlineAllText());
        this.myRbInlineAll.setSelected(true);
        this.myRbInlineThisOnly = new JRadioButton();
        this.myRbInlineThisOnly.setText(this.getInlineThisText());
        boolean writable = this.allowInlineAll();
        optionsPanel.add(this.myRbInlineAll);
        String keepDeclarationText = this.getKeepTheDeclarationText();
        if (keepDeclarationText != null && writable) {
            this.myKeepTheDeclaration = new JRadioButton();
            this.myKeepTheDeclaration.setText(keepDeclarationText);
            optionsPanel.add(this.myKeepTheDeclaration);
        }
        optionsPanel.add(this.myRbInlineThisOnly);
        ButtonGroup bg = new ButtonGroup();
        if (this.myKeepTheDeclaration != null) {
            JRadioButton[] jRadioButtonArray2 = new JRadioButton[3];
            jRadioButtonArray2[0] = this.myRbInlineAll;
            jRadioButtonArray2[1] = this.myKeepTheDeclaration;
            jRadioButtonArray = jRadioButtonArray2;
            jRadioButtonArray2[2] = this.myRbInlineThisOnly;
        } else {
            JRadioButton[] jRadioButtonArray3 = new JRadioButton[2];
            jRadioButtonArray3[0] = this.myRbInlineAll;
            jRadioButtonArray = jRadioButtonArray3;
            jRadioButtonArray3[1] = this.myRbInlineThisOnly;
        }
        for (JRadioButton button2 : buttons = jRadioButtonArray) {
            bg.add(button2);
        }
        new RadioUpDownListener(buttons);
        this.myRbInlineThisOnly.setEnabled(this.myInvokedOnReference);
        this.myRbInlineAll.setEnabled(writable);
        if (this.myInvokedOnReference) {
            if (this.canInlineThisOnly()) {
                this.myRbInlineAll.setSelected(false);
                this.myRbInlineAll.setEnabled(false);
                if (this.myKeepTheDeclaration != null) {
                    this.myKeepTheDeclaration.setSelected(false);
                    this.myKeepTheDeclaration.setEnabled(false);
                }
                this.myRbInlineThisOnly.setSelected(true);
            } else if (writable) {
                boolean inlineThis = this.isInlineThis();
                this.myRbInlineThisOnly.setSelected(inlineThis);
                if (this.myKeepTheDeclaration != null) {
                    this.myKeepTheDeclaration.setSelected(!inlineThis && this.isKeepTheDeclarationByDefault());
                }
                this.myRbInlineAll.setSelected(!inlineThis && !this.isKeepTheDeclarationByDefault());
            } else {
                this.myRbInlineAll.setSelected(false);
                if (this.myKeepTheDeclaration != null) {
                    this.myKeepTheDeclaration.setSelected(false);
                }
                this.myRbInlineThisOnly.setSelected(true);
            }
        } else {
            boolean keepTheDeclarationByDefault = this.isKeepTheDeclarationByDefault();
            this.myRbInlineAll.setSelected(!keepTheDeclarationByDefault);
            if (this.myKeepTheDeclaration != null) {
                this.myKeepTheDeclaration.setSelected(keepTheDeclarationByDefault);
            }
            this.myRbInlineThisOnly.setSelected(false);
        }
        this.getPreviewAction().setEnabled(this.myRbInlineAll.isSelected() || this.myKeepTheDeclaration != null && this.myKeepTheDeclaration.isSelected());
        ActionListener previewListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = InlineOptionsDialog.this.myRbInlineAll.isSelected() || InlineOptionsDialog.this.myKeepTheDeclaration != null && InlineOptionsDialog.this.myKeepTheDeclaration.isSelected();
                InlineOptionsDialog.this.getPreviewAction().setEnabled(enabled);
            }
        };
        for (JRadioButton button3 : buttons) {
            button3.addActionListener(previewListener);
        }
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            InlineOptionsDialog.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    protected boolean allowInlineAll() {
        return this.myElement.isWritable();
    }

    @NlsContexts.Label
    protected abstract String getNameLabelText();

    @NlsContexts.BorderTitle
    protected abstract String getBorderTitle();

    @NlsContexts.RadioButton
    protected abstract String getInlineAllText();

    @NlsContexts.RadioButton
    protected String getKeepTheDeclarationText() {
        return null;
    }

    protected boolean isKeepTheDeclarationByDefault() {
        return false;
    }

    @NlsContexts.RadioButton
    protected abstract String getInlineThisText();

    protected abstract boolean isInlineThis();

    protected boolean canInlineThisOnly() {
        return false;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRbInlineThisOnly.isSelected() ? this.myRbInlineThisOnly : this.myRbInlineAll;
    }

    protected boolean ignoreOccurrence(PsiReference reference2) {
        return false;
    }

    protected static int initOccurrencesNumber(PsiNameIdentifierOwner nameIdentifierOwner) {
        return InlineOptionsDialog.getNumberOfOccurrences(nameIdentifierOwner, reference2 -> true);
    }

    protected int getNumberOfOccurrences(PsiNameIdentifierOwner nameIdentifierOwner) {
        return InlineOptionsDialog.getNumberOfOccurrences(nameIdentifierOwner, this::ignoreOccurrence);
    }

    protected static int getNumberOfOccurrences(PsiNameIdentifierOwner nameIdentifierOwner, Predicate<? super PsiReference> ignoreOccurrence) {
        return InlineOptionsDialog.getNumberOfOccurrences(nameIdentifierOwner, ignoreOccurrence, scope -> ReferencesSearch.search((PsiElement)nameIdentifierOwner, (SearchScope)scope));
    }

    protected static int getNumberOfOccurrences(PsiNameIdentifierOwner nameIdentifierOwner, Predicate<? super PsiReference> ignoreOccurrence, Function<? super GlobalSearchScope, ? extends Query<PsiReference>> searcher2) {
        ProgressManager progressManager = ProgressManager.getInstance();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)nameIdentifierOwner.getProject());
        GlobalSearchScope scope = GlobalSearchScope.projectScope(nameIdentifierOwner.getProject());
        String name2 = nameIdentifierOwner.getName();
        boolean isCheapToSearch = name2 != null && searchHelper.isCheapEnoughToSearch(name2, scope, null, progressManager.getProgressIndicator()) != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        return isCheapToSearch ? (int)searcher2.apply(scope).findAll().stream().filter(ignoreOccurrence).count() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineOptionsDialog", "createCenterPanel"));
    }
}

