/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.lang.refactoring.InlineHandlers;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineRefactoringActionHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance(InlineRefactoringActionHandler.class);

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project2 == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(elements.length == 1);
        if (dataContext == null) {
            dataContext = DataManager.getInstance().getDataContext();
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        for (InlineActionHandler handler : InlineActionHandler.EP_NAME.getExtensionList()) {
            if (!handler.canInlineElement(elements[0])) continue;
            handler.inlineElement(project2, editor2, elements[0]);
            return;
        }
        InlineRefactoringActionHandler.invokeInliner(editor2, elements[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            InlineRefactoringActionHandler.$$$reportNull$$$0(2);
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element2 == null) {
            element2 = BaseRefactoringAction.getElementAtCaret(editor2, file2);
        }
        if (element2 != null) {
            for (InlineActionHandler handler : InlineActionHandler.EP_NAME.getExtensionList()) {
                if (!handler.canInlineElementInEditor(element2, editor2)) continue;
                handler.inlineElement(project2, editor2, element2);
                return;
            }
            if (InlineRefactoringActionHandler.invokeInliner(editor2, element2)) {
                return;
            }
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.local.name"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)InlineRefactoringActionHandler.getRefactoringName(), null);
        }
    }

    public static boolean invokeInliner(@Nullable Editor editor2, PsiElement element2) {
        List handlers2 = InlineHandlers.getInlineHandlers((Language)element2.getLanguage());
        for (InlineHandler handler : handlers2) {
            if (!GenericInlineHandler.invoke(element2, editor2, handler)) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/inline/InlineRefactoringActionHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

