/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.MoveUsagesCollector;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2, DataContext dataContext) {
        PsiReference reference2;
        if (project2 == null) {
            MoveHandler.$$$reportNull$$$0(0);
        }
        int offset = editor2.getCaretModel().getOffset();
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            element2 = file2;
        }
        if ((reference2 = TargetElementUtilBase.findReferenceWithoutExpectedCaret(editor2)) != null) {
            PsiElement refElement = reference2.resolve();
            for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (refElement == null || !delegate2.tryToMove(refElement, project2, dataContext, reference2, editor2)) continue;
                MoveHandler.logDelegate(project2, delegate2, refElement.getLanguage());
                return;
            }
        }
        List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element2);
        while (true) {
            if (element2 == null) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.at.the.class.method.or.field.to.be.refactored"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)MoveHandler.getRefactoringName(), null);
                return;
            }
            for (MoveHandlerDelegate delegate2 : candidateHandlers) {
                if (!delegate2.tryToMove(element2, project2, dataContext, null, editor2)) continue;
                MoveHandler.logDelegate(project2, delegate2, element2.isValid() ? element2.getLanguage() : null);
                return;
            }
            element2 = element2.getParent();
        }
    }

    private static void logDelegate(@NotNull Project project2, @NotNull MoveHandlerDelegate delegate2, @Nullable Language language) {
        if (project2 == null) {
            MoveHandler.$$$reportNull$$$0(1);
        }
        if (delegate2 == null) {
            MoveHandler.$$$reportNull$$$0(2);
        }
        MoveUsagesCollector.HANDLER_INVOKED.log(project2, (Object)language, delegate2.getClass());
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project2 == null) {
            MoveHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(4);
        }
        PsiElement targetContainer = dataContext == null ? null : (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        HashSet<PsiElement> filesOrDirs = new HashSet<PsiElement>();
        if (!DumbService.isDumb(project2)) {
            for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.canMove(dataContext) || !delegate2.isValidTarget(targetContainer, elements)) continue;
                delegate2.collectFilesOrDirsFromContext(dataContext, filesOrDirs);
            }
        }
        if (!filesOrDirs.isEmpty()) {
            for (PsiElement element2 : elements) {
                if (element2 instanceof PsiDirectory) {
                    filesOrDirs.add(element2);
                    continue;
                }
                PsiFile containingFile = element2.getContainingFile();
                if (containingFile == null) continue;
                filesOrDirs.add(containingFile);
            }
            MoveUsagesCollector.MOVE_FILES_OR_DIRECTORIES.log(project2);
            MoveFilesOrDirectoriesUtil.doMove(project2, PsiUtilCore.toPsiElementArray(filesOrDirs), new PsiElement[]{targetContainer}, null);
            return;
        }
        MoveHandler.doMove(project2, elements, targetContainer, dataContext, null);
    }

    public static void doMove(Project project2, PsiElement @NotNull [] elements, PsiElement targetContainer, DataContext dataContext, MoveCallback callback) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(5);
        }
        if (elements.length == 0) {
            return;
        }
        SlowOperations.allowSlowOperations(() -> {
            block2: {
                block1: {
                    int copyDumb;
                    if (!DumbService.isDumb(project2)) break block1;
                    MoveFilesOrDirectoriesHandler filesOrDirectoriesHandler = MoveHandlerDelegate.EP_NAME.findExtensionOrFail(MoveFilesOrDirectoriesHandler.class);
                    if (!filesOrDirectoriesHandler.canMove(elements, targetContainer, null) || (copyDumb = Messages.showYesNoDialog((Project)project2, (String)RefactoringBundle.message((String)"move.handler.is.dumb.during.indexing"), (String)MoveHandler.getRefactoringName(), (Icon)Messages.getQuestionIcon())) != 0) break block2;
                    MoveHandler.logDelegate(project2, filesOrDirectoriesHandler, elements[0].getLanguage());
                    filesOrDirectoriesHandler.doMove(project2, elements, filesOrDirectoriesHandler.adjustTargetForMove(dataContext, targetContainer), callback);
                    break block2;
                }
                for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                    if (!delegate2.canMove(elements, targetContainer, null)) continue;
                    MoveHandler.logDelegate(project2, delegate2, elements[0].getLanguage());
                    delegate2.doMove(project2, elements, delegate2.adjustTargetForMove(dataContext, targetContainer), callback);
                    break;
                }
            }
        });
    }

    public static PsiElement @Nullable [] adjustForMove(Project project2, PsiElement[] sourceElements, PsiElement targetElement) {
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canMove(sourceElements, targetElement, null)) continue;
            return delegate2.adjustForMove(project2, sourceElements, targetElement);
        }
        return sourceElements;
    }

    public static boolean canMove(PsiElement @NotNull [] elements, PsiElement targetContainer) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(6);
        }
        return MoveHandler.findDelegate(elements, targetContainer, null) != null;
    }

    @Nullable
    private static MoveHandlerDelegate findDelegate(PsiElement @NotNull [] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference2) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(7);
        }
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canMove(elements, targetContainer, reference2)) continue;
            return delegate2;
        }
        return null;
    }

    @Nullable
    @NlsActions.ActionText
    public static String getActionName(@NotNull DataContext dataContext) {
        Editor editor2;
        if (dataContext == null) {
            MoveHandler.$$$reportNull$$$0(8);
        }
        if ((editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR)) != null) {
            MoveHandlerDelegate refDelegate;
            PsiElement refElement;
            PsiReference reference2;
            Project project2 = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                return null;
            }
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
            if (file2 == null) {
                return null;
            }
            PsiElement element2 = file2.findElementAt(editor2.getCaretModel().getOffset());
            if (element2 == null) {
                element2 = file2;
            }
            if ((reference2 = TargetElementUtilBase.findReferenceWithoutExpectedCaret(editor2)) != null && (refElement = reference2.resolve()) != null && (refDelegate = MoveHandler.findDelegate(new PsiElement[]{refElement}, null, reference2)) != null) {
                return refDelegate.getActionName(new PsiElement[]{refElement});
            }
            List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element2);
            while (element2 != null) {
                PsiElement[] elementArray = new PsiElement[]{element2};
                for (MoveHandlerDelegate handler : candidateHandlers) {
                    if (!handler.canMove(elementArray, null, reference2)) continue;
                    return handler.getActionName(elementArray);
                }
                element2 = element2.getParent();
            }
            return null;
        }
        PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext);
        List<MoveHandlerDelegate> delegates = MoveHandlerDelegate.EP_NAME.getExtensionList();
        for (MoveHandlerDelegate delegate2 : delegates) {
            if (!delegate2.canMove(elements, null, null)) continue;
            return delegate2.getActionName(elements);
        }
        return null;
    }

    @NotNull
    private static List<MoveHandlerDelegate> findHandlersForLanguage(@NotNull PsiElement element2) {
        if (element2 == null) {
            MoveHandler.$$$reportNull$$$0(9);
        }
        List<MoveHandlerDelegate> list2 = ContainerUtil.filter(MoveHandlerDelegate.EP_NAME.getExtensionList(), delegate2 -> delegate2.supportsLanguage(element2.getLanguage()));
        if (list2 == null) {
            MoveHandler.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public static boolean isValidTarget(PsiElement psiElement, PsiElement[] elements) {
        if (psiElement != null) {
            for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.isValidTarget(psiElement, elements)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canMove(DataContext dataContext) {
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canMove(dataContext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoveRedundant(PsiElement source, PsiElement target2) {
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.isMoveRedundant(source, target2)) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"move.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/MoveHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/MoveHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findHandlersForLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logDelegate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canMove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findHandlersForLanguage";
                break;
            }
            case 10: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

