/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryUsageInfo;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesHelper;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveDirectoryWithClassesProcessor
extends BaseRefactoringProcessor {
    private final PsiDirectory[] myDirectories;
    private final PsiDirectory myTargetDirectory;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;
    private final Map<VirtualFile, TargetDirectoryWrapper> myFilesToMove;
    private final Map<PsiDirectory, TargetDirectoryWrapper> myNestedDirsToMove;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final MoveCallback myMoveCallback;
    private final PsiManager myManager;

    public MoveDirectoryWithClassesProcessor(Project project2, PsiDirectory[] directories, PsiDirectory targetDirectory, boolean searchInComments, boolean searchInNonJavaFiles, boolean includeSelf, MoveCallback moveCallback) {
        super(project2);
        if (targetDirectory != null) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(Arrays.asList(directories));
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                PsiDirectory directory = (PsiDirectory)iterator.next();
                if (!targetDirectory.equals(directory.getParentDirectory()) && !targetDirectory.equals(directory)) continue;
                iterator.remove();
            }
            directories = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        this.myManager = PsiManager.getInstance(project2);
        this.myDirectories = directories;
        this.myTargetDirectory = targetDirectory;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
        this.myFilesToMove = new HashMap<VirtualFile, TargetDirectoryWrapper>();
        this.myNestedDirsToMove = new LinkedHashMap<PsiDirectory, TargetDirectoryWrapper>();
        for (PsiDirectory dir : directories) {
            MoveDirectoryWithClassesProcessor.collectFiles2Move(this.myFilesToMove, this.myNestedDirsToMove, dir, includeSelf ? dir.getParentDirectory() : dir, this.getTargetDirectory(dir));
        }
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(0);
        }
        return new MoveMultipleElementsViewDescriptor(PsiUtilCore.toPsiFileArray(this.getPsiFiles()), this.getTargetName());
    }

    private Set<PsiFile> getPsiFiles() {
        return this.myFilesToMove.keySet().stream().map(this.myManager::findFile).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected String getTargetName() {
        return RefactoringUIUtil.getDescription(this.getTargetDirectory(null).getTargetDirectory(), false);
    }

    public UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
            helper.findUsages(this.myFilesToMove, this.myDirectories, usages, this.mySearchInComments, this.mySearchInNonJavaFiles, this.myProject);
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usages.toArray(UsageInfo.EMPTY_ARRAY));
        if (usageInfoArray == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    private void collectConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull Ref<UsageInfo[]> refUsages) {
        if (conflicts == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(2);
        }
        if (refUsages == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(3);
        }
        for (VirtualFile vFile : this.myFilesToMove.keySet()) {
            PsiFile file2 = this.myManager.findFile(vFile);
            if (file2 == null) continue;
            try {
                this.myFilesToMove.get(vFile).checkMove(file2);
            }
            catch (IncorrectOperationException e) {
                conflicts.putValue(file2, e.getMessage());
            }
        }
        for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
            helper.preprocessUsages(this.myProject, this.getPsiFiles(), refUsages.get(), this.myTargetDirectory, conflicts);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(4);
        }
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> this.collectConflicts(conflicts, refUsages)), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        return this.showConflicts(conflicts, refUsages.get());
    }

    public void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(5);
        }
        try {
            for (PsiDirectory directory : this.myDirectories) {
                this.getResultDirectory(directory).findOrCreateTargetDirectory();
            }
            for (PsiDirectory directory : this.myNestedDirsToMove.keySet()) {
                this.myNestedDirsToMove.get(directory).findOrCreateTargetDirectory();
            }
            for (VirtualFile virtualFile2 : this.myFilesToMove.keySet()) {
                this.myFilesToMove.get(virtualFile2).findOrCreateTargetDirectory();
            }
            DumbService.getInstance(this.myProject).completeJustSubmittedTasks();
            ArrayList<PsiFile> movedFiles = new ArrayList<PsiFile>();
            HashMap<PsiElement, PsiElement> oldToNewElementsMapping = new HashMap<PsiElement, PsiElement>();
            for (VirtualFile virtualFile3 : this.myFilesToMove.keySet()) {
                MoveDirectoryWithClassesHelper helper;
                boolean processed;
                PsiFile file2 = this.myManager.findFile(virtualFile3);
                if (file2 == null) continue;
                for (MoveDirectoryWithClassesHelper helper2 : MoveDirectoryWithClassesHelper.findAll()) {
                    helper2.beforeMove(file2);
                }
                RefactoringElementListener listener2 = this.getTransaction().getElementListener((PsiElement)file2);
                PsiDirectory moveDestination = this.myFilesToMove.get(virtualFile3).getTargetDirectory();
                Iterator<MoveDirectoryWithClassesHelper> iterator = MoveDirectoryWithClassesHelper.findAll().iterator();
                while (iterator.hasNext() && !(processed = (helper = iterator.next()).move(file2, moveDestination, oldToNewElementsMapping, movedFiles, listener2))) {
                }
            }
            for (PsiElement newElement : oldToNewElementsMapping.values()) {
                for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
                    helper.afterMove(newElement);
                }
            }
            for (PsiFile movedFile : movedFiles) {
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                FileReferenceContextUtil.decodeFileReferences(movedFile);
            }
            this.myNonCodeUsages = CommonMoveUtil.retargetUsages(usages, oldToNewElementsMapping);
            SmartList<UsageInfo> postProcessUsages = new SmartList<UsageInfo>(usages);
            this.myNestedDirsToMove.entrySet().stream().filter(entry -> ((TargetDirectoryWrapper)entry.getValue()).getTargetDirectory() != null).map(entry -> new MoveDirectoryUsageInfo((PsiDirectory)entry.getKey(), ((TargetDirectoryWrapper)entry.getValue()).getTargetDirectory())).forEach(postProcessUsages::add);
            for (MoveDirectoryWithClassesHelper helper : MoveDirectoryWithClassesHelper.findAll()) {
                helper.postProcessUsages(postProcessUsages.toArray(UsageInfo.EMPTY_ARRAY), dir -> this.getResultDirectory((PsiDirectory)dir).findOrCreateTargetDirectory());
            }
            for (PsiDirectory directory : this.myDirectories) {
                if (this.isUsedInTarget(directory)) continue;
                directory.delete();
            }
            for (PsiDirectory directory : this.myNestedDirsToMove.keySet()) {
                if (!directory.isValid() || directory.getChildren().length != 0) continue;
                directory.delete();
            }
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
        }
    }

    private boolean isUsedInTarget(PsiDirectory directory) {
        PsiDirectory targetDirectory = this.myNestedDirsToMove.get(directory).getTargetDirectory();
        if (targetDirectory != null && PsiTreeUtil.isAncestor(directory, targetDirectory, false)) {
            return true;
        }
        return PsiTreeUtil.isAncestor(targetDirectory, directory, false);
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElements((PsiElement[])this.myDirectories);
        return data2;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(6);
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement((PsiElement)this.myTargetDirectory);
        return data2;
    }

    private TargetDirectoryWrapper getResultDirectory(PsiDirectory dir) {
        return this.myTargetDirectory != null ? new TargetDirectoryWrapper(this.myTargetDirectory, dir.getName()) : this.getTargetDirectory(dir);
    }

    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages == null) {
            return;
        }
        RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])this.myNonCodeUsages);
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
    }

    private static void collectFiles2Move(Map<VirtualFile, TargetDirectoryWrapper> files2Move, Map<PsiDirectory, TargetDirectoryWrapper> nestedDirsToMove, PsiDirectory directory, PsiDirectory rootDirectory, @NotNull TargetDirectoryWrapper targetDirectory) {
        if (targetDirectory == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(7);
        }
        PsiElement[] children2 = directory.getChildren();
        String relativePath = VfsUtilCore.getRelativePath(directory.getVirtualFile(), rootDirectory.getVirtualFile(), '/');
        TargetDirectoryWrapper newTargetDirectory = relativePath.length() == 0 ? targetDirectory : targetDirectory.findOrCreateChild(relativePath);
        nestedDirsToMove.put(directory, newTargetDirectory);
        for (PsiElement child : children2) {
            if (child instanceof PsiFile) {
                files2Move.put(PsiUtilCore.getVirtualFile(child), newTargetDirectory);
                continue;
            }
            if (!(child instanceof PsiDirectory)) continue;
            MoveDirectoryWithClassesProcessor.collectFiles2Move(files2Move, nestedDirsToMove, (PsiDirectory)child, directory, newTargetDirectory);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string2 = RefactoringBundle.message((String)"moving.directories.command");
        if (string2 == null) {
            MoveDirectoryWithClassesProcessor.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    public TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
        return new TargetDirectoryWrapper(this.myTargetDirectory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles2Move";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TargetDirectoryWrapper {
        private TargetDirectoryWrapper myParentDirectory;
        private PsiDirectory myTargetDirectory;
        private String myRelativePath;

        public TargetDirectoryWrapper(PsiDirectory targetDirectory) {
            this.myTargetDirectory = targetDirectory;
        }

        public TargetDirectoryWrapper(TargetDirectoryWrapper parentDirectory, String relativePath) {
            this.myParentDirectory = parentDirectory;
            this.myRelativePath = relativePath;
        }

        public TargetDirectoryWrapper(PsiDirectory parentDirectory, String relativePath) {
            this.myTargetDirectory = parentDirectory.findSubdirectory(relativePath);
            this.myParentDirectory = new TargetDirectoryWrapper(parentDirectory);
            this.myRelativePath = relativePath;
        }

        public PsiDirectory findOrCreateTargetDirectory() throws IncorrectOperationException {
            if (this.myTargetDirectory == null) {
                String[] pathComponents;
                PsiDirectory root = this.myParentDirectory.findOrCreateTargetDirectory();
                for (String component2 : pathComponents = this.myRelativePath.split("/")) {
                    this.myTargetDirectory = root.findSubdirectory(component2);
                    if (this.myTargetDirectory == null) {
                        this.myTargetDirectory = root.createSubdirectory(component2);
                    }
                    root = this.myTargetDirectory;
                }
            }
            return this.myTargetDirectory;
        }

        @Nullable
        public PsiDirectory getTargetDirectory() {
            return this.myTargetDirectory;
        }

        public TargetDirectoryWrapper findOrCreateChild(String relativePath) {
            PsiDirectory psiDirectory;
            if (this.myTargetDirectory != null && (psiDirectory = this.myTargetDirectory.findSubdirectory(relativePath)) != null) {
                return new TargetDirectoryWrapper(psiDirectory);
            }
            return new TargetDirectoryWrapper(this, relativePath);
        }

        public void checkMove(PsiFile psiFile) throws IncorrectOperationException {
            if (this.myTargetDirectory != null) {
                MoveFilesOrDirectoriesUtil.checkMove(psiFile, this.myTargetDirectory);
            }
        }

        @NotNull
        public PsiDirectory getRootDirectory() {
            if (this.myTargetDirectory == null) {
                PsiDirectory psiDirectory = this.myParentDirectory.getRootDirectory();
                if (psiDirectory == null) {
                    TargetDirectoryWrapper.$$$reportNull$$$0(0);
                }
                return psiDirectory;
            }
            PsiDirectory psiDirectory = this.myTargetDirectory;
            if (psiDirectory == null) {
                TargetDirectoryWrapper.$$$reportNull$$$0(1);
            }
            return psiDirectory;
        }

        @NotNull
        public String getRelativePathFromRoot() {
            if (this.myTargetDirectory != null) {
                return "";
            }
            String pathFromRoot = this.myParentDirectory.getRelativePathFromRoot();
            if (pathFromRoot.isEmpty()) {
                String string2 = this.myRelativePath;
                if (string2 == null) {
                    TargetDirectoryWrapper.$$$reportNull$$$0(2);
                }
                return string2;
            }
            String string3 = this.myRelativePath + "/" + pathFromRoot;
            if (string3 == null) {
                TargetDirectoryWrapper.$$$reportNull$$$0(3);
            }
            return string3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesProcessor$TargetDirectoryWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootDirectory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePathFromRoot";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

