/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.api;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.StringOperation;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00042\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/refactoring/rename/api/FileOperation;", "", "()V", "Add", "Companion", "Modify", "Move", "Remove", "Lcom/intellij/refactoring/rename/api/FileOperation$Add;", "Lcom/intellij/refactoring/rename/api/FileOperation$Move;", "Lcom/intellij/refactoring/rename/api/FileOperation$Remove;", "Lcom/intellij/refactoring/rename/api/FileOperation$Modify;", "intellij.platform.lang.impl"})
public abstract class FileOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FileOperation() {
    }

    public /* synthetic */ FileOperation(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final FileOperation addFile(@NotNull Path path2, @NotNull CharSequence content2) {
        return Companion.addFile(path2, content2);
    }

    @JvmStatic
    @NotNull
    public static final FileOperation moveFile(@NotNull VirtualFile file2, @NotNull Path path2) {
        return Companion.moveFile(file2, path2);
    }

    @JvmStatic
    @NotNull
    public static final FileOperation removeFile(@NotNull VirtualFile file2) {
        return Companion.removeFile(file2);
    }

    @JvmStatic
    @NotNull
    public static final FileOperation modifyFile(@NotNull PsiFile file2, @NotNull Collection<StringOperation> modifications) {
        return Companion.modifyFile(file2, modifications);
    }

    @JvmStatic
    @NotNull
    public static final FileOperation modifyFile(@NotNull PsiFile file2, @NotNull StringOperation modification, StringOperation ... modifications) {
        return Companion.modifyFile(file2, modification, modifications);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/refactoring/rename/api/FileOperation$Add;", "Lcom/intellij/refactoring/rename/api/FileOperation;", "path", "Ljava/nio/file/Path;", "content", "", "(Ljava/nio/file/Path;Ljava/lang/CharSequence;)V", "getContent", "()Ljava/lang/CharSequence;", "getPath", "()Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
    public static final class Add
    extends FileOperation {
        @NotNull
        private final Path path;
        @NotNull
        private final CharSequence content;

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final CharSequence getContent() {
            return this.content;
        }

        public Add(@NotNull Path path2, @NotNull CharSequence content2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            super(null);
            this.path = path2;
            this.content = content2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/refactoring/rename/api/FileOperation$Move;", "Lcom/intellij/refactoring/rename/api/FileOperation;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/nio/file/Path;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getPath", "()Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
    public static final class Move
    extends FileOperation {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final Path path;

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public Move(@NotNull VirtualFile file2, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            super(null);
            this.file = file2;
            this.path = path2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/refactoring/rename/api/FileOperation$Remove;", "Lcom/intellij/refactoring/rename/api/FileOperation;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
    public static final class Remove
    extends FileOperation {
        @NotNull
        private final VirtualFile file;

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public Remove(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super(null);
            this.file = file2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/refactoring/rename/api/FileOperation$Modify;", "Lcom/intellij/refactoring/rename/api/FileOperation;", "file", "Lcom/intellij/psi/PsiFile;", "modifications", "", "Lcom/intellij/util/text/StringOperation;", "(Lcom/intellij/psi/PsiFile;Ljava/util/Collection;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getModifications", "()Ljava/util/Collection;", "intellij.platform.lang.impl"})
    public static final class Modify
    extends FileOperation {
        @NotNull
        private final PsiFile file;
        @NotNull
        private final Collection<StringOperation> modifications;

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }

        @NotNull
        public final Collection<StringOperation> getModifications() {
            return this.modifications;
        }

        public Modify(@NotNull PsiFile file2, @NotNull Collection<StringOperation> modifications) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(modifications, (String)"modifications");
            super(null);
            this.file = file2;
            this.modifications = modifications;
            Collection<StringOperation> collection = this.modifications;
            boolean bl2 = bl = !collection.isEmpty();
            if (!bl) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J1\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u000f\"\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0013H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/refactoring/rename/api/FileOperation$Companion;", "", "()V", "addFile", "Lcom/intellij/refactoring/rename/api/FileOperation;", "path", "Ljava/nio/file/Path;", "content", "", "modifyFile", "file", "Lcom/intellij/psi/PsiFile;", "modification", "Lcom/intellij/util/text/StringOperation;", "modifications", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/util/text/StringOperation;[Lcom/intellij/util/text/StringOperation;)Lcom/intellij/refactoring/rename/api/FileOperation;", "", "moveFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeFile", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FileOperation addFile(@NotNull Path path2, @NotNull CharSequence content2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new Add(path2, content2);
        }

        @JvmStatic
        @NotNull
        public final FileOperation moveFile(@NotNull VirtualFile file2, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return new Move(file2, path2);
        }

        @JvmStatic
        @NotNull
        public final FileOperation removeFile(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return new Remove(file2);
        }

        @JvmStatic
        @NotNull
        public final FileOperation modifyFile(@NotNull PsiFile file2, @NotNull Collection<StringOperation> modifications) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(modifications, (String)"modifications");
            return new Modify(file2, modifications);
        }

        @JvmStatic
        @NotNull
        public final FileOperation modifyFile(@NotNull PsiFile file2, @NotNull StringOperation modification, StringOperation ... modifications) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
            Intrinsics.checkNotNullParameter((Object)modifications, (String)"modifications");
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)modification);
            spreadBuilder.addSpread((Object)modifications);
            return this.modifyFile(file2, CollectionsKt.listOf((Object[])((StringOperation[])spreadBuilder.toArray((Object[])new StringOperation[spreadBuilder.size()]))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

