/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.lang.LangBundle;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.safeDelete.SafeDeleteUsageViewDescriptor;
import com.intellij.refactoring.safeDelete.UnsafeUsagesDialog;
import com.intellij.refactoring.safeDelete.UsageHolder;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteCustomUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SafeDeleteProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(SafeDeleteProcessor.class);
    private final PsiElement[] myElements;
    private boolean mySearchInCommentsAndStrings;
    private boolean mySearchNonJava;
    private boolean myPreviewNonCodeUsages = true;
    private Runnable myAfterRefactoringCallback;
    private @NlsContexts.Command String myCachedCommandName = null;

    private SafeDeleteProcessor(Project project2, @Nullable Runnable prepareSuccessfulCallback, PsiElement[] elementsToDelete, boolean isSearchInComments, boolean isSearchNonJava) {
        super(project2, prepareSuccessfulCallback);
        this.myElements = elementsToDelete;
        this.mySearchInCommentsAndStrings = isSearchInComments;
        this.mySearchNonJava = isSearchNonJava;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        return new SafeDeleteUsageViewDescriptor(this.myElements);
    }

    private static boolean isInside(PsiElement place, PsiElement[] ancestors) {
        return SafeDeleteProcessor.isInside(place, Arrays.asList(ancestors));
    }

    private static boolean isInside(PsiElement place, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!SafeDeleteProcessor.isInside(place, psiElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(PsiElement place, PsiElement ancestor) {
        PsiElement nameIdentifier;
        boolean isAncestor;
        if (ancestor instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)ancestor).getDirectories(place.getResolveScope());
            for (PsiDirectory directory : directories) {
                if (!SafeDeleteProcessor.isInside(place, directory)) continue;
                return true;
            }
        }
        if (ancestor instanceof PsiFile) {
            for (PsiFile file2 : ((PsiFile)ancestor).getViewProvider().getAllFiles()) {
                if (!PsiTreeUtil.isAncestor(file2, place, false)) continue;
                return true;
            }
        }
        if (!(isAncestor = PsiTreeUtil.isAncestor(ancestor, place, false)) && ancestor instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)ancestor).getNameIdentifier()) != null && !PsiTreeUtil.isAncestor(ancestor, nameIdentifier, true)) {
            isAncestor = PsiTreeUtil.isAncestor(nameIdentifier.getParent(), place, false);
        }
        if (!isAncestor) {
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(place.getProject());
            PsiLanguageInjectionHost host = injectedLanguageManager.getInjectionHost(place);
            while (host != null) {
                if (PsiTreeUtil.isAncestor(ancestor, host, false)) {
                    isAncestor = true;
                    break;
                }
                host = injectedLanguageManager.getInjectionHost(host);
            }
        }
        return isAncestor;
    }

    protected UsageInfo @NotNull [] findUsages() {
        List<UsageInfo> usages = Collections.synchronizedList(new ArrayList());
        GlobalSearchScope searchScope2 = GlobalSearchScope.projectScope(this.myProject);
        for (PsiElement element2 : this.myElements) {
            boolean handled = false;
            for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.handlesElement(element2)) continue;
                NonCodeUsageSearchInfo filter2 = delegate2.findUsages(element2, this.myElements, usages);
                if (filter2 != null) {
                    for (PsiElement psiElement : filter2.getElementsToSearch()) {
                        SafeDeleteProcessor.addNonCodeUsages(psiElement, searchScope2, usages, filter2.getInsideDeletedCondition(), this.mySearchNonJava, this.mySearchInCommentsAndStrings);
                    }
                }
                handled = true;
                break;
            }
            if (handled || !(element2 instanceof PsiNamedElement)) continue;
            SafeDeleteProcessor.findGenericElementUsages(element2, usages, this.myElements);
            SafeDeleteProcessor.addNonCodeUsages(element2, searchScope2, usages, SafeDeleteProcessor.getDefaultInsideDeletedCondition(this.myElements), this.mySearchNonJava, this.mySearchInCommentsAndStrings);
        }
        UsageInfo[] result2 = usages.toArray(UsageInfo.EMPTY_ARRAY);
        result2 = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result2);
        Arrays.sort(result2, (o1, o2) -> PsiUtilCore.compareElementsByPosition(o2.getElement(), o1.getElement()));
        if (result2 == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        return result2;
    }

    public static Condition<PsiElement> getDefaultInsideDeletedCondition(PsiElement[] elements) {
        return usage2 -> !(usage2 instanceof PsiFile) && SafeDeleteProcessor.isInside(usage2, elements);
    }

    public static void findGenericElementUsages(@NotNull PsiElement element2, List<? super UsageInfo> usages, PsiElement[] allElementsToDelete, SearchScope scope) {
        if (element2 == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        ReferencesSearch.search((PsiElement)element2, (SearchScope)scope).forEach(reference2 -> {
            PsiElement refElement = reference2.getElement();
            if (!SafeDeleteProcessor.isInside(refElement, allElementsToDelete)) {
                usages.add(new SafeDeleteReferenceSimpleDeleteUsageInfo(refElement, element2, false));
            }
            return true;
        });
    }

    public static void findGenericElementUsages(PsiElement element2, List<? super UsageInfo> usages, PsiElement[] allElementsToDelete) {
        SafeDeleteProcessor.findGenericElementUsages(element2, usages, allElementsToDelete, element2.getUseScope());
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        UsageInfo[] usages = refUsages.get();
        ArrayList<String> conflicts = new ArrayList<String>();
        block0: for (PsiElement element2 : this.myElements) {
            for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                Collection<String> foundConflicts;
                if (!delegate2.handlesElement(element2)) continue;
                Collection<String> collection = foundConflicts = delegate2 instanceof SafeDeleteProcessorDelegateBase ? ((SafeDeleteProcessorDelegateBase)delegate2).findConflicts(element2, this.myElements, usages) : delegate2.findConflicts(element2, this.myElements);
                if (foundConflicts == null) continue block0;
                conflicts.addAll(foundConflicts);
                continue block0;
            }
        }
        if (this.checkConflicts(usages, conflicts)) {
            return false;
        }
        UsageInfo[] preprocessedUsages = usages;
        for (SafeDeleteProcessorDelegate delegate3 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
            preprocessedUsages = delegate3.preprocessUsages(this.myProject, preprocessedUsages);
            if (preprocessedUsages != null) continue;
            return false;
        }
        HashSet<UsageInfo> diff = ContainerUtil.newHashSet(preprocessedUsages);
        diff.removeAll(Arrays.asList(usages));
        if (this.checkConflicts(diff.toArray(UsageInfo.EMPTY_ARRAY), new ArrayList<String>())) {
            return false;
        }
        UsageInfo[] filteredUsages = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])preprocessedUsages);
        this.prepareSuccessful();
        refUsages.set(filteredUsages);
        return true;
    }

    private boolean checkConflicts(UsageInfo[] usages, ArrayList<String> conflicts) {
        HashMap<PsiElement, UsageHolder> elementsToUsageHolders = SafeDeleteProcessor.sortUsages(usages);
        Collection<UsageHolder> usageHolders = elementsToUsageHolders.values();
        for (UsageHolder usageHolder : usageHolders) {
            if (!usageHolder.hasUnsafeUsagesInCode()) continue;
            conflicts.add(usageHolder.getDescription());
        }
        if (!conflicts.isEmpty()) {
            RefactoringEventData conflictData = new RefactoringEventData();
            conflictData.putUserData(RefactoringEventData.CONFLICTS_KEY, conflicts);
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected("refactoring.safeDelete", conflictData);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                    throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts);
                }
            } else {
                UnsafeUsagesDialog dialog = new UnsafeUsagesDialog(ArrayUtilRt.toStringArray(conflicts), this.myProject);
                if (!dialog.showAndGet()) {
                    int exitCode = dialog.getExitCode();
                    this.prepareSuccessful();
                    if (exitCode == 2) {
                        this.showUsages((UsageInfo[])Arrays.stream(usages).filter(usage2 -> usage2 instanceof SafeDeleteReferenceUsageInfo && !((SafeDeleteReferenceUsageInfo)usage2).isSafeDelete()).toArray(UsageInfo[]::new), usages);
                    }
                    return true;
                }
                this.myPreviewNonCodeUsages = false;
            }
        }
        return false;
    }

    private void showUsages(UsageInfo[] conflictUsages, UsageInfo[] usages) {
        UsageViewPresentation presentation2 = new UsageViewPresentation();
        presentation2.setTabText(LangBundle.message("tab.title.safe.delete.conflicts", new Object[0]));
        presentation2.setTargetsNodeText(RefactoringBundle.message((String)"attempting.to.delete.targets.node.text"));
        presentation2.setShowReadOnlyStatusAsRed(true);
        presentation2.setShowCancelButton(true);
        presentation2.setCodeUsagesString(RefactoringBundle.message((String)"safe.delete.conflict.title"));
        presentation2.setNonCodeUsagesString(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
        presentation2.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        UsageView usageView = this.showUsages(conflictUsages, presentation2, manager);
        usageView.addPerformOperationAction((Runnable)new RerunSafeDelete(this.myProject, this.myElements, usageView), RefactoringBundle.message((String)"retry.command"), "", RefactoringBundle.message((String)"rerun.safe.delete"));
        usageView.addPerformOperationAction(() -> {
            UsageInfo[] preprocessedUsages = usages;
            for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                preprocessedUsages = delegate2.preprocessUsages(this.myProject, preprocessedUsages);
                if (preprocessedUsages != null) continue;
                return;
            }
            UsageInfo[] filteredUsages = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])preprocessedUsages);
            this.execute(filteredUsages);
        }, LangBundle.message("command.name.delete.anyway", new Object[0]), RefactoringBundle.message((String)"usageView.need.reRun"), RefactoringBundle.message((String)"usageView.doAction"));
    }

    private UsageView showUsages(UsageInfo[] usages, UsageViewPresentation presentation2, UsageViewManager manager) {
        for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
            UsageView view;
            if (!(delegate2 instanceof SafeDeleteProcessorDelegateBase) || (view = ((SafeDeleteProcessorDelegateBase)delegate2).showUsages(usages, presentation2, manager, this.myElements)) == null) continue;
            return view;
        }
        UsageTarget[] targets2 = new UsageTarget[this.myElements.length];
        for (int i = 0; i < targets2.length; ++i) {
            targets2[i] = new PsiElement2UsageTargetAdapter(this.myElements[i]);
        }
        return manager.showUsages(targets2, UsageInfoToUsageConverter.convert((PsiElement[])this.myElements, (UsageInfo[])usages), presentation2);
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    private static HashMap<PsiElement, UsageHolder> sortUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        HashMap<PsiElement, UsageHolder> result2 = new HashMap<PsiElement, UsageHolder>();
        for (UsageInfo usage2 : usages) {
            PsiElement referencedElement;
            if (!(usage2 instanceof SafeDeleteUsageInfo) || result2.containsKey(referencedElement = ((SafeDeleteUsageInfo)usage2).getReferencedElement())) continue;
            result2.put(referencedElement, new UsageHolder(referencedElement, usages));
        }
        return result2;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(elements.length == this.myElements.length);
        System.arraycopy(elements, 0, this.myElements, 0, elements.length);
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        if (this.myPreviewNonCodeUsages && UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)this.myProject)) {
            return true;
        }
        return super.isPreviewUsages(SafeDeleteProcessor.filterToBeDeleted(usages));
    }

    private static UsageInfo[] filterToBeDeleted(UsageInfo[] infos) {
        ArrayList<UsageInfo> list2 = new ArrayList<UsageInfo>();
        for (UsageInfo info : infos) {
            if (info instanceof SafeDeleteReferenceUsageInfo && !((SafeDeleteReferenceUsageInfo)info).isSafeDelete()) continue;
            list2.add(info);
        }
        return list2.toArray(UsageInfo.EMPTY_ARRAY);
    }

    @NotNull
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements(this.myElements);
        RefactoringEventData refactoringEventData = beforeData;
        if (refactoringEventData == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        return refactoringEventData;
    }

    @NotNull
    protected String getRefactoringId() {
        return "refactoring.safeDelete";
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        try {
            SmartPointerManager pointerManager = SmartPointerManager.getInstance(this.myProject);
            List<SmartPsiElementPointer> pointers2 = ContainerUtil.map(this.myElements, pointerManager::createSmartPsiElementPointer);
            for (UsageInfo usage2 : usages) {
                if (!(usage2 instanceof SafeDeleteCustomUsageInfo)) continue;
                ((SafeDeleteCustomUsageInfo)((Object)usage2)).performRefactoring();
            }
            for (PsiElement element2 : this.myElements) {
                for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                    if (!delegate2.handlesElement(element2)) continue;
                    delegate2.prepareForDeletion(element2);
                }
            }
            for (SmartPsiElementPointer pointer : pointers2) {
                Object element3 = pointer.getElement();
                if (element3 == null) continue;
                element3.delete();
            }
            if (this.myAfterRefactoringCallback != null) {
                this.myAfterRefactoringCallback.run();
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
        }
    }

    @NlsContexts.Command
    private String calcCommandName() {
        return RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(this.myElements)});
    }

    @NotNull
    protected String getCommandName() {
        if (this.myCachedCommandName == null) {
            this.myCachedCommandName = this.calcCommandName();
        }
        String string2 = this.myCachedCommandName;
        if (string2 == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        return string2;
    }

    public static void addNonCodeUsages(final PsiElement element2, SearchScope searchScope2, List<? super UsageInfo> usages, final @Nullable Condition<? super PsiElement> insideElements, boolean searchNonJava, boolean searchInCommentsAndStrings) {
        String stringToSearch;
        UsageInfoFactory nonCodeUsageFactory = new UsageInfoFactory(){

            @Override
            public UsageInfo createUsageInfo(@NotNull PsiElement usage2, int startOffset, int endOffset) {
                if (usage2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (insideElements != null && insideElements.value(usage2)) {
                    return null;
                }
                return new SafeDeleteReferenceSimpleDeleteUsageInfo(usage2, element2, startOffset, endOffset, true, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/safeDelete/SafeDeleteProcessor$1", "createUsageInfo"));
            }
        };
        if (searchInCommentsAndStrings) {
            stringToSearch = ElementDescriptionUtil.getElementDescription(element2, NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS);
            TextOccurrencesUtil.addUsagesInStringsAndComments(element2, searchScope2, stringToSearch, usages, nonCodeUsageFactory);
        }
        if (searchNonJava && searchScope2 instanceof GlobalSearchScope) {
            stringToSearch = ElementDescriptionUtil.getElementDescription(element2, NonCodeSearchDescriptionLocation.NON_JAVA);
            TextOccurrencesUtil.addTextOccurrences(element2, stringToSearch, (GlobalSearchScope)searchScope2, usages, nonCodeUsageFactory);
        }
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        if (usageInfo instanceof SafeDeleteReferenceUsageInfo) {
            return ((SafeDeleteReferenceUsageInfo)usageInfo).isSafeDelete() && super.isToBeChanged(usageInfo);
        }
        return super.isToBeChanged(usageInfo);
    }

    public static boolean validElement(@NotNull PsiElement element2) {
        if (element2 == null) {
            SafeDeleteProcessor.$$$reportNull$$$0(11);
        }
        if (element2 instanceof PsiFile) {
            return true;
        }
        if (!element2.isPhysical()) {
            return false;
        }
        RefactoringSupportProvider provider2 = LanguageRefactoringSupport.INSTANCE.forContext(element2);
        return provider2 != null && provider2.isSafeDeleteAvailable(element2);
    }

    public static SafeDeleteProcessor createInstance(Project project2, @Nullable Runnable prepareSuccessfulCallback, PsiElement[] elementsToDelete, boolean isSearchInComments, boolean isSearchNonJava) {
        return new SafeDeleteProcessor(project2, prepareSuccessfulCallback, elementsToDelete, isSearchInComments, isSearchNonJava);
    }

    public static SafeDeleteProcessor createInstance(Project project2, @Nullable Runnable prepareSuccessfulCallBack, PsiElement[] elementsToDelete, boolean isSearchInComments, boolean isSearchNonJava, boolean askForAccessors) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>(Arrays.asList(elementsToDelete));
        Set<PsiElement> elementsToDeleteSet = ContainerUtil.set(elementsToDelete);
        block0: for (PsiElement psiElement : elementsToDelete) {
            for (SafeDeleteProcessorDelegate delegate2 : SafeDeleteProcessorDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.handlesElement(psiElement)) continue;
                Collection<PsiElement> addedElements = delegate2.getAdditionalElementsToDelete(psiElement, elementsToDeleteSet, askForAccessors);
                if (addedElements == null) continue block0;
                elements.addAll(addedElements);
                continue block0;
            }
        }
        return new SafeDeleteProcessor(project2, prepareSuccessfulCallBack, PsiUtilCore.toPsiElementArray(elements), isSearchInComments, isSearchNonJava);
    }

    public boolean isSearchInCommentsAndStrings() {
        return this.mySearchInCommentsAndStrings;
    }

    public void setSearchInCommentsAndStrings(boolean searchInCommentsAndStrings) {
        this.mySearchInCommentsAndStrings = searchInCommentsAndStrings;
    }

    public boolean isSearchNonJava() {
        return this.mySearchNonJava;
    }

    public void setSearchNonJava(boolean searchNonJava) {
        this.mySearchNonJava = searchNonJava;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    public void setAfterRefactoringCallback(Runnable afterRefactoringCallback) {
        this.myAfterRefactoringCallback = afterRefactoringCallback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/safeDelete/SafeDeleteProcessor";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/safeDelete/SafeDeleteProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findGenericElementUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isToBeChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RerunSafeDelete
    implements Runnable {
        final SmartPsiElementPointer[] myPointers;
        private final Project myProject;
        private final UsageView myUsageView;

        RerunSafeDelete(Project project2, PsiElement[] elements, UsageView usageView) {
            this.myProject = project2;
            this.myUsageView = usageView;
            this.myPointers = new SmartPsiElementPointer[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                PsiElement element2 = elements[i];
                this.myPointers[i] = SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(element2);
            }
        }

        @Override
        public void run() {
            PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
            this.myUsageView.close();
            ArrayList elements = new ArrayList();
            for (SmartPsiElementPointer pointer : this.myPointers) {
                Object element2 = pointer.getElement();
                if (element2 == null) continue;
                elements.add(element2);
            }
            if (!elements.isEmpty()) {
                SafeDeleteHandler.invoke(this.myProject, PsiUtilCore.toPsiElementArray(elements), true);
            }
        }
    }
}

