/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CodeFragmentTableCellRenderer
implements TableCellRenderer {
    private final Project myProject;
    private final FileType myFileType;

    public CodeFragmentTableCellRenderer(Project project2) {
        this(project2, StdFileTypes.JAVA);
    }

    public CodeFragmentTableCellRenderer(Project project2, FileType fileType) {
        this.myProject = project2;
        this.myFileType = fileType;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        EditorTextField editorTextField2;
        PsiCodeFragment codeFragment = (PsiCodeFragment)value;
        Document document = null;
        if (codeFragment != null) {
            document = PsiDocumentManager.getInstance(this.myProject).getDocument(codeFragment);
            editorTextField2 = new EditorTextField(document, this.myProject, this.myFileType){

                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        } else {
            editorTextField2 = new EditorTextField("", this.myProject, this.myFileType){

                protected boolean shouldHaveBorder() {
                    return false;
                }
            };
        }
        if (!table.isShowing()) {
            editorTextField2.ensureWillComputePreferredSize();
        }
        editorTextField2.putClientProperty((Object)"JComboBox.isTableCellEditor", (Object)Boolean.TRUE);
        editorTextField2.setBorder(hasFocus || isSelected ? BorderFactory.createLineBorder(table.getSelectionBackground()) : JBUI.Borders.empty(1));
        if (isSelected && document != null) {
            Color bg = table.getSelectionBackground();
            Color fg = table.getSelectionForeground();
            editorTextField2.setBackground(bg);
            editorTextField2.setForeground(fg);
            editorTextField2.setAsRendererWithSelection(bg, fg);
        }
        return editorTextField2;
    }
}

