/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.Refactoring;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialogUsageCollector;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class RefactoringDialog
extends DialogWrapper {
    private Action myRefactorAction;
    private Action myPreviewAction;
    private boolean myCbPreviewResults;
    protected final Project myProject;

    protected RefactoringDialog(@NotNull Project project2, boolean canBeParent) {
        if (project2 == null) {
            RefactoringDialog.$$$reportNull$$$0(0);
        }
        this(project2, canBeParent, false);
    }

    protected RefactoringDialog(@NotNull Project project2, boolean canBeParent, boolean addOpenInEditorCheckbox) {
        if (project2 == null) {
            RefactoringDialog.$$$reportNull$$$0(1);
        }
        super(project2, canBeParent);
        this.myCbPreviewResults = true;
        this.myProject = project2;
        if (addOpenInEditorCheckbox) {
            this.addOpenInEditorCheckbox();
        }
    }

    protected void addOpenInEditorCheckbox() {
        this.setDoNotAskOption((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean selected, int exitCode) {
                PropertiesComponent.getInstance().setValue(RefactoringDialog.this.getRefactoringId() + ".OpenInEditor", selected, RefactoringDialog.this.isOpenInEditorEnabledByDefault());
                RefactoringDialogUsageCollector.logOpenInEditorSaved(RefactoringDialog.this.myProject, selected, ((Object)((Object)RefactoringDialog.this)).getClass());
            }

            public boolean isSelectedByDefault() {
                boolean selected = PropertiesComponent.getInstance().getBoolean(RefactoringDialog.this.getRefactoringId() + ".OpenInEditor", RefactoringDialog.this.isOpenInEditorEnabledByDefault());
                RefactoringDialogUsageCollector.logOpenInEditorShown(RefactoringDialog.this.myProject, selected, ((Object)((Object)RefactoringDialog.this)).getClass());
                return selected;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string2 = RefactoringBundle.message((String)"open.in.editor.label");
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/RefactoringDialog$1", "getDoNotShowMessage"));
            }
        });
    }

    protected boolean isOpenInEditorEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    protected String getRefactoringId() {
        String string2 = ((Object)((Object)this)).getClass().getName();
        if (string2 == null) {
            RefactoringDialog.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public boolean isOpenInEditor() {
        return this.myCheckBoxDoNotShowDialog != null && this.myCheckBoxDoNotShowDialog.isSelected();
    }

    public final boolean isPreviewUsages() {
        return this.myCbPreviewResults;
    }

    public void setPreviewResults(boolean previewResults) {
        this.myCbPreviewResults = previewResults;
    }

    public void show() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        super.show();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myRefactorAction = new RefactorAction();
        this.myPreviewAction = new PreviewAction();
    }

    protected final Action getRefactorAction() {
        return this.myRefactorAction;
    }

    protected final void setRefactorButtonText(@NlsContexts.Button @NotNull String text2) {
        if (text2 == null) {
            RefactoringDialog.$$$reportNull$$$0(3);
        }
        this.myRefactorAction.putValue("Name", text2);
        this.myRefactorAction.putValue("SwingDisplayedMnemonicIndexKey", null);
        this.myRefactorAction.putValue("MnemonicKey", null);
    }

    protected final Action getPreviewAction() {
        return this.myPreviewAction;
    }

    protected abstract void doAction();

    private void doPreviewAction() {
        this.myCbPreviewResults = true;
        this.doAction();
    }

    protected void doRefactorAction() {
        this.myCbPreviewResults = false;
        this.doAction();
    }

    protected final void closeOKAction() {
        super.doOKAction();
    }

    protected final void doOKAction() {
        if (!DumbService.isDumbAware((Object)this) && DumbService.isDumb(this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"refactoring.not.available.indexing"), (String)RefactoringBundle.message((String)"refactoring.indexing.warning.title"), null);
            return;
        }
        this.doAction();
    }

    protected boolean areButtonsValid() {
        return true;
    }

    protected void canRun() throws ConfigurationException {
        if (!this.areButtonsValid()) {
            throw new ConfigurationException(null);
        }
    }

    protected void setHelpTooltip(@NotNull JButton helpButton) {
        if (helpButton == null) {
            RefactoringDialog.$$$reportNull$$$0(4);
        }
        if (Registry.is("ide.helptooltip.enabled")) {
            new HelpTooltip().setDescription(ActionsBundle.actionDescription((String)"HelpTopics")).installOn((JComponent)helpButton);
        } else {
            super.setHelpTooltip(helpButton);
        }
    }

    protected void validateButtons() {
        boolean enabled = true;
        try {
            this.setErrorText(null);
            this.canRun();
        }
        catch (ConfigurationException e) {
            enabled = false;
            this.setErrorText(e.getMessage());
        }
        this.getPreviewAction().setEnabled(enabled);
        this.getRefactorAction().setEnabled(enabled);
    }

    protected void validateButtonsAsync() {
        this.validateButtonsAsync(ModalityState.stateForComponent(this.getContentPanel()));
    }

    protected void validateButtonsAsync(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            RefactoringDialog.$$$reportNull$$$0(5);
        }
        this.setErrorText(null);
        ReadAction.nonBlocking(() -> {
            try {
                this.canRun();
                return null;
            }
            catch (ConfigurationException e) {
                return e;
            }
        }).finishOnUiThread(modalityState, e -> {
            if (e != null) {
                this.setErrorText(e.getMessage());
            }
            this.getPreviewAction().setEnabled(e == null);
            this.getRefactorAction().setEnabled(e == null);
        }).coalesceBy(this.myProject, ((Object)((Object)this)).getClass()).submit(AppExecutorUtil.getAppExecutorService());
    }

    protected boolean hasHelpAction() {
        return true;
    }

    protected boolean hasPreviewButton() {
        return true;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions2 = new ArrayList<Action>();
        actions2.add(this.getRefactorAction());
        if (this.hasPreviewButton()) {
            actions2.add(this.getPreviewAction());
        }
        actions2.add(this.getCancelAction());
        if (this.hasHelpAction()) {
            actions2.add(this.getHelpAction());
        }
        if (SystemInfo.isMac) {
            Collections.reverse(actions2);
        }
        Action[] actionArray = actions2.toArray(new Action[0]);
        if (actionArray == null) {
            RefactoringDialog.$$$reportNull$$$0(6);
        }
        return actionArray;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor) {
        Runnable prepareSuccessfulCallback = () -> this.close(0);
        processor.setPrepareSuccessfulSwingThreadCallback(prepareSuccessfulCallback);
        processor.setPreviewUsages(this.isPreviewUsages());
        processor.run();
    }

    protected void invokeRefactoring(Refactoring processor) {
        Runnable prepareSuccessfulCallback = () -> this.close(0);
        processor.setInteractive(prepareSuccessfulCallback);
        processor.setPreviewUsages(this.isPreviewUsages());
        processor.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/ui/RefactoringDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpButton";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/ui/RefactoringDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRefactorButtonText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setHelpTooltip";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateButtonsAsync";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class PreviewAction
    extends AbstractAction {
        PreviewAction() {
            super(RefactoringBundle.message((String)"preview.button"));
            if (SystemInfo.isMac) {
                this.putValue("FocusedAction", Boolean.TRUE);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doPreviewAction();
        }
    }

    private class RefactorAction
    extends AbstractAction {
        RefactorAction() {
            super(RefactoringBundle.message((String)"refactor.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doRefactorAction();
        }
    }
}

