/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.BuildTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.ProjectTaskState;
import com.intellij.task.TaskRunnerResults;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.task.impl.ProjectTaskManagerListener;
import com.intellij.task.impl.ProjectTaskManagerStatisticsCollector;
import com.intellij.task.impl.ProjectTaskScope;
import com.intellij.tracing.Tracer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private static final Logger LOG = Logger.getInstance(ProjectTaskManager.class);
    private final ProjectTaskRunner myDummyTaskRunner;
    private final ProjectTaskListener myEventPublisher;
    private final List<ProjectTaskManagerListener> myListeners;

    public ProjectTaskManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myDummyTaskRunner = new DummyTaskRunner();
        this.myListeners = new CopyOnWriteArrayList<ProjectTaskManagerListener>();
        this.myEventPublisher = project2.getMessageBus().syncPublisher(ProjectTaskListener.TOPIC);
    }

    @Override
    public Promise<ProjectTaskManager.Result> build(Module @NotNull [] modules2) {
        if (modules2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(1);
        }
        return this.run(this.createModulesBuildTask(modules2, true, true, false));
    }

    @Override
    public Promise<ProjectTaskManager.Result> rebuild(Module @NotNull [] modules2) {
        if (modules2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(2);
        }
        return this.run(this.createModulesBuildTask(modules2, false, false, false));
    }

    @Override
    public Promise<ProjectTaskManager.Result> compile(VirtualFile @NotNull [] files2) {
        if (files2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(3);
        }
        List<ModuleFilesBuildTask> buildTasks = ContainerUtil.map(Arrays.stream(files2).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.getInstance(this.myProject).getModuleForFile((VirtualFile)file2, false))).entrySet(), entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue()));
        return this.run(new ProjectTaskList((Collection<? extends ProjectTask>)buildTasks));
    }

    @Override
    public Promise<ProjectTaskManager.Result> build(ProjectModelBuildableElement @NotNull [] buildableElements) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(4);
        }
        return this.doBuild(buildableElements, true);
    }

    @Override
    public Promise<ProjectTaskManager.Result> rebuild(ProjectModelBuildableElement @NotNull [] buildableElements) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(5);
        }
        return this.doBuild(buildableElements, false);
    }

    @Override
    public Promise<ProjectTaskManager.Result> buildAllModules() {
        return this.run(this.createAllModulesBuildTask(true, this.myProject));
    }

    @Override
    public Promise<ProjectTaskManager.Result> rebuildAllModules() {
        return this.run(this.createAllModulesBuildTask(false, this.myProject));
    }

    @Override
    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project2) {
        return this.createModulesBuildTask(ModuleManager.getInstance(project2).getModules(), isIncrementalBuild, false, false);
    }

    @Override
    public ProjectTask createModulesBuildTask(Module[] modules2, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies, boolean includeTests) {
        if (modules2.length == 1) {
            return new ModuleBuildTaskImpl(modules2[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies, includeTests);
        }
        return new ProjectTaskList((Collection<? extends ProjectTask>)ContainerUtil.map(Arrays.asList(modules2), module -> new ModuleBuildTaskImpl((Module)module, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies, includeTests)));
    }

    @Override
    public ProjectTask createBuildTask(boolean isIncrementalBuild, ProjectModelBuildableElement ... buildableElements) {
        return buildableElements.length == 1 ? new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>(buildableElements[0], isIncrementalBuild) : new ProjectTaskList((Collection<? extends ProjectTask>)ContainerUtil.map(Arrays.asList(buildableElements), buildableElement -> new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>((ProjectModelBuildableElement)buildableElement, isIncrementalBuild)));
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public ExecutionEnvironment createProjectTaskExecutionEnvironment(@NotNull ProjectTask projectTask) {
        List<Pair<ProjectTaskRunner, Collection<? extends ProjectTask>>> toRun;
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(6);
        }
        if ((toRun = this.groupByRunner(projectTask)).isEmpty()) {
            return null;
        }
        LinkedHashMap<ProjectTaskRunner, List> tasksMap = new LinkedHashMap<ProjectTaskRunner, List>();
        for (Pair<ProjectTaskRunner, Collection<? extends ProjectTask>> pair : toRun) {
            tasksMap.computeIfAbsent((ProjectTaskRunner)pair.first, runner -> new ArrayList()).addAll((Collection)pair.second);
        }
        if (tasksMap.size() != 1) {
            LOG.debug("Can not create single execution environment for tasks of different runners: '" + tasksMap + "'");
            return null;
        }
        Map.Entry entry = tasksMap.entrySet().iterator().next();
        ProjectTask[] tasks = ((List)entry.getValue()).toArray(EMPTY_TASKS_ARRAY);
        ProjectTaskRunner taskRunner = (ProjectTaskRunner)entry.getKey();
        return taskRunner.createExecutionEnvironment(this.myProject, tasks);
    }

    @Override
    public Promise<ProjectTaskManager.Result> run(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(7);
        }
        return this.run(new ProjectTaskContext(), projectTask);
    }

    @Override
    public Promise<ProjectTaskManager.Result> run(@NotNull ProjectTaskContext context2, @NotNull ProjectTask projectTask) {
        if (context2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(8);
        }
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(9);
        }
        Tracer.Span buildSpan = Tracer.start((String)"build");
        AsyncPromise promiseResult = new AsyncPromise();
        final List<Pair<ProjectTaskRunner, Collection<? extends ProjectTask>>> toRun = this.groupByRunner(projectTask);
        buildSpan.complete();
        context2.putUserData(ProjectTaskScope.KEY, new ProjectTaskScope(){

            @Override
            @NotNull
            public <T extends ProjectTask> List<T> getRequestedTasks(@NotNull Class<T> instanceOf) {
                if (instanceOf == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList tasks = new ArrayList();
                toRun.forEach(pair -> ((Collection)pair.second).stream().filter(instanceOf::isInstance).map(task2 -> task2).forEach(tasks::add));
                ArrayList arrayList = tasks;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instanceOf";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRequestedTasks";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRequestedTasks";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        StructuredIdeActivity activity = this.reportBuildStart(projectTask, toRun);
        this.myEventPublisher.started(context2);
        Runnable runnable = () -> {
            for (ProjectTaskManagerListener listener2 : this.myListeners) {
                try {
                    listener2.beforeRun(context2);
                }
                catch (com.intellij.execution.ExecutionException e) {
                    ProjectTaskManagerImpl.sendAbortedEmptyResult(context2, new ResultConsumer((AsyncPromise<ProjectTaskManager.Result>)promiseResult));
                    activity.finished();
                    return;
                }
            }
            if (toRun.isEmpty()) {
                ProjectTaskManagerImpl.sendSuccessEmptyResult(context2, new ResultConsumer((AsyncPromise<ProjectTaskManager.Result>)promiseResult));
                activity.finished();
                return;
            }
            ProjectTaskResultsAggregator resultsCollector = new ProjectTaskResultsAggregator(context2, new ResultConsumer((AsyncPromise<ProjectTaskManager.Result>)promiseResult), toRun.size(), activity);
            for (Pair pair : toRun) {
                Consumer<ProjectTaskRunner.Result> runnerResultConsumer = result2 -> resultsCollector.add((ProjectTaskRunner.Result)result2, (Collection)pair.second);
                if (((Collection)pair.second).isEmpty()) {
                    runnerResultConsumer.accept(TaskRunnerResults.SUCCESS);
                    continue;
                }
                ProjectTaskRunner runner = (ProjectTaskRunner)pair.first;
                if (context2.isCollectionOfGeneratedFilesEnabled() && !runner.isFileGeneratedEventsSupported()) {
                    ((Collection)pair.second).stream().filter(ModuleBuildTask.class::isInstance).map(task2 -> ((ModuleBuildTask)task2).getModule()).forEach(module -> context2.addDirtyOutputPathsProvider(ProjectTaskManagerImpl.moduleOutputPathsProvider(module)));
                }
                runner.run(this.myProject, context2, ((Collection)pair.second).toArray(EMPTY_TASKS_ARRAY)).onSuccess(runnerResultConsumer).onError(throwable -> runnerResultConsumer.accept(TaskRunnerResults.ABORTED));
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        } else {
            runnable.run();
        }
        promiseResult.onProcessed(result2 -> buildSpan.complete());
        return promiseResult;
    }

    @NotNull
    private StructuredIdeActivity reportBuildStart(@NotNull ProjectTask projectTask, List<Pair<ProjectTaskRunner, Collection<? extends ProjectTask>>> toRun) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(10);
        }
        Ref<Object> incremental = new Ref<Object>(null);
        AtomicInteger modules2 = new AtomicInteger(0);
        ProjectTaskManagerImpl.visitTask(projectTask, tasks -> {
            for (ProjectTask task2 : tasks) {
                if (task2 instanceof BuildTask) {
                    boolean taskIncremental = ((BuildTask)task2).isIncrementalBuild();
                    if (!taskIncremental) {
                        incremental.set(false);
                    } else if (incremental.get() == null) {
                        incremental.set(true);
                    }
                }
                if (!(task2 instanceof ModuleBuildTask)) continue;
                modules2.incrementAndGet();
            }
        });
        SmartList<EventPair> fields = new SmartList<EventPair>();
        fields.add(ProjectTaskManagerStatisticsCollector.TASK_RUNNER.with(ContainerUtil.map(toRun, it -> ((ProjectTaskRunner)it.first).getClass().getName())));
        if (incremental.get() != null) {
            fields.add(ProjectTaskManagerStatisticsCollector.INCREMENTAL.with((Object)incremental.get()));
        }
        if (modules2.get() > 0) {
            fields.add(ProjectTaskManagerStatisticsCollector.MODULES.with((Object)modules2.get()));
        }
        StructuredIdeActivity structuredIdeActivity = ProjectTaskManagerStatisticsCollector.BUILD_ACTIVITY.started(this.myProject, () -> fields);
        if (structuredIdeActivity == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(11);
        }
        return structuredIdeActivity;
    }

    private List<Pair<ProjectTaskRunner, Collection<? extends ProjectTask>>> groupByRunner(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(12);
        }
        SmartList<Pair<ProjectTaskRunner, Collection<? extends ProjectTask>>> toRun = new SmartList<Pair<ProjectTaskRunner, Collection<? extends ProjectTask>>>();
        Consumer<Collection> taskClassifier = tasks -> {
            Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> Arrays.stream(ProjectTaskRunner.EP_NAME.getExtensions()).filter(runner -> {
                try {
                    return runner.canRun(this.myProject, (ProjectTask)aTask);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Broken project task runner: " + runner.getClass().getName(), e);
                    return false;
                }
            }).findFirst().orElse(this.myDummyTaskRunner)));
            for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : toBuild.entrySet()) {
                toRun.add(Pair.create(entry.getKey(), (Collection)entry.getValue()));
            }
        };
        ProjectTaskManagerImpl.visitTask(projectTask, taskClassifier);
        return toRun;
    }

    private static void visitTask(@NotNull ProjectTask projectTask, Consumer<? super Collection<? extends ProjectTask>> taskClassifier) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(13);
        }
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), taskClassifier);
    }

    @ApiStatus.Experimental
    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(14);
        }
        while (true) {
            try {
                return promise.blockingGet(10, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow(e);
            }
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    private static Supplier<List<String>> moduleOutputPathsProvider(@NotNull Module module) {
        if (module == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(15);
        }
        Supplier<List<String>> supplier2 = () -> ReadAction.compute(() -> JBIterable.of(OrderEnumerator.orderEntries(module).withoutSdk().withoutLibraries().getClassesRoots()).filterMap(file2 -> file2.isDirectory() && !file2.getFileSystem().isReadOnly() ? file2.getPath() : null).toList());
        if (supplier2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(16);
        }
        return supplier2;
    }

    public void addListener(@NotNull ProjectTaskManagerListener listener2) {
        if (listener2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(17);
        }
        this.myListeners.add(listener2);
    }

    private static void sendSuccessEmptyResult(@NotNull ProjectTaskContext context2, @NotNull Consumer<? super ProjectTaskManager.Result> resultConsumer) {
        if (context2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(18);
        }
        if (resultConsumer == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(19);
        }
        resultConsumer.accept(new MyResult(context2, Collections.emptyMap(), false, false));
    }

    private static void sendAbortedEmptyResult(@NotNull ProjectTaskContext context2, @NotNull Consumer<? super ProjectTaskManager.Result> resultConsumer) {
        if (context2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(20);
        }
        if (resultConsumer == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(21);
        }
        resultConsumer.accept(new MyResult(context2, Collections.emptyMap(), true, false));
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<? super Collection<? extends ProjectTask>> consumer) {
        if (tasks == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(23);
        }
        if (tasks.isEmpty()) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            List<ProjectTask> taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : ContainerUtil.emptyList());
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer);
        }
        consumer.accept(tasks);
    }

    private Promise<ProjectTaskManager.Result> doBuild(ProjectModelBuildableElement @NotNull [] buildableElements, boolean isIncrementalBuild) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(24);
        }
        return this.run(this.createBuildTask(isIncrementalBuild, buildableElements));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildableElements";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 8: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "reportBuildStart";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleOutputPathsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProjectTaskExecutionEnvironment";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportBuildStart";
                break;
            }
            case 11: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "groupByRunner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitTask";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moduleOutputPathsProvider";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sendSuccessEmptyResult";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sendAbortedEmptyResult";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitTasks";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResultWrapper
    implements ProjectTaskManager.Result {
        private final ProjectTaskManager.Result myResult;

        private ResultWrapper(ProjectTaskManager.Result result2) {
            this.myResult = result2;
        }

        @Override
        @NotNull
        public ProjectTaskContext getContext() {
            ProjectTaskContext projectTaskContext = this.myResult.getContext();
            if (projectTaskContext == null) {
                ResultWrapper.$$$reportNull$$$0(0);
            }
            return projectTaskContext;
        }

        @Override
        public boolean isAborted() {
            return this.myResult.isAborted();
        }

        @Override
        public boolean hasErrors() {
            return this.myResult.hasErrors();
        }

        @Override
        public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> predicate) {
            if (predicate == null) {
                ResultWrapper.$$$reportNull$$$0(1);
            }
            return this.myResult.anyTaskMatches(predicate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl$ResultWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ResultWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "anyTaskMatches";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyResult
    implements ProjectTaskManager.Result {
        private final ProjectTaskContext myContext;
        private final boolean myAborted;
        private final boolean myErrors;
        private final Map<ProjectTask, ProjectTaskState> myTasksState;

        private MyResult(@NotNull ProjectTaskContext context2, @NotNull Map<ProjectTask, ProjectTaskState> tasksState, boolean isAborted, boolean hasErrors) {
            if (context2 == null) {
                MyResult.$$$reportNull$$$0(0);
            }
            if (tasksState == null) {
                MyResult.$$$reportNull$$$0(1);
            }
            this.myContext = context2;
            this.myTasksState = tasksState;
            this.myAborted = isAborted;
            this.myErrors = hasErrors;
        }

        @Override
        @NotNull
        public ProjectTaskContext getContext() {
            ProjectTaskContext projectTaskContext = this.myContext;
            if (projectTaskContext == null) {
                MyResult.$$$reportNull$$$0(2);
            }
            return projectTaskContext;
        }

        @Override
        public boolean isAborted() {
            return this.myAborted;
        }

        @Override
        public boolean hasErrors() {
            return this.myErrors;
        }

        @Override
        public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> predicate) {
            if (predicate == null) {
                MyResult.$$$reportNull$$$0(3);
            }
            return this.myTasksState.entrySet().stream().anyMatch(entry -> predicate.test((ProjectTask)entry.getKey(), (ProjectTaskState)entry.getValue()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasksState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl$MyResult";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$MyResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "anyTaskMatches";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ProjectTaskResultsAggregator {
        private final ProjectTaskContext myContext;
        private final ResultConsumer myResultConsumer;
        private final AtomicInteger myProgressCounter;
        private final StructuredIdeActivity myActivity;
        private final AtomicBoolean myErrorsFlag;
        private final AtomicBoolean myAbortedFlag;
        private final Map<ProjectTask, ProjectTaskState> myTasksState;

        private ProjectTaskResultsAggregator(@NotNull ProjectTaskContext context2, @NotNull ResultConsumer resultConsumer, int expectedResults, @NotNull StructuredIdeActivity activity) {
            if (context2 == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(0);
            }
            if (activity == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(1);
            }
            if (resultConsumer == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(2);
            }
            this.myTasksState = new ConcurrentHashMap<ProjectTask, ProjectTaskState>();
            this.myContext = context2;
            this.myResultConsumer = resultConsumer;
            this.myProgressCounter = new AtomicInteger(expectedResults);
            this.myActivity = activity;
            this.myErrorsFlag = new AtomicBoolean(false);
            this.myAbortedFlag = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(final @NotNull ProjectTaskRunner.Result result2, @NotNull Collection<? extends ProjectTask> tasks) {
            if (result2 == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(3);
            }
            if (tasks == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(4);
            }
            int inProgress = this.myProgressCounter.decrementAndGet();
            ProjectTaskState state = new ProjectTaskState(){

                @Override
                public boolean isSkipped() {
                    return result2.isAborted();
                }

                @Override
                public boolean isFailed() {
                    return result2.hasErrors();
                }
            };
            for (ProjectTask projectTask : tasks) {
                this.myTasksState.put(projectTask, state);
            }
            if (result2.isAborted()) {
                this.myAbortedFlag.set(true);
            }
            if (result2.hasErrors()) {
                this.myErrorsFlag.set(true);
            }
            if (inProgress <= 0) {
                try {
                    this.myResultConsumer.accept(new MyResult(this.myContext, this.myTasksState, this.myAbortedFlag.get(), this.myErrorsFlag.get()));
                }
                finally {
                    this.myActivity.finished(() -> List.of(ProjectTaskManagerStatisticsCollector.HAS_ERRORS.with((Object)this.myErrorsFlag.get())));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultConsumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ProjectTaskResultsAggregator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ResultConsumer
    implements Consumer<ProjectTaskManager.Result> {
        @NotNull
        private final AsyncPromise<ProjectTaskManager.Result> myPromise;

        private ResultConsumer(AsyncPromise<ProjectTaskManager.Result> promise) {
            if (promise == null) {
                ResultConsumer.$$$reportNull$$$0(0);
            }
            this.myPromise = promise;
        }

        @Override
        public void accept(@NotNull ProjectTaskManager.Result result2) {
            if (result2 == null) {
                ResultConsumer.$$$reportNull$$$0(1);
            }
            if (!result2.isAborted() && !result2.hasErrors()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        for (ProjectTaskManagerListener listener2 : ProjectTaskManagerImpl.this.myListeners) {
                            listener2.afterRun(result2);
                        }
                        this.notify(result2);
                    }
                    catch (com.intellij.execution.ExecutionException e) {
                        LOG.debug(e);
                        this.notify(new ResultWrapper(result2){

                            @Override
                            public boolean hasErrors() {
                                return true;
                            }
                        });
                    }
                });
            } else {
                this.notify(result2);
            }
        }

        private void notify(@NotNull ProjectTaskManager.Result result2) {
            if (result2 == null) {
                ResultConsumer.$$$reportNull$$$0(2);
            }
            ModalityUiUtil.invokeLaterIfNeeded(ModalityState.defaultModalityState(), () -> {
                if (!ProjectTaskManagerImpl.this.myProject.isDisposed()) {
                    ProjectTaskManagerImpl.this.myEventPublisher.finished(result2);
                }
                this.myPromise.setResult((Object)result2);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "promise";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ResultConsumer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notify";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DummyTaskRunner
    extends ProjectTaskRunner {
        private DummyTaskRunner() {
        }

        @Override
        public Promise<ProjectTaskRunner.Result> run(@NotNull Project project2, @NotNull ProjectTaskContext context2, ProjectTask ... tasks) {
            if (project2 == null) {
                DummyTaskRunner.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                DummyTaskRunner.$$$reportNull$$$0(1);
            }
            if (tasks == null) {
                DummyTaskRunner.$$$reportNull$$$0(2);
            }
            return Promises.resolvedPromise((Object)TaskRunnerResults.SUCCESS);
        }

        @Override
        public boolean canRun(@NotNull ProjectTask projectTask) {
            if (projectTask == null) {
                DummyTaskRunner.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectTask";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$DummyTaskRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

