/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPassFactory;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

public final class EditorTestUtil {
    public static final String CARET_TAG = "<caret>";
    public static final String CARET_TAG_PREFIX = "<caret>".substring(0, "<caret>".length() - 1);
    public static final String SELECTION_START_TAG = "<selection>";
    public static final String SELECTION_END_TAG = "</selection>";
    public static final String BLOCK_SELECTION_START_TAG = "<block>";
    public static final String BLOCK_SELECTION_END_TAG = "</block>";
    public static final char BACKSPACE_FAKE_CHAR = '\uffff';
    public static final char SMART_ENTER_FAKE_CHAR = '\ufffe';
    public static final char SMART_LINE_SPLIT_CHAR = '\ufffd';
    private static final Comparator<Pair<Integer, String>> MARKERS_COMPARATOR = (o1, o2) -> {
        int first2 = Comparing.compare((Integer)o1.first, (Integer)o2.first);
        return first2 != 0 ? first2 : Comparing.compare((String)o1.second, (String)o2.second);
    };

    public static void performTypingAction(@NotNull Editor editor2, char c) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(0);
        }
        if (c == '\uffff') {
            EditorTestUtil.executeAction(editor2, "EditorBackSpace");
        } else if (c == '\ufffe') {
            EditorTestUtil.executeAction(editor2, "EditorCompleteStatement");
        } else if (c == '\ufffd') {
            EditorTestUtil.executeAction(editor2, "EditorSplitLine");
        } else if (c == '\n') {
            EditorTestUtil.executeAction(editor2, "EditorEnter");
        } else {
            TypedAction action2 = TypedAction.getInstance();
            action2.actionPerformed(editor2, c, DataManager.getInstance().getDataContext((Component)editor2.getContentComponent()));
        }
    }

    public static void executeAction(@NotNull Editor editor2, @NotNull String actionId) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(1);
        }
        if (actionId == null) {
            EditorTestUtil.$$$reportNull$$$0(2);
        }
        EditorTestUtil.executeAction(editor2, actionId, false);
    }

    public static void executeAction(@NotNull Editor editor2, @NotNull String actionId, boolean assertActionIsEnabled) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(3);
        }
        if (actionId == null) {
            EditorTestUtil.$$$reportNull$$$0(4);
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        AnAction action2 = actionManager.getAction(actionId);
        Assert.assertNotNull((Object)action2);
        EditorTestUtil.executeAction(editor2, assertActionIsEnabled, action2);
    }

    public static void executeAction(@NotNull Editor editor2, boolean assertActionIsEnabled, @NotNull AnAction action2) {
        AnActionEvent event;
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            EditorTestUtil.$$$reportNull$$$0(6);
        }
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)(event = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)EditorTestUtil.createEditorContext(editor2))), (boolean)false)) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event);
        } else if (assertActionIsEnabled) {
            Assert.fail((String)("Action " + action2 + " is disabled"));
        }
    }

    @NotNull
    private static DataContext createEditorContext(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(7);
        }
        Editor hostEditor = editor2 instanceof EditorWindow ? ((EditorWindow)editor2).getDelegate() : editor2;
        DataContext parent = DataManager.getInstance().getDataContext((Component)editor2.getContentComponent());
        DataContext dataContext = SimpleDataContext.builder().setParent(parent).add(CommonDataKeys.HOST_EDITOR, (Object)hostEditor).add(CommonDataKeys.EDITOR, (Object)editor2).build();
        if (dataContext == null) {
            EditorTestUtil.$$$reportNull$$$0(8);
        }
        return dataContext;
    }

    public static void performReferenceCopy(Editor editor2) {
        EditorTestUtil.executeAction(editor2, "CopyReference", true);
    }

    public static void performPaste(Editor editor2) {
        EditorTestUtil.executeAction(editor2, "EditorPaste", true);
    }

    public static List<IElementType> getAllTokens(EditorHighlighter highlighter) {
        ArrayList<IElementType> tokens = new ArrayList<IElementType>();
        HighlighterIterator iterator = highlighter.createIterator(0);
        while (!iterator.atEnd()) {
            tokens.add(iterator.getTokenType());
            iterator.advance();
        }
        return tokens;
    }

    public static void checkEditorHighlighter(Project project2, Editor editor2) {
        if (!(editor2 instanceof EditorImpl)) {
            return;
        }
        HighlighterIterator editorIterator = editor2.getHighlighter().createIterator(0);
        EditorHighlighter freshHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, ((EditorEx)editor2).getVirtualFile());
        freshHighlighter.setEditor((HighlighterClient)((EditorImpl)editor2));
        freshHighlighter.setText(editor2.getDocument().getImmutableCharSequence());
        HighlighterIterator freshIterator = freshHighlighter.createIterator(0);
        while (!editorIterator.atEnd() || !freshIterator.atEnd()) {
            if (editorIterator.atEnd() || freshIterator.atEnd() || editorIterator.getTokenType() != freshIterator.getTokenType() || editorIterator.getStart() != freshIterator.getStart() || editorIterator.getEnd() != freshIterator.getEnd()) {
                throw new IllegalStateException("Editor highlighter failed to update incrementally:\nFresh:  " + EditorTestUtil.dumpHighlighter(freshHighlighter) + "\nEditor: " + EditorTestUtil.dumpHighlighter(editor2.getHighlighter()));
            }
            editorIterator.advance();
            freshIterator.advance();
        }
    }

    private static String dumpHighlighter(EditorHighlighter highlighter) {
        HighlighterIterator iterator = highlighter.createIterator(0);
        StringBuilder result2 = new StringBuilder();
        int i = 0;
        while (!iterator.atEnd()) {
            result2.append(i).append(": ").append(iterator.getTokenType()).append(" [").append(iterator.getStart()).append("-").append(iterator.getEnd()).append("], ");
            iterator.advance();
        }
        return result2.toString();
    }

    public static int getCaretPosition(@NotNull String content2) {
        if (content2 == null) {
            EditorTestUtil.$$$reportNull$$$0(9);
        }
        return EditorTestUtil.getCaretAndSelectionPosition(content2)[0];
    }

    public static int[] getCaretAndSelectionPosition(@NotNull String content2) {
        String visualOffsetString;
        if (content2 == null) {
            EditorTestUtil.$$$reportNull$$$0(10);
        }
        int caretPosInSourceFile = content2.indexOf(CARET_TAG_PREFIX);
        int caretEndInSourceFile = content2.indexOf(">", caretPosInSourceFile);
        int caretLength = caretEndInSourceFile - caretPosInSourceFile;
        int visualColumnOffset = 0;
        if (caretPosInSourceFile >= 0 && (visualOffsetString = content2.substring(caretPosInSourceFile + CARET_TAG_PREFIX.length(), caretEndInSourceFile)).length() > 1) {
            visualColumnOffset = Integer.parseInt(visualOffsetString.substring(1));
        }
        int selectionStartInSourceFile = content2.indexOf(SELECTION_START_TAG);
        int selectionEndInSourceFile = content2.indexOf(SELECTION_END_TAG);
        if (selectionStartInSourceFile >= 0) {
            if (caretPosInSourceFile >= 0) {
                if (caretPosInSourceFile < selectionStartInSourceFile) {
                    selectionStartInSourceFile -= caretLength;
                    selectionEndInSourceFile -= caretLength;
                } else {
                    caretPosInSourceFile = caretPosInSourceFile < selectionEndInSourceFile ? (caretPosInSourceFile -= SELECTION_START_TAG.length()) : (caretPosInSourceFile -= SELECTION_START_TAG.length() + SELECTION_END_TAG.length());
                }
            }
            selectionEndInSourceFile -= SELECTION_START_TAG.length();
        }
        return new int[]{caretPosInSourceFile, visualColumnOffset, selectionStartInSourceFile, selectionEndInSourceFile};
    }

    @TestOnly
    public static boolean configureSoftWraps(Editor editor2, int charCountToWrapAt) {
        return EditorTestUtil.configureSoftWraps(editor2, charCountToWrapAt, true);
    }

    @TestOnly
    public static boolean configureSoftWraps(Editor editor2, int charCountToWrapAt, boolean useCustomSoftWrapIndent) {
        int charWidthInPixels = 10;
        return EditorTestUtil.configureSoftWraps(editor2, (charCountToWrapAt + 1) * charWidthInPixels + 1, 1000, charWidthInPixels, useCustomSoftWrapIndent);
    }

    @TestOnly
    public static boolean configureSoftWrapsAndViewport(Editor editor2, int charCountToWrapAt, int visibleLineCount) {
        int charWidthInPixels = 10;
        return EditorTestUtil.configureSoftWraps(editor2, (charCountToWrapAt + 1) * charWidthInPixels + 1, visibleLineCount * editor2.getLineHeight(), charWidthInPixels);
    }

    @TestOnly
    public static boolean configureSoftWraps(Editor editor2, int visibleWidth, int charWidthInPixels) {
        return EditorTestUtil.configureSoftWraps(editor2, visibleWidth, 1000, charWidthInPixels);
    }

    @TestOnly
    public static boolean configureSoftWraps(Editor editor2, int visibleWidthInPixels, int visibleHeightInPixels, int charWidthInPixels) {
        return EditorTestUtil.configureSoftWraps(editor2, visibleWidthInPixels, visibleHeightInPixels, charWidthInPixels, true);
    }

    @TestOnly
    public static boolean configureSoftWraps(Editor editor2, int visibleWidthInPixels, int visibleHeightInPixels, final int charWidthInPixels, boolean useCustomSoftWrapIndent) {
        editor2.getSettings().setUseSoftWraps(true);
        editor2.getSettings().setUseCustomSoftWrapIndent(useCustomSoftWrapIndent);
        SoftWrapModelImpl model2 = (SoftWrapModelImpl)editor2.getSoftWrapModel();
        model2.setSoftWrapPainter(new SoftWrapPainter(){

            public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
                if (g == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (drawingType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return charWidthInPixels;
            }

            public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
                if (g == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (drawingType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return charWidthInPixels;
            }

            public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
                if (drawingType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return charWidthInPixels;
            }

            public boolean canUse() {
                return true;
            }

            public void reinit() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "drawingType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDrawingHorizontalOffset";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getMinDrawingWidth";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        model2.reinitSettings();
        SoftWrapApplianceManager applianceManager = model2.getApplianceManager();
        applianceManager.setWidthProvider((SoftWrapApplianceManager.VisibleAreaWidthProvider)new TestWidthProvider(visibleWidthInPixels));
        EditorTestUtil.setEditorVisibleSizeInPixels(editor2, visibleWidthInPixels, visibleHeightInPixels);
        applianceManager.registerSoftWrapIfNecessary();
        return !model2.getRegisteredSoftWraps().isEmpty();
    }

    public static void setEditorVisibleSize(Editor editor2, int widthInChars, int heightInChars) {
        EditorTestUtil.setEditorVisibleSizeInPixels(editor2, widthInChars * EditorUtil.getSpaceWidth((int)0, (Editor)editor2), heightInChars * editor2.getLineHeight());
    }

    public static void setEditorVisibleSizeInPixels(Editor editor2, int widthInPixels, int heightInPixels) {
        Dimension size = new Dimension(widthInPixels, heightInPixels);
        ((EditorEx)editor2).getScrollPane().getViewport().setExtentSize(size);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document) {
        if (document == null) {
            EditorTestUtil.$$$reportNull$$$0(11);
        }
        return EditorTestUtil.extractCaretAndSelectionMarkers(document, true);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document, boolean processBlockSelection) {
        if (document == null) {
            EditorTestUtil.$$$reportNull$$$0(12);
        }
        CaretAndSelectionState caretAndSelectionState = WriteCommandAction.writeCommandAction(null).compute(() -> EditorTestUtil.extractCaretAndSelectionMarkersImpl(document, processBlockSelection));
        if (caretAndSelectionState == null) {
            EditorTestUtil.$$$reportNull$$$0(13);
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkersImpl(@NotNull Document document, boolean processBlockSelection) {
        if (document == null) {
            EditorTestUtil.$$$reportNull$$$0(14);
        }
        ArrayList<CaretInfo> carets = new ArrayList<CaretInfo>();
        String fileText = document.getText();
        RangeMarker blockSelectionStartMarker = null;
        RangeMarker blockSelectionEndMarker = null;
        if (processBlockSelection) {
            int blockSelectionEnd;
            int blockSelectionStart = fileText.indexOf(BLOCK_SELECTION_START_TAG);
            if ((blockSelectionStart ^ (blockSelectionEnd = fileText.indexOf(BLOCK_SELECTION_END_TAG))) < 0) {
                throw new IllegalArgumentException("Both block selection opening and closing tag must be present");
            }
            if (blockSelectionStart >= 0) {
                blockSelectionStartMarker = document.createRangeMarker(blockSelectionStart, blockSelectionStart);
                blockSelectionEndMarker = document.createRangeMarker(blockSelectionEnd, blockSelectionEnd);
                document.deleteString(blockSelectionStartMarker.getStartOffset(), blockSelectionStartMarker.getStartOffset() + BLOCK_SELECTION_START_TAG.length());
                document.deleteString(blockSelectionEndMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset() + BLOCK_SELECTION_END_TAG.length());
            }
        }
        boolean multiCaret = StringUtil.getOccurrenceCount(document.getText(), CARET_TAG) > 1 || StringUtil.getOccurrenceCount(document.getText(), SELECTION_START_TAG) > 1;
        int pos = 0;
        while (pos < document.getTextLength()) {
            RangeMarker selEndMarker;
            int selEndIndex;
            fileText = document.getText();
            int caretIndex = fileText.indexOf(CARET_TAG, pos);
            int selStartIndex = fileText.indexOf(SELECTION_START_TAG, pos);
            if ((selStartIndex ^ (selEndIndex = fileText.indexOf(SELECTION_END_TAG, pos))) < 0) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (0 <= selEndIndex && selEndIndex < selStartIndex) {
                throw new IllegalArgumentException("Wrong order of selection opening and closing tags");
            }
            if (caretIndex < 0 && selStartIndex < 0 && selEndIndex < 0) break;
            if (multiCaret && 0 <= caretIndex && caretIndex < selStartIndex) {
                selStartIndex = -1;
                selEndIndex = -1;
            }
            if (multiCaret && caretIndex > selEndIndex && selEndIndex >= 0) {
                caretIndex = -1;
            }
            RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
            RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
            RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
            if (caretMarker != null) {
                document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_TAG.length());
            }
            if (selStartMarker != null) {
                document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_TAG.length());
            }
            if (selEndMarker != null) {
                document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_TAG.length());
            }
            LogicalPosition caretPosition = null;
            if (caretMarker != null) {
                int line = document.getLineNumber(caretMarker.getStartOffset());
                int column = caretMarker.getStartOffset() - document.getLineStartOffset(line);
                caretPosition = new LogicalPosition(line, column);
            }
            carets.add(new CaretInfo(caretPosition, selStartMarker == null || selEndMarker == null ? null : new TextRange(selStartMarker.getStartOffset(), selEndMarker.getEndOffset())));
            pos = Math.max(caretMarker == null ? -1 : caretMarker.getStartOffset(), selEndMarker == null ? -1 : selEndMarker.getEndOffset());
        }
        if (carets.isEmpty()) {
            carets.add(new CaretInfo(null, null));
        }
        TextRange blockSelection = null;
        if (blockSelectionStartMarker != null) {
            blockSelection = new TextRange(blockSelectionStartMarker.getStartOffset(), blockSelectionEndMarker.getStartOffset());
        }
        return new CaretAndSelectionState(Arrays.asList(carets.toArray(new CaretInfo[0])), blockSelection);
    }

    public static void setCaretsAndSelection(Editor editor2, CaretAndSelectionState caretsState) {
        CaretModel caretModel = editor2.getCaretModel();
        ArrayList<CaretState> states = new ArrayList<CaretState>(caretsState.carets.size());
        for (CaretInfo caret : caretsState.carets) {
            states.add(new CaretState(caret.position == null ? null : editor2.offsetToLogicalPosition(caret.getCaretOffset(editor2.getDocument())), caret.selection == null ? null : editor2.offsetToLogicalPosition(caret.selection.getStartOffset()), caret.selection == null ? null : editor2.offsetToLogicalPosition(caret.selection.getEndOffset())));
        }
        caretModel.setCaretsAndSelections(states);
        if (caretsState.blockSelection != null) {
            editor2.getSelectionModel().setBlockSelection(editor2.offsetToLogicalPosition(caretsState.blockSelection.getStartOffset()), editor2.offsetToLogicalPosition(caretsState.blockSelection.getEndOffset()));
        }
    }

    public static void verifyCaretAndSelectionState(Editor editor2, CaretAndSelectionState caretState) {
        EditorTestUtil.verifyCaretAndSelectionState(editor2, caretState, null);
    }

    public static void verifyCaretAndSelectionState(Editor editor2, CaretAndSelectionState caretState, String message2) {
        boolean hasChecks = false;
        for (int i = 0; i < caretState.carets.size(); ++i) {
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position == null && expected.selection == null) continue;
            hasChecks = true;
            break;
        }
        if (!hasChecks) {
            return;
        }
        try {
            EditorTestUtil.doVerifyCaretAndSelectionState(editor2, caretState, message2);
        }
        catch (AssertionError e) {
            try {
                Assert.assertEquals((String)((Throwable)((Object)e)).getMessage(), (Object)CaretAndSelectionMarkup.renderExpectedState(editor2, caretState.carets), (Object)CaretAndSelectionMarkup.renderActualState(editor2));
            }
            catch (AssertionError exception) {
                ((Throwable)((Object)exception)).addSuppressed((Throwable)((Object)e));
                throw exception;
            }
            throw e;
        }
    }

    private static void doVerifyCaretAndSelectionState(Editor editor2, CaretAndSelectionState caretState, String message2) {
        Object messageSuffix = message2 == null ? "" : message2 + ": ";
        CaretModel caretModel = editor2.getCaretModel();
        ArrayList allCarets = new ArrayList(caretModel.getAllCarets());
        Assert.assertEquals((String)((String)messageSuffix + " Unexpected number of carets"), (long)caretState.carets.size(), (long)allCarets.size());
        for (int i = 0; i < caretState.carets.size(); ++i) {
            String caretDescription = caretState.carets.size() == 1 ? "" : "caret " + (i + 1) + "/" + caretState.carets.size() + " ";
            Caret currentCaret = (Caret)allCarets.get(i);
            int actualCaretLine = editor2.getDocument().getLineNumber(currentCaret.getOffset());
            int actualCaretColumn = currentCaret.getOffset() - editor2.getDocument().getLineStartOffset(actualCaretLine);
            LogicalPosition actualCaretPosition = new LogicalPosition(actualCaretLine, actualCaretColumn);
            int selectionStart = currentCaret.getSelectionStart();
            int selectionEnd = currentCaret.getSelectionEnd();
            LogicalPosition actualSelectionStart = editor2.offsetToLogicalPosition(selectionStart);
            LogicalPosition actualSelectionEnd = editor2.offsetToLogicalPosition(selectionEnd);
            CaretInfo expected = caretState.carets.get(i);
            if (expected.position != null) {
                Assert.assertEquals((String)((String)messageSuffix + caretDescription + "unexpected caret position"), (Object)expected.position, (Object)actualCaretPosition);
            }
            if (expected.selection != null) {
                LogicalPosition expectedSelectionStart = editor2.offsetToLogicalPosition(expected.selection.getStartOffset());
                LogicalPosition expectedSelectionEnd = editor2.offsetToLogicalPosition(expected.selection.getEndOffset());
                Assert.assertEquals((String)((String)messageSuffix + caretDescription + "unexpected selection start"), (Object)expectedSelectionStart, (Object)actualSelectionStart);
                Assert.assertEquals((String)((String)messageSuffix + caretDescription + "unexpected selection end"), (Object)expectedSelectionEnd, (Object)actualSelectionEnd);
                continue;
            }
            Assert.assertFalse((String)((String)messageSuffix + caretDescription + "should has no selection, but was: (" + actualSelectionStart + ", " + actualSelectionEnd + ")"), (boolean)currentCaret.hasSelection());
        }
    }

    public static void testFileSyntaxHighlighting(@NotNull PsiFile testFile, @NotNull String answerFilePath, boolean allowUnhandledTokens) {
        IElementType tokenType;
        if (testFile == null) {
            EditorTestUtil.$$$reportNull$$$0(15);
        }
        if (answerFilePath == null) {
            EditorTestUtil.$$$reportNull$$$0(16);
        }
        TestCase.assertNotNull((String)"Fixture has no file", (Object)testFile);
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)testFile.getFileType(), (Project)testFile.getProject(), (VirtualFile)testFile.getVirtualFile());
        TestCase.assertNotNull((String)"Syntax highlighter not found", (Object)syntaxHighlighter);
        Lexer highlightingLexer = syntaxHighlighter.getHighlightingLexer();
        TestCase.assertNotNull((String)"Highlighting lexer not found", (Object)highlightingLexer);
        String fileText = testFile.getText();
        highlightingLexer.start(fileText);
        StringBuilder sb = new StringBuilder();
        HashSet<IElementType> notHighlightedTokens = new HashSet<IElementType>();
        while ((tokenType = highlightingLexer.getTokenType()) != null) {
            TextAttributesKey[] highlights = syntaxHighlighter.getTokenHighlights(tokenType);
            if (highlights.length > 0) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                String token = fileText.substring(highlightingLexer.getTokenStart(), highlightingLexer.getTokenEnd());
                if (StringUtil.isEmptyOrSpaces(token = token.replace(' ', '\u2423'))) {
                    token = token.replace("\n", "\\n");
                }
                sb.append(token).append("\n");
                SmartList<String> attrNames = new SmartList<String>();
                for (TextAttributesKey attributesKey : highlights) {
                    attrNames.add("    " + EditorTestUtil.serializeTextAttributeKey(attributesKey));
                }
                sb.append(StringUtil.join(attrNames, "\n"));
            } else if (!StringUtil.isEmptyOrSpaces(highlightingLexer.getTokenText())) {
                notHighlightedTokens.add(tokenType);
            }
            highlightingLexer.advance();
        }
        if (!allowUnhandledTokens && !notHighlightedTokens.isEmpty()) {
            TestCase.fail((String)("Some tokens have no highlighting: " + notHighlightedTokens));
        }
        UsefulTestCase.assertSameLinesWithFile(answerFilePath, sb.toString());
    }

    private static String serializeTextAttributeKey(@Nullable TextAttributesKey key) {
        if (key == null) {
            return "";
        }
        String keyName = key.getExternalName();
        TextAttributesKey fallbackKey = key.getFallbackAttributeKey();
        TestCase.assertNotSame((Object)fallbackKey, (Object)key);
        return fallbackKey == null ? keyName : keyName + " => " + EditorTestUtil.serializeTextAttributeKey(fallbackKey);
    }

    public static FoldRegion addFoldRegion(@NotNull Editor editor2, int startOffset, int endOffset, String placeholder, boolean collapse) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(17);
        }
        FoldingModel foldingModel = editor2.getFoldingModel();
        Ref ref = new Ref();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion region = foldingModel.addFoldRegion(startOffset, endOffset, placeholder);
            Assert.assertNotNull((Object)region);
            region.setExpanded(!collapse);
            ref.set(region);
        });
        return (FoldRegion)ref.get();
    }

    public static Inlay addInlay(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(18);
        }
        return EditorTestUtil.addInlay(editor2, offset, false);
    }

    public static Inlay addInlay(@NotNull Editor editor2, int offset, boolean relatesToPrecedingText) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(19);
        }
        return EditorTestUtil.addInlay(editor2, offset, relatesToPrecedingText, 1);
    }

    public static Inlay addInlay(@NotNull Editor editor2, int offset, boolean relatesToPrecedingText, int widthInPixels) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(20);
        }
        return editor2.getInlayModel().addInlineElement(offset, relatesToPrecedingText, (EditorCustomElementRenderer)new EmptyInlayRenderer(widthInPixels));
    }

    public static Inlay addBlockInlay(@NotNull Editor editor2, int offset, boolean relatesToPrecedingText, boolean showAbove, int widthInPixels, Integer heightInPixels) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(21);
        }
        return EditorTestUtil.addBlockInlay(editor2, offset, relatesToPrecedingText, showAbove, false, widthInPixels, heightInPixels);
    }

    public static Inlay addBlockInlay(@NotNull Editor editor2, int offset, boolean relatesToPrecedingText, boolean showAbove, boolean showWhenFolded, int widthInPixels, Integer heightInPixels) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(22);
        }
        return editor2.getInlayModel().addBlockElement(offset, new InlayProperties().relatesToPrecedingText(relatesToPrecedingText).showAbove(showAbove).showWhenFolded(showWhenFolded), (EditorCustomElementRenderer)new EmptyInlayRenderer(widthInPixels, heightInPixels));
    }

    public static Inlay addAfterLineEndInlay(@NotNull Editor editor2, int offset, int widthInPixels) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(23);
        }
        return editor2.getInlayModel().addAfterLineEndElement(offset, false, (EditorCustomElementRenderer)new EmptyInlayRenderer(widthInPixels));
    }

    @Nullable
    public static CustomFoldRegion addCustomFoldRegion(@NotNull Editor editor2, int startLine, int endLine) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(24);
        }
        return EditorTestUtil.addCustomFoldRegion(editor2, startLine, endLine, 1);
    }

    @Nullable
    public static CustomFoldRegion addCustomFoldRegion(@NotNull Editor editor2, int startLine, int endLine, int heightInPixels) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(25);
        }
        return EditorTestUtil.addCustomFoldRegion(editor2, startLine, endLine, 0, heightInPixels);
    }

    @Nullable
    public static CustomFoldRegion addCustomFoldRegion(@NotNull Editor editor2, int startLine, int endLine, int widthInPixels, int heightInPixels) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(26);
        }
        CustomFoldRegion[] result2 = new CustomFoldRegion[1];
        FoldingModel model2 = editor2.getFoldingModel();
        model2.runBatchFoldingOperation(() -> {
            result2[0] = model2.addCustomLinesFolding(startLine, endLine, (CustomFoldRegionRenderer)new EmptyCustomFoldingRenderer(widthInPixels, heightInPixels));
        });
        return result2[0];
    }

    public static void waitForLoading(Editor editor2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (EditorUtil.isRealFileEditor((Editor)editor2)) {
            UIUtil.dispatchAllInvocationEvents();
            while (!AsyncEditorLoader.isEditorLoaded((Editor)editor2)) {
                LockSupport.parkNanos(100000000L);
                UIUtil.dispatchAllInvocationEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testUndoInEditor(@NotNull Editor editor2, @NotNull Runnable runnable) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(27);
        }
        if (runnable == null) {
            EditorTestUtil.$$$reportNull$$$0(28);
        }
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
        Project project2 = editor2.getProject();
        Assert.assertNotNull((Object)project2);
        UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance(project2);
        CurrentEditorProvider savedProvider = undoManager.getEditorProvider();
        undoManager.setEditorProvider(() -> EditorTestUtil.lambda$testUndoInEditor$4((FileEditor)fileEditor));
        try {
            runnable.run();
        }
        finally {
            undoManager.setEditorProvider(savedProvider);
        }
    }

    @NotNull
    public static String getTextWithCaretsAndSelections(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(29);
        }
        return EditorTestUtil.getTextWithCaretsAndSelections(editor2, true, true);
    }

    @NotNull
    public static String getTextWithCaretsAndSelections(@NotNull Editor editor2, boolean addCarets, boolean addSelections) {
        if (editor2 == null) {
            EditorTestUtil.$$$reportNull$$$0(30);
        }
        StringBuilder sb = new StringBuilder(editor2.getDocument().getCharsSequence());
        ContainerUtil.reverse(editor2.getCaretModel().getAllCarets()).forEach(caret -> ContainerUtil.reverse(EditorTestUtil.getCaretMacros(caret, addCarets, addSelections)).forEach(pair -> sb.insert((int)((Integer)pair.first), (String)pair.second)));
        String string2 = sb.toString();
        if (string2 == null) {
            EditorTestUtil.$$$reportNull$$$0(31);
        }
        return string2;
    }

    @NotNull
    public static List<Pair<Integer, String>> getCaretMacros(@NotNull Caret caret, boolean position, boolean selection) {
        if (caret == null) {
            EditorTestUtil.$$$reportNull$$$0(32);
        }
        if (!position && !selection) {
            List<Pair<Integer, String>> list2 = Collections.emptyList();
            if (list2 == null) {
                EditorTestUtil.$$$reportNull$$$0(33);
            }
            return list2;
        }
        boolean addSelection = selection && caret.hasSelection();
        ArrayList<Pair<Integer, String>> result2 = new ArrayList<Pair<Integer, String>>();
        if (addSelection) {
            result2.add(Pair.create(caret.getSelectionStart(), SELECTION_START_TAG));
        }
        if (position) {
            result2.add(Pair.create(caret.getOffset(), CARET_TAG));
        }
        if (addSelection) {
            result2.add(Pair.create(caret.getSelectionEnd(), SELECTION_END_TAG));
        }
        result2.sort(Pair.comparingByFirst());
        ArrayList<Pair<Integer, String>> arrayList = result2;
        if (arrayList == null) {
            EditorTestUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public static void checkEditorHighlighting(@NotNull CodeInsightTestFixture fixture, @NotNull String answersFilePath, @Nullable Set<String> acceptableKeyNames) {
        Editor editor2;
        CaretModel caretModel;
        List<Integer> caretsOffsets;
        if (fixture == null) {
            EditorTestUtil.$$$reportNull$$$0(35);
        }
        if (answersFilePath == null) {
            EditorTestUtil.$$$reportNull$$$0(36);
        }
        if ((caretsOffsets = ContainerUtil.map((caretModel = (editor2 = fixture.getEditor()).getCaretModel()).getAllCarets(), Caret::getOffset)).isEmpty()) {
            caretsOffsets.add(-1);
        }
        caretModel.removeSecondaryCarets();
        CharSequence documentSequence = editor2.getDocument().getCharsSequence();
        IdentifierHighlighterPassFactory.doWithHighlightingEnabled(fixture.getProject(), fixture.getProjectDisposable(), () -> {
            for (Integer caretsOffset : caretsOffsets) {
                if (caretsOffset != -1) {
                    caretModel.moveToOffset(caretsOffset.intValue());
                }
                UsefulTestCase.assertSameLinesWithFile(answersFilePath, EditorTestUtil.renderTextWithHighlihgtingInfos(fixture.doHighlighting(), documentSequence, acceptableKeyNames), () -> "Failed at:\n " + documentSequence.subSequence(0, caretsOffset) + CARET_TAG + documentSequence.subSequence(caretsOffset, documentSequence.length()) + "\n");
            }
        });
    }

    @NotNull
    private static String renderTextWithHighlihgtingInfos(@NotNull List<HighlightInfo> highlightInfos, @NotNull CharSequence documentSequence, @Nullable Set<String> acceptableKeyNames) {
        if (highlightInfos == null) {
            EditorTestUtil.$$$reportNull$$$0(37);
        }
        if (documentSequence == null) {
            EditorTestUtil.$$$reportNull$$$0(38);
        }
        List sortedMarkers = highlightInfos.stream().flatMap(it -> {
            String keyText = it.type.getAttributesKey().toString();
            if (acceptableKeyNames != null && !acceptableKeyNames.contains(keyText)) {
                return Stream.empty();
            }
            return Stream.of(Pair.create(it.getStartOffset(), "<" + keyText + ">"), Pair.create(it.getEndOffset(), "</" + keyText + ">"));
        }).sorted(MARKERS_COMPARATOR).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        int lastEnd = 0;
        for (Pair marker : sortedMarkers) {
            Integer startOffset = (Integer)marker.first;
            if (startOffset > lastEnd) {
                sb.append(documentSequence.subSequence(lastEnd, startOffset));
                lastEnd = startOffset;
            }
            sb.append((String)marker.second);
        }
        String string2 = sb.append(documentSequence.subSequence(lastEnd, documentSequence.length())).toString();
        if (string2 == null) {
            EditorTestUtil.$$$reportNull$$$0(39);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void saveEncodingsIn(@NotNull Project project2, Charset newIdeCharset, Charset newProjectCharset, @NotNull ThrowableRunnable<E> task2) throws E {
        if (project2 == null) {
            EditorTestUtil.$$$reportNull$$$0(40);
        }
        if (task2 == null) {
            EditorTestUtil.$$$reportNull$$$0(41);
        }
        EncodingManager encodingManager = EncodingManager.getInstance();
        String oldIde = encodingManager.getDefaultCharsetName();
        if (newIdeCharset != null) {
            encodingManager.setDefaultCharsetName(newIdeCharset.name());
        }
        EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance(project2);
        String oldProject = encodingProjectManager.getDefaultCharsetName();
        if (newProjectCharset != null) {
            encodingProjectManager.setDefaultCharsetName(newProjectCharset.name());
        }
        try {
            task2.run();
        }
        finally {
            if (newIdeCharset != null) {
                encodingManager.setDefaultCharsetName(oldIde);
            }
            if (newProjectCharset != null) {
                encodingProjectManager.setDefaultCharsetName(oldProject);
            }
        }
    }

    private static /* synthetic */ FileEditor lambda$testUndoInEditor$4(FileEditor fileEditor) {
        return fileEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 31: 
            case 33: 
            case 34: 
            case 39: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 31: 
            case 33: 
            case 34: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: 
            case 13: 
            case 31: 
            case 33: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/EditorTestUtil";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answerFilePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answersFilePath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfos";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentSequence";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCaretAndSelectionMarkers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithCaretsAndSelections";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretMacros";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "renderTextWithHighlihgtingInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performTypingAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditorContext";
                break;
            }
            case 8: 
            case 13: 
            case 31: 
            case 33: 
            case 34: 
            case 39: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCaretPosition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAndSelectionPosition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkersImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "testFileSyntaxHighlighting";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addInlay";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addBlockInlay";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addAfterLineEndInlay";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addCustomFoldRegion";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "testUndoInEditor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithCaretsAndSelections";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCaretMacros";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkEditorHighlighting";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "renderTextWithHighlihgtingInfos";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "saveEncodingsIn";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 13: 
            case 31: 
            case 33: 
            case 34: 
            case 39: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TestWidthProvider
    implements SoftWrapApplianceManager.VisibleAreaWidthProvider {
        private int myWidth;

        public TestWidthProvider(int width) {
            this.setVisibleAreaWidth(width);
        }

        public int getVisibleAreaWidth() {
            return this.myWidth;
        }

        public void setVisibleAreaWidth(int width) {
            this.myWidth = width;
        }
    }

    private static class EmptyCustomFoldingRenderer
    implements CustomFoldRegionRenderer {
        private final int myWidth;
        private final int myHeight;

        private EmptyCustomFoldingRenderer(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public int calcWidthInPixels(@NotNull CustomFoldRegion region) {
            if (region == null) {
                EmptyCustomFoldingRenderer.$$$reportNull$$$0(0);
            }
            return this.myWidth;
        }

        public int calcHeightInPixels(@NotNull CustomFoldRegion region) {
            if (region == null) {
                EmptyCustomFoldingRenderer.$$$reportNull$$$0(1);
            }
            return this.myHeight;
        }

        public void paint(@NotNull CustomFoldRegion region, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
            if (region == null) {
                EmptyCustomFoldingRenderer.$$$reportNull$$$0(2);
            }
            if (g == null) {
                EmptyCustomFoldingRenderer.$$$reportNull$$$0(3);
            }
            if (targetRegion == null) {
                EmptyCustomFoldingRenderer.$$$reportNull$$$0(4);
            }
            if (textAttributes == null) {
                EmptyCustomFoldingRenderer.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "region";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRegion";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$EmptyCustomFoldingRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcHeightInPixels";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class EmptyInlayRenderer
    implements EditorCustomElementRenderer {
        private final int width;
        private final Integer height;

        private EmptyInlayRenderer(int width) {
            this(width, null);
        }

        private EmptyInlayRenderer(int width, Integer height) {
            this.width = width;
            this.height = height;
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                EmptyInlayRenderer.$$$reportNull$$$0(0);
            }
            return this.width;
        }

        public int calcHeightInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                EmptyInlayRenderer.$$$reportNull$$$0(1);
            }
            return this.height == null ? super.calcHeightInPixels(inlay) : this.height.intValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "inlay";
            objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$EmptyInlayRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcHeightInPixels";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CaretInfo {
        @Nullable
        public final LogicalPosition position;
        @Nullable
        public final TextRange selection;

        public CaretInfo(@Nullable LogicalPosition position, @Nullable TextRange selection) {
            this.position = position;
            this.selection = selection;
        }

        public int getCaretOffset(Document document) {
            return this.position == null ? -1 : document.getLineStartOffset(this.position.line) + this.position.column;
        }
    }

    public static class CaretAndSelectionState {
        public final List<CaretInfo> carets;
        public final TextRange blockSelection;

        public CaretAndSelectionState(List<CaretInfo> carets, @Nullable TextRange blockSelection) {
            this.carets = carets;
            this.blockSelection = blockSelection;
        }

        public boolean hasExplicitCaret() {
            if (this.carets.isEmpty()) {
                return false;
            }
            if (this.blockSelection == null && this.carets.size() == 1) {
                CaretInfo caret = this.carets.get(0);
                return caret.position != null || caret.selection != null;
            }
            return true;
        }
    }

    private static class CaretAndSelectionMarkup {
        @NotNull
        private final ArrayList<Pair<Integer, String>> marks = new ArrayList();

        private CaretAndSelectionMarkup() {
        }

        @NotNull
        static String renderActualState(@NotNull Editor editor2) {
            if (editor2 == null) {
                CaretAndSelectionMarkup.$$$reportNull$$$0(0);
            }
            CaretAndSelectionMarkup markup = new CaretAndSelectionMarkup();
            for (Caret caret : editor2.getCaretModel().getAllCarets()) {
                boolean hasSelection = caret.hasSelection();
                if (hasSelection) {
                    markup.addMark(caret.getSelectionStart(), EditorTestUtil.SELECTION_START_TAG);
                }
                markup.addMark(caret.getOffset(), EditorTestUtil.CARET_TAG);
                if (!hasSelection) continue;
                markup.addMark(caret.getSelectionEnd(), EditorTestUtil.SELECTION_END_TAG);
            }
            return markup.insertMarks(editor2.getDocument().getCharsSequence());
        }

        @NotNull
        static String renderExpectedState(@NotNull Editor editor2, @NotNull List<CaretInfo> carets) {
            if (editor2 == null) {
                CaretAndSelectionMarkup.$$$reportNull$$$0(1);
            }
            if (carets == null) {
                CaretAndSelectionMarkup.$$$reportNull$$$0(2);
            }
            CaretAndSelectionMarkup markup = new CaretAndSelectionMarkup();
            for (CaretInfo expected : carets) {
                LogicalPosition position = expected.position;
                TextRange selection = expected.selection;
                if (selection != null) {
                    markup.addMark(selection.getStartOffset(), EditorTestUtil.SELECTION_START_TAG);
                }
                if (position != null) {
                    markup.addMark(editor2.getDocument().getLineStartOffset(position.line) + position.column, EditorTestUtil.CARET_TAG);
                }
                if (selection == null) continue;
                markup.addMark(selection.getEndOffset(), EditorTestUtil.SELECTION_END_TAG);
            }
            return markup.insertMarks(editor2.getDocument().getCharsSequence());
        }

        private void addMark(int offset, @NotNull String s) {
            if (s == null) {
                CaretAndSelectionMarkup.$$$reportNull$$$0(3);
            }
            Pair<Integer, String> mark = Pair.create(offset, s);
            this.marks.add(mark);
        }

        @NotNull
        private String insertMarks(@NotNull @NlsSafe CharSequence text2) {
            if (text2 == null) {
                CaretAndSelectionMarkup.$$$reportNull$$$0(4);
            }
            StringBuilder sb = new StringBuilder(text2);
            this.marks.sort(Comparator.comparingInt(mark -> (Integer)mark.first));
            for (int i = this.marks.size() - 1; i >= 0; --i) {
                Pair<Integer, String> mark2 = this.marks.get(i);
                int offset = (Integer)mark2.first;
                if (0 <= offset && offset <= sb.length()) {
                    sb.insert(offset, (String)mark2.second);
                    continue;
                }
                sb.insert(Math.max(0, Math.min(offset, sb.length())), "!!!" + (String)mark2.second + "@[" + offset + "]");
            }
            String string2 = sb.toString();
            if (string2 == null) {
                CaretAndSelectionMarkup.$$$reportNull$$$0(5);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "carets";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/EditorTestUtil$CaretAndSelectionMarkup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$CaretAndSelectionMarkup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertMarks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "renderActualState";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "renderExpectedState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addMark";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "insertMarks";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

