/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public abstract class FileEditorManagerTestCase
extends BasePlatformTestCase {
    protected FileEditorManagerImpl myManager;
    protected int myInitialContainers;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myManager = new FileEditorManagerImpl(this.getProject());
        ServiceContainerUtil.registerComponentInstance(this.getProject(), FileEditorManager.class, this.myManager, this.getTestRootDisposable());
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
        this.myInitialContainers = DockManager.getInstance((Project)this.getProject()).getContainers().size();
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.getProject();
        RunAll.runAll(() -> this.myManager.closeAllFiles(), () -> {
            if (project2 != null) {
                EditorHistoryManager.getInstance((Project)project2).removeAllFiles();
            }
        }, () -> ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders(), () -> Disposer.dispose((Disposable)this.myManager), () -> {
            this.myManager = null;
            if (project2 != null) {
                DockManager dockManager = project2.getServiceIfCreated(DockManager.class);
                Set containers = dockManager == null ? Collections.emptySet() : dockManager.getContainers();
                FileEditorManagerTestCase.assertSize(this.myInitialContainers, containers);
            }
        }, () -> super.tearDown());
    }

    @NotNull
    protected VirtualFile getFile(@NotNull String path2) {
        if (path2 == null) {
            FileEditorManagerTestCase.$$$reportNull$$$0(0);
        }
        String fullPath = this.getTestDataPath() + path2;
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        FileEditorManagerTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file2);
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 == null) {
            FileEditorManagerTestCase.$$$reportNull$$$0(1);
        }
        return virtualFile2;
    }

    @NotNull
    protected VirtualFile createFile(@NotNull String path2, byte @NotNull [] content2) {
        if (path2 == null) {
            FileEditorManagerTestCase.$$$reportNull$$$0(2);
        }
        if (content2 == null) {
            FileEditorManagerTestCase.$$$reportNull$$$0(3);
        }
        File io = new File(this.getTestDataPath() + path2);
        try {
            FileUtil.writeToFile(io, content2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(io);
        FileEditorManagerTestCase.assertNotNull((String)("Can't find " + io), (Object)file2);
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 == null) {
            FileEditorManagerTestCase.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    protected void openFiles(@NotNull String femSerialisedText) throws IOException, JDOMException, InterruptedException, ExecutionException {
        if (femSerialisedText == null) {
            FileEditorManagerTestCase.$$$reportNull$$$0(5);
        }
        Element rootElement = JDOMUtil.load(femSerialisedText);
        ExpandMacroToPathMap map2 = new ExpandMacroToPathMap();
        map2.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map2.substitute(rootElement, true, true);
        this.myManager.loadState(rootElement);
        Future<?> future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> this.myManager.getMainSplitters().openFiles());
        while (true) {
            try {
                future2.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/FileEditorManagerTestCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "femSerialisedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/FileEditorManagerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openFiles";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

