/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

final class IoTimings {
    private static final int WARM_UP_PROBES = 2;
    private static final int IO_PROBES = 42;

    IoTimings() {
    }

    static long calcIoTiming() {
        long start2 = System.nanoTime();
        for (int i = 0; i < 2; ++i) {
            IoTimings.singleIteration(i, true);
        }
        long warmupMinutes = TimeUnit.NANOSECONDS.toMinutes(System.nanoTime() - start2);
        if (warmupMinutes > 1L) {
            System.out.println("Too long warmup: " + warmupMinutes + " minutes");
        }
        start2 = System.nanoTime();
        for (int i = 0; i < 42; ++i) {
            IoTimings.singleIteration(i, i == 41);
        }
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2);
    }

    private static void singleIteration(int i, boolean doSync) {
        try {
            File tempFile = FileUtil.createTempFile("test", "test" + i);
            try (FileWriter writer = new FileWriter(tempFile);){
                for (int j = 0; j < 15; ++j) {
                    writer.write("test" + j);
                    writer.flush();
                }
            }
            try (FileReader reader = new FileReader(tempFile);){
                while (reader.read() >= 0) {
                }
            }
            if (doSync) {
                try (FileOutputStream stream = new FileOutputStream(tempFile);){
                    stream.getFD().sync();
                }
            }
            if (!tempFile.delete()) {
                throw new IOException("Unable to delete: " + tempFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

