/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.project.TestProjectManager;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorCache;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class LeakHunter {
    @TestOnly
    public static void checkProjectLeak() throws AssertionError {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault() && !project2.isLight());
    }

    @TestOnly
    public static void checkNonDefaultProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, (? super T project2) -> !project2.isDefault());
    }

    @TestOnly
    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(0);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(1);
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(2);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(3);
        }
        LeakHunter.processLeaks(rootsSupplier, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String place = leaked instanceof Project ? TestProjectManager.getCreationPlace((Project)leaked) : "";
            String message2 = "Found leaked " + leaked.getClass() + ": " + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place + "\n" + backLink;
            System.out.println(message2);
            System.out.println(";-----");
            UsefulTestCase.printThreadDump();
            throw new AssertionError((Object)message2);
        });
    }

    @TestOnly
    public static <T> void processLeaks(@NotNull Supplier<? extends Map<Object, String>> rootsSupplier, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor) throws AssertionError {
        if (rootsSupplier == null) {
            LeakHunter.$$$reportNull$$$0(4);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            LeakHunter.$$$reportNull$$$0(6);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorCache.clearCacheForTests();
        Runnable runnable = () -> {
            try (AccessToken ignored = ProhibitAWTEvents.start((String)"checking for leaks");){
                DebugReflectionUtil.walkObjects(10000, (Map)rootsSupplier.get(), suspectClass, __ -> true, (leaked, backLink) -> {
                    if (isReallyLeak == null || isReallyLeak.test(leaked)) {
                        return processor.process(leaked, backLink);
                    }
                    return true;
                });
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            runnable.run();
        } else {
            application.runReadAction(runnable);
        }
    }

    @TestOnly
    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Predicate<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            LeakHunter.$$$reportNull$$$0(7);
        }
        if (suspectClass == null) {
            LeakHunter.$$$reportNull$$$0(8);
        }
        LeakHunter.checkLeak(() -> Collections.singletonMap(root, "Root object"), suspectClass, isReallyLeak);
    }

    @TestOnly
    @NotNull
    public static Supplier<Map<Object, String>> allRoots() {
        Supplier<Map<Object, String>> supplier2 = () -> {
            ClassLoader classLoader = LeakHunter.class.getClassLoader();
            Collection allLoadedClasses = ReflectionUtil.getField(classLoader.getClass(), classLoader, Vector.class, "classes");
            LaterInvocator.purgeExpiredItems();
            IdentityHashMap<Object, String> result2 = new IdentityHashMap<Object, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                result2.put(application, "ApplicationManager.getApplication()");
            }
            result2.put(Disposer.getTree(), "Disposer.getTree()");
            result2.put(IdeEventQueue.getInstance(), "IdeEventQueue.getInstance()");
            result2.put(LaterInvocator.getLaterInvocatorEdtQueue(), "LaterInvocator.getLaterInvocatorEdtQueue()");
            result2.put(ThreadTracker.getThreads().values(), "all live threads");
            if (allLoadedClasses != null) {
                result2.put(allLoadedClasses, "all loaded classes statics");
            }
            return result2;
        };
        if (supplier2 == null) {
            LeakHunter.$$$reportNull$$$0(9);
        }
        return supplier2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspectClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsSupplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LeakHunter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "allRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processLeaks";
                break;
            }
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

