/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.testFramework.AbstractMockGlyphVector;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.function.IntToDoubleFunction;
import org.jetbrains.annotations.NotNull;

public class MockFontLayoutService
extends FontLayoutService {
    private final IntToDoubleFunction myCharWidthFunction;
    private final int myCharWidth;
    private final int myLineHeight;
    private final int myDescent;

    public MockFontLayoutService(int charWidth, int lineHeight, int descent) {
        this.myCharWidthFunction = null;
        this.myCharWidth = charWidth;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    public MockFontLayoutService(IntToDoubleFunction charWidthFunction, int lineHeight, int descent) {
        this.myCharWidthFunction = charWidthFunction;
        this.myCharWidth = -1;
        this.myLineHeight = lineHeight;
        this.myDescent = descent;
    }

    @NotNull
    public GlyphVector layoutGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, char @NotNull [] chars, int start2, int end, boolean isRtl) {
        if (font == null) {
            MockFontLayoutService.$$$reportNull$$$0(0);
        }
        if (fontRenderContext == null) {
            MockFontLayoutService.$$$reportNull$$$0(1);
        }
        if (chars == null) {
            MockFontLayoutService.$$$reportNull$$$0(2);
        }
        return new MockGlyphVector(Arrays.copyOfRange(chars, start2, end), isRtl);
    }

    private double getCharWidth(int codePoint) {
        return this.myCharWidthFunction == null ? (double)this.myCharWidth : (double)((float)this.myCharWidthFunction.applyAsDouble(codePoint));
    }

    public int charWidth(@NotNull FontMetrics fontMetrics, char c) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(3);
        }
        return (int)this.getCharWidth(c);
    }

    public int charWidth(@NotNull FontMetrics fontMetrics, int codePoint) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(4);
        }
        return (int)this.getCharWidth(codePoint);
    }

    public float charWidth2D(@NotNull FontMetrics fontMetrics, int codePoint) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(5);
        }
        return (float)this.getCharWidth(codePoint);
    }

    public int stringWidth(@NotNull FontMetrics fontMetrics, @NotNull String str) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(6);
        }
        if (str == null) {
            MockFontLayoutService.$$$reportNull$$$0(7);
        }
        if (this.myCharWidthFunction == null) {
            return this.myCharWidth * str.codePointCount(0, str.length());
        }
        float width = 0.0f;
        int pos = 0;
        while (pos < str.length()) {
            width = (float)((double)width + this.myCharWidthFunction.applyAsDouble(str.codePointAt(pos)));
            pos = str.offsetByCodePoints(pos, 1);
        }
        return Math.round(width);
    }

    public int getHeight(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(8);
        }
        return this.myLineHeight;
    }

    public int getDescent(@NotNull FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            MockFontLayoutService.$$$reportNull$$$0(9);
        }
        return this.myDescent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontRenderContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/MockFontLayoutService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "layoutGlyphVector";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "charWidth";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "charWidth2D";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "stringWidth";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getHeight";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MockGlyphVector
    extends AbstractMockGlyphVector {
        private final char[] myChars;
        private final boolean myIsRtl;

        private MockGlyphVector(char[] chars, boolean isRtl) {
            this.myChars = chars;
            this.myIsRtl = isRtl;
        }

        @Override
        public int getNumGlyphs() {
            return this.myChars.length;
        }

        @Override
        public int getGlyphCharIndex(int glyphIndex) {
            return this.myIsRtl ? this.myChars.length - 1 - glyphIndex : glyphIndex;
        }

        @Override
        public Point2D getGlyphPosition(int glyphIndex) {
            double x = 0.0;
            if (MockFontLayoutService.this.myCharWidthFunction == null) {
                x = glyphIndex * MockFontLayoutService.this.myCharWidth;
            } else {
                for (int i = 0; i < glyphIndex; ++i) {
                    x += MockFontLayoutService.this.myCharWidthFunction.applyAsDouble(this.myChars[this.getGlyphCharIndex(i)]);
                }
            }
            return new Point2D.Double(x, 0.0);
        }

        @Override
        public Shape getGlyphLogicalBounds(int glyphIndex) {
            Point2D position = this.getGlyphPosition(glyphIndex);
            return new Rectangle2D.Double(position.getX(), position.getY() - (double)MockFontLayoutService.this.myDescent, MockFontLayoutService.this.myCharWidth, MockFontLayoutService.this.myLineHeight);
        }

        @Override
        public int getGlyphCode(int glyphIndex) {
            return this.myChars[glyphIndex];
        }
    }
}

