/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.toolWindow.ToolWindowHeadlessManagerImpl;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Function;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class ProjectViewTestUtil {
    public static VirtualFile[] getFiles(AbstractTreeNode<?> kid, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        VirtualFile[] result2;
        if (kid instanceof BasePsiNode) {
            Object value = kid.getValue();
            VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)value);
            return new VirtualFile[]{virtualFile2};
        }
        if (converterFunction != null && (result2 = converterFunction.fun(kid)) != null) {
            return result2;
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public static void collect(AbstractTreeNode node2, MultiValuesMap<VirtualFile, AbstractTreeNode<?>> map2, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        Object[] kids;
        for (Object kid1 : kids = structure.getChildElements((Object)node2)) {
            VirtualFile[] files2;
            ProjectViewNode kid = (ProjectViewNode)((Object)kid1);
            for (VirtualFile vFile : files2 = ProjectViewTestUtil.getFiles(kid, converterFunction)) {
                map2.put(vFile, kid);
                for (ProjectViewNode eachParent = (ProjectViewNode)kid.getParent(); eachParent != null; eachParent = (ProjectViewNode)eachParent.getParent()) {
                    map2.put(vFile, eachParent);
                }
            }
            ProjectViewTestUtil.collect(kid, map2, structure, converterFunction);
        }
    }

    public static void checkContainsMethod(Object rootElement, AbstractTreeStructure structure, Function<? super AbstractTreeNode<?>, VirtualFile[]> converterFunction) {
        MultiValuesMap map2 = new MultiValuesMap();
        ProjectViewTestUtil.collect((AbstractTreeNode)rootElement, map2, structure, converterFunction);
        for (VirtualFile eachFile : map2.keySet()) {
            Collection<AbstractTreeNode<?>> nodes = map2.values();
            for (AbstractTreeNode<?> node2 : nodes) {
                boolean expected;
                ProjectViewNode eachNode = (ProjectViewNode)node2;
                boolean actual = eachNode.contains(eachFile);
                if (actual == (expected = map2.get(eachFile).contains((Object)eachNode))) continue;
                Assert.fail((String)("file=" + eachFile + "\n node=" + eachNode.getTestPresentation() + " expected:" + expected));
            }
        }
    }

    public static void checkGetParentConsistency(AbstractTreeStructure structure, Object from) {
        Object[] childElements;
        for (Object childElement : childElements = structure.getChildElements(from)) {
            Assert.assertSame((Object)from, (Object)structure.getParentElement(childElement));
            ProjectViewTestUtil.checkGetParentConsistency(structure, childElement);
        }
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.assertStructureEqual(structure, expected, 27, null, structure.getRootElement(), printInfo);
    }

    public static void assertStructureEqual(AbstractTreeStructure structure, String expected, int maxRowCount, @Nullable Comparator comparator2, Object rootNode, @Nullable Queryable.PrintInfo printInfo) {
        ProjectViewTestUtil.checkGetParentConsistency(structure, rootNode);
        String actual = PlatformTestUtil.print(structure, rootNode, 0, comparator2, maxRowCount, ' ', printInfo).toString();
        Assert.assertEquals((Object)expected.trim(), (Object)actual.trim());
    }

    public static boolean isExpanded(PsiElement element2, AbstractProjectViewPSIPane pane) {
        return null != ProjectViewTestUtil.getVisiblePath(element2, pane);
    }

    @Nullable
    public static TreePath getVisiblePath(@NotNull PsiElement element2, @NotNull AbstractProjectViewPSIPane pane) {
        if (element2 == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(0);
        }
        if (pane == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(1);
        }
        PlatformTestUtil.waitWhileBusy(pane.getTree());
        return TreeUtil.visitVisibleRows((JTree)pane.getTree(), path2 -> {
            AbstractTreeNode node2 = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path2);
            return node2 != null && element2.equals(node2.getValue()) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
        });
    }

    public static void setupImpl(@NotNull Project project2, boolean loadPaneExtensions) {
        ToolWindowHeadlessManagerImpl toolWindowManager;
        ToolWindow toolWindow;
        if (project2 == null) {
            ProjectViewTestUtil.$$$reportNull$$$0(2);
        }
        if ((toolWindow = (toolWindowManager = (ToolWindowHeadlessManagerImpl)ToolWindowManager.getInstance((Project)project2)).getToolWindow("Project")) == null) {
            for (ToolWindowEP bean : ToolWindowEP.EP_NAME.getExtensionList()) {
                if (!bean.id.equals("Project")) continue;
                toolWindow = toolWindowManager.doRegisterToolWindow(bean.id);
                break;
            }
        }
        assert (toolWindow != null);
        LafManager.getInstance();
        ((ProjectViewImpl)ProjectView.getInstance(project2)).setupImpl(toolWindow, loadPaneExtensions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/ProjectViewTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisiblePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

