/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

@TestOnly
public final class SdkLeakTracker {
    private final Sdk @NotNull [] oldSdks;

    public SdkLeakTracker() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        this.oldSdks = table == null ? new Sdk[]{} : table.getAllJdks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForJdkTableLeaks() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        if (table == null) {
            return;
        }
        Sdk[] jdks = table.getAllJdks();
        if (jdks.length == 0) {
            return;
        }
        Set<Sdk> leaked = ContainerUtil.set(jdks);
        Set<Sdk> old = ContainerUtil.set(this.oldSdks);
        leaked.removeAll(old);
        try {
            if (!leaked.isEmpty()) {
                String message2 = "Leaked SDKs: " + leaked + ". Please remove leaking SDKs by e.g. ProjectJdkTable.getInstance().removeJdk() or by disposing the ProjectJdkImpl";
                Pair<Sdk, Throwable> withTrace = this.findSdkWithRegistrationTrace(leaked);
                if (withTrace != null) {
                    throw new AssertionError(message2 + ". Registration trace for '" + ((Sdk)withTrace.first).getName() + "' is shown as the cause", (Throwable)withTrace.second);
                }
                Assert.fail((String)message2);
            }
        }
        finally {
            for (Sdk jdk : leaked) {
                WriteAction.run(() -> table.removeJdk(jdk));
            }
        }
    }

    private Pair<Sdk, Throwable> findSdkWithRegistrationTrace(Set<Sdk> sdks) {
        for (Sdk sdk2 : sdks) {
            Throwable trace;
            if (!(sdk2 instanceof Disposable) || (trace = Disposer.getRegistrationTrace((Disposable)((Object)sdk2))) == null) continue;
            return new Pair<Sdk, Throwable>(sdk2, trace);
        }
        return null;
    }
}

