/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class BasePlatformTestCase
extends UsefulTestCase {
    protected CodeInsightTestFixture myFixture;

    @Override
    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.myFixture == null ? super.getTestRootDisposable() : this.myFixture.getTestRootDisposable();
        if (disposable == null) {
            BasePlatformTestCase.$$$reportNull$$$0(0);
        }
        return disposable;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IdeaTestFixtureFactory factory2 = IdeaTestFixtureFactory.getFixtureFactory();
        TestFixtureBuilder<IdeaProjectTestFixture> fixtureBuilder = factory2.createLightFixtureBuilder(this.getProjectDescriptor(), this.getTestName(false));
        IdeaProjectTestFixture fixture = fixtureBuilder.getFixture();
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(fixture, this.createTempDirTestFixture());
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myFixture.setUp();
    }

    protected TempDirTestFixture createTempDirTestFixture() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        return policy != null ? policy.createTempDirTestFixture() : new LightTempDirTestFixtureImpl(true);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myFixture = null;
            super.tearDown();
        }
    }

    protected String getBasePath() {
        return "";
    }

    protected LightProjectDescriptor getProjectDescriptor() {
        return null;
    }

    protected String getTestDataPath() {
        String path2 = this.isCommunity() ? PlatformTestUtil.getCommunityPath() : IdeaTestExecutionPolicy.getHomePathWithPolicy();
        return StringUtil.trimEnd(FileUtil.toSystemIndependentName(path2), "/") + "/" + StringUtil.trimStart(FileUtil.toSystemIndependentName(this.getBasePath()), "/");
    }

    protected boolean isCommunity() {
        return false;
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            BasePlatformTestCase.$$$reportNull$$$0(1);
        }
        if (this.isWriteActionRequired()) {
            WriteCommandAction.writeCommandAction(this.getProject()).run(() -> super.runTestRunnable(testRunnable));
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    protected boolean isWriteActionRequired() {
        return false;
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected PsiManager getPsiManager() {
        return PsiManager.getInstance(this.getProject());
    }

    protected PsiFile createLightFile(FileType fileType, String text2) {
        return PsiFileFactory.getInstance(this.getProject()).createFileFromText("a." + fileType.getDefaultExtension(), fileType, (CharSequence)text2);
    }

    public PsiFile createLightFile(String fileName, Language language, String text2) {
        return PsiFileFactory.getInstance(this.getProject()).createFileFromText(fileName, language, (CharSequence)text2, false, true);
    }

    @NotNull
    protected Module getModule() {
        Module module = this.myFixture.getModule();
        if (module == null) {
            BasePlatformTestCase.$$$reportNull$$$0(2);
        }
        return module;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/BasePlatformTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/BasePlatformTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

