/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.InjectionAssertionData;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a-\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u00a2\u0006\u0002\u0010\n\u001a/\u0010\u000b\u001a\u00020\u0005*\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000f\u001a.\u0010\u000b\u001a\u00020\u0005\"\u0006\b\u0000\u0010\u0010\u0018\u0001*\u00020\u00062\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003H\u0086\b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"injectionForHost", "Lcom/intellij/testFramework/fixtures/InjectionAssertionData;", "text", "", "assertInjectedLanguage", "", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "langId", "fragmentTexts", "", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;Ljava/lang/String;[Ljava/lang/String;)V", "assertInjectedReference", "referenceClass", "Ljava/lang/Class;", "referenceTexts", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;Ljava/lang/Class;[Ljava/lang/String;)V", "T", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;[Ljava/lang/String;)V", "intellij.platform.testFramework"})
public final class InjectionTestFixtureKt {
    @NotNull
    public static final InjectionAssertionData injectionForHost(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return new InjectionAssertionData(text2, null, 2, null);
    }

    public static final void assertInjectedLanguage(@NotNull CodeInsightTestFixture $this$assertInjectedLanguage, @Nullable String langId, String ... fragmentTexts) {
        Intrinsics.checkNotNullParameter((Object)$this$assertInjectedLanguage, (String)"$this$assertInjectedLanguage");
        Intrinsics.checkNotNullParameter((Object)fragmentTexts, (String)"fragmentTexts");
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable($this$assertInjectedLanguage, fragmentTexts, langId){
            final /* synthetic */ CodeInsightTestFixture $this_assertInjectedLanguage$inlined;
            final /* synthetic */ String[] $fragmentTexts$inlined;
            final /* synthetic */ String $langId$inlined;
            {
                this.$this_assertInjectedLanguage$inlined = codeInsightTestFixture;
                this.$fragmentTexts$inlined = stringArray;
                this.$langId$inlined = string2;
            }

            public final T compute() {
                boolean bl = false;
                InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(this.$this_assertInjectedLanguage$inlined.getProject());
                Editor editor2 = this.$this_assertInjectedLanguage$inlined.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                Document doc = document;
                for (String text2 : this.$fragmentTexts$inlined) {
                    String string2 = doc.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"doc.text");
                    int index = StringsKt.indexOf$default((CharSequence)string2, (String)text2, (int)0, (boolean)false, (int)6, null);
                    if (index < 0) {
                        Assert.fail((String)("No such text in document: " + text2));
                    }
                    int pos = index + text2.length() / 2;
                    PsiElement injectedElement = injectedLanguageManager.findInjectedElementAt(this.$this_assertInjectedLanguage$inlined.getFile(), pos);
                    if (this.$langId$inlined != null) {
                        Assert.assertNotNull((String)("There should be injected element at " + pos + " with text '" + text2 + "'"), (Object)injectedElement);
                        PsiElement psiElement = injectedElement;
                        Intrinsics.checkNotNull((Object)psiElement);
                        Language language = psiElement.getLanguage();
                        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"injectedElement!!.language");
                        Assert.assertEquals((String)"Injected Language don't match", (Object)this.$langId$inlined, (Object)language.getID());
                        continue;
                    }
                    Assert.assertNull((String)("There should be no injected element at " + pos + " with text '" + text2 + "'"), (Object)injectedElement);
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public static final void assertInjectedReference(@NotNull CodeInsightTestFixture $this$assertInjectedReference, @NotNull Class<?> referenceClass, String ... referenceTexts) {
        Intrinsics.checkNotNullParameter((Object)$this$assertInjectedReference, (String)"$this$assertInjectedReference");
        Intrinsics.checkNotNullParameter(referenceClass, (String)"referenceClass");
        Intrinsics.checkNotNullParameter((Object)referenceTexts, (String)"referenceTexts");
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable($this$assertInjectedReference, referenceTexts, referenceClass){
            final /* synthetic */ CodeInsightTestFixture $this_assertInjectedReference$inlined;
            final /* synthetic */ String[] $referenceTexts$inlined;
            final /* synthetic */ Class $referenceClass$inlined;
            {
                this.$this_assertInjectedReference$inlined = codeInsightTestFixture;
                this.$referenceTexts$inlined = stringArray;
                this.$referenceClass$inlined = clazz;
            }

            public final T compute() {
                boolean bl = false;
                PsiFile psiFile = this.$this_assertInjectedReference$inlined.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file");
                FileViewProvider fileViewProvider = psiFile.getViewProvider();
                Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file.viewProvider");
                FileViewProvider provider2 = fileViewProvider;
                Editor editor2 = this.$this_assertInjectedReference$inlined.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                String string2 = document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"editor.document.text");
                String documentText = string2;
                for (String refText : this.$referenceTexts$inlined) {
                    PsiReference psiReference;
                    block5: {
                        PsiReference[] psiReferenceArray;
                        PsiLanguageInjectionHost psiLanguageInjectionHost;
                        int pos = StringsKt.indexOf$default((CharSequence)documentText, (String)refText, (int)0, (boolean)false, (int)6, null) + refText.length() / 2;
                        PsiElement element2 = provider2.findElementAt(pos);
                        Assert.assertNotNull((String)("There should be element at " + pos), (Object)element2);
                        PsiElement psiElement = element2;
                        if (!(psiElement instanceof PsiLanguageInjectionHost)) {
                            psiElement = null;
                        }
                        if ((psiLanguageInjectionHost = (PsiLanguageInjectionHost)psiElement) == null) {
                            PsiElement psiElement2 = element2;
                            Intrinsics.checkNotNull((Object)psiElement2);
                            PsiElement psiElement3 = psiElement2.getParent();
                            if (!(psiElement3 instanceof PsiLanguageInjectionHost)) {
                                psiElement3 = null;
                            }
                            psiLanguageInjectionHost = (PsiLanguageInjectionHost)psiElement3;
                        }
                        PsiLanguageInjectionHost host = psiLanguageInjectionHost;
                        Assert.assertNotNull((String)("There should be injection host at " + pos), (Object)host);
                        PsiLanguageInjectionHost psiLanguageInjectionHost2 = host;
                        Intrinsics.checkNotNull((Object)psiLanguageInjectionHost2);
                        PsiReference[] references = psiLanguageInjectionHost2.getReferences();
                        Intrinsics.checkNotNullExpressionValue((Object)references, (String)"references");
                        PsiReference[] psiReferenceArray2 = references;
                        Assert.assertTrue((String)"There should be references in element", (!(psiReferenceArray2.length == 0) ? 1 : 0) != 0);
                        PsiReference[] psiReferenceArray3 = psiReferenceArray = references;
                        int n = psiReferenceArray3.length;
                        for (int i = 0; i < n; ++i) {
                            PsiReference psiReference2;
                            PsiReference it = psiReference2 = psiReferenceArray3[i];
                            boolean bl2 = false;
                            if (!this.$referenceClass$inlined.isInstance(it)) continue;
                            psiReference = psiReference2;
                            break block5;
                        }
                        psiReference = null;
                    }
                    PsiReference reference2 = psiReference;
                    Assert.assertNotNull((String)("There should be reference of type " + this.$referenceClass$inlined + " in element"), reference2);
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public static final /* synthetic */ <T> void assertInjectedReference(CodeInsightTestFixture $this$assertInjectedReference, String ... fragmentTexts) {
        int $i$f$assertInjectedReference = 0;
        Intrinsics.checkNotNullParameter((Object)$this$assertInjectedReference, (String)"$this$assertInjectedReference");
        Intrinsics.checkNotNullParameter((Object)fragmentTexts, (String)"fragmentTexts");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        InjectionTestFixtureKt.assertInjectedReference($this$assertInjectedReference, Object.class, Arrays.copyOf(fragmentTexts, fragmentTexts.length));
    }
}

