/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.IdeView;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.project.TestProjectManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.OpenProjectTaskBuilderKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

final class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements HeavyIdeaTestFixture {
    private Project myProject;
    private volatile Module myModule;
    private final Set<Path> myFilesToDelete;
    private final Set<ModuleFixtureBuilder<?>> myModuleFixtureBuilders;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private final String mySanitizedName;
    private final Path myProjectPath;
    private final boolean myIsDirectoryBasedProject;
    private SdkLeakTracker myOldSdks;
    private AccessToken projectTracker;

    HeavyIdeaTestFixtureImpl(@NotNull String name2, @Nullable Path projectPath, boolean isDirectoryBasedProject) {
        if (name2 == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(0);
        }
        this.myFilesToDelete = new HashSet<Path>();
        this.myModuleFixtureBuilders = new LinkedHashSet();
        this.mySanitizedName = FileUtil.sanitizeFileName(name2, false);
        this.myProjectPath = projectPath;
        this.myIsDirectoryBasedProject = isDirectoryBasedProject;
    }

    void addModuleFixtureBuilder(ModuleFixtureBuilder<?> builder2) {
        this.myModuleFixtureBuilders.add(builder2);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        this.projectTracker = ((TestProjectManager)((Object)ProjectManager.getInstance())).startTracking();
        this.setUpProject();
        EncodingManager.getInstance();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        InjectedLanguageManagerImpl.pushInjectors(this.getProject());
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() {
        ArrayList actions2 = new ArrayList();
        if (this.myProject != null) {
            Project project2 = this.myProject;
            actions2.add(() -> {
                TestApplicationManagerKt.tearDownProjectAndApp(this.myProject);
                this.myProject = null;
            });
            for (ModuleFixtureBuilder<?> moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                actions2.add(() -> moduleFixtureBuilder.getFixture().tearDown());
            }
            actions2.add(() -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project2));
        }
        JarFileSystemImpl.cleanupForNextTest();
        for (Path fileToDelete : this.myFilesToDelete) {
            actions2.add(() -> {
                List errors;
                try (Stream<Path> stream = Files.walk(fileToDelete, new FileVisitOption[0]);){
                    errors = stream.sorted(Comparator.reverseOrder()).map(x -> {
                        try {
                            Files.delete(x);
                            return null;
                        }
                        catch (IOException e) {
                            return e;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                }
                catch (NoSuchFileException ignore) {
                    errors = Collections.emptyList();
                }
                CompoundRuntimeException.throwIfNotEmpty(errors);
            });
        }
        actions2.add(() -> {
            AccessToken projectTracker = this.projectTracker;
            if (projectTracker != null) {
                this.projectTracker = null;
                projectTracker.finish();
            }
        });
        actions2.add(() -> super.tearDown());
        actions2.add(() -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        });
        actions2.add(() -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        });
        actions2.add(() -> LightPlatformTestCase.checkEditorsReleased());
        actions2.add(() -> {
            if (this.myOldSdks != null) {
                this.myOldSdks.checkForJdkTableLeaks();
            }
        });
        actions2.add(() -> HeavyPlatformTestCase.cleanupApplicationCaches(null));
        new RunAll(actions2).run();
    }

    private void setUpProject() throws Exception {
        OpenProjectTask options = OpenProjectTaskBuilderKt.createTestOpenProjectOptions(true).withBeforeOpenCallback(project2 -> {
            project2.getMessageBus().simpleConnect().subscribe(ProjectTopics.MODULES, new ModuleListener(){

                @Override
                public void moduleAdded(@NotNull Project __, @NotNull Module module) {
                    if (__ == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (module == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (HeavyIdeaTestFixtureImpl.this.myModule == null) {
                        HeavyIdeaTestFixtureImpl.this.myModule = module;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "__";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "module";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl$1";
                    objectArray[2] = "moduleAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return true;
        });
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
        }
        this.myProject = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().openProject(this.generateProjectPath(), options));
        EdtTestUtil.runInEdtAndWait(() -> {
            for (ModuleFixtureBuilder<?> moduleFixtureBuilder : this.myModuleFixtureBuilders) {
                moduleFixtureBuilder.getFixture().setUp();
            }
            LightPlatformTestCase.clearUncommittedDocuments(this.myProject);
            ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        });
    }

    @NotNull
    private Path generateProjectPath() {
        Path tempDirectory;
        if (this.myProjectPath == null) {
            tempDirectory = TemporaryDirectory.generateTemporaryPath(this.mySanitizedName);
            this.myFilesToDelete.add(tempDirectory);
        } else {
            tempDirectory = this.myProjectPath;
        }
        Path path2 = tempDirectory.resolve(this.mySanitizedName + (this.myIsDirectoryBasedProject ? "" : ".ipr"));
        if (path2 == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(1);
        }
        return path2;
    }

    private void initApplication() {
        TestApplicationManager.getInstance().setDataProvider(new MyDataProvider());
    }

    @Override
    public Project getProject() {
        Assert.assertNotNull((String)"setUp() should be called first", (Object)this.myProject);
        return this.myProject;
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }

    @Override
    public PsiFile addFileToProject(@NotNull @NonNls String rootPath, @NotNull @NonNls String relativePath, @NotNull @NonNls String fileText) throws IOException {
        if (rootPath == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(3);
        }
        if (fileText == null) {
            HeavyIdeaTestFixtureImpl.$$$reportNull$$$0(4);
        }
        VirtualFile dir = VfsUtil.createDirectories(rootPath + "/" + PathUtil.getParentPath(relativePath));
        VirtualFile[] virtualFile2 = new VirtualFile[1];
        WriteCommandAction.writeCommandAction(this.getProject()).run(() -> {
            virtualFile2[0] = dir.createChildData(this, StringUtil.getShortName(relativePath, '/'));
            VfsUtil.saveText(virtualFile2[0], fileText);
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        });
        return ReadAction.compute(() -> PsiManager.getInstance(this.getProject()).findFile(virtualFile2[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFileToProject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            VirtualFile[] contentRoots;
            if (dataId == null) {
                MyDataProvider.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return HeavyIdeaTestFixtureImpl.this.myProject;
            }
            if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                if (HeavyIdeaTestFixtureImpl.this.myProject == null || HeavyIdeaTestFixtureImpl.this.myProject.isDisposed()) {
                    return null;
                }
                return FileEditorManager.getInstance(HeavyIdeaTestFixtureImpl.this.myProject).getSelectedTextEditor();
            }
            Editor editor2 = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
            if (editor2 != null) {
                if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
                    return TextEditorProvider.getInstance().getTextEditor(editor2);
                }
                FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)HeavyIdeaTestFixtureImpl.this.myProject);
                return manager.getData(dataId, editor2, editor2.getCaretModel().getCurrentCaret());
            }
            if (LangDataKeys.IDE_VIEW.is(dataId) && (contentRoots = ProjectRootManager.getInstance(HeavyIdeaTestFixtureImpl.this.myProject).getContentRoots()).length > 0) {
                final PsiDirectory psiDirectory = PsiManager.getInstance(HeavyIdeaTestFixtureImpl.this.myProject).findDirectory(contentRoots[0]);
                return new IdeView(){

                    public PsiDirectory @NotNull [] getDirectories() {
                        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                        if (psiDirectoryArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return psiDirectoryArray;
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl$MyDataProvider$1", "getDirectories"));
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl$MyDataProvider", "getData"));
        }
    }
}

