/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.Synthetic;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.testFramework.DisposableRule;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RuleChain;
import com.intellij.testFramework.rules.ProjectModelRule;
import com.intellij.testFramework.rules.ProjectModelRule$disposeOnTearDown$;
import com.intellij.testFramework.rules.TempDirectory;
import com.intellij.util.Consumer;
import com.intellij.util.io.PathKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.storage.EntityStorageSnapshot;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001lB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0:JK\u0010=\u001a\u0002H>\"\u000e\b\u0000\u0010>*\b\u0012\u0004\u0012\u0002H@0?\"\b\b\u0001\u0010@*\u00020A2\u0006\u0010B\u001a\u00020C2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u0002H@0E2\b\b\u0002\u0010F\u001a\u0002H@\u00a2\u0006\u0002\u0010GJ,\u0010H\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010I\u001a\u00020\u001e2\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0:J,\u0010J\u001a\u0002062\u0006\u0010B\u001a\u00020C2\u0006\u00107\u001a\u0002082\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0:J$\u0010K\u001a\u0002062\u0006\u00107\u001a\u0002082\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<0:J$\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0014\b\u0002\u00109\u001a\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020<0:J\"\u0010P\u001a\u00020Q2\u0006\u0010B\u001a\u00020C2\u0006\u0010R\u001a\u0002082\n\u0010S\u001a\u0006\u0012\u0002\b\u00030TJ\u0018\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020V2\u0006\u0010X\u001a\u00020YH\u0016J\u0016\u0010Z\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010[\u001a\u00020\\J\u0010\u0010]\u001a\u00020C2\b\b\u0002\u00107\u001a\u000208J\u0016\u0010]\u001a\u00020C2\u0006\u00107\u001a\u0002082\u0006\u0010^\u001a\u00020_J\u0010\u0010`\u001a\u00020M2\b\b\u0002\u00107\u001a\u000208J\u0010\u0010a\u001a\u00020<2\u0006\u0010b\u001a\u000206H\u0002J\u0018\u0010c\u001a\n d*\u0004\u0018\u00010&0&2\u0006\u00107\u001a\u000208H\u0002J\u0012\u0010e\u001a\u00020<2\n\u0010f\u001a\u0006\u0012\u0002\b\u00030?J\u000e\u0010g\u001a\u00020<2\u0006\u0010B\u001a\u00020CJ\u0016\u0010h\u001a\u00020<2\u0006\u0010b\u001a\u00020i2\u0006\u0010j\u001a\u000208J\u0016\u0010k\u001a\u00020<2\u0006\u0010B\u001a\u00020C2\u0006\u0010j\u001a\u000208R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0015\u0010!\u001a\u00060\"R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006m"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule;", "Lorg/junit/rules/TestRule;", "forceEnableWorkspaceModel", "", "(Z)V", "baseProjectDir", "Lcom/intellij/testFramework/rules/TempDirectory;", "getBaseProjectDir", "()Lcom/intellij/testFramework/rules/TempDirectory;", "disposableRule", "Lcom/intellij/testFramework/DisposableRule;", "getDisposableRule", "()Lcom/intellij/testFramework/DisposableRule;", "filePointerTracker", "Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;", "getFilePointerTracker", "()Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;", "setFilePointerTracker", "(Lcom/intellij/openapi/vfs/impl/VirtualFilePointerTracker;)V", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "getModuleManager", "()Lcom/intellij/openapi/module/ModuleManager;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "projectLibraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "getProjectLibraryTable", "()Lcom/intellij/openapi/roots/libraries/LibraryTable;", "projectResource", "Lcom/intellij/testFramework/rules/ProjectModelRule$ProjectResource;", "getProjectResource", "()Lcom/intellij/testFramework/rules/ProjectModelRule$ProjectResource;", "projectRootDir", "Ljava/nio/file/Path;", "getProjectRootDir", "()Ljava/nio/file/Path;", "setProjectRootDir", "(Ljava/nio/file/Path;)V", "projectRootManager", "Lcom/intellij/openapi/roots/ProjectRootManager;", "getProjectRootManager", "()Lcom/intellij/openapi/roots/ProjectRootManager;", "ruleChain", "Lcom/intellij/testFramework/RuleChain;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "getSdkType", "()Lcom/intellij/openapi/projectRoots/SdkTypeId;", "addApplicationLevelLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "name", "", "setup", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "", "addFacet", "F", "Lcom/intellij/facet/Facet;", "C", "Lcom/intellij/facet/FacetConfiguration;", "module", "Lcom/intellij/openapi/module/Module;", "type", "Lcom/intellij/facet/FacetType;", "configuration", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/facet/FacetType;Lcom/intellij/facet/FacetConfiguration;)Lcom/intellij/facet/Facet;", "addLibrary", "libraryTable", "addModuleLevelLibrary", "addProjectLevelLibrary", "addSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "addSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "rootType", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "createLibraryAndDisposeOnTearDown", "model", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "createModule", "moduleModel", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "createSdk", "disposeOnTearDown", "library", "generateImlPath", "kotlin.jvm.PlatformType", "removeFacet", "facet", "removeModule", "renameLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "newName", "renameModule", "ProjectResource", "intellij.platform.testFramework"})
public class ProjectModelRule
implements TestRule {
    @NotNull
    private final TempDirectory baseProjectDir;
    @NotNull
    private final DisposableRule disposableRule;
    public Project project;
    public Path projectRootDir;
    public VirtualFilePointerTracker filePointerTracker;
    @NotNull
    private final ProjectResource projectResource;
    private final RuleChain ruleChain;
    private final boolean forceEnableWorkspaceModel;

    @NotNull
    public final TempDirectory getBaseProjectDir() {
        return this.baseProjectDir;
    }

    @NotNull
    public final DisposableRule getDisposableRule() {
        return this.disposableRule;
    }

    @NotNull
    public final Project getProject() {
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project2;
    }

    public final void setProject(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"<set-?>");
        this.project = project2;
    }

    @NotNull
    public final Path getProjectRootDir() {
        Path path2 = this.projectRootDir;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectRootDir");
        }
        return path2;
    }

    public final void setProjectRootDir(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"<set-?>");
        this.projectRootDir = path2;
    }

    @NotNull
    public final VirtualFilePointerTracker getFilePointerTracker() {
        VirtualFilePointerTracker virtualFilePointerTracker = this.filePointerTracker;
        if (virtualFilePointerTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filePointerTracker");
        }
        return virtualFilePointerTracker;
    }

    public final void setFilePointerTracker(@NotNull VirtualFilePointerTracker virtualFilePointerTracker) {
        Intrinsics.checkNotNullParameter((Object)virtualFilePointerTracker, (String)"<set-?>");
        this.filePointerTracker = virtualFilePointerTracker;
    }

    @NotNull
    public final ProjectResource getProjectResource() {
        return this.projectResource;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.ruleChain.apply(base, description);
    }

    @NotNull
    public final Module createModule(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Path imlFile = this.generateImlPath(name2);
        ModuleManager manager = this.getModuleManager();
        boolean $i$f$runWriteActionAndWait = false;
        Object t = WriteAction.computeAndWait(new ThrowableComputable(manager, imlFile){
            final /* synthetic */ ModuleManager $manager$inlined;
            final /* synthetic */ Path $imlFile$inlined;
            {
                this.$manager$inlined = moduleManager;
                this.$imlFile$inlined = path2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$manager$inlined.newModule(this.$imlFile$inlined, "EMPTY_MODULE");
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"runWriteActionAndWait {\n\u2026eType.EMPTY_MODULE)\n    }");
        return (Module)t;
    }

    public static /* synthetic */ Module createModule$default(ProjectModelRule projectModelRule, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createModule");
        }
        if ((n & 1) != 0) {
            string2 = "module";
        }
        return projectModelRule.createModule(string2);
    }

    @NotNull
    public final Module createModule(@NotNull String name2, @NotNull ModifiableModuleModel moduleModel) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)moduleModel, (String)"moduleModel");
        Module module = moduleModel.newModule(this.generateImlPath(name2), "EMPTY_MODULE");
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"moduleModel.newModule(ge\u2026yModuleType.EMPTY_MODULE)");
        return module;
    }

    @NotNull
    public final VirtualFile addSourceRoot(@NotNull Module module, @NotNull String relativePath, @NotNull JpsModuleSourceRootType<?> rootType) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(rootType, (String)"rootType");
        VirtualFile srcRoot = this.baseProjectDir.newVirtualDirectory(module.getName() + "/" + relativePath);
        ModuleRootModificationUtil.updateModel(module, new Consumer(this, module, srcRoot, rootType){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ VirtualFile $srcRoot;
            final /* synthetic */ JpsModuleSourceRootType $rootType;

            public final void consume(ModifiableRootModel model2) {
                boolean bl;
                ContentEntry contentEntry;
                block5: {
                    boolean bl2;
                    ContentEntry contentEntry2;
                    ContentEntry contentEntry3;
                    Synthetic it;
                    String contentRootUrl;
                    block4: {
                        ContentEntry[] contentEntryArray;
                        Path path2 = this.this$0.getProjectRootDir().resolve(this.$module.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectRootDir.resolve(module.name)");
                        String string2 = VfsUtil.pathToUrl(PathKt.getSystemIndependentPath(path2));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtil.pathToUrl(projec\u2026e).systemIndependentPath)");
                        contentRootUrl = string2;
                        ModifiableRootModel modifiableRootModel = model2;
                        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"model");
                        ContentEntry[] contentEntryArray2 = modifiableRootModel.getContentEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray2, (String)"model.contentEntries");
                        for (ContentEntry contentEntry4 : contentEntryArray = contentEntryArray2) {
                            it = contentEntry4;
                            boolean bl3 = false;
                            ContentEntry contentEntry5 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)contentEntry5, (String)"it");
                            if (!Intrinsics.areEqual((Object)contentEntry5.getUrl(), (Object)contentRootUrl)) continue;
                            contentEntry3 = contentEntry4;
                            break block4;
                        }
                        contentEntry3 = contentEntry2 = null;
                    }
                    if (contentEntry3 == null) {
                        ContentEntry contentEntry6 = model2.addContentEntry(contentRootUrl);
                        contentEntry2 = contentEntry6;
                        Intrinsics.checkNotNullExpressionValue((Object)contentEntry6, (String)"model.addContentEntry(contentRootUrl)");
                    }
                    contentEntry = contentEntry2;
                    SourceFolder[] sourceFolderArray = contentEntry.getSourceFolders();
                    Intrinsics.checkNotNullExpressionValue((Object)sourceFolderArray, (String)"contentEntry.sourceFolders");
                    SourceFolder[] $this$none$iv = sourceFolderArray;
                    boolean $i$f$none = false;
                    for (SourceFolder element$iv : $this$none$iv) {
                        it = element$iv;
                        boolean bl4 = false;
                        Synthetic synthetic = it;
                        Intrinsics.checkNotNullExpressionValue((Object)synthetic, (String)"it");
                        if (!Intrinsics.areEqual((Object)synthetic.getUrl(), (Object)this.$srcRoot.getUrl())) continue;
                        bl2 = false;
                        break block5;
                    }
                    bl2 = bl = true;
                }
                if (!bl) {
                    boolean bl5 = false;
                    String string3 = "Source folder " + this.$srcRoot + " already exists";
                    throw new IllegalArgumentException(string3.toString());
                }
                contentEntry.addSourceFolder(this.$srcRoot, this.$rootType);
            }
            {
                this.this$0 = projectModelRule;
                this.$module = module;
                this.$srcRoot = virtualFile2;
                this.$rootType = jpsModuleSourceRootType;
            }
        });
        return srcRoot;
    }

    private final Path generateImlPath(String name2) {
        Path path2 = this.projectRootDir;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectRootDir");
        }
        return path2.resolve(name2 + "/" + name2 + ".iml");
    }

    @NotNull
    public final Sdk createSdk(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(name2, this.getSdkType());
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"ProjectJdkTable.getInsta\u2026.createSdk(name, sdkType)");
        return sdk2;
    }

    public static /* synthetic */ Sdk createSdk$default(ProjectModelRule projectModelRule, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSdk");
        }
        if ((n & 1) != 0) {
            string2 = "sdk";
        }
        return projectModelRule.createSdk(string2);
    }

    @NotNull
    public final Sdk addSdk(@NotNull Sdk sdk2, @NotNull Function1<? super SdkModificator, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(this, sdk2, setup){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Sdk $sdk$inlined;
            final /* synthetic */ Function1 $setup$inlined;
            {
                this.this$0 = projectModelRule;
                this.$sdk$inlined = sdk2;
                this.$setup$inlined = function1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                boolean bl = false;
                ProjectJdkTable.getInstance().addJdk(this.$sdk$inlined, this.this$0.getDisposableRule().getDisposable());
                SdkModificator sdkModificator = this.$sdk$inlined.getSdkModificator();
                Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"sdk.sdkModificator");
                SdkModificator sdkModificator2 = sdkModificator;
                try {
                    this.$setup$inlined.invoke((Object)sdkModificator2);
                }
                finally {
                    sdkModificator2.commitChanges();
                }
                return (T)Unit.INSTANCE;
            }
        });
        return sdk2;
    }

    public static /* synthetic */ Sdk addSdk$default(ProjectModelRule projectModelRule, Sdk sdk2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSdk");
        }
        if ((n & 2) != 0) {
            function1 = addSdk.1.INSTANCE;
        }
        return projectModelRule.addSdk(sdk2, (Function1<? super SdkModificator, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addProjectLevelLibrary(@NotNull String name2, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        return this.addLibrary(name2, this.getProjectLibraryTable(), setup);
    }

    public static /* synthetic */ LibraryEx addProjectLevelLibrary$default(ProjectModelRule projectModelRule, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addProjectLevelLibrary");
        }
        if ((n & 2) != 0) {
            function1 = addProjectLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addProjectLevelLibrary(string2, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addModuleLevelLibrary(@NotNull Module module, @NotNull String name2, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue(ref, (String)"Ref.create<LibraryEx>()");
        Ref library2 = ref;
        ModuleRootModificationUtil.updateModel(module, new Consumer(this, library2, name2, setup){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Ref $library;
            final /* synthetic */ String $name;
            final /* synthetic */ Function1 $setup;

            public final void consume(ModifiableRootModel model2) {
                ModifiableRootModel modifiableRootModel = model2;
                Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"model");
                LibraryTable libraryTable = modifiableRootModel.getModuleLibraryTable();
                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"model.moduleLibraryTable");
                this.$library.set(this.this$0.addLibrary(this.$name, libraryTable, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)this.$setup));
            }
            {
                this.this$0 = projectModelRule;
                this.$library = ref;
                this.$name = string2;
                this.$setup = function1;
            }
        });
        Object t = library2.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"library.get()");
        return (LibraryEx)t;
    }

    public static /* synthetic */ LibraryEx addModuleLevelLibrary$default(ProjectModelRule projectModelRule, Module module, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addModuleLevelLibrary");
        }
        if ((n & 4) != 0) {
            function1 = addModuleLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addModuleLevelLibrary(module, string2, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addLibrary(@NotNull String name2, @NotNull LibraryTable libraryTable, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)libraryTable, (String)"libraryTable");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        LibraryTable.ModifiableModel modifiableModel = libraryTable.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"libraryTable.modifiableModel");
        LibraryTable.ModifiableModel model2 = modifiableModel;
        Library library2 = model2.createLibrary(name2);
        if (library2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        }
        LibraryEx library3 = (LibraryEx)library2;
        LibraryEx.ModifiableModelEx modifiableModelEx = library3.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModelEx, (String)"library.modifiableModel");
        LibraryEx.ModifiableModelEx libraryModel = modifiableModelEx;
        setup.invoke((Object)libraryModel);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(libraryModel, model2){
            final /* synthetic */ LibraryEx.ModifiableModelEx $libraryModel$inlined;
            final /* synthetic */ LibraryTable.ModifiableModel $model$inlined;
            {
                this.$libraryModel$inlined = modifiableModelEx;
                this.$model$inlined = modifiableModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$libraryModel$inlined.commit();
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return library3;
    }

    public static /* synthetic */ LibraryEx addLibrary$default(ProjectModelRule projectModelRule, String string2, LibraryTable libraryTable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addLibrary");
        }
        if ((n & 4) != 0) {
            function1 = addLibrary.1.INSTANCE;
        }
        return projectModelRule.addLibrary(string2, libraryTable, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    @NotNull
    public final LibraryEx addApplicationLevelLibrary(@NotNull String name2, @NotNull Function1<? super LibraryEx.ModifiableModelEx, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar, (String)"LibraryTablesRegistrar.getInstance()");
        LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.getInstance().libraryTable");
        LibraryTable libraryTable2 = libraryTable;
        LibraryEx library2 = this.addLibrary(name2, libraryTable2, setup);
        this.disposeOnTearDown(library2);
        return library2;
    }

    public static /* synthetic */ LibraryEx addApplicationLevelLibrary$default(ProjectModelRule projectModelRule, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addApplicationLevelLibrary");
        }
        if ((n & 2) != 0) {
            function1 = addApplicationLevelLibrary.1.INSTANCE;
        }
        return projectModelRule.addApplicationLevelLibrary(string2, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)function1);
    }

    private final void disposeOnTearDown(LibraryEx library2) {
        DisposableRule this_$iv = this.disposableRule;
        boolean $i$f$register = false;
        Disposer.register(this_$iv.getDisposable(), new Disposable(library2){
            final /* synthetic */ LibraryEx $library$inlined;
            {
                this.$library$inlined = libraryEx;
            }

            public void dispose() {
                boolean bl = false;
                boolean $i$f$runWriteActionAndWait = false;
                WriteAction.computeAndWait(new ThrowableComputable(this){
                    final /* synthetic */ disposeOnTearDown$$inlined$register$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        if (!this.this$0.$library$inlined.isDisposed()) {
                            LibraryTable libraryTable = this.this$0.$library$inlined.getTable();
                            String string2 = this.this$0.$library$inlined.getName();
                            Intrinsics.checkNotNull((Object)string2);
                            if (Intrinsics.areEqual((Object)libraryTable.getLibraryByName(string2), (Object)this.this$0.$library$inlined)) {
                                this.this$0.$library$inlined.getTable().removeLibrary(this.this$0.$library$inlined);
                            }
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        });
    }

    @NotNull
    public final LibraryEx createLibraryAndDisposeOnTearDown(@NotNull String name2, @NotNull LibraryTable.ModifiableModel model2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Library library2 = model2.createLibrary(name2);
        if (library2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
        }
        LibraryEx library3 = (LibraryEx)library2;
        this.disposeOnTearDown(library3);
        return library3;
    }

    public final void renameLibrary(@NotNull Library library2, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Library.ModifiableModel modifiableModel = library2.getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"library.modifiableModel");
        Library.ModifiableModel model2 = modifiableModel;
        model2.setName(newName2);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(model2){
            final /* synthetic */ Library.ModifiableModel $model$inlined;
            {
                this.$model$inlined = modifiableModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void renameModule(@NotNull Module module, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        boolean $i$f$runReadAction = false;
        Object t = ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ ProjectModelRule this$0;
            {
                this.this$0 = projectModelRule;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.this$0.getModuleManager().getModifiableModel();
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"runReadAction { moduleManager.modifiableModel }");
        ModifiableModuleModel model2 = (ModifiableModuleModel)t;
        model2.renameModule(module, newName2);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(model2){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void removeModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(this, module){
            final /* synthetic */ ProjectModelRule this$0;
            final /* synthetic */ Module $module$inlined;
            {
                this.this$0 = projectModelRule;
                this.$module$inlined = module;
            }

            public final T compute() {
                boolean bl = false;
                this.this$0.getModuleManager().disposeModule(this.$module$inlined);
                return (T)Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final <F extends Facet<C>, C extends FacetConfiguration> F addFacet(@NotNull Module module, @NotNull FacetType<F, C> type, @NotNull C configuration) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel modifiableFacetModel = facetManager.createModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableFacetModel, (String)"facetManager.createModifiableModel()");
        ModifiableFacetModel model2 = modifiableFacetModel;
        Facet facet = facetManager.createFacet(type, type.getDefaultFacetName(), configuration, null);
        Intrinsics.checkNotNullExpressionValue((Object)facet, (String)"facetManager.createFacet\u2026ame, configuration, null)");
        Facet facet2 = facet;
        model2.addFacet(facet2);
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait(new ThrowableComputable(model2){
            final /* synthetic */ ModifiableFacetModel $model$inlined;
            {
                this.$model$inlined = modifiableFacetModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return (F)facet2;
    }

    public static /* synthetic */ Facet addFacet$default(ProjectModelRule projectModelRule, Module module, FacetType facetType, FacetConfiguration facetConfiguration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addFacet");
        }
        if ((n & 4) != 0) {
            FacetConfiguration facetConfiguration2 = facetType.createDefaultConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)facetConfiguration2, (String)"type.createDefaultConfiguration()");
            facetConfiguration = facetConfiguration2;
        }
        return projectModelRule.addFacet(module, facetType, facetConfiguration);
    }

    public final void removeFacet(@NotNull Facet<?> facet) {
        Intrinsics.checkNotNullParameter(facet, (String)"facet");
        FacetUtil.deleteFacet(facet);
    }

    @NotNull
    public final SdkTypeId getSdkType() {
        SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)simpleJavaSdkType, (String)"SimpleJavaSdkType.getInstance()");
        return (SdkTypeId)simpleJavaSdkType;
    }

    @NotNull
    public final ProjectRootManager getProjectRootManager() {
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        return projectRootManager;
    }

    @NotNull
    public final ModuleManager getModuleManager() {
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        return moduleManager;
    }

    @NotNull
    public final LibraryTable getProjectLibraryTable() {
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        Project project2 = this.project;
        if (project2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTable(project2);
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
        return libraryTable;
    }

    public ProjectModelRule(boolean forceEnableWorkspaceModel) {
        this.forceEnableWorkspaceModel = forceEnableWorkspaceModel;
        this.baseProjectDir = new TempDirectory();
        this.disposableRule = new DisposableRule();
        this.projectResource = new ProjectResource();
        this.ruleChain = new RuleChain((TestRule)this.baseProjectDir, (TestRule)this.projectResource, (TestRule)this.disposableRule);
    }

    public /* synthetic */ ProjectModelRule(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public ProjectModelRule() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/testFramework/rules/ProjectModelRule$ProjectResource;", "Lorg/junit/rules/ExternalResource;", "(Lcom/intellij/testFramework/rules/ProjectModelRule;)V", "after", "", "before", "intellij.platform.testFramework"})
    public final class ProjectResource
    extends ExternalResource {
        public void before() {
            Path path2 = ProjectModelRule.this.getBaseProjectDir().getRoot().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"baseProjectDir.root.toPath()");
            ProjectModelRule.this.setProjectRootDir(path2);
            if (ProjectModelRule.this.forceEnableWorkspaceModel) {
                WorkspaceModelInitialTestContent.INSTANCE.withInitialContent(EntityStorageSnapshot.Companion.empty(), (Function0)new Function0<Unit>(this){
                    final /* synthetic */ ProjectResource this$0;

                    public final void invoke() {
                        ProjectModelRule projectModelRule = this.this$0.ProjectModelRule.this;
                        Project project2 = PlatformTestUtil.loadAndOpenProject(this.this$0.ProjectModelRule.this.getProjectRootDir(), this.this$0.ProjectModelRule.this.getDisposableRule().getDisposable());
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"PlatformTestUtil.loadAnd\u2026isposableRule.disposable)");
                        projectModelRule.setProject(project2);
                    }
                    {
                        this.this$0 = projectResource;
                        super(0);
                    }
                });
            } else {
                Project project2 = PlatformTestUtil.loadAndOpenProject(ProjectModelRule.this.getProjectRootDir(), ProjectModelRule.this.getDisposableRule().getDisposable());
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"PlatformTestUtil.loadAnd\u2026isposableRule.disposable)");
                ProjectModelRule.this.setProject(project2);
            }
            ProjectModelRule.this.setFilePointerTracker(new VirtualFilePointerTracker());
        }

        public void after() {
            PlatformTestUtil.forceCloseProjectWithoutSaving(ProjectModelRule.this.getProject());
            ProjectModelRule.this.getFilePointerTracker().assertPointersAreDisposed();
        }
    }
}

