/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.testFramework.utils.inlays.InlayInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ>\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0006\u0010\"\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0015J\u0016\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\fJH\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\f2\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002R!\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "inlayFilter", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Inlay;", "", "getInlayFilter", "()Lkotlin/jvm/functions/Function1;", "inlayPresenter", "", "getInlayPresenter", "isParamHintsEnabledBefore", "manager", "Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "kotlin.jvm.PlatformType", "getManager", "()Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "checkInlays", "", "checkParameterHints", "extractInlaysAndCaretInfo", "Lcom/intellij/testFramework/utils/inlays/CaretAndInlaysInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "getActualInlays", "", "Lcom/intellij/testFramework/utils/inlays/InlayInfo;", "removeText", "realStartOffset", "", "matchedLength", "setUp", "tearDown", "verifyInlaysAndCaretInfo", "expectedInlaysAndCaret", "originalText", "Companion", "intellij.platform.testFramework"})
public final class InlayHintsChecker {
    private boolean isParamHintsEnabledBefore;
    private final ParameterHintsPresentationManager manager;
    @NotNull
    private final Function1<Inlay<?>, String> inlayPresenter;
    @NotNull
    private final Function1<Inlay<?>, Boolean> inlayFilter;
    private final CodeInsightTestFixture myFixture;
    @NotNull
    private static final Pattern pattern;
    private static final ParameterNameHintsSettings default;
    @NotNull
    public static final Companion Companion;

    public final void setUp() {
        EditorSettingsExternalizable settings;
        EditorSettingsExternalizable editorSettingsExternalizable = settings = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"settings");
        this.isParamHintsEnabledBefore = editorSettingsExternalizable.isShowParameterNameHints();
        settings.setShowParameterNameHints(true);
    }

    public final void tearDown() {
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable, (String)"EditorSettingsExternalizable.getInstance()");
        editorSettingsExternalizable.setShowParameterNameHints(this.isParamHintsEnabledBefore);
        ParameterNameHintsSettings hintSettings = ParameterNameHintsSettings.Companion.getInstance();
        hintSettings.loadState(default.getState());
    }

    public final ParameterHintsPresentationManager getManager() {
        return this.manager;
    }

    @NotNull
    public final Function1<Inlay<?>, String> getInlayPresenter() {
        return this.inlayPresenter;
    }

    @NotNull
    public final Function1<Inlay<?>, Boolean> getInlayFilter() {
        return this.inlayFilter;
    }

    public final void checkParameterHints() {
        this.checkInlays(this.inlayPresenter, this.inlayFilter);
    }

    public final void checkInlays(@NotNull Function1<? super Inlay<?>, String> inlayPresenter2, @NotNull Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        Document document;
        Intrinsics.checkNotNullParameter(inlayPresenter2, (String)"inlayPresenter");
        Intrinsics.checkNotNullParameter(inlayFilter2, (String)"inlayFilter");
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Document document2 = document = this.myFixture.getDocument(file2);
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
        String string2 = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String originalText = string2;
        CaretAndInlaysInfo expectedInlaysAndCaret = this.extractInlaysAndCaretInfo(document);
        this.myFixture.doHighlighting();
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, inlayPresenter2, inlayFilter2);
    }

    public final void verifyInlaysAndCaretInfo(@NotNull CaretAndInlaysInfo expectedInlaysAndCaret, @NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)expectedInlaysAndCaret, (String)"expectedInlaysAndCaret");
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, this.inlayPresenter, this.inlayFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyInlaysAndCaretInfo(CaretAndInlaysInfo expectedInlaysAndCaret, String originalText, Function1<? super Inlay<?>, String> inlayPresenter2, Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        block17: {
            List<InlayInfo> actual;
            Document document;
            PsiFile file2;
            block16: {
                boolean bl;
                block14: {
                    PsiFile psiFile = this.myFixture.getFile();
                    Intrinsics.checkNotNull((Object)psiFile);
                    file2 = psiFile;
                    document = this.myFixture.getDocument(file2);
                    actual = this.getActualInlays(inlayPresenter2, inlayFilter2);
                    List<InlayInfo> expected = expectedInlaysAndCaret.getInlays();
                    if (expectedInlaysAndCaret.getInlays().size() != actual.size()) break block16;
                    Iterable $this$any$iv = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Iterator element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)((InlayInfo)it.getFirst()), (Object)((InlayInfo)it.getSecond())) ^ true)) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block17;
            }
            List entries2 = new ArrayList();
            Iterable $this$forEach$iv = actual;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string2;
                void $this$buildString;
                InlayInfo it = (InlayInfo)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = stringBuilder;
                Integer n = it.getOffset();
                List list2 = entries2;
                boolean bl3 = false;
                $this$buildString.append("<");
                $this$buildString.append(it.getHighlighted() ? "H" : "h");
                $this$buildString.append(it.getCurrent() ? "INT" : "int");
                $this$buildString.append(" text=\"");
                $this$buildString.append(it.getText());
                $this$buildString.append("\"/>");
                Unit unit = Unit.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                Integer n2 = n;
                list2.add(new Pair((Object)n2, (Object)string2));
            }
            if (expectedInlaysAndCaret.getCaretOffset() != null) {
                int n;
                int actualInlaysBeforeCaret;
                int actualCaretOffset;
                block15: {
                    Editor editor2 = this.myFixture.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myFixture.editor");
                    CaretModel caretModel = editor2.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"myFixture.editor.caretModel");
                    actualCaretOffset = caretModel.getOffset();
                    Editor editor3 = this.myFixture.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"myFixture.editor");
                    CaretModel caretModel2 = editor3.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"myFixture.editor.caretModel");
                    actualInlaysBeforeCaret = caretModel2.getVisualPosition().column - this.myFixture.getEditor().offsetToVisualPosition((int)actualCaretOffset).column;
                    List $this$indexOfFirst$iv = entries2;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        Pair it = (Pair)item$iv;
                        boolean bl = false;
                        if (((Number)it.getFirst()).intValue() == actualCaretOffset) {
                            n = index$iv;
                            break block15;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int first2 = n;
                int insertIndex2 = first2 == -1 ? -CollectionsKt.binarySearch$default((List)entries2, (int)0, (int)0, (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends String>, Integer>(actualCaretOffset){
                    final /* synthetic */ int $actualCaretOffset;

                    public final int invoke(@NotNull Pair<Integer, String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return ((Number)it.getFirst()).intValue() - this.$actualCaretOffset;
                    }
                    {
                        this.$actualCaretOffset = n;
                        super(1);
                    }
                }), (int)3, null) - 1 : first2 + actualInlaysBeforeCaret;
                entries2.add(insertIndex2, new Pair((Object)actualCaretOffset, (Object)"<caret>"));
            }
            Document document2 = document;
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
            StringBuilder proposedText = new StringBuilder(document2.getText());
            Iterable $this$forEach$iv2 = CollectionsKt.asReversedMutable((List)entries2);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                proposedText.insert(((Number)it.getFirst()).intValue(), (String)it.getSecond());
            }
            String string3 = VfsTestUtil.TEST_DATA_FILE_PATH.get(file2.getVirtualFile());
            if (string3 != null) {
                String string4;
                String originalPath = string4 = string3;
                boolean bl = false;
                throw (Throwable)new FileComparisonFailure("Hints differ", originalText, proposedText.toString(), originalPath);
            }
            throw (Throwable)new ComparisonFailure("Hints differ", originalText, proposedText.toString());
        }
        if (expectedInlaysAndCaret.getCaretOffset() != null) {
            Integer n = expectedInlaysAndCaret.getCaretOffset();
            Editor editor4 = this.myFixture.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"myFixture.editor");
            CaretModel caretModel = editor4.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"myFixture.editor.caretModel");
            Assert.assertEquals((String)"Unexpected caret offset", (Object)n, (Object)caretModel.getOffset());
            VisualPosition visualPosition = this.myFixture.getEditor().offsetToVisualPosition(expectedInlaysAndCaret.getCaretOffset().intValue());
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"myFixture.editor.offsetT\u2026laysAndCaret.caretOffset)");
            VisualPosition position = visualPosition;
            VisualPosition visualPosition2 = new VisualPosition(position.line, position.column + expectedInlaysAndCaret.getInlaysBeforeCaret());
            Editor editor5 = this.myFixture.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor5, (String)"myFixture.editor");
            CaretModel caretModel3 = editor5.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel3, (String)"myFixture.editor.caretModel");
            Assert.assertEquals((String)"Unexpected caret visual position", (Object)visualPosition2, (Object)caretModel3.getVisualPosition());
            Editor editor6 = this.myFixture.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor6, (String)"myFixture.editor");
            SelectionModel selectionModel = editor6.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"myFixture.editor.selectionModel");
            SelectionModel selectionModel2 = selectionModel;
            if (expectedInlaysAndCaret.getSelection() == null) {
                Assert.assertFalse((boolean)selectionModel2.hasSelection());
            } else {
                Assert.assertEquals((String)"Unexpected selection", (Object)expectedInlaysAndCaret.getSelection(), (Object)new TextRange(selectionModel2.getSelectionStart(), selectionModel2.getSelectionEnd()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlayInfo> getActualInlays(Function1<? super Inlay<?>, String> inlayPresenter2, Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Inlay it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Editor editor2;
        Editor editor3 = editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
        InlayModel inlayModel = editor3.getInlayModel();
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        List list2 = inlayModel.getInlineElementsInRange(0, document.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.inlayModel.getInl\u2026itor.document.textLength)");
        Collection collection = list2;
        InlayModel inlayModel2 = editor2.getInlayModel();
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
        List list3 = inlayModel2.getBlockElementsInRange(0, document2.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"editor.inlayModel.getBlo\u2026itor.document.textLength)");
        List allInlays = CollectionsKt.plus((Collection)collection, (Iterable)list3);
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)allInlays);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)inlayFilter2.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            boolean isHighlighted = false;
            boolean isCurrent = false;
            if (hintManager.isParameterHint(it)) {
                isHighlighted = hintManager.isHighlighted(it);
                isCurrent = hintManager.isCurrent(it);
            } else {
                isHighlighted = false;
                isCurrent = false;
            }
            InlayInfo inlayInfo = new InlayInfo(it.getOffset(), (String)inlayPresenter2.invoke((Object)it), isHighlighted, isCurrent);
            collection2.add(inlayInfo);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                InlayInfo it = (InlayInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (InlayInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = it.getOffset();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CaretAndInlaysInfo extractInlaysAndCaretInfo(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string2 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
        String text2 = string2;
        Matcher matcher = pattern.matcher(text2);
        List inlays = new ArrayList();
        int extractedLength = 0;
        Integer caretOffset = null;
        int inlaysBeforeCaret = 0;
        Integer selectionStart = null;
        Integer selectionEnd = null;
        while (matcher.find()) {
            Iterable iterable;
            int start2 = matcher.start();
            int matchedLength = matcher.end() - start2;
            int realStartOffset = start2 - extractedLength;
            if (matcher.group(1) != null) {
                void $this$forEach$iv;
                Iterable $this$takeWhile$iv;
                caretOffset = realStartOffset;
                iterable = CollectionsKt.asReversedMutable((List)inlays);
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    InlayInfo it = (InlayInfo)item$iv;
                    boolean bl = false;
                    if (!(it.getOffset() == caretOffset.intValue())) break;
                    list$iv.add(item$iv);
                }
                $this$takeWhile$iv = list$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InlayInfo it = (InlayInfo)element$iv;
                    boolean bl = false;
                    int n = inlaysBeforeCaret;
                    inlaysBeforeCaret = n + 1;
                }
            } else if (matcher.group(2) != null) {
                selectionStart = realStartOffset;
            } else if (matcher.group(3) != null) {
                selectionEnd = realStartOffset;
            } else {
                iterable = inlays;
                String string3 = matcher.group(5);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(5)");
                String string4 = matcher.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"matcher.group(4)");
                boolean bl = StringsKt.startsWith$default((String)string4, (String)"H", (boolean)false, (int)2, null);
                String string5 = matcher.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"matcher.group(4)");
                InlayInfo inlayInfo = new InlayInfo(realStartOffset, string3, bl, StringsKt.endsWith$default((String)string5, (String)"INT", (boolean)false, (int)2, null));
                iterable.add(inlayInfo);
            }
            this.removeText(document, realStartOffset, matchedLength);
            extractedLength += matcher.end() - start2;
        }
        return new CaretAndInlaysInfo(caretOffset, inlaysBeforeCaret, selectionStart == null || selectionEnd == null ? null : new TextRange(selectionStart, selectionEnd), inlays);
    }

    private final void removeText(Document document, int realStartOffset, int matchedLength) {
        WriteCommandAction.runWriteCommandAction(this.myFixture.getProject(), new Runnable(document, realStartOffset, matchedLength){
            final /* synthetic */ Document $document;
            final /* synthetic */ int $realStartOffset;
            final /* synthetic */ int $matchedLength;

            public final void run() {
                this.$document.replaceString(this.$realStartOffset, this.$realStartOffset + this.$matchedLength, "");
            }
            {
                this.$document = document;
                this.$realStartOffset = n;
                this.$matchedLength = n2;
            }
        });
    }

    public InlayHintsChecker(@NotNull CodeInsightTestFixture myFixture) {
        Intrinsics.checkNotNullParameter((Object)myFixture, (String)"myFixture");
        this.myFixture = myFixture;
        this.manager = ParameterHintsPresentationManager.getInstance();
        this.inlayPresenter = inlayPresenter.1.INSTANCE;
        this.inlayFilter = new Function1<Inlay<?>, Boolean>(this){
            final /* synthetic */ InlayHintsChecker this$0;

            public final boolean invoke(@NotNull Inlay<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.this$0.getManager().isParameterHint(it);
            }
            {
                this.this$0 = inlayHintsChecker;
                super(1);
            }
        };
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(<caret>)|(<selection>)|(</selection>)|<(hint|HINT|Hint|hINT)\\s+text=\"([^\"\n\r]+)\"\\s*/>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"(<caret\u2026=\\\"([^\\\"\\n\\r]+)\\\"\\\\s*/>\")");
        InlayHintsChecker.pattern = pattern;
        default = new ParameterNameHintsSettings();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "()V", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
    public static final class Companion {
        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

