/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.GCUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public class DynamicExtensionPointsTester {
    public static final Set<String> EXTENSION_POINTS_WHITE_LIST = Collections.emptySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkDynamicExtensionPoints(Function<? super String, String> namer) {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        app.invokeAndWait(() -> PlatformTestUtil.cleanupAllProjects());
        Map<ExtensionPointImpl<?>, Collection<WeakReference<Object>>> extensionPointToNonPlatformExtensions = DynamicExtensionPointsTester.collectDynamicNonPlatformExtensions(app);
        IdeaPluginDescriptor corePlugin = PluginManagerCore.getPlugin(PluginManagerCore.CORE_ID);
        assert (corePlugin != null);
        try {
            DynamicExtensionPointsTester.fireBeforePluginUnloadEvent(corePlugin);
            app.invokeAndWait(() -> app.runWriteAction(() -> {
                for (ExtensionPointImpl ep : extensionPointToNonPlatformExtensions.keySet()) {
                    ep.reset();
                }
            }));
            for (Project project2 : ProjectUtil.getOpenProjects()) {
                ((CachedValuesManagerImpl)CachedValuesManager.getManager(project2)).clearCachedValues();
            }
        }
        finally {
            DynamicExtensionPointsTester.firePluginUnloadedEvent(corePlugin);
        }
        GCUtil.tryGcSoftlyReachableObjects();
        System.gc();
        System.gc();
        String heapDump = TestApplicationManagerKt.publishHeapDump("dynamicExtension");
        AtomicBoolean failed = new AtomicBoolean(false);
        extensionPointToNonPlatformExtensions.forEach((ep, references) -> {
            String testName = DynamicExtensionPointsTester.escape((String)namer.fun("Dynamic EP unloading " + ep.getName()));
            System.out.printf("##teamcity[testStarted name='%s']%n", testName);
            System.out.flush();
            List<Object> alive = ContainerUtil.mapNotNull(references, Reference::get);
            if (!alive.isEmpty()) {
                String aliveExtensions = StringUtil.join(alive, o -> o + " (" + o.getClass() + ")", "\n");
                System.out.printf("##teamcity[%s name='%s' message='%s']%n", "testFailed", testName, DynamicExtensionPointsTester.escape("Not unloaded extensions:\n" + aliveExtensions + "\n\nSee testDynamicExtensions output to find a heapDump"));
                System.out.flush();
                failed.set(true);
            } else {
                System.out.printf("##teamcity[testFinished name='%s']%n", testName);
                System.out.flush();
            }
        });
        if (failed.get()) {
            TestCase.fail((String)("Some of dynamic extensions have not been unloaded. See individual tests for details. Heap dump: " + heapDump));
        }
    }

    private static void fireBeforePluginUnloadEvent(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            DynamicExtensionPointsTester.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().getMessageBus().syncPublisher(DynamicPluginListener.TOPIC).beforePluginUnload(plugin, false));
    }

    private static void firePluginUnloadedEvent(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            DynamicExtensionPointsTester.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().getMessageBus().syncPublisher(DynamicPluginListener.TOPIC).pluginUnloaded(plugin, false));
    }

    @NotNull
    private static String escape(String s) {
        String string2 = MapSerializerUtil.escapeStr((String)s, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
        if (string2 == null) {
            DynamicExtensionPointsTester.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    private static Map<ExtensionPointImpl<?>, Collection<WeakReference<Object>>> collectDynamicNonPlatformExtensions(@NotNull Application app) {
        if (app == null) {
            DynamicExtensionPointsTester.$$$reportNull$$$0(3);
        }
        boolean useWhiteList = !SystemProperties.getBooleanProperty("intellij.test.all.dynamic.extension.points", false);
        HashMap extensions2 = new HashMap();
        for (Project project2 : ProjectUtil.getOpenProjects()) {
            DynamicExtensionPointsTester.collectForArea((ExtensionsAreaImpl)project2.getExtensionArea(), useWhiteList, extensions2);
        }
        DynamicExtensionPointsTester.collectForArea((ExtensionsAreaImpl)app.getExtensionArea(), useWhiteList, extensions2);
        HashMap hashMap = extensions2;
        if (hashMap == null) {
            DynamicExtensionPointsTester.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static void collectForArea(@NotNull ExtensionsAreaImpl area, boolean useWhiteList, @NotNull Map<ExtensionPointImpl<?>, Collection<WeakReference<Object>>> extensions2) {
        if (area == null) {
            DynamicExtensionPointsTester.$$$reportNull$$$0(5);
        }
        if (extensions2 == null) {
            DynamicExtensionPointsTester.$$$reportNull$$$0(6);
        }
        area.processExtensionPoints(ep -> {
            if (!ep.isDynamic() || useWhiteList && !EXTENSION_POINTS_WHITE_LIST.contains(ep.getName())) {
                return;
            }
            ArrayList list2 = new ArrayList();
            ep.processWithPluginDescriptor(false, (object, pluginDescriptor) -> {
                if (!PluginManagerCore.CORE_ID.equals(pluginDescriptor.getPluginId())) {
                    list2.add(new WeakReference<Object>(object));
                }
            });
            extensions2.put((ExtensionPointImpl<?>)ep, list2);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tests/DynamicExtensionPointsTester";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tests/DynamicExtensionPointsTester";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDynamicNonPlatformExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforePluginUnloadEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "firePluginUnloadedEvent";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectDynamicNonPlatformExtensions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectForArea";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

